/* Datei: treegen.c      Autor: -- jd --     Version: 130200       */
/* Baut einen kahlen Baum aus ITER Stufen mit maximal BLATT Aesten */

#include <math.h>
#include <sys/times.h>

#define ITER 7
#define DICKE (double) 0.4
#define BLATT 4
#define MAXLAENGE 3
#define DIMENSIONS 3
#define MAXBLATT ITER*ITER*(BLATT+1)*(BLATT+1)

double ta[MAXBLATT][DIMENSIONS]; /* Liste der Anfangspunkte */
double tp[MAXBLATT][DIMENSIONS]; /* Liste der Endpunkte */
double tw[MAXBLATT][DIMENSIONS]; /* Liste der Winkel */

main()
{   int i,j,k,l,m,n,leafs;
    double d,d0,d1,stub;
    struct tms t;

    srand((int) times(&t));
    printf("#declare tree=union {\n");

    for (i = 0; i < MAXBLATT; i++)
        for (j = 0; j < DIMENSIONS; j++)
	    ta[i][j] = tp[i][j] = tw[i][j] = 0.0;
    tw[0][0] = 0.0; tw[0][1] = 1.0; tw[0][2] = 0.0;
    d = ((double) rand()) / 1000.0;
    d -= ((double) ((int) d));
    stub = d*1.4*MAXLAENGE;
    tp[0][0] = 0.0; tp[0][1] = stub; tp[0][2] = 0.0;
    d0 = ((double) (ITER)+1.0)*(DICKE)/((double)(ITER));
    d1 = DICKE;

    printf("    cone { <%.3f, %.3f, %.3f>, %.5f, <%.3f ,%.3f ,%.3f>, %.5f }\n", ta[0][0], ta[0][1], ta[0][2], d0, tp[0][0], tp[0][1], tp[0][2], d1);
    printf("    sphere { <%.3f, %.3f, %.3f>, %.5f }\n", tp[0][0], tp[0][1], tp[0][2], d1);
    leafs = 1;
    for (i = 0; i < ITER; i++)
    {
        for (j = 0; j < leafs; j++)
            for (k = 0; k < DIMENSIONS; k++) ta[j][k] = tp[j][k];
	l = leafs;
        for (j = 0; j < l; j++)
        {
            m = (rand()/10)%(BLATT+1);
	    if (i == 0 && m == 0) m = 1; /* zuerst min. 2 Verzweigungen */
            for (n = 0; n < m; n++)
            {   ta[leafs][0] = ta[j][0];
		ta[leafs][1] = ta[j][1];
		ta[leafs][2] = ta[j][2];
                tw[leafs][0] = tw[j][0];
		tw[leafs][1] = tw[j][1];
		tw[leafs][2] = tw[j][2];
                if (leafs < MAXBLATT-1) leafs++;
            }
        }
        for (j = 0; j < leafs; j++)
        {
            for (k = 0; k < DIMENSIONS; k++)
            {
                d = ((double) rand()) / 1000.0;
		d -= ((double) ((int) d))+0.5; /* -0.5 < d < 0.5 */
		tw[j][k] += d * 1.66;
                d = ((double) rand()) / 1000.0;
		d -= ((double) ((int) d));
		d *= 2.0; /* 0 < d < 1.999 */
		tp[j][k] = tw[j][k] * ((double) MAXLAENGE)/(((double) (i+1))*2.0+d);
                tp[j][k] += ta[j][k];
            }
	    d0 = DICKE/((double) (2*i+1)); /* linear */
	    /* if (i == 0) d0 = DICKE; else d0 = DICKE/((double) (i*(i+1)); /* quadratisch */
	    if (i == ITER-1) d1 = 0.00001;
	    else d1 = DICKE/((double) (2*i+2)); /* linear */
	    /* else d1 = DICKE/((double) (i+1)*(i+2)); quadratisch */
            printf("    cone { <%.3f, %.3f, %.3f>, %.5f, <%.3f, %.3f, %.3f>, %.5f }\n", ta[j][0], ta[j][1], ta[j][2], d0, tp[j][0], tp[j][1], tp[j][2], d1);
            printf("    sphere { <%.3f, %.3f, %.3f>, %.5f }\n", tp[j][0], tp[j][1], tp[j][2], d1);
        }
    }

    printf("}\n");
    printf("#declare treefoot=difference {\n    union {\n");
    j = BLATT + (rand()/100)%BLATT;
    for (i = 0; i < j; i++)
    {
        d = ((double) rand()) / 1000.0;
        d -= ((double) ((int) d))+0.5;
	tp[0][0] = DICKE*d*2;
        d = ((double) rand()) / 1000.0;
        d -= ((double) ((int) d))+0.5;
	tp[0][2] = DICKE*d*2;
        d = ((double) rand()) / 1000.0;
        d -= ((double) ((int) d)); d += 1.0; /* 1 < d < 2 */
        d0 = DICKE/3.0; d1 = DICKE/d;
        printf("        cone { < 0, %.3f, 0 >, %.5f, < %.3f, -%.3f, %.3f >, %.5f }\n", (stub/2.0)*d, d0, tp[0][0], DICKE/2.0, tp[0][2], d1);
    }
    printf("   }\n    box { < -%.3f , 0 , -%.3f >, < %.3f , -%.3f, %.3f > } \n",DICKE*4,DICKE*4,DICKE*4,DICKE*4,DICKE*4);
    printf("}\n");
    
    printf("#declare Tree=union { object { tree } object { treefoot } }\n");
    exit(0);
}

/* Diese Software unterliegt dem Copyleft 2000.         -- jd --   */
