/*******************************************
        Declared Numbers:
*******************************************/        
 #declare Sun_Pos=<100,500,500>;
 #declare Sun_Size=100;
 #declare Cam_Pos=<1,5,10>;
 #declare Look_At=0;
/*******************************************
        Declared Textures:
*******************************************/        

#declare Sand_Tex=
texture{
pigment{
bozo turbulence 100
color_map{
[0 color rgb <1,0.9,0.3>]
[0.25 color rgb<1,0.9,0.2>]
[0.5 color rgb <0.8,0.8,0.1>]
[0.75 color rgb <1,0.99,0.2>]
[1 color rgb <0.8,0.8,0.3333>]}
scale 0.0001}
normal{bumps 0.5 scale<4,1,4>}
finish{roughness 5}
}

#declare Ocean_Tex=
texture{         
pigment{
bozo turbulence 1
color_map{
[0 color rgb<0,0,1>]
[1 color rgb<0,0,0.7>]}
}
finish{reflection 0.5}
normal{ripples 0.5 turbulence 1 scale <4,1,4>}
}
                 
#declare Sky_Tex=
pigment{
bozo turbulence 1
color_map{
[0 color rgb 1]
[1 color rgb<0,0,1>]}
}

#declare Bucket_Tex = 
material{texture{pigment{
color rgb <1.0, 0.0, 0.0>}      
finish{
ambient 0.1
phong 1.0
phong_size 15.23
}}}

#declare Spade_Tex = 
material{texture{pigment{
color rgb <0,0,1>}      
finish{
ambient 0.1
phong 1.0
phong_size 15.23
}}}
/*******************************************
        Declared objects:
*******************************************/        

#declare Handle = difference {box {<-1, -1, -1>, <1, 1, 1> material {Spade_Tex}
scale <0.696202, 0.39855, 0.106416>translate  <-0.01787, -4.673983, -0.907546>}
box {<-1, -1, -1>, <1, 1, 1>material {Spade_Tex}scale <0.553239, 0.267311, 1.0>
translate  <-0.01787, -4.646319, -1.0>}scale <0.9, 1.0, 1.0>}

#declare Digging_Bit = prism {   //for spade
  linear_sweep
  linear_spline
  -2.0,0.0
  9  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, -0.666667>,
  <0.835669, -0.666667>,
  <0.834881, -0.836518>,
  <-0.828502, -0.837049>,
  <-0.829172, -0.666667>,
  <-1.0, -0.666667>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Spade_Tex}
    rotate 90*x
  scale <0.8, 1.0, 1.0>
}

#declare Spade=union { 
  object { Handle }
  box {       //shaft
    <-1, -1, -1>, <1, 1, 1>
    scale <0.078553, 1.1435, 0.078491>
    translate  <0.0, -3.135146, -0.921509>
  }
  object { Digging_Bit  }
rotate -90*x        //to get it up the right way
material{Spade_Tex}}


#declare Bucket=lathe { // Bucket
  linear_spline
  8  // control points
  <0.012739, -1.339703>,
  <1.225053, -1.338641>,
  <1.856688, 1.556157>,
  <1.532909, 1.561571>,
  <1.467091, 1.435244>,
  <1.691348, 1.418259>,
  <1.108811, -1.176221>,
  <0.002123, -1.176221>
  rotate <90,0,90>
  material {
    Bucket_Tex
  }
rotate -90*x}//to get it up the right way


#declare Sun=
sphere{Sun_Pos Sun_Size pigment{color rgb<1,0.8,0>}}

#declare Sun_Source=
light_source{Sun_Pos color rgb<1,1,0.6>looks_like{Sun}}

#declare Ocean=
plane{-y 0.5 
texture{
Ocean_Tex
}}

#if (Trace_Ground=on)
#debug "\n Parsing Ground\n"
#declare Sandy_Ground=
  height_field {
    tga "mine\Hf_01.tga"
    smooth
    texture { Sand_Tex finish{ambient 0.35}}
    translate <-.5, -.5, -.5>
    scale <300, 25, 300>
  water_level 0.2
  }
 #end
 
#declare Sky=
sky_sphere{pigment{Sky_Tex}}

#if (Trace_Sand_Castle=on)
#debug "\n Parsing Sand Castle\n\n"
#declare Sand_Castle=
union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.676520, -37.652186, -3.145700>, <-27.905808, -37.652186, -3.155615>, <-23.919264, -37.652186, -3.155615>, <-19.932720, -37.652186, -3.155615>, 
      <-31.892352, -32.945663, -3.155615>, <-16.316888, -22.398499, -1.634781>, <-13.985904, -22.398499, -1.634781>, <-11.654920, -22.398499, -1.634781>, 
      <-31.892352, -28.239139, -3.155615>, <-16.316888, -19.198713, -1.634781>, <-7.862748, -8.474394, 0.000000>, <-6.552290, -8.474394, 0.000000>, 
      <-31.892352, -23.532616, -3.155615>, <-16.316888, -15.998928, -1.634781>, <-7.862748, -7.061995, 0.000000>, <-6.246344, -6.649596, 1.285828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.892352, -23.532616, -3.155615>, <-16.316888, -15.998928, -1.634781>, <-7.862748, -7.061995, 0.000000>, <-6.246344, -6.649596, 1.285828>, 
      <-31.892352, -18.826093, -3.155615>, <-16.316888, -12.799142, -1.634781>, <-7.862748, -5.649596, 0.000000>, <-5.940397, -4.824798, 2.571656>, 
      <-31.892352, -14.119570, -3.155615>, <-16.316888, -9.599357, -1.634781>, <-7.862748, -4.237197, 0.000000>, <-5.940397, -3.618598, 2.571656>, 
      <-31.892352, -9.413046, -3.155615>, <-16.316888, -6.399571, -1.634781>, <-6.281910, -2.522203, 1.191083>, <-4.914584, -2.212904, 2.772011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.892352, -9.413046, -3.155615>, <-16.316888, -6.399571, -1.634781>, <-6.281910, -2.522203, 1.191083>, <-4.914584, -2.212904, 2.772011>, 
      <-31.892352, -4.706523, -3.155615>, <-16.316888, -3.199786, -1.634781>, <-4.701072, -0.807209, 2.382166>, <-3.888770, -0.807209, 2.972367>, 
      <-31.892352, 0.000000, -3.155615>, <-16.316888, 0.000000, -1.634781>, <-4.701072, 0.000000, 2.382166>, <-3.888770, 0.000000, 2.972367>, 
      <-31.892352, 4.706523, -3.155615>, <-16.316888, 3.199786, -1.634781>, <-6.281910, 1.412399, 1.191083>, <-4.914584, 1.206199, 2.772011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.892352, 4.706523, -3.155615>, <-16.316888, 3.199786, -1.634781>, <-6.281910, 1.412399, 1.191083>, <-4.914584, 1.206199, 2.772011>, 
      <-31.892352, 9.413046, -3.155615>, <-16.316888, 6.399571, -1.634781>, <-7.862748, 2.824798, 0.000000>, <-5.940397, 2.412399, 2.571656>, 
      <-31.892352, 14.119570, -3.155615>, <-16.316888, 9.599357, -1.634781>, <-7.862748, 4.237197, 0.000000>, <-5.940397, 3.618598, 2.571656>, 
      <-31.892352, 18.826093, -3.155615>, <-16.316888, 12.799142, -1.634781>, <-7.862748, 5.649596, 0.000000>, <-6.246344, 5.340296, 1.285828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.892352, 18.826093, -3.155615>, <-16.316888, 12.799142, -1.634781>, <-7.862748, 5.649596, 0.000000>, <-6.246344, 5.340296, 1.285828>, 
      <-31.892352, 23.532616, -3.155615>, <-16.316888, 15.998928, -1.634781>, <-7.862748, 7.061995, 0.000000>, <-6.552290, 7.061995, 0.000000>, 
      <-31.892352, 28.239139, -3.155615>, <-16.316888, 19.198713, -1.634781>, <-13.985904, 19.198713, -1.634781>, <-11.654920, 19.198713, -1.634781>, 
      <-31.676520, 32.945663, -3.145700>, <-27.905808, 32.945663, -3.155615>, <-23.919264, 32.945663, -3.155615>, <-19.932720, 32.945663, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-19.932720, -37.652186, -3.155615>, <-15.946176, -37.652186, -3.155615>, <-11.959632, -37.652186, -3.155615>, <-7.973088, -37.652186, -3.155615>, 
      <-11.654920, -22.398499, -1.634781>, <-9.323936, -22.398499, -1.634781>, <-6.992952, -22.398499, -1.634781>, <-4.661968, -22.398499, -1.634781>, 
      <-6.552290, -8.474394, 0.000000>, <-5.241832, -8.474394, 0.000000>, <-3.931374, -8.474394, 0.000000>, <-2.357443, -6.658825, 1.191083>, 
      <-6.246344, -6.649596, 1.285828>, <-4.629939, -6.237197, 2.571656>, <-3.474710, -6.237197, 2.571656>, <-2.107518, -5.136622, 2.779209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.246344, -6.649596, 1.285828>, <-4.629939, -6.237197, 2.571656>, <-3.474710, -6.237197, 2.571656>, <-2.107518, -5.136622, 2.779209>, 
      <-5.940397, -4.824798, 2.571656>, <-4.018047, -4.000000, 5.143312>, <-3.018047, -4.000000, 5.143312>, <-1.857594, -3.614419, 4.367335>, 
      <-5.940397, -3.618598, 2.571656>, <-4.018047, -3.000000, 5.143312>, <-2.949286, -3.000000, 6.656046>, <-1.823214, -2.710814, 5.526767>, 
      <-4.914584, -2.212904, 2.772011>, <-3.547257, -1.903605, 4.352940>, <-2.621121, -1.903605, 5.512371>, <-1.751962, -1.908791, 5.929453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.914584, -2.212904, 2.772011>, <-3.547257, -1.903605, 4.352940>, <-2.621121, -1.903605, 5.512371>, <-1.751962, -1.908791, 5.929453>, 
      <-3.888770, -0.807209, 2.972367>, <-3.076468, -0.807209, 3.562568>, <-2.292956, -0.807209, 4.368697>, <-1.680710, -1.106767, 6.332139>, 
      <-3.888770, 0.000000, 2.972367>, <-3.076468, 0.000000, 3.562568>, <-2.292956, 0.000000, 4.368697>, <-1.680710, 0.156515, 6.332139>, 
      <-4.914584, 1.206199, 2.772011>, <-3.547257, 1.000000, 4.352940>, <-2.655501, 1.000000, 4.756004>, <-1.769152, 0.981862, 5.551269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.914584, 1.206199, 2.772011>, <-3.547257, 1.000000, 4.352940>, <-2.655501, 1.000000, 4.756004>, <-1.769152, 0.981862, 5.551269>, 
      <-5.940397, 2.412399, 2.571656>, <-4.018047, 2.000000, 5.143312>, <-3.018047, 2.000000, 5.143312>, <-1.857594, 1.807209, 4.770400>, 
      <-5.940397, 3.618598, 2.571656>, <-4.018047, 3.000000, 5.143312>, <-2.949286, 3.000000, 6.656046>, <-1.823214, 2.710814, 5.123702>, 
      <-6.246344, 5.340296, 1.285828>, <-4.629939, 5.030997, 2.571656>, <-3.440330, 5.030997, 3.328023>, <-2.090328, 4.129917, 3.157393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.246344, 5.340296, 1.285828>, <-4.629939, 5.030997, 2.571656>, <-3.440330, 5.030997, 3.328023>, <-2.090328, 4.129917, 3.157393>, 
      <-6.552290, 7.061995, 0.000000>, <-5.241832, 7.061995, 0.000000>, <-3.931374, 7.061995, 0.000000>, <-2.357443, 5.549021, 1.191083>, 
      <-11.654920, 19.198713, -1.634781>, <-9.323936, 19.198713, -1.634781>, <-6.992952, 19.198713, -1.634781>, <-4.661968, 19.198713, -1.634781>, 
      <-19.932720, 32.945663, -3.155615>, <-15.946176, 32.945663, -3.155615>, <-11.959632, 32.945663, -3.155615>, <-7.973088, 32.945663, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.973088, -37.652186, -3.155615>, <-3.986544, -37.652186, -3.155615>, <0.000000, -37.652186, -3.155615>, <3.986544, -37.652186, -3.155615>, 
      <-4.661968, -22.398499, -1.634781>, <-2.330984, -22.398499, -1.634781>, <0.000000, -22.398499, -1.634781>, <2.330984, -22.398499, -1.634781>, 
      <-2.357443, -6.658825, 1.191083>, <-0.783512, -4.843256, 2.382166>, <0.000000, -4.843256, 2.382166>, <1.310458, -6.658825, 1.191083>, 
      <-2.107518, -5.136622, 2.779209>, <-0.740327, -4.036047, 2.986762>, <0.043185, -4.036047, 2.986762>, <1.172310, -5.136622, 2.779209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.107518, -5.136622, 2.779209>, <-0.740327, -4.036047, 2.986762>, <0.043185, -4.036047, 2.986762>, <1.172310, -5.136622, 2.779209>, 
      <-1.857594, -3.614419, 4.367335>, <-0.697141, -3.228838, 3.591358>, <0.086371, -3.228838, 3.591358>, <1.034162, -3.614419, 4.367335>, 
      <-1.823214, -2.710814, 5.526767>, <-0.697141, -2.421628, 4.397487>, <0.086371, -2.421628, 4.397487>, <1.068542, -2.710814, 5.526767>, 
      <-1.751962, -1.908791, 5.929453>, <-0.882803, -1.913976, 6.346534>, <0.110937, -1.913976, 6.346534>, <0.974298, -1.908791, 5.929453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.751962, -1.908791, 5.929453>, <-0.882803, -1.913976, 6.346534>, <0.110937, -1.913976, 6.346534>, <0.974298, -1.908791, 5.929453>, 
      <-1.680710, -1.106767, 6.332139>, <-1.068465, -1.406325, 8.295581>, <0.135504, -1.406325, 8.295581>, <0.880054, -1.106767, 6.332139>, 
      <-1.680710, 0.156515, 6.332139>, <-1.068465, 0.313031, 8.295581>, <0.135504, 0.313031, 8.295581>, <0.880054, 0.156515, 6.332139>, 
      <-1.769152, 0.981862, 5.551269>, <-0.882803, 0.963725, 6.346534>, <0.110937, 0.963725, 6.346534>, <0.957108, 0.981862, 5.551269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.769152, 0.981862, 5.551269>, <-0.882803, 0.963725, 6.346534>, <0.110937, 0.963725, 6.346534>, <0.957108, 0.981862, 5.551269>, 
      <-1.857594, 1.807209, 4.770400>, <-0.697141, 1.614419, 4.397487>, <0.086371, 1.614419, 4.397487>, <1.034162, 1.807209, 4.770400>, 
      <-1.823214, 2.710814, 5.123702>, <-0.697141, 2.421628, 3.591358>, <0.086371, 2.421628, 3.591358>, <1.068542, 2.710814, 5.123702>, 
      <-2.090328, 4.129917, 3.157393>, <-0.740327, 3.228838, 2.986762>, <0.043185, 3.228838, 2.986762>, <1.189500, 4.129917, 3.157393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.090328, 4.129917, 3.157393>, <-0.740327, 3.228838, 2.986762>, <0.043185, 3.228838, 2.986762>, <1.189500, 4.129917, 3.157393>, 
      <-2.357443, 5.549021, 1.191083>, <-0.783512, 4.036047, 2.382166>, <0.000000, 4.036047, 2.382166>, <1.310458, 5.549021, 1.191083>, 
      <-4.661968, 19.198713, -1.634781>, <-2.330984, 19.198713, -1.634781>, <0.000000, 19.198713, -1.634781>, <2.330984, 19.198713, -1.634781>, 
      <-7.973088, 32.945663, -3.155615>, <-3.986544, 32.945663, -3.155615>, <0.000000, 32.945663, -3.155615>, <3.986544, 32.945663, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.986544, -37.652186, -3.155615>, <7.973088, -37.652186, -3.155615>, <11.959632, -37.652186, -3.155615>, <15.946176, -37.652186, -3.155615>, 
      <2.330984, -22.398499, -1.634781>, <4.661968, -22.398499, -1.634781>, <6.992952, -22.398499, -1.634781>, <9.323936, -22.398499, -1.634781>, 
      <1.310458, -6.658825, 1.191083>, <2.620916, -8.474394, 0.000000>, <3.931374, -8.474394, 0.000000>, <5.241832, -8.474394, 0.000000>, 
      <1.172310, -5.136622, 2.779209>, <2.301435, -6.237197, 2.571656>, <3.456664, -6.237197, 2.571656>, <5.004477, -6.649596, 1.285828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.172310, -5.136622, 2.779209>, <2.301435, -6.237197, 2.571656>, <3.456664, -6.237197, 2.571656>, <5.004477, -6.649596, 1.285828>, 
      <1.034162, -3.614419, 4.367335>, <1.981953, -4.000000, 5.143312>, <2.981953, -4.000000, 5.143312>, <4.767122, -4.824798, 2.571656>, 
      <1.068542, -2.710814, 5.526767>, <2.050714, -3.000000, 6.656046>, <2.981953, -3.000000, 5.143312>, <4.767122, -3.618598, 2.571656>, 
      <0.974298, -1.908791, 5.929453>, <1.837659, -1.903605, 5.512371>, <2.695035, -1.903605, 4.352940>, <3.964980, -2.212904, 2.772011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.974298, -1.908791, 5.929453>, <1.837659, -1.903605, 5.512371>, <2.695035, -1.903605, 4.352940>, <3.964980, -2.212904, 2.772011>, 
      <0.880054, -1.106767, 6.332139>, <1.624605, -0.807209, 4.368697>, <2.408117, -0.807209, 3.562568>, <3.162839, -0.807209, 2.972367>, 
      <0.880054, 0.156515, 6.332139>, <1.624605, 0.000000, 4.368697>, <2.408117, 0.000000, 3.562568>, <3.162839, 0.000000, 2.972367>, 
      <0.957108, 0.981862, 5.551269>, <1.803279, 1.000000, 4.756004>, <2.695035, 1.000000, 4.352940>, <3.964980, 1.206199, 2.772011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.957108, 0.981862, 5.551269>, <1.803279, 1.000000, 4.756004>, <2.695035, 1.000000, 4.352940>, <3.964980, 1.206199, 2.772011>, 
      <1.034162, 1.807209, 4.770400>, <1.981953, 2.000000, 5.143312>, <2.981953, 2.000000, 5.143312>, <4.767122, 2.412399, 2.571656>, 
      <1.068542, 2.710814, 5.123702>, <2.050714, 3.000000, 6.656046>, <2.981953, 3.000000, 5.143312>, <4.767122, 3.618598, 2.571656>, 
      <1.189500, 4.129917, 3.157393>, <2.335815, 5.030997, 3.328023>, <3.456664, 5.030997, 2.571656>, <5.004477, 5.340296, 1.285828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.189500, 4.129917, 3.157393>, <2.335815, 5.030997, 3.328023>, <3.456664, 5.030997, 2.571656>, <5.004477, 5.340296, 1.285828>, 
      <1.310458, 5.549021, 1.191083>, <2.620916, 7.061995, 0.000000>, <3.931374, 7.061995, 0.000000>, <5.241832, 7.061995, 0.000000>, 
      <2.330984, 19.198713, -1.634781>, <4.661968, 19.198713, -1.634781>, <6.992952, 19.198713, -1.634781>, <9.323936, 19.198713, -1.634781>, 
      <3.986544, 32.945663, -3.155615>, <7.973088, 32.945663, -3.155615>, <11.959632, 32.945663, -3.155615>, <15.946176, 32.945663, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <15.946176, -37.652186, -3.155615>, <19.932720, -37.652186, -3.155615>, <23.919264, -37.652186, -3.155615>, <28.121640, -37.652186, -3.145700>, 
      <9.323936, -22.398499, -1.634781>, <11.654920, -22.398499, -1.634781>, <13.985904, -22.398499, -1.634781>, <27.905808, -32.945663, -3.155615>, 
      <5.241832, -8.474394, 0.000000>, <6.552290, -8.474394, 0.000000>, <13.985904, -19.198713, -1.634781>, <27.905808, -28.239139, -3.155615>, 
      <5.004477, -6.649596, 1.285828>, <6.552290, -7.061995, 0.000000>, <13.985904, -15.998928, -1.634781>, <27.905808, -23.532616, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.004477, -6.649596, 1.285828>, <6.552290, -7.061995, 0.000000>, <13.985904, -15.998928, -1.634781>, <27.905808, -23.532616, -3.155615>, 
      <4.767122, -4.824798, 2.571656>, <6.552290, -5.649596, 0.000000>, <13.985904, -12.799142, -1.634781>, <27.905808, -18.826093, -3.155615>, 
      <4.767122, -3.618598, 2.571656>, <6.552290, -4.237197, 0.000000>, <13.985904, -9.599357, -1.634781>, <27.905808, -14.119570, -3.155615>, 
      <3.964980, -2.212904, 2.772011>, <5.234925, -2.522203, 1.191083>, <13.985904, -6.399571, -1.634781>, <27.905808, -9.413046, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.964980, -2.212904, 2.772011>, <5.234925, -2.522203, 1.191083>, <13.985904, -6.399571, -1.634781>, <27.905808, -9.413046, -3.155615>, 
      <3.162839, -0.807209, 2.972367>, <3.917560, -0.807209, 2.382166>, <13.985904, -3.199786, -1.634781>, <27.905808, -4.706523, -3.155615>, 
      <3.162839, 0.000000, 2.972367>, <3.917560, 0.000000, 2.382166>, <13.985904, 0.000000, -1.634781>, <27.905808, 0.000000, -3.155615>, 
      <3.964980, 1.206199, 2.772011>, <5.234925, 1.412399, 1.191083>, <13.985904, 3.199786, -1.634781>, <27.905808, 4.706523, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.964980, 1.206199, 2.772011>, <5.234925, 1.412399, 1.191083>, <13.985904, 3.199786, -1.634781>, <27.905808, 4.706523, -3.155615>, 
      <4.767122, 2.412399, 2.571656>, <6.552290, 2.824798, 0.000000>, <13.985904, 6.399571, -1.634781>, <27.905808, 9.413046, -3.155615>, 
      <4.767122, 3.618598, 2.571656>, <6.552290, 4.237197, 0.000000>, <13.985904, 9.599357, -1.634781>, <27.905808, 14.119570, -3.155615>, 
      <5.004477, 5.340296, 1.285828>, <6.552290, 5.649596, 0.000000>, <13.985904, 12.799142, -1.634781>, <27.905808, 18.826093, -3.155615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.004477, 5.340296, 1.285828>, <6.552290, 5.649596, 0.000000>, <13.985904, 12.799142, -1.634781>, <27.905808, 18.826093, -3.155615>, 
      <5.241832, 7.061995, 0.000000>, <6.552290, 7.061995, 0.000000>, <13.985904, 15.998928, -1.634781>, <27.905808, 23.532616, -3.155615>, 
      <9.323936, 19.198713, -1.634781>, <11.654920, 19.198713, -1.634781>, <13.985904, 19.198713, -1.634781>, <27.905808, 28.239139, -3.155615>, 
      <15.946176, 32.945663, -3.155615>, <19.932720, 32.945663, -3.155615>, <23.919264, 32.945663, -3.155615>, <28.121640, 32.945663, -3.145700>
    }
  }
  texture {
    Sand_Tex finish{ambient 0.2}  }
    clipped_by{box{<10,10,10><-10,-10,-10>}}

rotate -90*x scale 0.5    //to put it right way up and right size
}
 #end

