/*
//debut de fichier
camera {
    location <50, 60, -200>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <50, 60, 0>
}

#default {
  pigment {rgb <1,1,1>}
 }
//creation d'une source de lumiere ponctuelle
light_source {
    0*x //POSITION de base
    color rgb 1 //COULEUR
    //fade_distance FADE_DISTANCE // attnuation de la lumire avec la distance
    // fade_power FADE_POWER 		// idem
    translate <2000, 000, -2000>// deplace  la lumiere
    }
#declare cm=1;
#declare m=cm*100; 
#declare hazard=seed(0); 
#declare Planche=
texture {
    pigment {
        bozo//gradient y
        color_map {
            [ 0.000 rgb <0.75, 0.65, 0.45> ] 
            [ 0.100 rgb <0.75, 0.65, 0.45> ] 
            [ 0.101 rgb <0.75, 0.65, 0.45> ] 
            [ 0.900 rgb <0.70, 0.55, 0.40> ] 
            [ 0.901 rgb <0.70, 0.55, 0.40> ] 
            [ 1.000 rgb <0.75, 0.65, 0.45> ] 
        }turbulence <.25,.2,.2>
    }
    scale 10
    scale <40,.5,1>
    scale .5
}
*/

//les portes du sallon et la fenetre du saloon

#declare porte_saloon_gauche=
union {
box{
  <-4, 0, -5>  
  < 1,  2*m-1,  5>  
texture {Planche translate rand(hazard)*10 rotate 90*z}
}
box{
  <-5, 2*m-1, -10>  
  < 1.1*m,  2*m+5,  5>  
texture {Planche translate rand(hazard)*10}
}
box{
  <0, 0, -2.5>  
  < 5,  1.5*m,  2.5>
  texture {Planche translate rand(hazard)*10 rotate 90*z scale .5}
}

box{
  <0, 0, -2.5>  
  < 5,  1.3*m,  2.5>
  translate 65*x  
  texture {Planche translate rand(hazard)*10 rotate 90*z scale .5}
}
box{
  <0, 0, -2.>  
  < 60,  20,  2.>
  translate <5,5,0>
    texture {Planche translate rand(hazard)*10  scale .5}
}

prism {
  linear_spline
  linear_sweep
  -2,
  2,
  5,
  <0, 1.05*m>,<0, 1.45*m>,<65, 1.25*m>,<65,1.05*m>,<0, 1.05*m>
    texture {Planche translate rand(hazard)*10 rotate 90*x scale .5}
  rotate -90*x
}
#declare tr=27;
#declare nb=0;
#while (nb<7)
box{
  <0, 0, -1.>  
  < 60,  10,  1.>
  texture {Planche translate rand(hazard)*10 scale .5}
  rotate 5*x
  translate <5,tr,0>
}
#declare tr=tr+11;
#declare nb=nb+1;
#end
} 


#declare porte_saloon_droite=
union {
box{
  <-4, 0, -5>  
  < 1,  2*m-1,  5>  
texture {Planche translate rand(hazard)*10 rotate 90*z}
}
box{
  <0, 0, -2.5>  
  < 5,  1.5*m,  2.5>
    texture {Planche translate rand(hazard)*10 rotate 90*z scale .5}
}

box{
  <0, 0, -2.5>  
  < 5,  1.3*m,  2.5>
  translate 65*x  
  texture {Planche translate rand(hazard)*10 rotate 90*z scale .5}
}
box{
  <0, 0, -2.>  
  < 60,  20,  2.>
  texture {Planche translate rand(hazard)*10  scale .5}
  translate <5,5,0>  
}

prism {
  linear_spline
  linear_sweep
  -2,
  2,
  5,
  <0, 1.05*m>,<0, 1.45*m>,<65, 1.25*m>,<65,1.05*m>,<0, 1.05*m>
  texture {Planche translate rand(hazard)*10 rotate 90*x scale .5}
  rotate -90*x
}
#declare tr=27;
#declare nb=0;
#while (nb<7)
box{
  <0, 0, -1.>                                
  < 60,  10,  1.>
  texture {Planche translate rand(hazard)*10  scale .5}
  rotate -5*x
  translate <5,tr,0>
}
#declare tr=tr+11;
#declare nb=nb+1;
#end
}

//la fenetre du saloon
#declare grd_fenetre=
union {
box{
  <-4, -4, -5>  
  < 2.04*m, 1,  2.5>
  texture {Planche translate rand(hazard)*10  scale .5}
}
box{
  <-4, 1.39*m, -2.5>  
  < 2.04*m, 1.44*m,  2.5>
    texture {Planche translate rand(hazard)*10  scale .5}
}
box{
  <-4, 1, -2.5>  
  < 1, 1.39*m,  2.5>
    texture {Planche translate rand(hazard)*10 rotate 90*z scale .5}
}
box{
  <1.99*m, 1, -2.5>  
  < 2.04*m, 1.39*m,  2.5>
  texture {Planche translate rand(hazard)*10 rotate 90*z scale .5}
}
box{
  <4, 1, -.5>  
  < 1.99*m, 1.39*m,  .5>
pigment {image_map { gif "saloon.gif"
    filter 24, .950
    } scale <195,138,1> translate <4,1,-5> }}  

finish {
        specular 1
        roughness 0.001
        ambient 0
        diffuse 0
        reflection 0.1
    }
interior {
    ior 1.5
    caustics 1
    fade_power 1
    fade_distance 1
    }    


}
//panneaux du saloon
#declare pan_saloon=
box{
  <0, 0, -3>  
  < 2*m,  .5*m,  0>
  texture { Planche translate rand(hazard)*100  scale 3} 
  texture {
  pigment {image_map { gif "sleepsaloon.gif"
    filter 1, 1 
    } scale <2*m,50,1> }}  
 
  rotate -87*z

}

#declare pan_gs=
box{
  <0, 0, -3>  
  < 2*m,  1*m,  0>
  //texture { Planche translate rand(hazard)*100  scale .3 } 
  texture {
  pigment {image_map { gif "gs.gif"
    transmit 0, 1 
    } scale <2*m,1*m,1> }}  
  //finish {ambient .1 diffuse .5}
  //rotate -87*z
}


#declare pan_gsp=
union {
cylinder {
  -5*x,  27*x,  1
  pigment {
        spotted
        color_map {
            [ 0.000 rgb <0.500,0.320,0.200> ] 
            [ 0.200 rgb <0.500,0.320,0.200> ] 
            [ 0.501 rgb <1.000,0.000,0.000> ] 
            [ 1.000 rgb <1.000,0.000,0.000> ] 
        }
    }
  translate 20*y
}
sphere
{
<27, 20, 0>   1.5       
pigment {
        spotted
        color_map {
            [ 0.000 rgb <0.500,0.320,0.200> ] 
            [ 0.200 rgb <0.500,0.320,0.200> ] 
            [ 0.501 rgb <1.000,0.000,0.000> ] 
            [ 1.000 rgb <1.000,0.000,0.000> ] 
        }
    }
}
torus
{
  2,
  0.2
  //scale <1,1,2>
  rotate <90, 90,0>
  translate <2,18,0>
  texture {
    pigment {
        color rgb <1.000,0.831,0.494>
    }
    finish {
        roughness 0.1
        specular 0.8
        brilliance 8
        reflection 0.15
        diffuse 0.7
        ambient <0.300, 0.300, 0.300 >
    }
}
}
torus
{
  2,
  0.2
  //scale <1,1,2>
  rotate <90, 90,0>
  translate <22.8,18,0>
texture {
    pigment {
        color rgb <1.000,0.831,0.494>
    }
    finish {
        roughness 0.1
        specular 0.8
        brilliance 8
        reflection 0.15
        diffuse 0.7
        ambient <0.300, 0.300, 0.300 >
    }
}
}
box{
  <-5.5, -2.5, -2.5>  
  < -5,  2.5,  2.5>   translate 20*y
  pigment {
        spotted
        color_map {
            [ 0.000 rgb <0.500,0.320,0.200> ] 
            [ 0.200 rgb <0.500,0.320,0.200> ] 
            [ 0.501 rgb <1.000,0.000,0.000> ] 
            [ 1.000 rgb <1.000,0.000,0.000> ] 
        }
    }
}

box{
  <0, 0, -1.5>  
  < 24.8,  16.9,  1.5>
  texture { Planche translate rand(hazard)*100  scale .3 } 
  texture {
  pigment {image_map { gif "gs1.gif"
    transmit 0, 1 
    } scale <24.8,16.9,1> }}  
  //finish {ambient .1 diffuse .5}
  //rotate -87*z
}
translate <5.5,-20,0>
}
 
#declare hampe=
union {
union {
cylinder {
  0*z,  -1.25*m*z,  4
}          
cylinder {
  -1.25*m*z,  -1.3*m*z,  8
}
cylinder {
  0*z,  -.02*m*z,  12
}
pigment {
        spotted
        color_map {
            [ 0.000 rgb <0.500,0.320,0.200> ] 
            [ 0.200 rgb <0.500,0.320,0.200> ] 
            [ 0.501 rgb <0.300,0.300,1.000> ] 
            [ 1.000 rgb <0.300,0.300,1.000> ] 
        }scale 5
    }
}
box{
  <0, 0, 5>  
  < 1*m,  1*m,  -.5>
  texture { Planche translate rand(hazard)*100  scale .3 } 
  texture {
  pigment {image_map { gif "hotel.gif"
    transmit 0, 1 
    } scale <1*m,1*m,1> }}
      rotate 90*y  translate <0,-1.1*m,-.2*m>
}

}