// =========================================
// New York City lamplights for Povray 3.1g
// -----------------------------------------
// (c) 2000 Gilles Tran tran@inapg.inra.fr
// http://www.mediaport.net/Artichaud/Tran
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// These are several lamplights and stoplights NYC-style
// Disclaimer: you'll have to figure out the parameters yourself if you want to change something
// One POV unit = 1 meter
// -----------------------------------------
// Convert the maps from jpg to png before use !!!!!!!!
// -----------------------------------------
// 28/04/2000
// ============================
#version unofficial Megapov 0.4;
#include "colors.inc"

#declare yPostMast=7.5; // Height of the main mast
#declare rLampSupport=2.5; // radius of the lamp support
#declare yStopLightSupport=1.5; // height of the stoplight branch
#declare zStopLightSupport=4;  // length of the stoplight branch
#declare yStopLightRig=4.25;  
#declare yDontWalkRig=2.33;  

//--------------------------------------
// Textures
//--------------------------------------
#declare colPaint=rgb<255,206,67>/255;
#declare txtStopLight=texture{
        pigment{
                bozo
                color_map{
                        [0 color colPaint]
                        [1 color colPaint*0.7]
                }
        }                                
        normal{bozo 0.7 scale 2}
        finish{ambient 0 diffuse 0.6 specular 0.3 roughness 0.1 reflect_metallic}
        scale 0.5

}
//--------------------------------------
// Texture mast
//--------------------------------------
#declare colPost=rgb<1,0.8,0.7>;
#declare colPost=rgb<197,213,209>/255;
#declare txtNYPostAttach=texture{
        pigment{colPost*1.2}
        finish{ambient 0  brilliance 3 diffuse 0.6 metallic specular 0.70 roughness 1/60 reflection 0.05}
}
#declare txtNYPost0=texture{
        pigment{
                crackle solid
                color_map{
                        [0 color colPost*0.7*0.1]
                        [1 color colPost*1.5*0.1]
                }
                
        }                              
        finish{ambient 0  brilliance 3 diffuse 0.4 metallic specular 0.70 roughness 1/60 reflection 0.01}
}
#declare txtNYPost1=texture{
        pigment{
                bozo turbulence 0.3
                color_map{
                        [0 color colPost*0.7*0.2]
                        [1 color colPost*1.5*0.2]
                }
                
        }                              
        normal{granite bump_size 0.01 scale 0.1}
        finish{ambient 0  brilliance 3 diffuse 0.4 metallic specular 0.70 roughness 1/60}
}
#declare txtNYPost2=texture{
        pigment{
                bozo turbulence 0.3
                color_map{
                        [0 color colPost*0.8]
                        [1 color colPost*1.7]
                }
                scale 3
                
        }
        normal{granite bump_size 0.1 scale 0.05}
        finish{ambient 0  brilliance 3 diffuse 0.4 metallic specular 0.70 roughness 1/60 }
}                  
#declare txtNYPost3=texture{
        pigment{
                bozo turbulence 0.3
                color_map{
                        [0 color colPost*0.8]
                        [1 color colPost*1.7]
                }
                scale 3
                
        }
        normal{granite bump_size 0.1 scale 0.05}
        finish{ambient 0  brilliance 3 diffuse 0.4 metallic specular 0.70 roughness 1/60 reflection 0.25}
}                  
#declare txtNYPost=texture{
        gradient y
        poly_wave 0.2
        texture_map{
                [0 txtNYPost1 scale 0.01]
                [1 txtNYPost3 scale 0.01]
        }
        scale (yPostMast+rLampSupport)*1.1
}

#declare matGlass=material{
        texture{pigment{rgbf <0.5,0.5,0.5,0.9>} finish{ambient 0 diffuse 0.1 specular 1 roughness 0.001 reflection 0.3}}
        interior{ior 1.45}
}
//--------------------------------------
// Mat
//--------------------------------------
#declare PostBase=union{
        object{#include "postbase.inc"}
        union{
                superellipsoid{<0.3,0.3> scale <1,0.3,0.1>}
                superellipsoid{<0.3,0.3> scale <1,0.3,0.1> rotate y*90}
                scale 0.37*<1,2,1> translate -y*0.2
                translate y
        }
        texture{
                gradient y
                texture_map{
                        [0 txtNYPost0 scale 0.02]
                        [1 txtNYPost2 scale 0.02]
                }
                scale 2
        }
}

#declare PostMast=union{
        object{#include "postmast.inc" rotate y*20 scale <0.26,yPostMast,0.26>}
        union{
                sphere{0,0.1 scale <1,0.4,1>}
                sphere{0,0.075 scale <1,1,1> translate y*0.01}
                sphere{0,0.1 scale <1,0.4,1> translate -y*0.2}
                cylinder{0,-y*0.2,0.08}
                translate y*yPostMast
        }
}       
//--------------------------------------
// Joint
//--------------------------------------
#macro Joint(rj)
        union{
                cylinder{-y*0.13,y*0.13,rj}
                torus{rj,0.025 scale <1.2,1,1.2> translate y*0.15}
                sphere{0,0.5 scale <0.04,0.04,rj*2> rotate y*45 translate y*0.075}
                sphere{0,0.5 scale <0.04,0.04,rj*2> rotate -y*45 translate y*0.075}
                sphere{0,0.5 scale <0.04,0.04,rj*2> rotate y*90 translate y*0.075}
                torus{rj,0.025}
                sphere{0,0.5 scale <0.04,0.04,rj*2> rotate y*45 translate -y*0.075}
                sphere{0,0.5 scale <0.04,0.04,rj*2> rotate -y*45 translate -y*0.075}
                sphere{0,0.5 scale <0.04,0.04,rj*2> rotate y*90 translate -y*0.075}
                torus{rj,0.025 scale <1.2,1,1.2> translate -y*0.15}
        }
#end                    
//--------------------------------------
// Lamp
//--------------------------------------
#declare Lamp=union{ 
        object{#include "postlamp.inc" scale <1,1,-1.2> translate -z*0.1}
        sphere{0,1 scale 0.4 scale <0.8,0.8,1.2> translate <0,-0.2,1.7> material{matGlass}}
}                          
//--------------------------------------
// Lamp support
//--------------------------------------
#declare LampSupport=union{
        difference{
                torus{rLampSupport,0.04 rotate z*90}
                plane{y,0}
                plane{z,0 inverse}
        }
        object{Lamp scale 0.4 translate <0,rLampSupport-0.045,0>}
        union{
                cylinder{0,-y*0.25,0.05}
                sphere{0,0.1 scale <1,0.3,1> translate -0.05*y}
                cylinder{-0.05*y,-0.2*y,0.08}
                sphere{0,0.1 scale <1,0.3,1> translate -0.2*y}
                translate -z*rLampSupport
        }                             
        translate z*(rLampSupport+0.15)
}                               
//--------------------------------------
// Stop light support
//--------------------------------------
#declare rSLSB=0.125;
#declare rSLS=(pow(zStopLightSupport,2)+pow(yStopLightSupport,2))/(2*yStopLightSupport);
#declare tSLS=degrees(asin(zStopLightSupport/rSLS));
#declare StopLightSupport=union{
        // arc
        difference{
                torus{rSLS,0.04 rotate z*90}
                plane{z,0 inverse}
                plane{y,yStopLightSupport}
                plane{z,-zStopLightSupport}
        }

        // end
        union{        
                torus{0.05,0.02 rotate x*90 translate z*0.1}
                torus{0.05,0.02 rotate x*90 translate -z*0.1}
                cylinder{-z*0.1,z*0.1,0.05}
                difference{
                        torus{0.1,0.065 rotate z*90}
                        plane{z,0}
                        plane{y,0}
                        translate <0,-0.1,0.1>
                }              
                sphere{0,0.07 translate <0,-0.1,0.2>}
                // potence
                union{
                        cylinder{0,0.115*y,0.02}
                        superellipsoid{<0.3,0.3> translate -y*0.5 scale <0.1,0.6,0.1>*0.125 rotate y*45}
                        translate -y*0.115
                }
                // liaison
                union{
                        difference{
                                cylinder{-0.025*z,z*0.025,0.1}
                                plane{y,0 inverse}
                        }
                        cylinder{0,0.175*y,0.015 translate -x*0.075}
                        cylinder{0,0.175*y,0.015 translate x*0.075}
                        sphere{0,0.02 scale <1,1,2> translate <-0.075,0.15,0>}
                        sphere{0,0.02 scale <1,1,2> translate <0.075,0.15,0>}
                        
                        // wiring
                        #declare xRig=0.75; 
                        #declare yRig=0.3;
                        cylinder{<-0.075,0.15,0>,<-xRig,yRig,-zStopLightSupport-0.55>,0.01}
                        cylinder{<0.075,0.15,0>,<xRig,yRig,-zStopLightSupport-0.55>,0.01}
                        sphere{<-xRig,yRig,-zStopLightSupport-0.55>,0.02}
                        sphere{<xRig,yRig,-zStopLightSupport-0.55>,0.02}
                        union{
                                // Support
                                object{Joint(0.1)}
                                difference{
                                        cylinder{-x,x,1}
                                        cylinder{-x*1.1,x*1.1,0.9}
                                        scale <xRig*1.2,0.07,0.07>
                                        translate -z*0.14
                                }
                                translate -z*(zStopLightSupport+0.1+rSLSB)
                                translate y*yRig
                        }
                        
                }
                translate y*rSLS
        }
        translate <0,-rSLS+yStopLightSupport,zStopLightSupport>
}                               

//--------------------------------------
// Stop light support base
//--------------------------------------
#declare StopLightSupportBase=union{
        object{Joint(rSLSB*0.9)}
        union{                
                union{
                        torus{0.1,0.02 rotate z*90}
                        difference{sphere{0,0.08 scale <0.5,1,1>}sphere{0,0.03 translate -x*0.04}}
                        cylinder{0,-z*0.15+x*0.04,0.06 rotate -x*20  scale <0.5,1,1>} 
                        translate -x*rSLSB
                }
                union{
                        torus{0.1,0.02 rotate z*90}
                        difference{sphere{0,0.08 scale <0.5,1,1>}sphere{0,0.03 translate x*0.04}}
                        cylinder{0,-z*0.15-x*0.04,0.06 rotate -x*20  scale <0.5,1,1>} 
                        translate x*rSLSB
                }
                scale 0.9
                translate z*rSLSB*1.2
        }                                                          
}
//cylinder{0,<0,yStopLightSupport,zStopLightSupport>,0.1}

//--------------------------------------
// Stop light shade
//--------------------------------------
#declare zShade=0.5;
#declare rShade=0.25;   
#declare rShadeBox=rShade*1.25;
#declare Shade=union{
        // Shade        
        difference{
                difference{
                        cylinder{0,z*zShade,rShade}
                        cylinder{-z*0.1,z*zShade*1.1,rShade*0.97}
                        cylinder{-z*0.1,z*zShade*1.1,rShade*0.9 translate -y*rShade*1.5}
                        rotate x*8
                }          
                plane{z,zShade*0.9 inverse}
                translate -zShade*z*0.1
        }
        superellipsoid{<0.3,0.3> translate -z scale <rShadeBox,rShadeBox,rShade*0.3> }
        union{
                cylinder{<0,0,zShade*0.2>,<0,rShade*0.5,-rShade*0.5>,rShade*0.2 translate y*rShade*0.8 rotate z*-60}
                cylinder{<0,0,zShade*0.2>,<0,rShade*0.5,-rShade*0.5>,rShade*0.2 translate y*rShade*0.8 rotate z*-120}
                cylinder{<0,0,zShade*0.2>,<0,rShade*0.5,-rShade*0.5>,rShade*0.2 translate y*rShade*0.8 rotate z*60}
                cylinder{<0,0,zShade*0.2>,<0,rShade*0.5,-rShade*0.5>,rShade*0.2 translate y*rShade*0.8 rotate z*120}
        }
        
}              
//--------------------------------------
// Shade light
//--------------------------------------
#macro ShadeLight(colShade)
        union{
                object{Shade}
                sphere{0,1
                texture{                           
                        pigment{
                        gradient x
                                color_map{
                                        [0 colShade*2]
                                        [0.7 colShade]
                                        [0.8 Black]
                                }
                                translate x*10
                                scale 0.2
                        }
                        finish{ambient 1 diffuse 0}
                }
                scale rShade*0.9
                }       
                #if(colShade.x>0 | colShade.y>0 | colShade.z>0)
                cylinder{0,z,1
                        hollow
                        texture{pigment{Clear} finish{ambient 0 diffuse 0}}
                        interior{
                                media{emission 6 method 2 density{gradient z color_map{[0 colShade][1 Black]}}}
                        }
                        scale <rShade*0.99,rShade*0.99,zShade*1>
                        rotate x*8
                }
                #end
                translate y*rShadeBox
        }
#end      
//--------------------------------------
// Top of the stop light
//--------------------------------------
#declare rSLT=rShadeBox*0.2;      
#declare StopLightTop=union{
        torus{rSLT,rSLT*0.3}
        cylinder{0,y*rShadeBox,rSLT}
        sphere{0,rSLT*1.4 translate y*rShadeBox}
        cylinder{0,-z*rShadeBox*2,rSLT translate y*rShadeBox}
}
//--------------------------------------
// Green light
//--------------------------------------
#declare Green=rgb<0.1,0.9,0.3>*1.2;
#declare StopLightGreen=union{
                object{ShadeLight(Green)}
                object{ShadeLight(Black) translate y*rShadeBox*2}
                object{ShadeLight(Black) translate y*rShadeBox*4}
                box{<-rShadeBox*1.1,0,-rShadeBox>,<rShadeBox*1.1,6*rShadeBox,-rShadeBox*0.3>}
                object{StopLightTop translate <0,6*rShadeBox,-rSLT*1.3>}
                translate z*rShadeBox*1.6
}
//--------------------------------------
// Red light
//--------------------------------------
#declare Red=rgb<1.1,0.02,0.02>;
#declare StopLightRed=union{
                object{ShadeLight(Black)}
                object{ShadeLight(Black) translate y*rShadeBox*2}
                object{ShadeLight(Red) translate y*rShadeBox*4}
                box{<-rShadeBox*1.1,0,-rShadeBox>,<rShadeBox*1.1,6*rShadeBox,-rShadeBox*0.3>}
                object{StopLightTop translate <0,6*rShadeBox,-rSLT*1.3>}
                translate z*rShadeBox*1.6
}               
//--------------------------------------
// 4 lights
//--------------------------------------
#declare StopLight4=union{
        object{StopLightGreen rotate z*2 translate z*0.1}
        object{StopLightRed rotate x*9 rotate y*90 translate x*0.1}
        object{StopLightGreen rotate z*1 rotate y*180 translate -z*0.1}
        object{StopLightRed rotate x*10 rotate y*270 translate -x*0.1}
        union{
                difference{
                        superellipsoid{<0.5,0.5>}
                        cylinder{-x*2,x*2,0.6}
                        cylinder{-z*2,z*2,0.6}
                }           
                difference{
                        sphere{0,0.9 scale <1,1.2,1>}
                        plane{y,0 inverse}
                        translate -y
                }
                scale rShadeBox*0.4
                translate y*7*rShadeBox
        }
        translate -y*6.1*rShadeBox     
        texture{txtStopLight}
}                                     
//--------------------------------------
// Stoplight rig
//--------------------------------------
#declare StopLightRig=union{
        union{
                object{StopLight4 scale 0.34 rotate y*30 translate <0,yStopLightSupport*0.8,zStopLightSupport>}
                object{StopLightSupport}
                translate z*(rSLSB+0.1)
        }
        object{StopLightSupportBase}
        translate y*yStopLightRig
        
}

//--------------------------------------
// Don't walk & Walk
//--------------------------------------
#declare DontWalkBox=superellipsoid{<0.2,0.2> 
        texture{pigment{image_map{png "dontwalkmap"} scale <-2,2,1> translate <1,-1,0>} finish{ambient 1 diffuse 0}}
        scale 0.9*<1,1,0.1> translate z*0.5
        scale <1.2,1,0.75>
}
#declare WalkBox=superellipsoid{<0.2,0.2> 
        texture{pigment{image_map{png "walkmap"} scale <-2,2,1> translate <1,-1,0>} finish{ambient 1 diffuse 0}}
        scale 0.9*<1,1,0.1> translate z*0.5
        scale <1.2,1,0.75>
}        
#declare EmptyBox=union{
        difference{
                union{
                        superellipsoid{<0.2,0.2>}
                        superellipsoid{<0.2,0.2> scale 0.9 translate -z*0.25}
                        difference{
                                superellipsoid{<0.2,0.2>}
                                plane{z,0.7}
                                scale <1.03,1.03,1.001>
                        }
                }          
        superellipsoid{<0.2,0.2> scale 0.9 translate z*0.5 texture{pigment{White*0.3}}}
        scale <1.2,1,0.75>
        }
        union{
                cylinder{-z,0,0.8} 
                difference{
                        cylinder{-z,0,1} 
                        cylinder{-z*1.1,z,0.9} 
                }
                scale 0.2
                translate <0,0.5,-0.75>
        }
        
}
#declare DontWalk=union{object{EmptyBox} object{DontWalkBox}}
#declare Walk=union{object{EmptyBox} object{WalkBox}}
//--------------------------------------
// Branch don't walk
//--------------------------------------
#declare rDWS=0.12; // radius of pipe
#declare RDWS=3; // radius of curve
#declare xDWS2=0.5; // length of attach
#declare yDWS=1.2;  // height of branch
#declare sqrt22=pow(2,0.5)/2;
#declare xDWSa=0.5;
#declare xDWSb=2;

#macro mDWB(xDWS)
// rDWS : radius of pipe
// RDWS : radius of curve
// xDWS : length of branch
// yDWS : height of branch
union{
        sphere{0,rDWS*1.1 scale <0.5,1,1> translate -x*xDWS*1.2}
        cylinder{-x*xDWS*1.2,0,rDWS}
        cylinder{-y*yDWS,0,rDWS translate -x*xDWS}
        difference{
                torus{RDWS,rDWS}
                plane{z,sqrt22*RDWS}
                plane{x,0}
                translate -z*RDWS
        }                
        translate <-RDWS*sqrt22,0,RDWS*(1-sqrt22)>
}        
#end
//--------------------------------------
// Support don't walk
//--------------------------------------
#declare DontWalkSupport=union{                         
        union{                                   
                object{mDWB(xDWSa)}
                object{mDWB(xDWSb) scale <-1,1,1> rotate -y*90}
                cylinder{<xDWS2,0,-xDWS2>,0,rDWS}
                superellipsoid{<0.4,0.4> scale <1,3,1>*rDWS rotate y*45 translate <xDWS2,0,-xDWS2>}
                translate <-xDWS2,yDWS,xDWS2>
        }              
                  
        union{
                object{mDWB(xDWSa)}
                object{mDWB(xDWSb) scale <-1,1,1> rotate -y*90}
                cylinder{<xDWS2,0,-xDWS2>,0,rDWS}
                superellipsoid{<0.4,0.4> scale <1,3,1>*rDWS rotate y*45 translate <xDWS2,0,-xDWS2>}
                translate <-xDWS2,yDWS,xDWS2>
                scale <1,-1,1>
        }
        
}                           
                       
//--------------------------------------
// Rig don't walk
//--------------------------------------
#declare tDWR=10;
#declare DontWalkRig=union{
        object{DontWalk rotate y*(-45+tDWR) translate <-(xDWSa+xDWS2)-RDWS*sqrt22,0,xDWS2+RDWS*(1-sqrt22)>}
        object{Walk rotate y*(45+tDWR) translate <-xDWS2-RDWS*(1-sqrt22),0,xDWSb+xDWS2+RDWS*sqrt22>}
        object{DontWalkSupport}
        texture{txtStopLight}
        rotate y*45
        scale 0.167
} 
#declare tDWR=10;
#declare DontWalkRigLeftOpp=union{
        object{DontWalk scale <1,1,-1> rotate y*(-45+tDWR) translate <-(xDWSa+xDWS2)-RDWS*sqrt22,0,xDWS2+RDWS*(1-sqrt22)>}
        object{Walk scale <-1,1,-1> rotate y*(45+tDWR) translate <-xDWS2-RDWS*(1-sqrt22),0,xDWSb+xDWS2+RDWS*sqrt22>}
        object{DontWalkSupport}
        texture{txtStopLight}
        rotate y*45
        scale 0.167
} 

#declare DontWalkRigLeft=union{
        object{DontWalk scale <1,1,1> rotate y*(-45+tDWR) translate <-(xDWSa+xDWS2)-RDWS*sqrt22,0,xDWS2+RDWS*(1-sqrt22)>}
        object{Walk scale <-1,1,1> rotate y*(45+tDWR) translate <-xDWS2-RDWS*(1-sqrt22),0,xDWSb+xDWS2+RDWS*sqrt22>}
        object{DontWalkSupport}
        texture{txtStopLight}
        rotate y*45
        scale 0.167
} 
//--------------------------------------
// Square post
//--------------------------------------
#declare NYSquarePost=union{
        box{<-0.02,0,0>,<0,4,0.05> translate -x*0.025}
        box{<-0.02,0,0>,<0,4,0.05> translate -x*0.025 scale <-1,1,1>}
        #declare i=0;
        #while (i<3.3)
                box{<-0.025,-0.015,-0.014>,<0.025,0.015,0.014> rotate x*45 translate <0,i,0.025>}
                #declare i=i+0.1;
        #end
}    
//--------------------------------------
// OneWay
//--------------------------------------
#declare NYOneWay=
superellipsoid{<0.1,0.1> 

        texture{
                pigment{image_map{png "oneway" once}}
                finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1}
                scale <2,2,1>
                translate <-1,-1,0>
                }
                
        scale <280,101,1>*0.4/280
}                
//--------------------------------------
// DogSign
//--------------------------------------
#declare NYDogSign=union{
        superellipsoid{<0.1,0.1> translate z}
        superellipsoid{<0.1,0.1> 
                texture{
                        pigment{image_map{png "ny_dog_sign" once}}
                        finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1}
                        scale <2,2,1>
                        translate <-1,-1,0>
                        }
        }                
        scale <250,340,1>*0.42/250
}                
//--------------------------------------
// Towaway
//--------------------------------------
#declare NYTowaway=union{
        superellipsoid{<0.1,0.1> translate z}
        superellipsoid{<0.1,0.1> 
                texture{
                        pigment{image_map{png "ny_towaway_sign" once}}
                        normal{bozo 0.2} 
                        finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1
                        reflection 0.3
                        }
                        scale <2,2,1>
                        translate <-1,-1,0>
                        }
        }                
        scale <250,340,1>*0.32/250
}                
//--------------------------------------
// Keep Clear
//--------------------------------------
#declare NYKeepClear=union{
        superellipsoid{<0.1,0.1> translate z}
        superellipsoid{<0.1,0.1> 
                texture{
                        pigment{image_map{png "ny_keep_sign" once}}
                        finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1}
                        scale <2,2,1>
                        translate <-1,-1,0>
                        }
        }                
        scale <122,126,1>*0.41/122
}                
//--------------------------------------
// FDR Drive
//--------------------------------------
#declare NYFDRSign=union{
        superellipsoid{<0.1,0.1> translate z}
        superellipsoid{<0.1,0.1> 
                texture{
                        pigment{image_map{png "ny_fdr_sign" once}}
                        finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1}
                        scale <2,2,1>
                        translate <-1,-1,0>
                        }
        }                
        scale <245,199,1>*0.63/245
}                
//--------------------------------------
// Municipal parking
//--------------------------------------
#declare NYParkSign=union{
        superellipsoid{<0.1,0.1> translate z}
        superellipsoid{<0.1,0.1> 
                texture{
                        pigment{image_map{png "ny_park_sign" once}}
                        finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1}
                        scale <2,2,1>
                        translate <-1,-1,0>
                        }
        }                
        scale <78,61,1>*0.34/78
}                
//--------------------------------------
// Bus sign
//--------------------------------------
#declare NYBusSign=union{
        superellipsoid{<0.1,0.1> translate z}
        superellipsoid{<0.1,0.1> 
                texture{
                        pigment{image_map{png "ny_bus_sign" once}}
                        finish{ambient 0 diffuse 0.7 specular 0.1 roughness 0.1}
                        scale <2,2,1>
                        translate <-1,-1,0>
                        }
        }                
        scale <231,318,1>*0.54/231
}                
//--------------------------------------
// Street name
//--------------------------------------
#macro StreetName(SNMap,dir,rmast)        
        union{
                union{
                        box{<0,0,-1>,1}
                        box{<0,0,-1.5>,<1,0.05,1.5>}
                        box{<0,0,-1.5>,<1,0.05,1.5> scale<1,-1,1> translate y}
                        texture{pigment{image_map{png SNMap once}} finish{ambient 0.1 diffuse 0.6}
                                #if (dir=-1)
                                        scale <-1,1,1>
                                        translate x
                                #end
                        }
                        scale <0.5,0.2,0.01>
                        translate x*rmast
                }
                union{
                        cylinder{0,y*0.02,rmast}
                        cylinder{0,y*0.02,rmast scale <1,-1,1> translate y*0.25}
                        texture{txtNYPostAttach}
                }     
        }
#end
//--------------------------------------
// Loupiotte
//--------------------------------------
#declare Loupiotte=union{
        #declare rmast=0.112;
        union{
                cylinder{0,z*0.3,0.03}
                difference{torus{0.1,0.03 rotate z*90} plane{y,0 inverse}plane{z,0} translate <0,0.1,0.3>}
                union{
                        union{
                                difference{sphere{0,1}plane{y,0 inverse}}
                                torus{1,0.2}
                                scale <0.08,0.06,0.08>
                        }
                        merge{
                                cone{0,0.08,y*0.2,0.06}
                                sphere{0,0.06 translate y*0.2}
                                material{
                                        texture{
                                                pigment{
                                                        color rgbt <0.878,0.455,0.11,0.1>*1.7
                                                        
                                                }
                                                finish{
                                                        ambient 0 diffuse 0.2 specular 0.1 roughness 0.1
                                                }
                                        }
                                        interior{
                                                ior 1.33
                                        }
                                }
                        }
                        translate <0,0.15,0.4>
                }                                    
                sphere{0,0.035}
                translate z*rmast
        }
        union{
                difference{
                        cylinder{-y*0.14,y*0.14,rmast}
                        plane{z,0}
                }
                sphere{0,0.025 translate <0,0.112,rmast> rotate y*60}
                sphere{0,0.025 translate <0,0.112,rmast> rotate -y*60}
                sphere{0,0.025 translate <0,-0.112,rmast> rotate y*60}
                sphere{0,0.025 translate <0,-0.112,rmast> rotate -y*60}
        }
}
//--------------------------------------
// Basic post
//--------------------------------------
#declare NYPost=union{
        object{PostBase scale <0.56,0.6,0.56> rotate y*90}
        object{PostMast}
        object{LampSupport translate <0,yPostMast,0>}
}                           
//--------------------------------------
// Corner Post
//
//--------------------------------------
#declare NYCornerPost=union{
        object{NYPost}
        object{StopLightRig rotate y*20}
        object{DontWalkRig no_reflection translate <-0.08,0,0.08>  rotate y*-85 translate y*yDontWalkRig}
        
        object{NYOneWay rotate z*2 translate <0,3.5,-0.14> rotate y*75}
        object{NYTowaway rotate z*2 translate <0,6.7,-0.14> rotate y*96}
        union{
                object{StreetName("stnamemap_211",1,0.12) translate y*3.5}
                object{StreetName("stnamemap_403",1,0.12) translate y*3.75 rotate y*90}
        }
        object{Loupiotte translate y*5 rotate y*180}
        
}                       

#declare NYCornerPostOpp=union{
        object{NYPost}
        object{StopLightRig rotate y*20}
        object{DontWalkRig translate <-0.08,0,0.08>  rotate y*-100 scale <-1,1,1> translate y*yDontWalkRig}
        
        object{NYOneWay rotate z*2 translate <0,3.2,-0.14> rotate y*75}
        object{NYTowaway rotate z*2 translate <0,6.7,-0.14> rotate y*96}
        union{
                object{StreetName("stnamemap_211",-1,0.12) rotate y*180 translate y*3.5}
                object{StreetName("stnamemap_403",1,0.12) translate y*3.75 rotate y*90}
        }
        object{Loupiotte translate y*5 rotate y*180}
        
}
#declare NYCornerPostLeftOpp=union{
        object{NYPost}
        object{StopLightRig}
        object{DontWalkRigLeftOpp translate <0.08,0,-0.08>  rotate y*80 translate y*yDontWalkRig}
        
        object{NYTowaway rotate z*2 translate <0,6.7,-0.14> rotate y*96 scale <1,1,-1>}
        union{
                object{StreetName("stnamemap_211",-1,0.12) translate y*3.5}
                object{StreetName("stnamemap_403",-1,0.12) translate y*3.75 rotate y*90}
        }
        object{Loupiotte translate y*5 rotate y*180}
        
}

#declare NYCornerPostLeft=union{
        object{NYPost}
        object{StopLightRig}
        object{DontWalkRigLeft translate <0.08,0,0.08>  rotate y*80 scale <1,1,-1> translate y*yDontWalkRig}
        union{        
                object{NYOneWay scale <-1,1,1> rotate z*1 translate <0,3.3,0.14> rotate y*75}
                object{NYTowaway rotate z*2 translate <0,6.3,-0.14> rotate y*96}
                union{
                        object{StreetName("stnamemap_211",1,0.12) rotate y*180 translate y*3.5}
                        object{StreetName("stnamemap_403",-1,0.12) rotate y*180 translate y*3.75 rotate y*90}
                }     
                scale <1,1,-1>
        }
        object{Loupiotte translate y*5 rotate y*180}
        
}

//--------------------------------------
// Other posts
//--------------------------------------
#declare NYPost_1=union{
        object{NYPost}
        object{NYDogSign rotate z*2 translate <0,3.5,-0.14> rotate y*75}
        object{NYFDRSign rotate -z*0.5 translate <-0.1,6.5,-0.14> rotate y*80}
        object{Loupiotte translate y*5 rotate y*170}
}

#declare NYPost_2=union{
        object{NYPost}
        object{NYKeepClear rotate -z*1 translate <-0.05,4.7,-0.14> rotate y*85}
        object{NYBusSign rotate z*0.5 translate <-0.15,6.3,-0.14> rotate y*95}
        object{Loupiotte translate y*4.7 rotate y*182}
}
#declare NYSmallPost_1=union{
        object{NYSquarePost}
        object{NYParkSign rotate -z*0.5 translate <-0.02,3.4,0>}
}


// =========================================
// Scene
// -----------------------------------------

camera
{
location  <0.0, 5, -25.0>
direction 2*z
right     4*x/3
look_at   <0.0, 5,  0.0>
}

background{White}
light_source{<1,1,-1>*1000 color White*1.5}
light_source{<-1,1,-1>*1000 color White*1}

union{
        object{NYCornerPost texture{txtNYPost} rotate -y*90}
//        object{NYCornerPostOpp texture{txtNYPost} rotate -y*90}
//        object{NYCornerPostLeft texture{txtNYPost} rotate -y*90}
//        object{NYCornerPostLeftOpp texture{txtNYPost} rotate -y*90}
        
        object{NYPost_1 texture{txtNYPost} rotate y*-90 translate <-3,0,1>}
        object{NYPost_2 texture{txtNYPost} rotate y*-90  translate <3,0,2>}
        object{NYSmallPost_1 texture{txtNYPost} translate <5,0,5>}
        
}        
