//textures01.inc
//all the textures in this file are modified versions of textures included in the original
//POV-Ray 3.1 distribution
//Luis Valoyes / Bogota / Colombia

#include "colors.inc"
#include "textures.inc"

#declare Water2 =
texture {
    pigment{ rgbf <0.2, 0.5, 0.7, 0.7> }
    normal {
        ripples 0.45
        frequency 5
    }
    finish {
        reflection 0.7
#version -1.0;
        refraction 0.5
        ior 1.33
    }
#version 3.1;
}
    
// Small puffs of white clouds
#declare New_Sky1 = 
pigment {
    granite
    turbulence 0.1
    color_map {
        [0.25 rgb <0, 0, 0>]
        [1.0 rgb <0.5, 0.5, 0.5>]
    }
    scale 50
}

#declare Vitra = 
texture {
    Glass3
    pigment { rgbf <1.0, 0.5, 0, 0.9> }
}
   
// black & white stripes - Looks best on a y axis Cylinder
// It "spirals" because it's gradient on two axis
#declare Zebra_01 = 
pigment {
    gradient x+y
    color_map {
        [0.25 rgb <0,0,0>]
        [0.25 rgb <1,1,1>]
        [0.75 rgb <1,1,1>]
        [0.75 rgb <0.5,0.5,0.5>]
    }
}

#declare Zebra_02 = 
pigment {
    gradient x+y
    color_map {
        [0.25 rgb <1,1,1>]
        [0.25 rgb <0,0,0>]
        [0.75 rgb <1,1,1>]
        [0.75 rgb <0.5,0.5,0.5>]
    }
}
#declare Bizarre_Stone = 
pigment {
    granite
    turbulence 1.75
    color_map {
        [0.4 rgb <0.25, 0.25, 0.25>]
        [1.0 rgb <0.05, 0.05, 0.05>]
    }
    scale 0.1250
} 
#declare VitraNova = 
texture {
    pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
    normal{ripples 0.1
        frequency 10}
    finish  {
        ambient 0.1
        diffuse 0.1
        reflection 0.1
        refraction 0.9
        ior 1.45
        specular 0.8
        roughness 0.05
        phong 1 
        phong_size 900
     }
}
// White marble
#declare Bizarre_Stone_02 =
texture {
    pigment {
        gradient x
        turbulence 0.75
        frequency 6
        scale 0.5
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgbf <0.15, 0.15, 0.15, 0.0> ]
            [0.10 color rgbf <0.20, 0.20, 0.20, 0.0> ]
            [1.00 color rgbf <0.45, 0.45, 0.45, 0.0> ]
        }
    }
}
texture {
    pigment {
        crackle
        turbulence 0.7
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.25
        frequency 3
        phase 0.25
        rotate <0, 15, 60>
        color_map {
            [0.00 color Clear ]
            [0.15 color rgbf <0.40, 0.30, 0.30, 0.50> ]
            [0.30 color rgbf <0.05, 0.08, 0.02, 0.00> ]
            [0.35 color rgbf <0.60, 0.40, 0.35, 0.50> ]
            [0.45 color rgbf <0.70, 0.65, 0.20, 0.60> ]
            [0.65 color Clear ]
        }
    }
}
