#include "colors.inc"
#include "textures.inc"
#include "irtc.inc" //Whale Tail

camera{
  location <0,50,0>
  //location <-1900,3000,-3000>
  look_at <100,0,-100>
  //look_at 0
}

#declare PolarBear = union {
  blob {
    threshold .3
    sphere { <0,0,0>,.7,3 scale <1,.7,.7> translate <0,1,0>} //Body
    sphere { <0,0,0>,.4,1 scale <1,1.3,1> translate <.45,1,-.15>} //LR Thigh
    sphere { <0,0,0>,.4,1 scale <1,1.3,1> translate <.45,1,.15>} //RR Thigh
    sphere { <0,0,0>,.32,1 scale <1,1.2,1> translate <-.4,1,-.15>} //LF Thigh
    sphere { <0,0,0>,.32,1 scale <1,1.2,1> translate <-.4,1,.15>} //RF Thigh
    cylinder { <0,0,0>,<0,.6,0>,.25,.5 translate <.5,.2,-.2>} //LR Leg
    cylinder { <0,0,0>,<0,.6,0>,.25,.5 translate <.5,.2,.2>} //RR Leg
    cylinder { <0,0,0>,<0,.6,0>,.25,.5 translate <-.4,.2,-.2>} //LF Leg
    cylinder { <0,0,0>,<0,.6,0>,.25,.5 translate <-.4,.2,.2>} //RF Leg
    sphere { <0,0,0>,.3,.2 translate <.5,.5,-.2>} //LR Knee
    sphere { <0,0,0>,.3,.2 translate <.5,.5,.2>} //RR Knee
    sphere { <0,0,0>,.3,.2 translate <-.5,.5,-.2>} //LF Knee
    sphere { <0,0,0>,.3,.2 translate <-.5,.5,.2>} //RF Knee
    sphere { <0,0,0>,.3,.75 scale <1,.3,.6> translate <.4,.1,-.2>} //LR Foot
    sphere { <0,0,0>,.3,.75 scale <1,.3,.6> translate <.4,.1,.2>} //RR Foot
    sphere { <0,0,0>,.3,.75 scale <1,.3,.6> translate <-.5,.1,-.2>} //LF Foot
    sphere { <0,0,0>,.3,.75 scale <1,.3,.6> translate <-.5,.1,.2>} //RF Foot
    sphere { <0,0,0>,.4,.7 translate <-.5,1.3,0>} //Head
    pigment {color Gray90 }    
    normal {bumps 1 scale <.1,.01,.01> turbulence .5}
    finish { ambient .5 }
  } 
  union {
    blob {
      threshold .3
      sphere { <0,0,0>,.45,.6 translate <0,1,0>} //Head
      sphere { <0,0,0>,.1,.25 translate <-.20,1.2,0>} //Ears
      sphere { <0,0,0>,.1,.25 translate <.20,1.2,0>} //Ears
      sphere { <0,0,0>,.2,2 scale <.7,.7,1.2> translate <0,1,-.20> } //Nose
      pigment {color Gray90 }
      normal {bumps 1 scale <.1,.01,.01> turbulence .5}
      finish {ambient .5}
    }
    sphere { <-.06,1.14,-.15>,.035
      pigment { Black }
      finish {phong 1}
    }
    sphere { <.06,1.14,-.15>,.035
      pigment { Black }
      finish {phong 1}
    }
    rotate y*45
    translate <-.6,.45,0>
  } 
}

background {color rgb <.2,.6,.8>}

plane {
  y,1000
  pigment {
    bozo
    scale 2500
    turbulence 2
    color_map {
      [0 rgbt <1,1,1,1>]
      [.4 rgbt <1,1,1,1>]
      [1 rgbt <1,1,1,0>]
    }
  }
  finish {ambient .85}
}


plane {
  y,0
  normal { crackle 2 turbulence .5}
  pigment {color rgb <0,0,.55> }
  finish {reflection .7 phong 1 phong_size 1 }
}


  light_source{ <-1000,3000,-3000> White*1.5 }

  
 //Mountains
 height_field {
    tga "test.tga"
    smooth
    pigment { color rgb <.9,1,1> }
    finish {ambient .5 crand .1}
    scale <400,100, 400>
    translate <-300,0,-300>
      }
 
 //Craags 
  height_field {
    tga "hf.tga"
    smooth
    pigment { color rgb <.9,1,1> }
    finish {ambient .5 crand .1}
    scale <400,60, 400>
    translate <50,-30,-400>
      }

//Ocean 
/*
height_field {
    tga "irtc20.tga"
    smooth
    normal { crackle 2 turbulence .5}
    pigment { color Navy }
    finish {reflection .7}
    scale <2500,30, 2500>
    translate <120,-10,-2500>
  }

height_field {
    tga "irtc20.tga"
    smooth
    pigment { color Navy }
    finish {reflection .7}
    scale <2500,20, 2500>
    translate <2620,0,-500>
  }
*/   
   

object { 
  WhaleTail 
  pigment { color Gray10 }
  scale 10
  translate <800,0,-500> 
}

object { 
  WhaleTail 
  pigment { color Gray10 }
  scale 10
  rotate <60,-90,0>
  translate <750,0,-550> 
  
}

object {
  PolarBear
  scale 5
  translate <50,2,-120>
}

object {
  PolarBear
  scale 5
  rotate y*60
  translate <55,2,-100>
}

object {
  PolarBear
  scale 5
  rotate y*-180
  translate <85,2,-130>
}

object {
  PolarBear
  scale 5
  rotate <10,60,0>
  translate <40,12.5,-60>
}

object {
  PolarBear
  scale 3
  rotate <10,30,0>
  translate <36,12.5,-61>
}

object {
  PolarBear
  scale 3
  rotate <10,80,0>
  translate <45,12.5,-58>
}

object {
  PolarBear
  scale 5
  rotate <0,-30,-20>
  translate <90,3.5,-80>
}

#declare LandBird = union {
  blob {
    threshold .3
    sphere {<0,0,0>,.5,2 scale x*2 rotate z*25 } //Body
    cylinder { <.5,.5,0>,<.5,.75,0>,.25,.5 pigment {color White} } //Neck
    sphere {<.6,.70,0>,.3,.75 pigment {color White} } //Head
    cylinder { <0,-1.25,-.2>,<0,0,-.2>,.15,.5 } //Right Leg
    cylinder { <0,-1.25,.2>,<0,0,.2>,.15,.5 } //Left Leg
  }
  cone { //Beak
    <.75,.7,0>,.1
    <1,.7,0>,0
    pigment {color Yellow}
  }  
  cone { //Tail Feathers
    <-1,-.1,0>,1
    <0,-.1,0>,0
    scale <1.35,.1,.5>
    rotate z*25
  }  
  sphere {
    <0,0,0>,.2
    pigment {color Gray10}
  }
  pigment {color Gray10}
  
}

object {
  LandBird
  scale 2  
  rotate y*90
  translate <250,8.5,-130>
}

object {
  LandBird
  scale 2      
  rotate y*45
  translate <250,7.5,-100>
                       
}

object {
  LandBird
  scale 2      
  translate <230,8,-130>
  
}

object {
  LandBird
  scale 2      
  translate <210,3,-85>
  
}

object {
  LandBird
  scale 2      
  translate <250,12,-120>
  
}