// Desert scene file
//===========================
// by:  Andrew Wittrock
// last modified:  6/24/2000
//
	
#version unofficial MegaPov 0.4;
#include "colors.inc"
#include "cactus.inc"
#include "brush.inc"
#include "mountain.inc"

#declare Rad=1.25;

#declare light_loc=<250,124,-500>;

//The ground
object{Mount} 

//Locate the camera
#declare cam_loc=trace(Mount,<249,1000,-249>,-y)+Rad*y;
#declare lookat=<0,50,0>;

camera {
	//Put ourself at the corner of the heightfield
	location cam_loc
	angle 40
	look_at lookat
}

//Distance Fade
fog {distance 400 color rgb<0.5,0.5,0.625>}

//The Sun
light_source {light_loc	color 2.0 area_light 50*x,50*y,4,4 circular orient}

#declare Bushes=1;
#declare Cacti=1;
#declare MinZ=-250;
#declare MaxZ=250;
#declare MinX=-250;
#declare MaxX=250;

#if(Bushes=1)
	//Bushes
	#declare i=0;
	#declare R1=seed(3);
	#declare R2=seed(2);
	#while(i<4000)
		//Random location for bush
		#declare X=rand(R1)*(MaxX-MinX)+MinX;
		#declare Z=rand(R1)*(MaxZ-MinZ)+MinZ;
		
		//Randomly perturb the bush radius
		#declare rad=Rad*(rand(R2)/2.0+0.5);
		
		#declare Start=<X,2000,Z>;
		#declare Norm=<0,0,0>;
		
		//Find the bush's location on the heightfield
		#declare loc=trace(Mount,Start,-y,Norm);
		
		//Place the bush if the ground is right
		#if (vdot(Norm,y)>0.5 & loc.y<35)
			object{Brush(loc,rad)}
		#end
	        #declare i=i+1;
	        #if(i/100=int(i/100)) #debug concat(str(i,0,0),"\n") #end
	#end
#end

#if(Cacti=1)
	//Cacti
	#declare i=0;
	#declare R1=seed(7);
	#declare R2=seed(6);
	#declare Size=5;
	#while(i<500)
		//Random location for cactus
		#declare X=rand(R1)*(MaxX-MinX)+MinX;
		#declare Z=rand(R1)*(MaxZ-MinZ)+MinZ;
	
		//Randomly perturb the branches
		#declare b1=(rand(R2)*0.25)+0.375;
		#declare b2=(rand(R2)*0.25)+0.375;
		#declare rot=rand(R2)*360;
		
		#declare Start=<X,2000,Z>;
		#declare Norm=<0,0,0>;
	
		//Find the cactus's location on the heightfield
		#declare loc=trace(Mount,Start,-y,Norm);
	
		//Place the cactus if the ground is right
		#if (vdot(Norm,y)>0.5 & loc.y<35)
			object{Cactus(Size,b1,b2,rot) translate loc}
		#end
	        #declare i=i+1;
	        #if(i/100=int(i/100)) #debug concat(str(i,0,0),"\n") #end
	#end
#end
	
//Make a pretty sky
#declare Sky=
plane {
	y,-125
	pigment {
		bozo
		turbulence 0.65
		octaves 6
		omega 0.7
		lambda 2
		color_map {
			[0.0 0.1 color rgb <0.75, 0.75, 0.75>     color rgb <0.65, 0.65, 0.65>]
			[0.1 0.5 color rgb <0.65, 0.65, 0.65>     color rgbt <0.125,0.125,0.25,0.00>]
			[0.5 1.0 color rgbt <0.125,0.125,0.25,0.00> color rgbt <0.125,0.125,0.25,0.00>]
		}
		translate <10,10,10>
		scale 100
	}
	finish{ambient 1}
	scale <0.5,-1,0.5>
}

object{Sky}
