#version unofficial megapov 0.5;

global_settings {
	max_trace_level 50
	number_of_waves 5
	adc_bailout .1
	assumed_gamma 2.2
}


#declare St = seed(632);


#declare Use_Rad = on;

#declare Use_Fog1 = on;

#declare Place_Montagne1 = on;
#declare Place_Montagne2 = on;
#declare Use_Montagne = on;
#declare Use_Slope = on;

#declare Place_Water = on;
#declare Test_Water = off;

#declare Use_Fresnel = off;

#declare Place_Arbres = on;
#declare Test_Arbres = off;

#declare Place_Touffes = on;
#declare Nb_Brin_Touffes = 40;

#declare Use_Cailloux = on;
#declare Place_Stones = on;

#declare Place_Fern = on;

#declare Use_Plateo = on;
#declare Use_Ptero = on;
#declare Use_Brachyo = on;


#declare Arbres = array[16]

#include "colors.inc"
#include "reorient.mcr"
#include "textu.inc"
#include "utils.inc"

#if (Place_Stones)
	#debug "\n Parsing Stones"
	#include "i_stnmcr.inc"
	#include "i_stones.inc"
#end


#if (Use_Plateo)
	#include "plateauso.inc"
#end

#if (Use_Ptero)
	#include "ptero.inc"
#end

#if (Use_Brachyo)
	#include "brachyo.inc"
#end

#if (Place_Fern)
	#include "fougere.inc"
#end

#if (Use_Rad)
global_settings {
	ini_option "+QR"
	radiosity {
		pretrace_start 0.08
		pretrace_end   0.02
		brightness .8
		count 70
		recursion_limit 4
	}
	ambient_light .3
}
#else
global_settings {
	ambient_light .8
}
#end


#declare CamLoc = <.5, .45, 0>;

camera {
	location CamLoc
	right x*image_width/image_height
	up y
	angle 40
	look_at <0, 250, 10000>
}

plane {
	y, 0
	rotate x*180
	rotate -4*x
	translate y*3500
	pigment {
		bozo
		scale 2
		warp { turbulence .2 octaves 3 lambda 5 }
		scale 2
		warp { turbulence .4 octaves 3 lambda 5 }
		scale <250, 1000, 200>*5
		pigment_map {
			[.5 color rgb<.2, .4, 1>*.7  ]
			[.7 bozo scale .1 turbulence .6 color_map {[0 color rgb<.2, .4, 1>*.8] [.5 color rgb<.95, .97, .98>] [.9 color rgb<1, 1, 1>]} ]
		}
	}
#if (Use_Rad)
	finish { ambient .8/.3 diffuse 0 }
#else
	finish { ambient 1 diffuse 0 }
#end
	no_shadow
}

light_source {
	<0,200000, 0>, rgb <1,1,.95>/.95
	rotate -60*z
	rotate 50*y
}

light_source {
	<-1000,-1000, -1000>, rgb .25*<.95,1,.95>/.95
	shadowless
}



#if (Place_Montagne1)
#debug "\ndeclaration collines"
#declare O_Montagnes_Fond1 = object {
	height_field {
		png "hf1.png"
		smooth
		double_illuminate
		texture {
			T_HerbeLoin
		}
		translate -.5*x - .05*y
		scale <5000, 1350, 5000>
	}
	rotate y*.01
	translate z*3000
}
#end

#if (Place_Montagne2)
#debug "\ndeclaration montagnes"
#declare O_Montagnes_Fond2 = object {
	height_field {
		png "hf2.png"
		texture {
			gradient y
			texture_map {
			#if (Use_Slope)
				[0.25 T_HerbeLoin]
				[0.25 T_HerbeLoin2Rock]
				[0.40 T_HerbeLoin2Rock]
				[0.40 T_Rock2Snow]
			#else
				[0.25 T_HerbeLoin]
				[0.25 T_Rock]
				[0.40 T_Rock]
				[0.40 T_Snow]
			#end
			}
		}
		translate -.5*x - .05*y
		scale <7500, 4500, 6000>
	}
	rotate y*.01
	translate z*7000
}
#end

#declare TileHFSol = height_field {
#debug "\ndeclaration sol"
	png "tilehf.png"
	smooth
	double_illuminate
	translate -.5*x
}


#declare O_Sol = union {
	union {
		object { TileHFSol }
		object { TileHFSol translate z }
		object { TileHFSol translate 2*z }
		object { TileHFSol translate 3*z }
		object { TileHFSol translate 4*z }
		object { TileHFSol translate 5*z }
	    scale <15, .4, 50>
		texture { T_Sol scale <1,.4,1>}
	}
	box { <-500, -3, 0>, <0, 0, 3000> rotate -3*z translate -15*0.5*x +.6*.4*y }
	box { <0, -3, 0>, <500, 0, 3000>  rotate  3*z translate  15*0.5*x +.6*.4*y }
	texture { T_Sol1 }
	translate -10*z
	rotate -1*x
}

#declare O_Riviere = object {
	box { <-50, -3, 0>, <50, .18, 5000> }
	rotate -1*x
	material { T_Riviere }
}


#macro DeclareArbre(num, file)

	#if (num <16)
	#declare Arbres[num] = box {
		0,1
		hollow
		pigment {
			#if (Test_Arbres)
			color rgbt<0,.4,0,.7>
			#else
			image_map {
				png file
				once
				interpolate 2
				transmit 0, 1.0
			}
			#end
		}
		#if (Use_Rad)
		finish { ambient 1/0.3 diffuse 0 }
		#else
		finish { ambient 1/0.8 diffuse 0 }
		#end
		translate -.5*x
	}
	#end
#end



#warning "\nDeclaration des arbres"
DeclareArbre(0, "image_map/imgtree1.png")
DeclareArbre(1, "image_map/tree01.png")
DeclareArbre(2, "image_map/imgtree2.png")
DeclareArbre(3, "image_map/tree02.png")
DeclareArbre(4, "image_map/imgtree3.png")
DeclareArbre(5, "image_map/tree03.png")
DeclareArbre(6, "image_map/imgtree4.png")
DeclareArbre(7, "image_map/tree04.png")
DeclareArbre(8, "image_map/imgtree5.png")
DeclareArbre(9, "image_map/tree05.png")
DeclareArbre(10, "image_map/imgtree6.png")
DeclareArbre(11, "image_map/tree06.png")
DeclareArbre(12, "image_map/imgtree7.png")
DeclareArbre(13, "image_map/tree07.png")
DeclareArbre(14, "image_map/imgtree8.png")
DeclareArbre(15, "image_map/tree08.png")



#macro ImageArbre(loc, haut, larg, num)

#local arbre = object {
	Arbres[num]
	scale <larg, haut, .001>
	#local tmp = <loc.x, 0, loc.z> - <CamLoc.x, 0, CamLoc.z>;
	Reorient(z, tmp)
}

PlaceObjSurObj ( loc, arbre, O_Sol, int(rand(St)*1.1)*180)

#end


#declare O_Arbre = union {
	cylinder { 0, 3*y, .3 pigment { color rgb<.5, .3, 0>} }
	sphere { 3*y, 2 pigment { color rgb<.2, .6, .1>} }
}

object { O_Sol }

#if (Place_Water)
object { O_Riviere }
#end
#if (Place_Montagne1)
object { O_Montagnes_Fond1 }
#end
#if (Place_Montagne2)
object { O_Montagnes_Fond2 }
#end

#if (Place_Arbres)

	#warning "\nPlantation des arbres"
	#local i = 0;
	#local j = int(rand(St)*632);
	#while (i < 10)
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre( -(2 + 2*rand(St))*x + (10 + 20*i + 10*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre(  (3 + 2*rand(St))*x + (10 + 20*i + 10*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local i = i + 1;
	#end

	#local i = 0;
	#while (i < 30)
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre( -(5 + 4*rand(St))*x + (15 + 8*i + 4*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre(  (6 + 5*rand(St))*x + (15 + 8*i + 4*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local i = i + 1;
	#end

	#local i = 0;
	#while (i < 40)
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre( -(10 + 5*rand(St))*x + (40 + 7*i + 5*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre(  (13 + 5*rand(St))*x + (40 + 7*i + 5*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local i = i + 1;
	#end

	#local i = 0;
	#while (i < 50)
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre( -(30 + 2*rand(St))*x + (40 + 4*i + 2*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre( -(15 + 10*rand(St))*x + (60 + 5*i + 2*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre(  (18 + 10*rand(St))*x + (60 + 5*i + 2*rand(St))*z, haut, 4, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local haut = 4 + 1.5*mod(j,2);
		ImageArbre(  (30 + 2*rand(St))*x + (40 + 4*i + 2*rand(St))*z, haut, 3, mod( j, 16 ))
		#local j = j + mod(int(rand(St)*6521), 37);
		#local i = i + 1;
	#end

#end


#if (Use_Cailloux)
/*#macro LittleRocks(obj, loc1, loc2, nbx, nbz, rnd)*/

#warning "\nDes cailloux"
LittleRocks(O_Sol, <-1, .17, 2>, <-.2, .22, 12>, 45, 150, 12)
#warning "\nEncore des cailloux"
LittleRocks(O_Sol, <.3, .17, 1>, <1, .22, 11>, 45, 150, 12)

#end


#if (Use_Plateo)
PlaceObjSurObj ( <-1.2, 50, 6>, Plateausorius, O_Sol, 160)
#end

#if (Use_Ptero)
object {
	Pterodactyle
	rotate z*30
	rotate y*70
	translate 35*z + 7*y - 7*x
}
object {
	Pterodactyle
	rotate -z*20
	rotate y*30
	translate 40*z + 8*y + 5*x
}
object {
	Pterodactyle
	rotate z*20
	rotate -y*50
	translate 60*z + 10*y + 3*x
}
#end

#if (Use_Brachyo)
object {
	Brachyosaure
	scale <-1,1,1>
	scale .95
	rotate 20*y
	translate 120*z + .4*y + 7*x
}
object {
	Brachyosaure
	scale <-1,1,1>
	scale 1.02
	rotate 20*y
	translate 140*z + .42*y + 15*x
}
#end



#if (Place_Touffes)

/* Touffe 1 */
	#declare Start = <-.35,50,2>;
	#declare Norm = <0,0,0>;
	#declare Intersec = trace(O_Sol, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))
		//#macro TouffeHerbe(centre, rayon, nbre, lBlade, vBend, pwBend, rnd)
		#debug "\ndeclaration de la touffe"
		#declare Touffe1 = TouffeHerbe(Intersec-.05*y, <.02,1,.15>, Nb_Brin_Touffes, .10, .08, <-1, -.5, 0>, 2, 8562)
		object { Touffe1 }
	#else
		#debug "\npas d'intersection pour la touffe"
	#end

/* Touffe 2 */
	#declare Start = <.46,50,1.45>;
	#declare Norm = <0,0,0>;
	#declare Intersec = trace(O_Sol, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))
		//#macro TouffeHerbe(centre, rayon, nbre, lBlade, vBend, pwBend, rnd)
		#debug "\ndeclaration de la touffe"
		#declare Touffe2 = TouffeHerbe(Intersec-.05*y, <.02,1,.15>, Nb_Brin_Touffes, .10, .08, <.5, -.5, -.4>, 2, 351)
		object { Touffe2 }
	#else
		#debug "\npas d'intersection pour la touffe"
	#end

/* Touffe 3 */
	#declare Start = <.42,50,2.6>;
	#declare Norm = <0,0,0>;
	#declare Intersec = trace(O_Sol, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))
		//#macro TouffeHerbe(centre, rayon, nbre, lBlade, vBend, pwBend, rnd)
		#debug "\ndeclaration de la touffe"
		#declare Touffe3 = TouffeHerbe(Intersec-.05*y, <.02,1,.15>, Nb_Brin_Touffes, .10, .1, <.4, -.5, -.7>, 2, 523)
		object { Touffe3 }
	#else
		#debug "\npas d'intersection pour la touffe"
	#end

/* Touffe 4 */
	object { Touffe1 translate <-.18, 0, 2> }

/* Touffe 5 */
	object { Touffe3 translate <-.82, 0, 0.3> }

/* Touffe 6 */
	object { Touffe2 translate <-.16, 0, 2> }

/* Touffe 7 */
	object { Touffe3 translate <-.2, 0, 1.9> }


#end


#if (Place_Stones)

object {
	u_small_stones
	scale .2
	translate .05*y + 14*z +.2*x
	texture{
		planar
		warp { turbulence .2 }
		scale .07
		translate .18*y
		warp { reset_children }
		texture_map {
			[.6 T_Stone2 ]
			[.8 T_Stone1 ]
		}
	}
	rotate -1*x
}

#end


#if (Place_Fern)

	#declare Start = <0.8,50,1>;
	#declare Norm = <0,0,0>;
	#declare Intersec = trace(O_Sol, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))
		#debug "\ndeclaration de la fougere"
		#declare Fougere1 = PaquetFougere(3214)
		object {
			Fougere1
			scale .3
			rotate -15*y
			translate Intersec - .05*y
		}
	#else
		#debug "\npas d'intersection pour la fougere"
	#end

		object {
			Fougere1
			scale .4
			rotate y*120
			translate <-1.5,.3,8>
		}
		object {
			Fougere1
			scale .4
			rotate -y*120
			translate <-1,.3,12>
		}

		object {
			Fougere1
			scale .4
			rotate -y*190
			translate <1,.3,15>
		}


#end



#if (Use_Fog1)
fog {
	fog_type 1
	distance 15000
	color rgb<.7, .8, 1>
}
#end


