#declare Test = off;



// BrinFougere(startp, endp, nbb, courb, courbpow, norm, largmin, largmax, largpow)
// startp:   point de depart
// endp:     point d'arrivee
// nbb:      nbre desegment de la feuille
// courb:    hauteur de la courbure de la feuille
// courbpow: forme de la courbure de la feuille
// norm:     direction de la courbure de la feuille
// largmin:  largeur aux extremite
// largmax:  largeur au milieu
// largpow:  forme de la feuille


#macro BrinFougere(startp, endp, nbb, courb, courbpow, norm, largmin, largmax, largpow)

	#local x1 = vnormalize(endp-startp);
	#local long = vlength(endp-startp);
	#local larg = (largmax-largmin);
	#local y1 = vnormalize(norm);
	#local z1 = vnormalize(vcross(x1, y1));

	#local i = 0;
	#while (i < nbb)

		#if ((i/nbb) <= 0.5)
			#local adap = -.5*pow(1-(2*i/nbb), courbpow) + .5;
		#else
			#local adap = .5*pow((2.*i/nbb)-1, courbpow) + .5;
		#end
		#local temp0 = startp + x1*long*adap + y1*courb*pow(sin(pi*adap),courbpow);
		#local temp1 = startp + x1*long*adap + y1*courb*pow(sin(pi*adap),courbpow) + z1*(largmin + larg*pow(sin(pi*adap), largpow));
		#local temp2 = startp + x1*long*adap + y1*courb*pow(sin(pi*adap),courbpow) - z1*(largmin + larg*pow(sin(pi*adap), largpow));

		#local j = i+1;
		#if ((j/nbb) <= 0.5)
			#local adap = -.5*pow(1-(2*j/nbb), courbpow) + .5;
		#else
			#local adap = .5*pow((2*j/nbb)-1, courbpow) + .5;
		#end
		#local temp3 = startp + x1*long*adap + y1*courb*pow(sin(pi*adap),courbpow);
		#local temp4 = startp + x1*long*adap + y1*courb*pow(sin(pi*adap),courbpow) + z1*(largmin + larg*pow(sin(pi*adap), largpow));
		#local temp5 = startp + x1*long*adap + y1*courb*pow(sin(pi*adap),courbpow) - z1*(largmin + larg*pow(sin(pi*adap), largpow));
		
		triangle { temp0, temp1, temp3 }
		triangle { temp1, temp3, temp4 }
		triangle { temp0, temp2, temp3 }
		triangle { temp2, temp3, temp5 }
	
	#local i = i+1;
	#end

#end


// Fougere(startp, endp, nbbr, nbtr, courb, courbpow, norm, largtig, hauttig, largpow, f_seed)
// startp:    point de depart
// endp:      point d'arrivee
// nbbr:      nbre de feuille de chaque cote de la tige
// nbtr:      nbre de "segments" de tige entre chaque feuille
// courb:     "hauteur" de la courbure dela tige
// courbpow:  forme de la courbure de la tige
// norm:      direction de la courbure de la tige
// largtig:   largeur de la tige
// hauttig:   hauteur de la tige
// largpow:   forme des feuilles
// f_seed:    le hasard...

#macro Fougere(startp, endp, nbbr, nbtr, courb, courbpow, norm, largtig, hauttig, largpow, f_seed)

	#local st = seed(f_seed);

	#local x1 = vnormalize(endp-startp);
	#local long = vlength(endp-startp);
	#local y1 = vnormalize(norm);
	#local z1 = vnormalize(vcross(x1, y1));

	mesh {
		#local i = 0;
		
		#while (i < nbbr*nbtr)

			#local j = i;
			#while (j < (i+nbtr))

				#local temp0 = startp + x1*long*j/(nbbr*nbtr) + y1*courb*pow(sin(pi*j/(nbbr*nbtr)),courbpow);
				#local temp1 = startp + x1*long*(j+1)/(nbbr*nbtr) + y1*courb*pow(sin(pi*(j+1)/(nbbr*nbtr)),courbpow);
				
				#local tige11 = temp0 + largtig*z1 + hauttig*y1;
				#local tige12 = temp0 + largtig*z1 - hauttig*y1;
				#local tige13 = temp0 - largtig*z1 + hauttig*y1;
				#local tige14 = temp0 - largtig*z1 - hauttig*y1;
				#local tige21 = temp1 + largtig*z1 + hauttig*y1;
				#local tige22 = temp1 + largtig*z1 - hauttig*y1;
				#local tige23 = temp1 - largtig*z1 + hauttig*y1;
				#local tige24 = temp1 - largtig*z1 - hauttig*y1;

				triangle { tige11, tige21, tige22 }
				triangle { tige11, tige12, tige22 }
				triangle { tige11, tige21, tige23 }
				triangle { tige11, tige13, tige23 }
				triangle { tige13, tige23, tige24 }
				triangle { tige13, tige14, tige24 }
				triangle { tige12, tige22, tige24 }
				triangle { tige12, tige14, tige24 }

				#local j = j+1;
			#end
			
			// BrinFougere(startp, endp, nbb, courb, courbpow, norm, largmin, largmax, largpow)
			
			#local ntmp = vcross(z1, (temp1-temp0));
			
			#if (rand(st) > .5)
				#local deb = temp1;
			#else
				#local deb = temp0;
			#end
			#local ltmp = .5*long*(.8+.4*rand(st))*(.3+.7*pow(sin(pi*j/(nbbr*nbtr)),courbpow));
			#local largtmp = .45*long*(.8+.4*rand(st))*(.5+.5*pow(sin(pi*j/(nbbr*nbtr)),courbpow))/nbbr;
			#local courbtmp = .5*courb*(.8+.4*rand(st))*(.4+.6*pow(sin(pi*j/(nbbr*nbtr)),courbpow));
			BrinFougere(deb, temp1+ltmp*z1, 20, courbtmp, .75*(.8+.4*rand(st)), ntmp, largtig*.1, largtmp, largpow*(.8+.4*rand(st)))
			#if (rand(st) > .5)
				#local deb = temp1;
			#else
				#local deb = temp0;
			#end
			#local ltmp = .5*long*(.8+.4*rand(st))*(.3+.7*pow(sin(pi*j/(nbbr*nbtr)),courbpow));
			#local llarg = .45*long*(.8+.4*rand(st))*(.5+.5*pow(sin(pi*j/(nbbr*nbtr)),courbpow))/nbbr;
			#local courbtmp = .5*courb*(.8+.4*rand(st))*(.4+.6*pow(sin(pi*j/(nbbr*nbtr)),courbpow));
			BrinFougere(deb, temp1-ltmp*z1, 20, courbtmp, .75*(.8+.4*rand(st)), ntmp, largtig*.1, largtmp, largpow*(.8+.4*rand(st)))
			
			#local i = i+nbtr;
		#end
	}

#end


#macro PaquetFougere(p_seed)

#local St= seed(p_seed);

#local MESH_FERN1 = object {
//  Fougere(startp, endp, nbbr, nbtr, courb, courbpow, norm, largtig, hauttig, largpow, f_seed)
	Fougere(0, x, 15, 5, .2, .75, y, .004, .004, .5, rand(St)*6321)
}

#local MESH_FERN2 = object {
	Fougere(0, x, 13, 5, .22, .85, y, .004, .004, .4, rand(St)*1862)
}

union {
#declare i = 0;
#while (i < 20)
	object {
		#if (rand(St) > .5)
			MESH_FERN1
		#else
			MESH_FERN2
		#end
		scale <.8+.4*rand(St), .8+.4*rand(St), .8+.4*rand(St)>
		translate .05*(.8+.4*rand(St))*x
		rotate x*(-10+20*rand(St))
		rotate z*70*pow(rand(St),2)
		rotate y*360*rand(St)
	}
	#declare i = i+1;
#end
	pigment {
		bozo
		warp { turbulence .1 octaves 3 }
		scale .1
		warp { turbulence .01 octaves 3 }
		pigment_map {
			[0.85 bozo turbulence .5 color_map { [0.3 color rgb<.4, .6, .1>] [1 color rgb<.6, .4, .1>] }]
			[0.86 color rgb<.4, .2, .1>]
			[0.87 color rgb<.4, .2, .1>]
			[0.90 color rgb<.6, .6, .1>]
		}
	}
	normal { bumps .2 turbulence .4 scale .05 }
	finish {
		ambient .4 diffuse .6 crand .2
		phong .3 phong_size 30
	}
}
#end



#if (Test)

global_settings {
	assumed_gamma 2.2
}

camera {
	location <-2, .75, -4>
	right 1.5*x
	up y
	angle 30
	look_at <0,.5,0>
}


background { color rgb<.4, .5, 1> }

light_source { <1000, 1000, -1000>  color rgb 1 }
light_source { <-1, .1, -1>  color rgb .25 shadowless}

plane { y, 0 pigment { color rgb<.7, .5, .1> } }

object {
	PaquetFougere(3214)
}

#end

