/*

  "Stone Generator" macros

  Originally, the first version used a mesh, but due to poor realism with
  few triangles, I replaced them with blobs, with gives a "riverbed"
  apparence to the stones.

*/


// *** randomizes array of points
#macro Randomize_Array(a_rnd,max_val,rnd_seed)

 #local cnt=0;

 #while (cnt<dimension_size(a_rnd,1))
  #local tmp=a_rnd[cnt]*(1+max_val*rand(rnd_seed));
  #local a_rnd[cnt]=tmp;
  #local cnt=cnt+1;
 #end

#end

// *** calculates middle point betwen two given points ***
#macro middle_point(ap1,ap2,apa)

 #local p1=apa[ap1];
 #local p2=apa[ap2];

 #if (abs(p1.x)<=abs(p2.x))
  #local mp_x=p1.x+(p2.x-p1.x)/2;
 #else
  #local mp_x=p2.x+(p1.x-p2.x)/2;
 #end
 #if (abs(p1.y)<=abs(p2.y))
  #local mp_y=p1.y+(p2.y-p1.y)/2;
 #else
  #local mp_y=p2.y+(p1.y-p2.y)/2;
 #end
 #if (abs(p1.z)<=abs(p2.z))
  #local mp_z=p1.z+(p2.z-p1.z)/2;
 #else
  #local mp_z=p2.z+(p1.z-p2.z)/2;
 #end

 <mp_x,mp_y,mp_z>

#end

// *** find array element ***
#macro Array_Find(a_tmp,val_to_find,start_scan,end_scan)

 #local cnt=start_scan;
 #local found=0;

 #while (cnt<dimension_size(a_tmp,1) & cnt<=end_scan & found=0)
  #local elem=a_tmp[cnt];
  #if (elem.x=val_to_find.x & elem.y=val_to_find.y & elem.z=val_to_find.z)
   #declare found=cnt;
  #end
  #local cnt=cnt+1;
 #end

 (found)

#end

// *** subdivides arrays triangles, adding the new points ***
#macro Subdivide_Array(a_points,a_triang,r_seed)

 #local cnt=0;
 #local p_cnt=dimension_size(a_points,1);
 #local p_tmp=array[p_cnt+dimension_size(a_triang,1)]
 #local t_tmp=array[dimension_size(a_triang,1)*2]

 // fill temporary points array
 #while (cnt<p_cnt)
  #local p_tmp[cnt]=a_points[cnt];
  #local cnt=cnt+1;
 #end

 // subdivide
 #local cnt=0;
 #local t_cnt=0;
 #local r_dec=seed(r_seed);
 #while (cnt<dimension_size(a_triang,1))
  // new point
  #local this_triangle=a_triang[cnt];
  #local new_p=middle_point(this_triangle.x,this_triangle.y,a_points);
  #if (cnt>1)
   #local exist_p=Array_Find(p_tmp,new_p,dimension_size(a_points,1),p_cnt-1);
  #else
   #local exist_p=0;
  #end
  #if (exist_p=0)
   #local p_tmp[p_cnt]=new_p;
   #local t_tmp[t_cnt]=<this_triangle.x,this_triangle.z,p_cnt>;
   #local t_tmp[t_cnt+1]=<this_triangle.y,this_triangle.z,p_cnt>;
   #local p_cnt=p_cnt+1;
  #else
   #local t_tmp[t_cnt]=<this_triangle.x,this_triangle.z,exist_p>;
   #local t_tmp[t_cnt+1]=<this_triangle.y,this_triangle.z,exist_p>;
  #end
  // update counters
  #local cnt=cnt+1;
  #local t_cnt=t_cnt+2;
 #end

 // return arrays
 #local p_tmp2=array[p_cnt]
 #local cnt=0;
 #while (cnt<p_cnt)
   #local p_tmp2[cnt]=p_tmp[cnt];
   #local cnt=cnt+1;
 #end
 #declare a_points=p_tmp2
 #declare a_triang=t_tmp

#end

// *** generate the stone from points ***
#macro Build_Stone(a_points,r_stone)

 #local cnt=0;

 blob{threshold .9
  #while (cnt<dimension_size(a_points,1))
   sphere{a_points[cnt],1+rand(r_stone),1}
   #local cnt=cnt+1;
  #end
 }

#end
