#version unofficial megapov 0.5;


#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<230,190,50>/255;
#declare Green2=rgb<110,230,8>/255;

#declare pigSpotted =pigment {
	spotted
    color_map {
        [0.0, 1.01   color Green1 color Green2 ]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.4 color Tan*0.3]
        [0.4 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}

#declare txtGrass=texture {
	pigment { pigSpotted }
	finish{ ambient 0.4 diffuse 0.6}
	scale <0.01,1,0.01>
}


#declare T_Sol1 = texture {
	pigment { pigSpotted scale <.05, 1, .05> }
	normal {
		average
		normal_map {
			[1 bozo 3 scale 10 turbulence .2 ]
			[1 granite 1 ]
		}
	}
	finish { ambient .4 diffuse .6 crand .4 }
}

#declare T_Sol2 = texture {
	pigment {
		bozo
		scale .001
		warp { turbulence .7 octaves 3 }
		color_map
		{
			[.6 color rgb<.8,.6,.3>*.7]
			[.6 color rgb<.8,.6,.3>]
		}
	}
	normal {
		average
		normal_map
		{
			[1 granite 1 ]
			[1 bozo 10 scale <.02,.05,.02>]
		}
	}
	finish { ambient .4 diffuse .6 }
}


#declare T_Sol = texture {
	gradient y
	scale <1/5, 1, 1/5>
	warp { turbulence .1*y octaves 1 lambda 3 }
	scale <25, 1, 25>
	warp { turbulence .05*y octaves 1 lambda 3 }
	scale <5, 1, 5>
	warp { turbulence .05*y octaves 1 lambda 3 }
	scale <1/25, 1, 1/25>
	warp { reset_children }
	texture_map {
		[0.22/0.4 T_Sol2]
		[0.22/0.4 T_Sol1]
	}
}

#declare T_HerbeLoin = texture {
	pigment {
		bozo
		warp { turbulence .1 octaves 3 lambda 5 omega .3 }
		scale 1/10
		translate 321
		warp { reset_children }
		pigment_map {
			[0.6 bozo turbulence .5 octaves 3 lambda 7 scale 3/3000 color_map { [.4 rgb<0,.1,0>] [.5 rgb<.1,.4,.05>] } ]
			[0.6 wrinkles scale .01 color_map { [.5 color rgb<.4,.6,.1>] [.7 color rgb<.6,.7,.1>] } ]
		}
	}
	finish { ambient .4 diffuse .6 }
}

#declare P_Rock1 = pigment {
	granite
	warp { turbulence .8 octaves 3 lambda 6 }
	scale .01
	color_map {
		[0.00 rgb <0.2,0.25,0>]
		[0.30 rgb <.6,0.6,0.75>]
		[0.7 rgb <.8,0.85,.90>]
		[1.00 rgb <1,1,1>]
	}
}

#declare P_Rock2 = pigment {
	granite
	translate 65*x
	warp { turbulence .6 octaves 3 lambda 6 }
	scale <.01,.05,.01>
	color_map {
		[0.00 rgb <0.2,0.15,0>]
		[0.20 rgb <.65,0.6,0.6>]
		[0.50 rgb <.82,0.80,.8>]
		[1.00 rgb <1,1,1>]
	}
}


#declare T_Rock = texture {
	pigment {
		bozo
		scale .05
		warp { turbulence .1 octaves 3 lambda 4 }
		warp { reset_children }
		pigment_map {
			[0.6  P_Rock1 ]
			[0.6  P_Rock2 ]
			[0.8  P_Rock2 ]
			[0.9  P_Rock1 ]
		}
	 }
	normal { wrinkles scale <.01,.07,.01> }
	finish { ambient 0.4 diffuse 0.6 }
}

#declare T_Snow = texture {
	pigment { color rgb<.97,.98,1> }
	finish { ambient .4 diffuse .6 }
}

#if (Test_Water)

#declare Grad1 = pigment {
	gradient x
	translate 1000*x
	color_map {
		[0.1 color rgb<1,0,0>*0.0]
		[0.1 color rgb<1,0,0>*0.2]
		[0.3 color rgb<1,0,0>*0.2]
		[0.3 color rgb<1,0,0>*0.4]
		[0.5 color rgb<1,0,0>*0.4]
		[0.5 color rgb<1,0,0>*0.6]
		[0.7 color rgb<1,0,0>*0.6]
		[0.7 color rgb<1,0,0>*0.8]
		[0.9 color rgb<1,0,0>*0.8]
		[0.9 color rgb<1,0,0>*1.0]
	}
}

#declare Grad2 = pigment {
	gradient x
	translate 1000*x
	color_map {
		[0.1 color rgb<0,1,0>*0.0]
		[0.1 color rgb<0,1,0>*0.2]
		[0.3 color rgb<0,1,0>*0.2]
		[0.3 color rgb<0,1,0>*0.4]
		[0.5 color rgb<0,1,0>*0.4]
		[0.5 color rgb<0,1,0>*0.6]
		[0.7 color rgb<0,1,0>*0.6]
		[0.7 color rgb<0,1,0>*0.8]
		[0.9 color rgb<0,1,0>*0.8]
		[0.9 color rgb<0,1,0>*1.0]
	}
}

#declare Grad3 = pigment {
	gradient x
	translate 1000*x
	color_map {
		[0.1 color rgb<0,0,1>*0.0]
		[0.1 color rgb<0,0,1>*0.2]
		[0.3 color rgb<0,0,1>*0.2]
		[0.3 color rgb<0,0,1>*0.4]
		[0.5 color rgb<0,0,1>*0.4]
		[0.5 color rgb<0,0,1>*0.6]
		[0.7 color rgb<0,0,1>*0.6]
		[0.7 color rgb<0,0,1>*0.8]
		[0.9 color rgb<0,0,1>*0.8]
		[0.9 color rgb<0,0,1>*1.0]
	}
}

#declare T_Riviere = material {
	texture {
		pigment {
			gradient z
			pigment_map {
				[0.33 Grad1 ]
				[0.33 Grad2 ]
				[0.66 Grad2 ]
				[0.66 Grad3 ]
			}
		}
		finish { ambient 1 diffuse 0}
	}
}

#else

#declare T_Riviere = material {
	texture {
		pigment { color rgbf<1,1,1,1> }
		normal {
			average
			normal_map {
				[1 granite .3 scale <.6,1,.3>*.5]
				[2 bozo .3    scale <.6,1,.3>*.2 ]
				[1 waves .2 frequency 10 translate 50*z+20*x ]
				[1 waves .1 frequency 15 translate 100*z-50*x ]
			}
			scale  <1,1,3>
		}
		finish { ambient 0 diffuse 0
			#if (Use_Fresnel)
			reflection_type 1
			#else
			reflection_min 0
			reflection_max .7
			reflection_falloff .5
			#end
			conserve_energy
		    specular 1
		    roughness 0.001
		}
	}
	interior {
		ior 1.3
		fade_distance 5
	}
}
#end


#declare T_HerbeLoin2Rock = texture {
	slope -y, y   ,<0,0.40>, <0.25,0.4>
	texture_map {
		[0.50 T_HerbeLoin]
		[0.50 T_Rock]
	}
}

#declare T_Rock2Snow = texture {
	slope y, y  , <0.40,1.0>, <0.4,0.7>
	texture_map {
		[0.50 T_Rock]
		[0.50 T_Snow]
	}
}



#declare T_Stone1 = texture {
	pigment {
		granite
		turbulence 0.6
		color_map {
			[0.000 color rgb <0.690, 0.612, 0.569>*.7 ]
			[0.154 color rgb <0.737, 0.596, 0.522>*.7 ]
			[0.368 color rgb <0.776, 0.702, 0.624>*.7 ]
			[0.538 color rgb <0.796, 0.678, 0.643>*.7 ]
			[0.846 color rgb <0.690, 0.612, 0.569>*.7 ]
			[0.932 color rgb <0.773, 0.612, 0.569>*.7 ]
			[1.000 color rgb <0.690, 0.612, 0.569>*.7 ]
		}
	}
	normal {
		average
		normal_map {
			[1 granite 1.5 ]
			[1 granite 1.5 scale .2 ]
		}
	}
	finish {
		ambient .4 diffuse .6
		phong .7 phong_size 75
	}
	scale .1
}

#declare T_Stone2 = texture {
	pigment {
		granite
		turbulence 0.6
		color_map {
			[0.000 color rgb <0.690, 0.612, 0.569> ]
			[0.154 color rgb <0.737, 0.596, 0.522> ]
			[0.368 color rgb <0.776, 0.702, 0.624> ]
			[0.538 color rgb <0.796, 0.678, 0.643> ]
			[0.846 color rgb <0.690, 0.612, 0.569> ]
			[0.932 color rgb <0.773, 0.612, 0.569> ]
			[1.000 color rgb <0.690, 0.612, 0.569> ]
		}
	}
	normal {
		average
		normal_map {
			[1 granite 2 ]
			[1 granite 2 scale .2 ]
		}
	}
	finish {
		ambient .4 diffuse .6
		phong .1 phong_size 10
	}
	scale .1
}

