#version unofficial MegaPov 0.5;

#include "colors.inc"
                                                            
#declare Rad = 2500000 / (2 * pi);

global_settings {
assumed_gamma 1.0
max_trace_level 15

 //ini_option "+QR"
  
  radiosity{
  normal on  
  media on
  count 50 
  /*  pretrace_start 0.08
    pretrace_end   0.02
    count 70             // CHANGE range from 20 to 150
    nearest_count 7      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with pretrace_end

    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this

    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    */
    adc_bailout 0.01   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object 
    
  }
   
}                                                                                                                                 

#declare Image_Length = 700;
#declare Image_Height = 300 ;

#declare SunDistance = 93000000;
#declare CameraLocation = <0,0,-45>;
#declare CameraLookAt =<0, 5, 0>;  //y was 5

#declare SunPosition = CameraLocation +SunDistance * vnormalize 
(CameraLookAt - CameraLocation);

camera {
	location CameraLocation
	up .3
	right Image_Length/Image_Height*x 
	look_at CameraLookAt
	angle 80.000 
	}
                                                                                                                           

light_source {
SunPosition
color rgb<1  ,0.5 , 0.1>/4//*.375
rotate x*1.25
media_attenuation on
media_interaction on                              
}

//--------------------------------------------------
 
sky_sphere
{
  pigment
  {
    gradient y 
    color_map { [0.0 color rgb <1,.9,.65>  ] [0.8 color rgb<.7,.8,1> ] }rotate x*-2 
  }
}

//-------------------------------------------------
$ Clouds_on =1;
$ Land_on = 0;   
$ Mountains_on =0;
$ Eagle_on = 0; 
//-------------------------------------------------
#if(Land_on =1)
//lights for rocks

light_source{<500, 10, -1500> color rgb <.5,0.2,.375>*.075}   

#declare LTex = texture{
         pigment {
          crackle turbulence .5
              color_map {
               [ 0.0 rgbf <1,0.25,0,1>*1.1 ]
               [ .5 rgbf<1,.375,0,1>*1.2 ]
               [ .75 rgbf <1,.5,0,1>*1.1 ]
              } // color_map
               scale .000075 
               //rotate y*90
         } // pigment
 }//texture

light_source  //left  ok
{<0, 60, 600>
color rgb <1,0.25,0>
//color rgb .5
  spotlight               
  point_at <-24,0,0>     
  radius 50               
  tightness 50            
  falloff 8 
             
}
sphere{<0, 60, 600>,.0001 texture {LTex}}

light_source  //rightfront ok
{<0, 19, -17  > //was -18
color rgb <1,0.125,0> 
//color rgb .75
  spotlight               
  point_at <8,0,-20>      
  radius 49                  
  tightness 50           
  falloff 8
            
}
sphere{<0, 19, -18>,.0001 texture {LTex}}

light_source  //backleft   ok
{<0,20,100>
color rgb <1,0.175,0>  
//color rgb .75
  spotlight               
  point_at <-15,0,50>      
  radius 50              
  tightness 50           
  falloff 8
             
}
sphere{<0,20,100>,.0001 texture {LTex}}

light_source //backright ok
{<0,0,250> 
color rgb <1,0.25,0> 
// color rgb 1
  spotlight               
  point_at <5,0,150>      
  radius 50              
  tightness 50           
  falloff 8
            
}
sphere{<0,0,250>,.0001 texture {LTex}}

//lights for mounds

light_source //leftmost mound 
{<10,22,0> 
color rgb <1,0.5,0>/2 
//color rgb .5
  spotlight               
  point_at <-24,-22,0>      
  radius 5               
  tightness 7.5          
  falloff 20
           
} 
sphere{<10,22,0>,.0001 texture {LTex}}

light_source //right front mound
{<-20,20,-5>  //z was -8/-10/-20 
color rgb <1,0.175,0> /2
 //color rgb .75
  spotlight               
  point_at <8,-15,-20>      
  radius 7.5            
  tightness 1           
  falloff 20 
         
}  
sphere{<-20,20,-20>,.0001 texture {LTex}} 

light_source //backleft mound
{<20,10,45> //z was 45
color rgb <1,0.375,0>/2
// color rgb .75 
  spotlight               
  point_at <-15,-12,50>      
  radius 7.5                // hotspot (inner, in degrees)
  tightness 1            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 20               // intensity falloff radius (outer, in degrees)

} 
sphere{<20,10,45>,.0001 texture {LTex}}

//fill in lights

light_source  //rightfront mount fill in
{<25, 19, -50  > 
color rgb <.1,.05,.25>*.8 
//color rgb .75
  spotlight               
  point_at <8,-8.75,-20>//    
  radius 49                  
  tightness 50           
  falloff 8           
}

light_source //leftmost mound fill in 
{<35,22,-20> 
color rgb <.1,.075,.25>*.8//was .7  
//color rgb .5
  spotlight               
  point_at <-24,-17,0>      
  radius 5               
  tightness 7.5          
  falloff 20
           
} 

//rocks

#declare Rd = .05;
 
#declare F = function{"sphere", <Rd>}

#declare hft = function{
        pigment{
        image_map{
        tga"terrain.tga"
        interpolate 2
        map_type 1
        }
        }
        }

#declare hft2 = function{
        pigment{
        image_map{
        tga"terrai_t.tga"
        interpolate 2
        map_type 1
        }
        }
        }

#declare Rock =
isosurface{
    function{F(x,y,z)-(hft(x,y,z))/15}
        contained_by{box{-1,1}}
            method 2
            max_gradient 10
        texture{pigment{color<1,1,1>}
        normal{granite .4 scale 0.001}
        finish{specular 1 ambient 0 diffuse .125} //diffuse was .125
        }
    hollow
}
#declare Rock2 =
isosurface{
    function{F(x,y,z)-(hft2(x,y,z))/15}
        contained_by{box{-1,1}}
            method 2
            max_gradient 10
        texture{pigment{color<1,1,1>}normal{agate .8 scale 0.025} //granite .6 scale 0.0015
        finish{specular 1 ambient 0 diffuse .125}//diffuse was .125
        }
    hollow
}
#declare RockRnd =    //round rock
isosurface{
    function{F(x,y,z)+(hft(x,y,z)/15)}
        contained_by{box{-1,1}}
            method 2
            max_gradient 10
        texture{pigment{color<1,1,1>}normal{agate .6 scale 0.025}//granite .8 scale 0.0015
        finish{specular 1 ambient 0 diffuse .175}}
    hollow
}

object{Rock scale <180,60,60> rotate y*55 rotate z*-70 translate <-27,-2,0>}//leftmost
    object{RockRnd scale <25,35,25> rotate y*-10 rotate z*-195 translate <-25.25 ,8,4>normal{granite 1.5 scale 0.0025}}
object{Rock2 scale <160,80,80> rotate y*0 rotate z*-90 translate <5,-2,150>} //backright
    object{RockRnd scale <25,35,25>*1.2 rotate y*10 rotate z*-195 translate <5,15.5,150>}
object{Rock2 scale <160,40,150> rotate y*140 rotate z*-90 translate <-15.5,-2,50>}//backleft//was rotate y*120
    object{RockRnd scale <25,35,25> translate <-15,9.25,51>}
object{Rock scale <40,40,70> rotate y*100 rotate z*-76 rotate y*15 translate <8.5,0,-20>}//rightfront 210
    object{RockRnd scale <25,35,25>/1.2 rotate y*-25 translate <8,5.5,-19>}
object{Rock scale <100,40,30> rotate y*-40 rotate z*-50 translate <27,0,0>finish{specular 1 ambient 0 diffuse .125}}//rightmost//diffuse was .125                
    object{RockRnd scale <25,35,25>/1.2 rotate z *20 translate <26,8,0>}

//Boulders
       
#include"rockpts4.inc"
#include"rck4.inc"
#include"rck2.inc" 
#include"rck3.inc"

#declare RockTex=texture{                                                                                      
        pigment{color<1,1,1>}
        normal{granite .8 scale 0.05} 
        finish{specular 1 ambient 0 diffuse .1}
        }
              
#declare RN = seed(54373);
#declare N = 0; 

#declare Boulders = merge{    //This is  four times faster than a union??????????????
#while(N < rHF_pts)

#declare SS3=.0075+rand(RN)/70;
        #if(mod(N,3)=0)
           object{rock2 rotate z*90 scale SS3/1.5 texture{RockTex}   
                rotate y*rand(RN)*360   
                    translate rHF_pts_array[N]
                    translate y*-(SS3*50)
                    }//end obj
        #else            
           object{rock4 rotate z*90 scale SS3*1.5 texture{RockTex}   
                rotate y*rand(RN)*360   
                    translate rHF_pts_array[N]
                    translate y*-(SS3*50)
                    }//end obj 
        #end                       
	#declare N = N + (40+int(rand(RN)*34)); 
	
#end


#declare RN2 = seed(54373);
#declare C = 0; 

#while(C < rHF_pts)

#declare SS2 =.0005+rand(RN2)/150;
   object{rock3 rotate z*90 scale SS2 texture{RockTex}
        rotate y*rand(RN2)*360   
            translate rHF_pts_array[C]
            translate y*-(SS2*50)
            }//end obj
	#declare C = C + (1+(rand(RN2)*10));  
	
#end
}
//----------------------------------------------       
#declare MTex = texture{
 pigment{color<1,1,1>}
    normal{
        spiral1 2 frequency 10 normal_map{
            #declare Count = 1;
                #while(Count<10)
                    [ 1 agate 60/Count turbulence .25 scale 2/Count]
                    [ 1 crackle 10/Count  scale 2/Count]
                    [ 1 bumps 30/Count turbulence .55 scale 4/Count]
                #declare Count = Count+1;
                #end
                }
                turbulence .3
                rotate y*15
                rotate x*25
              scale .1  
           }//end of normal dec
           
           finish{specular 1 roughness .1 ambient 0 diffuse .0675}	
        }

	                
#declare Mound =
height_field{
	tga"mound4.tga" //was 3 try 4 
	smooth
	translate <-.5, -0.071, -.5> 
	scale <63.000, 12.697, 63.000>
}                                                                            
//----------------------------------------------
    
object{Mound scale <.9,.25,.6> texture{MTex} rotate y*90 translate<-25.5 ,-1.75,0> }//left most
   object{Boulders scale <.9,.25,.6>  rotate y*90 translate<-25.5,-1.75,0>}
object{Mound scale <.7,.2,1> texture{MTex} translate<5,-1,150>} //backright
    //  object{Boulders scale <.6,.2,.6> t translate<5,-1,150>}
object{Mound scale <.9,.25,.6> texture{MTex} translate<-15,-1.75,50>}//backleft
    object{Boulders scale <.9,.25,.6>  translate<-15,-1.75,50>}
object{Mound scale <.9,.275,.7> texture{MTex} rotate y*45 translate<8,-2.5,-20>}//rightfront 
    object{Boulders scale <.9,.275,.7>  rotate y*45 translate<8,-2.5,-20>}
object{Mound scale <.8,.25,.6> texture{MTex} translate<27,-2,0>} //rightmost
   object{Boulders scale <.6,.2,.6>  translate<27,-2,0>}


plane{y,-1.74 texture{MTex}} 

#end
//---------------------------------------------------------------
#if(Mountains_on = 1)

height_field{   //right
  tga"terrain.tga"
   //tga"terrai_t.tga"     
        texture{pigment{color<1,.75,0.65>}
        normal{granite .4 scale 0.001}
        finish{specular 1 ambient .0 diffuse .175}
        }
        smooth
        scale <800,45,1500>*3
        translate <400,-1.75,1100>      
}

height_field{   // left
  //tga"terrain.tga"
   tga"terrai_t.tga"     
        texture{pigment{color<1,.75,0.65>}
        normal{agate.4 scale 0.1}
        finish{specular 1 ambient 0 diffuse .175}
        }
        smooth
        scale <1500,60,1500>*3
        translate <-6500,-1.75,2500>                                             
}  
height_field{
  //tga"terrain.tga"
   tga"terrai_t.tga"     
        texture{pigment{color<1,.75,0.65>}
        normal{agate.4 scale 0.1}
        finish{specular 1 ambient 0 diffuse .175}
        }
        smooth
        scale <500,70,500>*3
        translate <-2500,-1.75,4500>       
} 

#end   
//---------------------------------------------------------------
#if(Eagle_on = 1)
 
#include"Eagle.inc"

object{Eagle scale <-75,15,35>/5
        rotate x*-25
        rotate y*5 
            translate<-30,25,100>
                 pigment{Tan}
                  finish{ambient 0 diffuse .05}
 }
object{Eagle scale <-75,15,35>/4
        rotate x*-30
        rotate y*10
        rotate z*-7.5 
            translate<-45,22.5,110>
                 pigment{Tan}
                    finish{ambient 0 diffuse .05}
 }
#end
//---------------------------------------------------------------

#if(Clouds_on = 1)

difference {
  sphere { 0,Rad}
  sphere {0,Rad-5000}
  material{
    texture{
      pigment{ rgbf 1}
    }
    interior{
      media{            
        scattering {2,<.01,.012,.0065 >/2.25 extinction 1/2.25 }
        method 3
        samples 30,30  
        intervals 1
         
         density { 
          wrinkles  
          ramp_wave                                      
          octaves 5
          turbulence .3                                                    
          color_map {           
            [0 rgb 0]
            [0.45 rgb 0]         
            [0.5 rgb 0.275]   
            [0.65 rgb 0.475]   
            [0.8 rgb 0]
            [1 rgb 0]        
          }//colmap 
          scale <30*300,1000,55*300>/3
         translate <1000,Rad-3000,0>
        }//density
                  
        density {
           wrinkles
           poly_wave
          color_map {           
            [0 rgb 0]
            [0.4 rgb 0]          
            [0.475 rgb 0.3]//.3   
            [0.65 rgb .5] //.5
            [0.8 rgb 0]
            [1 rgb 0]         
          }//colmap             
         scale <30*300,1000,55*300>*1.5
         translate <1000,Rad-3000,0>
        }//density
      }//media 
    }//interior
  }//material
  hollow
  rotate y*60
  translate <0,9000-Rad,0> 
}//difference

#end

