#version unofficial MegaPov 0.4; 

camera { 
    location -z*1.8 
    look_at <-2, 1, 0> 
    rotate -z*20
}
 
light_source{<3, 10, 0> rgb 1}   

#declare Snow = texture {
	pigment {
		rgb <0.7, 0.8, 1>
	}
	normal {
		granite 0.01 scale 20
	}
	finish {
		ambient 0.4
		diffuse 0.4
		roughness 1 
		phong 0.6 
		specular 0.2
	}
}

#declare Mountains = texture {
	pigment {rgb 0.1}
	finish {
		diffuse 0.6
		ambient 0.12
		phong 0.2
	}
}

#declare LandscapeTexture = texture {
	slope y, y, <0.3, 1>, <0, 4> 
	texture_map { 
		[0.2 Mountains]
		[0.2 Snow]       
	}
}     
     
#declare Ridge = function { "ridgedmf", <1, 2, 20, 1.1, 2> }

#declare Landscape = isosurface {
	function {
		Ridge(x, 0, z) - y
	}
	eval
	max_gradient 35
	accuracy 0.001
	sign -1
	contained_by { box {<-2, -2, -2> <2, 6, 2>} }
	texture {LandscapeTexture}
	hollow
}

#declare SkyTexture = 
texture {   
    pigment {
        bozo
        color_map {
            [ 0.0   rgb <0.14, 0.24, 0.44> ]
            [ 0.2   rgb <0.7, 0.8, 0.9> ]
            [ 0.5   rgb <0.35, 0.5, 0.66> ]
            [ 0.7   rgb <0.25, 0.3, 0.4> ]
            [ 1.0   rgb <0.2, 0.3, 0.35> ]
        }
        turbulence 1
        omega 0.55
        lambda 4.0
    }   
    finish {
        ambient 0.6
    }   
} 
texture {   
    pigment {
        leopard
        color_map {
            [0.0   rgbft <0.5, 0.3, 0.35, 0.4, 0.4>]
            [0.5   rgbft <0.5, 0.5, 0.66, 0.65, 0.65>]
            [1.0   rgbft <0.5, 0.38, 0.3, 0.65, 0.65>]
        }
        turbulence 1
        omega 0.55
        lambda 4.0                                
        scale 0.8
    }   
    finish {
        ambient 0.6
    }   
}
texture {   
    pigment {
        leopard
        color_map {
            [0.0   rgbft <0.1, 0.2, 0.4, 0.5, 0.5>]
            [0.5   rgbft <0.35, 0.5, 0.66, 0.65, 0.65>]
            [1.0   rgbft <0.2, 0.3, 0.3, 0.65, 0.65>]
        }
        turbulence 1
        omega 0.55
        lambda 4.0                                
        scale 0.6
    }   
    finish {
        ambient 0.6
    }   
}
 
   
#declare Sky = sphere { 
    <0,0,0>,1
    texture {
      SkyTexture      
      scale 0.15
    }
    hollow
} 

object {
    Sky
    scale <600, 100, 300>
} 

object {
    Landscape 
    scale <3, 0.4, 1> 
    scale 5
    translate <-22, -15, 16>
    rotate -x*45
}   

#include "beak.inc" 
#include "head.inc" 
#include "wings.inc" 
#include "tail.inc"
#declare Eagle = union {
    object{Beak}
    object{Head}
    object{Wings}
    object{Tail}
    scale <0.45, 0.45, 0.45> 
    rotate -z*20
    rotate -y*45
    rotate -x*80
    translate <-19, 12, 9>
    no_shadow
}                

object {Eagle}

