/*
 *	"Sunrise over Lake Solitude"
 *
 *	Created for the IRTC topic "Wilderness"
 *	Copyright Mark Wagner 2000
 *
 */

//	sol_sky.inc
//  Contains all the atmospheric effects for the scene -- sky, clouds, haze

#version unofficial MegaPov 0.5;
#ifndef(included)
	#declare included = true;
	#include "colors.inc"
	#declare cm = 1/30.48;
	#include "units.inc"
        #include "spectrum.inc" //from www.geocities.com/rengaw03
	#undef included
	#declare Clouds = 2;
	#declare Sky = 2;
	#declare Haze = off;
	#declare Terrain = on;
        global_settings{max_color 50}
#end

// The various cloud types
#switch(Clouds)
	#case(1)
		//Type 1: Generic pigment clouds on a plane
	#break
	#case(2)
		//Type 2: Sculpted blob pattern clouds
	#break
#end

// The sky
#switch(Sky)
	#case(1)
		//Type 1: quick sky_sphere
		sky_sphere{pigment{SummerSky}}
	#break
        #case(2)
	      //Type 2: Skypov sky
	sphere{ 0, 4050*miles	
	    pigment{rgbt 1}
	    hollow
	    interior{
		    media{
			    scattering{ 6, <.3,.3,1.1>*250 extinction 1 ior 1.5 }
			    samples 1,20
			    intervals 1
			    confidence .999
			    variance 1/1000
		            method 3
		    }
	    }
//          no_shadow
	    translate y*-4000*miles
        }
	#break

#end

#ifndef(included)
	#if(Terrain = off)
		plane{y, 0 pigment{rgb <0,1,0>}}
	        camera{location <0,20,0>*feet look_at <1,20,1>*feet}
	        camera{fisheye location y*.1 look_at y angle 180}
	        #declare SpectrumDivisor = 3.76;
	        light_source{
		      <0,0,0>
		      Spectrum(255,6000)
		      color <_red,_green,_blue>
		      translate x*1000000
		      rotate y*39
		      rotate z*10
		}
	#end
#end

// Allow rendering from any of the files making up this scene
#ifndef(included)
	#if(Terrain)
		#declare included = true;
		#declare sky_included = true;
		#include "sunrise.pov"
	#end
#end

