/*
 *	"Sunrise over Lake Solitude"
 *
 *	Created for the IRTC topic "Wilderness"
 *	Copyright Mark Wagner 2000
 *
 */

//	Cameras.inc
//  Defines the cameras used during the creation of this scene
#ifndef(included)
	#declare included = true;
	#declare cm = 1/30.48;
	#include "units.inc"
	#undef included
#end

// This file contains declares for all the cameras used in the scene.  I use so
//  many cameras, I decided to put them all in a single include file.


// Views from directly overhead
#declare top_1 = camera{ //Orthographic view from a distance
	location y*100*miles
	look_at 0
	angle 10
	rotate y*90 //North is to the left
	translate x*3*miles
}
#declare top_2 = camera{ //Close-up orthographic
	location y*10*miles
	look_at 0
	angle 5
	rotate y*90 //North is to the left
	translate x*3*miles
}
#declare top_3 = camera{ //Very long-distance view
	location y*100*miles
	look_at 0
	angle 20
	rotate y*90 //North is to the left
	translate x*3*miles
}

//General overviews
#declare over_1 = camera{
	location <5,5,-5>*8*miles
	look_at <0,0,0>
	angle 20
}

#declare over_2 = camera{
	location <5,5,0>*8*miles
	look_at <0,0,0>
	angle 20
}

// Cameras that follow the "Locator" object
// These cannot be rendered from this file
#ifdef(Location)
	#declare locate_top = camera{
		location y*8*miles
		look_at 0
		angle 10
		rotate y*90
		translate Location
	}
#end

//Cameras at specific locations
#ifdef(VegeObject)
	#declare CameraHeight = (trace(VegeObject,<8000,50000,16000>*feet,-y)).y;
	#warning str(CameraHeight/feet,1,1) #warning "\n"
	#declare solitude_1 = camera{ //General-purpose perspective camera
		location <8000,CameraHeight/feet+50,16000>*feet
		look_at <8100,CameraHeight/feet+50,15900>*feet
	} 
	
	#declare solitude_pan_1 = camera{ //General-purpose 2:1 panoramic camera
		location <8000,CameraHeight/feet+50,16000>*feet
		up y
		right x*2
		look_at <8100,CameraHeight/feet+50,15900>*feet
		perspective
	}
	#declare solitude_pan_2 = camera{ //General-purpose 2:1 panoramic camera facing east
		ultra_wide_angle
		location <8000,CameraHeight/feet+10,16000>*feet
		up y
		right x*2
		look_at <8100,CameraHeight/feet+10,15940>*feet
		angle 60
	}

#end

// Allow rendering from any of the files making up this scene
#ifndef(included)
	#declare included = true;
	#declare cam_included = true;
	#include "sunrise.pov"
#end

