/*
 *	"Sunrise over Lake Solitude"
 *
 *	Created for the IRTC topic "Wilderness"
 *	Copyright Mark Wagner 2000
 *
 */

//	soltext.inc
//  Defines textures specific to this scene

#version unofficial MegaPov 0.5;

#ifndef(included)
	#declare included = true;
	#include "colors.inc"
	#declare cm = 1/(30.48 * 100); // 1 pov unit = 100 feet
	#include "units.inc"   // from www.geocities.com/rengaw03
	#undef included
#end

#declare Grass = texture{
	pigment{rgb <.1,.3,.1>}
	finish{
		diffuse .8
		ambient 0
	}
/*		  normal{
			crackle 1
			scale 1*feet
	}*/
}

#declare Rock = texture{
//	pigment{rgb <1,0,0>}
	pigment{
		granite
		color_map{
			[0  rgb .1 ]
			[.3 rgb .9 ]
			[.5 rgb 0  ]
			[.7 rgb .25]
			[.8 rgb .05]
			[.9 rgb .4 ]
		}
	}
	finish{
		diffuse .7
		ambient 0
	}
	scale 50*feet
}

#declare Snow = texture{
	pigment{rgb <.9,.9,1>}
	finish{
		ambient 0
		diffuse .9
		crand .01
	}
}


#ifdef(VegeObject)	//Allow for rendering the whole scene from this file
	#declare Low_Slope_Grass_Rock = texture{
		proximity{
			object{VegeObject translate y*-1*foot},100*feet //Ignore terrain more than 100 feet away
			samples 20
			sample_bailout 80
			max_density 1
			type 0
			method 1
			sides 2
		}
		texture_map{
			[.25 Grass]
			[.25 Rock]
		}
	}
	#declare High_Slope_Grass_Rock = texture{
		proximity{
			object{VegeObject translate y*-1*foot},100*feet //Ignore terrain more than 100 feet away
			samples 20
			sample_bailout 80
			max_density 1
			type 0
			method 1
			sides 2
		}
		texture_map{
			[.1 /* If facing north, snow, else grass */
				slope z
				texture_map{
					[.75 Grass]
					[.75 Snow]
				}
			]
			[.1 /* Rock */
				Rock
			]
		}
	}
	#declare Rock_Snow = texture{
		slope z /* If facing north, snow, else rock */
		texture_map{
			[.9 Rock]
			[.9 Snow]
		}
	}
	
	//The main texture for the mountains
	#declare MainHFTexture = texture{
		gradient y
		texture_map{
			[.091 Grass]
			[.091 
				slope y
				texture_map{
					[.9 /* Grass, rock and snow */
						High_Slope_Grass_Rock
					]
					[.9 /* Grass and rock */
						Low_Slope_Grass_Rock
					]
					[.98 Grass]
				}
			]
			[.10 
				slope y
				texture_map{
					[.9 /* Grass, rock and snow */
						High_Slope_Grass_Rock
					]
					[.9 /* Grass and rock */
						Low_Slope_Grass_Rock
					]
				}
			]
			[.11 /* Rock or snow */
				Rock_Snow
			]
		}
		scale 100000*feet
	}
#end

#ifndef(included)
	#declare included = true;
	#include "sunrise.pov"
#end
