// Persistence of Vision Raytracer Version 3.1
//
// file: swgohome.pov      author: -- jd --      version: 290600
//
// Swallows over a grass field

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#declare camera_location = <16, 2, 16>; 
#declare camera_look_at = < 0, 7, 0>;
#declare effect_location = <-30,30,-5>;
#declare effect_always_on_top = false;
#declare effect_type = "SoftGlow"
#include "LENS.INC"

camera {
   location camera_location
   direction <0, 0, 1>
   up        <0, 1, 0>
   right   <4/3, 0, 0>
   look_at  camera_look_at

   focal_point <14.5,6,14.5> // near grasshopper in direction to swallow
   aperture 0.04
   blur_samples 48
   // ultra_wide_angle
   // angle 240
}

light_source
{
    0*x color White
    area_light <10, 0, 0>, <0, 0, 10>, 4, 4
    adaptive 1
    jitter

    translate <-30, 30, -5>
}

light_source { 0*x color Gray80 shadowless translate <40, 20, 20> }
light_source { 0*x color Gray80 shadowless translate <00, 20, 20> }

#declare Sky = sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.2  color Gray95]
      [1.0  color Gray70]
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.7
    octaves 7
    omega .49976
    lambda 2.432
    color_map {
      [0.0 color rgbf<.8, .8, .8, 0.1>]
      [0.6 color rgbf<.9, .9, .9, .95>]
      [0.9 color rgbf<1, 1, 1, 1>]
    }
    scale 4/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.66
    octaves 8
    omega .5113
    lambda 1.9545
    color_map {
      [0.0 color rgbf<.5, .5, .9, 0.2>]
      [0.3 color rgbf<.6, .6,  1, .9>]
      [0.6 color rgbf<.7, .7,  1, 1>]
    }
    scale 4/10
    scale <1, 0.3, 0.3>
  }
}

sky_sphere { Sky rotate 90 }

fog { distance 100.0 fog_type 2 fog_offset 0 fog_alt 20 color rgb<0.9, 0.9, 0.9> }

plane
{   y, 0
    pigment { color rgb <0.55, 0.50, 0.30> }
    normal { bumps 0.9 scale 1.75 }
    finish { ambient .1 diffuse .3 }
}

#declare s = seed(38);

#declare xpos = -20;
#while (xpos < 20)
#declare zpos = -20;
#while (zpos < 20)

difference
{   // grass
    sphere { <0,0,0>, 1 }
    sphere { <-0.1,0,0>, 1.05 }

    pigment
    {
        gradient z
        color_map
        {
            #declare ared = 0.3+rand(s)*.3;
            #declare bred = 0.1+rand(s)*.2;
            #declare agreen = 0.8+rand(s)*.2;
            #declare bgreen = 0.6+rand(s)*.2;
            #declare cgreen = 0.5+rand(s)*.2;
            [0     color rgbt <ared, agreen, 0.1, 0.4> ]
            [0.495 color rgbt <bred, bgreen, 0.0, 0.1> ]
            [0.50  color rgbt <0.0,  cgreen, 0.0, 0.0 > ]
            [0.505 color rgbt <bred, bgreen, 0.0, 0.1> ]
            [1     color rgbt <ared, agreen, 0.1, 0.4> ]
        }
        // scale <1,1,1>
    }
    normal { dents 0.8 scale 0.5 }

    scale <0.2,0.4+rand(s)*4,0.01>

    rotate <15*(rand(s)-0.5),15*(rand(s)-0.5),15*(rand(s)-0.5)>
    translate <xpos+0.175+(rand(s)-0.5)/2.5,rand(s)/5,zpos+(rand(s)-0.5)/2.5>
}

#declare zpos = zpos+0.4;
#end
#declare xpos = xpos+0.4;
#end

#declare s = seed(31416);

#declare xpos = -15;
#while (xpos < 15)
#declare zpos = -15;
#while (zpos < 15)

object
{   // hay
    cone { <0,-1,0>, 0.04, <0,1,0>, 0.00001 }
    scale <1+rand(s),3+rand(s)*2,0.01>

    rotate <5*(rand(s)-0.5),5*(rand(s)-0.5),5*(rand(s)-0.5)>
    translate <xpos+(rand(s)-0.5),0,zpos+(rand(s)-0.5)>

    pigment
    {
        gradient y
        turbulence 0.3
        color_map
        {
            #declare ared = 0.8+rand(s)*.2;
            #declare bred = 0.6+rand(s)*.3;
            #declare agreen = 0.7+rand(s)*.3;
            #declare bgreen = 0.6+rand(s)*.2;
            [0    color rgb <ared, agreen, 0.4> ]
            [0.49 color rgb <bred, bgreen, 0.3> ]
            [0.50 color rgb <0.7,  0.6, 0.2 > ]
            [0.51 color rgb <bred, bgreen, 0.3> ]
            [1    color rgb <ared, agreen, 0.4> ]
        }
        scale <0.01,0.2,0.01>
    }

    normal { dents 0.8 scale 0.02 }
}

#declare zpos = zpos+1.5;
#end
#declare xpos = xpos+1.5;
#end

#declare grass_with_grasshopper =
union
{
difference
{   // grass
    sphere { <0,0,0>, 1 }
    sphere { <-0.1,0,0>, 1.05 }

    pigment
    {
        gradient z
        color_map
        {
            #declare ared = 0.3+rand(s)*.3;
            #declare bred = 0.1+rand(s)*.2;
            #declare agreen = 0.8+rand(s)*.2;
            #declare bgreen = 0.5+rand(s)*.2;
            [0     color rgbt <ared, agreen, 0.1, 0.4> ]
            [0.495 color rgbt <bred, bgreen, 0.0, 0.1> ]
            [0.50  color rgbt <0.0,  0.6, 0.0, 0.0 > ]
            [0.505 color rgbt <bred, bgreen, 0.0, 0.1> ]
            [1     color rgbt <ared, agreen, 0.1, 0.4> ]
        }
        // scale <0.01,0.01,0.01>
    }
    normal { dents 0.8 scale 0.5 }

    scale <0.2,3,0.01>
    translate <0,0.5,0>
}

union // grasshopper
{ 
    sphere { <0,0,0>, 0.125  scale <0.75,1,0.75> }
    sphere { <0,-0.05,0>, 0.100  scale <0.75,1,0.75> }
    // cone   { <0,0,0>, 0.125, <0,-0.1,0>, 0.08  scale <0.75,1,0.75> }
    sphere { <0,-0.075,0>, 0.075  scale <0.75,1,0.75> }

    sphere
    {   // eyes
        <0,0,0>, 0.12 scale <0.3,0.2,1> translate <-0.025,0.05,0>
        pigment { Gray10 }
    }

    sphere { <0,0,0>, 0.015 translate <-0.05,0.1,0.05> }
    sphere { <0,0,0>, 0.015 translate <-0.05,0.1,-.05> }

    sphere { <0,0,0>, 0.1 scale <0.6,1,0.75> translate <0.2,-0.0775,0> }
    sphere { <0,0,0>, 0.1 scale <0.7,1,0.75> translate <0.3,-0.085,0> }
    
    sphere { <0,0,0>, 0.125 scale <0.3,1,0.75> translate x*0.1 }
    difference
    { 
        cylinder { <0.1,0,0>, <0.3,0,0>, 0.125 scale <1,1,0.75> }
        cylinder { <0.3,-0.05,0.2>, <0.3,-0.05,-0.2>, 0.125 }
    }

    sphere { <0,0,0>, 0.25 scale <1.75,0.6,0.4> translate <0.6,-0.05,0>
        pigment
        { 
            gradient x
            color_map {
            [0.00 color Green  ]
            [0.60 color Green  ]
            [0.75 color rgb <0.1, 0.7, 0.1> ]
            [0.90 color rgb <0.2, 0.5, 0.2> ]
            [1.00 color Green  ]
            } scale <0.075, 0.075, 0.075>
        }
    }
    cone   { <0.75,-0.1,0>, 0.075, <1.25,-0.2,0>, 0.0075  }
    sphere  { <0,0,0>, 0.075 scale <1.75,0.6,0.4> translate <0.85,-0.17,0> }

    // wings
    difference
    { 
        sphere { <0,0,0>, 0.45 scale <1.3,0.3,0.01> }
        sphere { <0,-0.1,-0.25>, 0.45 scale <1.3,0.3,0.01> }
        rotate z*10 rotate x*10
        translate <0.75,0.1,-0.08>
        pigment { color rgbt <0,1,0,0.2> }
        normal  { bumps 0.4 scale 0.08 }
    }
    difference
    { 
        sphere { <0,0,0>, 0.45 scale <1.3,0.3,0.01> }
        sphere { <0,-0.1,0.25>, 0.45 scale <1.3,0.3,0.01> }
        rotate z*10 rotate x*-10
        translate <0.75,0.1, 0.08>
        pigment { color rgbt <0,1,0,0.2> }
        normal  { bumps 0.4 scale 0.08 }
    }

    difference
    { 
        sphere { <0,0,0>, 0.5 }
        sphere { <-0.02,-0.0125,0>, 0.5195 }
        box { <1,-0.5,1>, <-1,-2,-1> }

        scale <0.1,2,0.01>

        rotate z*45
        rotate x*-15

        translate <0,0,-0.05>
    }

    difference
    { 
        sphere { <0,0,0>, 0.5 }
        sphere { <-0.02,-0.0125,0>, 0.5195 }
        box { <1,-0.5,1>, <-1,-2,-1> }

        scale <0.1,2,0.01>

        rotate z*45
        rotate x*15

        translate <0,0,0.05>
    }

    // legs
    sphere { <0.2,-0.1,-0.1>, 0.02 }
    cone { <0.2,-0.1,-0.1>, 0.02, <0,-0.2,-0.3>, 0.0125 }
    sphere { <0,-0.2,-0.3>, 0.015 }
    cylinder { <0,-0.2,-0.3>, <0,-0.5,-0.2>, 0.01 }
    cone { <0,-0.5,-0.2>, 0.0075, <-0.02,-0.52,-0.2>, 0.01 }
    cone { <-0.02,-0.52,-0.2>, 0.0075, <-0.04,-0.54,-0.2>, 0.01 }
    cone { <-0.04,-0.54,-0.2>, 0.0075, <-0.06,-0.56,-0.2>, 0.01 }
    cone { <-0.06,-0.56,-0.2>, 0.0075, <-0.08,-0.58,-0.2>, 0.01 }
    cone { <-0.08,-0.58,-0.2>, 0.0075, <-0.10,-0.60,-0.2>, 0.01 }

    sphere { <0.22,-0.1,-0.1>, 0.02 }
    cone { <0.22,-0.1,-0.1>, 0.02, <0.4,-0.2,-0.25>, 0.0125 }
    sphere { <0.4,-0.2,-0.25>, 0.015 }
    cylinder { <0.4,-0.2,-0.25>, <0.5,-0.5,-0.1>, 0.01 }
    cone { <0.5,-0.5, -0.10>, 0.0075, <0.5,-0.52,-0.12>, 0.01 }
    cone { <0.5,-0.52,-0.12>, 0.0075, <0.5,-0.54,-0.14>, 0.01 }
    cone { <0.5,-0.54,-0.14>, 0.0075, <0.5,-0.56,-0.16>, 0.01 }
    cone { <0.5,-0.56,-0.16>, 0.0075, <0.5,-0.58,-0.18>, 0.01 }
    cone { <0.5,-0.58,-0.18>, 0.0075, <0.5,-0.60,-0.20>, 0.01 }
    
    sphere { <0.25,-0.1,-0.1>, 0.02 }
    cone { <0.25,-0.1,-0.1>, 0.015, <0.30,-0.1,-0.15>, 0.025 }
    sphere { <0.30,-0.1,-0.15>, 0.03 }
    cone { <0.30,-0.1,-0.15>, 0.03, <0.70,0.5,-0.4>, 0.02 }
    sphere { <0.70,0.5,-0.4>, 0.02 }
    cone { <0.70,0.5,-0.4>, 0.02, <1.2,-0.5,-0.1> 0.01 }
    cone { <1.20,-0.50,-0.1> 0.0075, <1.22,-0.52,-0.1>, 0.01 }
    cone { <1.22,-0.52,-0.1> 0.0075, <1.24,-0.54,-0.1>, 0.01 }
    cone { <1.24,-0.54,-0.1> 0.0075, <1.26,-0.56,-0.1>, 0.01 }
    cone { <1.26,-0.56,-0.1> 0.0075, <1.28,-0.58,-0.1>, 0.01 }
    cone { <1.28,-0.58,-0.1> 0.0075, <1.30,-0.60,-0.1>, 0.01 }

    sphere { <0.2,-0.1,0.1>, 0.02 }
    cone { <0.2,-0.1,0.1>, 0.02, <0,-0.2,0.3>, 0.0125 }
    sphere { <0,-0.2,0.3>, 0.015 }
    cylinder { <0,-0.2,0.3>, <0,-0.5,0.2>, 0.01 }
    cone { <0,-0.5,0.2>, 0.0075, <-0.02,-0.52,0.2>, 0.01 }
    cone { <-0.02,-0.52,0.2>, 0.0075, <-0.04,-0.54,0.2>, 0.01 }
    cone { <-0.04,-0.54,0.2>, 0.0075, <-0.06,-0.56,0.2>, 0.01 }
    cone { <-0.06,-0.56,0.2>, 0.0075, <-0.08,-0.58,0.2>, 0.01 }
    cone { <-0.08,-0.58,0.2>, 0.0075, <-0.10,-0.60,0.2>, 0.01 }

    sphere { <0.22,-0.1,0.1>, 0.02 }
    cone { <0.22,-0.1,0.1>, 0.02, <0.4,-0.2,0.25>, 0.0125 }
    sphere { <0.4,-0.2,0.25>, 0.015 }
    cylinder { <0.4,-0.2,0.25>, <0.5,-0.5,0.1>, 0.01 }
    cone { <0.5,-0.5, 0.10>, 0.0075, <0.5,-0.52,0.12>, 0.01 }
    cone { <0.5,-0.52,0.12>, 0.0075, <0.5,-0.54,0.14>, 0.01 }
    cone { <0.5,-0.54,0.14>, 0.0075, <0.5,-0.56,0.16>, 0.01 }
    cone { <0.5,-0.56,0.16>, 0.0075, <0.5,-0.58,0.18>, 0.01 }
    cone { <0.5,-0.58,0.18>, 0.0075, <0.5,-0.60,0.20>, 0.01 }
    
    sphere { <0.25,-0.1,0.1>, 0.02 }
    cone { <0.25,-0.1,0.1>, 0.015, <0.30,-0.1,0.15>, 0.025 }
    sphere { <0.30,-0.1,0.15>, 0.03 }
    cone { <0.30,-0.1,0.15>, 0.03, <0.70,0.5,0.4>, 0.02 }
    sphere { <0.70,0.5,0.4>, 0.02 }
    cone { <0.70,0.5,0.4>, 0.02, <1.2,-0.5,0.1> 0.01 }
    cone { <1.20,-0.50,0.1> 0.0075, <1.22,-0.52,0.1>, 0.01 }
    cone { <1.22,-0.52,0.1> 0.0075, <1.24,-0.54,0.1>, 0.01 }
    cone { <1.24,-0.54,0.1> 0.0075, <1.26,-0.56,0.1>, 0.01 }
    cone { <1.26,-0.56,0.1> 0.0075, <1.28,-0.58,0.1>, 0.01 }
    cone { <1.28,-0.58,0.1> 0.0075, <1.30,-0.60,0.1>, 0.01 }

    pigment { Green }
    normal  { bumps 0.5 scale 0.1 }
    finish  { Shiny }

    scale <0.2, 0.2, 0.2>
    rotate z*-90
    translate <0.25,2.25,0>
} }


#declare s = seed(2);

#macro swallow(ha,fa,va)
union
{ // swallow rough model
    #local l=rand(s);
    #local o=rand(s);

    difference
    {
        sphere { 0*x, 1 scale <0.40,0.28,0.95> }
        box    { <-1,-1,0.3>, <1,1,1> }
        pigment
        {
            gradient y
            color_map {
            [0.00  color Gray25 ]
            [0.499 color Gray25 ]
            [0.50  color Gray95 ]
            [1.00  color Gray95 ]
            } turbulence 0.3  lambda l omega o
            scale <0.8, 0.8, 0.8> translate y*0.2
        }
    }
    sphere
    {
        0*x, 1 scale <0.37,0.30,0.475> translate <0,0,0.25>
        pigment
        {
            gradient y
            color_map {
            [0.00  color Gray25 ]
            [0.499 color Gray25 ]
            [0.50  color Gray95 ]
            [1.00  color Gray95 ]
            } turbulence 0.3  lambda l omega o
            scale <0.8, 0.8, 0.8> translate y*0.2
        }
    }
    cone
    {
        -0.25*z, 0.465, -1.5*z, 0.00001 scale <0.9,0.5,1>
        pigment
        {
            gradient y
            color_map {
            [0.00  color Gray25 ]
            [0.499 color Gray25 ]
            [0.50  color Gray95 ]
            [1.00  color Gray95 ]
            } turbulence 0.3  lambda l omega o
            scale <0.8, 0.8, 0.8> translate y*0.2
        }
    }
    difference
    {
        cone { <0,0.025,0.4>, 0.1, <0,-0.045,0.925>, 0.001 open }
        cone { <0,0.0,0.4>, 0.1, <0,-0.05,0.925>, 0.001 }
        
        scale <2,0.8,1>
        pigment { color Gray40 } normal { dents 0.5 scale 0.01 }
    }
    difference
    {
        cone { <0,-0.02,0.4>, 0.1, <0,-0.07,0.9>, 0.001 open }
        cone { <0,-0.015,0.4>, 0.1, <0,-0.069,0.9>, 0.001 }
        
        scale <1.95,0.75,1>
        pigment { color Gray40 } normal { dents 0.5 scale 0.01 }
    }

    union
    {   // wings
        difference
        {
           sphere { 0*z,1 scale <1,0.05,1> }
           sphere { -0.5*z,1.4 }
           box { <-0.25,-2,-2>, <-2,2,2> }

           scale <4,0.1,6>
           translate <1,0.1,-5.4>
           rotate z*fa
           rotate y*va
        }
        difference
        {
           sphere { 0*z,1 scale <1,0.05,1> }
           sphere { -0.5*z,1.4 }
           box { <0.25,-2,-2>, <2,2,2> }

           scale <4,0.1,6>
           translate <-1,0.1,-5.4>
           rotate y*-va
        }

        pigment { Gray15 }
    }

    union
    {   // tail
        sphere { -1*z,1 scale <0.1,0.02,1.00> rotate y*ha*5 translate z*-0.60 }
        sphere { -1*z,1 scale <0.1,0.02,0.80> rotate y*ha*4 translate z*-0.55 }
        sphere { -1*z,1 scale <0.1,0.02,0.70> rotate y*ha*3 translate z*-0.50 }
        sphere { -1*z,1 scale <0.1,0.02,0.65> rotate y*ha*2 translate z*-0.45 }
        sphere { -1*z,1 scale <0.1,0.02,0.62> rotate y*ha*1 translate z*-0.40 }
        sphere { -1*z,1 scale <0.1,0.02,0.60> rotate y*0    translate z*-0.35 }

        sphere { -1*z,1 scale <0.1,0.02,1.00> rotate -y*ha*5 translate z*-0.60 }
        sphere { -1*z,1 scale <0.1,0.02,0.80> rotate -y*ha*4 translate z*-0.55 }
        sphere { -1*z,1 scale <0.1,0.02,0.70> rotate -y*ha*3 translate z*-0.50 }
        sphere { -1*z,1 scale <0.1,0.02,0.65> rotate -y*ha*2 translate z*-0.45 }
        sphere { -1*z,1 scale <0.1,0.02,0.62> rotate -y*ha*1 translate z*-0.40 }
        pigment { Gray15 }
    }

    union
    {
        sphere { 0*x, 0.065 scale <0.7,1,0.9> translate <0.158, 0.075, 0.635> }
        sphere { 0*x, 0.065 scale <0.7,1,0.9> translate <-0.158, 0.075, 0.635> }
        pigment { Black }
        finish { reflection 0.1 roughness 0.0001 phong 1 phong_size 70 }
    }
}
#end

object { grass_with_grasshopper translate <14.6,0,14.5> }
object { grass_with_grasshopper rotate y*155 translate <14,-0.5,10> }

object { swallow(2,5,40) rotate x*60  translate <4,8,4> }
object { swallow(8,0,0) rotate z*25   translate <-45,20,-10> }
object { swallow(4,5,0) rotate x*-15  translate <-20,30,-20> }
object { swallow(4,15,0) rotate x*10  translate <-20,35,-30> }
object { swallow(3,-10,15) rotate y*45  translate <-10,50,-65> }
object { swallow(3,10,10) rotate z*-10 rotate y*33  translate <-12,55,-60> }
object { swallow(6,10,0) rotate x*-10 rotate y*-10  translate <-8,65,-75> }
