/* Persistence of Vision Ray Tracer Scene Description File
File: aphrodite.pov
Vers: MegaPOV 0.5
Date:27. August 2000 
Auth:Anto Matkovic, Zagreb, Croatia
e-mail:  matkovic.geo@yahoo.com
site: www.geocities.com/SoHo/Studios/7415
TEXTURES...
*/

#version unofficial MegaPov 0.5;
//APHRODITE************************************************************************
//#declare boja_ispod =colour rgb c59*0.5;
//#declare boja_izvana =colour rgb c09*0.25+0.74 filter 0.4;
//#declare boja_izvana_cic = colour rgb c09*0.27+0.72 filter 0.55;
//#declare fin_ispod =finish { ambient 0.84 diffuse 0.27}
//#declare fin_izvana =finish { ambient 0 diffuse 0.99 phong 0.5 phong_size 33 specular 0.35 roughness 0.35}

/*SKIN*********************************
All skin textures are layered, with large differences in finishes, to simulate 'specular color', which
POV not use */

#declare boja_ispod =colour rgb c59b*0.6;
#declare boja_izvana =colour rgb c09*0.17+0.82 filter 0.37;

#declare fin_ispod =finish { ambient 0.99 diffuse 0.05}
#declare fin_izvana =finish { ambient 0.05 diffuse 0.99 phong 0.3 phong_size 22 specular 0.3 roughness 0.3}
#declare fin_izvana_dolje =finish { ambient 0.05 diffuse 0.99 specular 0.2 roughness 0.3}
#declare fin_izvana_kaplje = finish { ambient 0.05 diffuse 0.99 phong 0.8 phong_size 22 
specular 0.3 roughness 0.3}

#declare boja_izvana_cic = colour rgb c09*0.17+0.82 filter 0.6;
#declare boja_ispod_cic = colour rgb c58b*0.5;

#declare skala_kaplja = 4;

#declare skin_suncano_dolje = 
texture { pigment {boja_ispod}
finish {fin_ispod}}

texture { pigment {boja_izvana}
finish {fin_izvana_dolje}
normal {granite 0.12 scale 0.8}}

#declare skin_suncano3 = //ovo je gore, blazi normal
texture { pigment {boja_ispod}
finish {fin_ispod}}

texture { pigment {boja_izvana}
finish {fin_izvana}
normal {granite 0.08 scale 0.9}}

#declare skin_suncano1 = 
texture { pigment {boja_ispod}
finish {fin_ispod}}

texture { pigment {boja_izvana}
finish {fin_izvana}
normal {granite 0.08 scale 1.1}}

#declare kaplje = //ovo su kaplje
texture { pigment {boja_ispod}
finish {fin_ispod}}

texture { pigment {boja_izvana}
finish {fin_izvana_kaplje}
normal {granite 0.11 scale 0.25}}

#declare skin_suncano_kaplje = texture {granite scale skala_kaplja
texture_map {[0 kaplje]
             [0.14 kaplje]
             [0.15 skin_suncano1]
             [1 skin_suncano1]}
             warp { reset_children}}

#declare cice_tex =  texture { pigment {boja_ispod_cic}
finish {fin_ispod}
normal {granite 0.3 scale 1}}

texture { pigment {boja_izvana_cic}
finish {fin_izvana}
normal {granite 0.3 scale 1}}

#declare za_ci = texture {gradient y  scale 50  rotate <-25, 0, 27> translate <-5, 37.2, 0>//<0, 32.7, 0>
texture_map {[0 cice_tex]
             [0.49 cice_tex]
             [0.5 skin_suncano_kaplje]
             [1 skin_suncano_kaplje]}
             warp { reset_children}}
             
#declare skin_suncano =material{ texture {gradient z scale 110 translate z*-93 
texture_map {[0 skin_suncano_dolje ]
             [0.3 skin_suncano_dolje ]
             [0.4 skin_suncano_kaplje]
             [0.43 skin_suncano_kaplje]
             [0.44 za_ci]//ovdje dodje za cice
             [0.56 za_ci]//ovdje dodje za cice
             [0.57 skin_suncano_kaplje]
             [0.75 skin_suncano_kaplje]
             [0.77 skin_suncano3 ]
             [1 skin_suncano3 ]
             }
             warp { reset_children}}
 interior { ior 1.33}}
 
//HAIR*********************************

#declare kosa300700_boja = texture { pigment {colour rgb c04b*0.5+0.4}
finish { ambient 0.2 diffuse 0.6 phong 0.99 phong_size 33 specular 0.4 roughness 0.2 reflection 0.03}
normal {bozo 0.1 scale <0.3, 0.007, 0.3>}}

#declare kosa300700_tamno = texture { pigment {colour rgb c07*0.2+0.1}
finish { ambient 0.2 diffuse 0.6 specular 0.1 roughness 0.2 reflection 0.03}
normal {bozo 0.1 scale <0.3, 0.007, 0.3>}}

#declare kosa_tex = texture { bozo scale <0.3, 0.007, 0.3>
texture_map {[0 kosa300700_boja]
             [0.35 kosa300700_boja]
             [0.65 kosa300700_tamno]
             [1 kosa300700_tamno]}warp { reset_children}}
             

             

//EYEBROWS, LASHES, etc*********************************
#declare unoci070800 = texture { pigment {colour rgb c01*0.4+0.45}
finish {ambient 0.25 diffuse 0.5 phong 0.99 phong_size 123 reflection 0.2}
normal {granite 0.4 scale 0.9}}

#declare obrve070800 =texture { pigment {gradient x scale 0.2 turbulence 0.7
colour_map {[0 colour rgb c07*0.4+0.2 ]
            [0.6 colour rgb c07*0.4+0.2]
            [0.61 colour rgbt 1]
            [1 colour rgbt 1]}}
finish {ambient 0.25 diffuse 0.6 }}

#declare trep_tex =texture { material_map {gif "trep.gif" map_type 0 
texture {pigment {colour rgb c07*0.4+0.2}
finish {ambient 0.2 diffuse 0.6 }}
texture {pigment {colour rgbt 1}
finish {ambient 0 diffuse 0}}} scale <-5, -5, 1> translate <-2.5, -2.5, 0>}

//LIPS*********************************

#declare usta_260700 = texture { pigment { colour rgb c01*0.55+0.44 }
finish { ambient 0.22 diffuse 0.6 phong 0.6 phong_size 22}
normal {bozo 0.05  scale <0.025, 0.025, 0.075> 
normal_map {[0 gradient x 0.2 sine_wave]
            [0.5 gradient x 0.2 sine_wave]
            [0.6 gradient x 0 sine_wave]
            [1 gradient x 0 sine_wave]}}}
//SAND********************************************************************
#declare boja_pijeska1 = colour_map {
            [0 colour rgb c02*0.7+0.2]
            [0.5 colour rgb c03*0.7+0.2]
            [1 colour rgb c04*0.7+0.2]}
            
#declare boja_pijeska_tamnije = colour_map {
            [0 colour rgb c02*0.3+0.1]
            [0.5 colour rgb c03*0.3+0.1]
            [1 colour rgb c04*0.3+0.1]}
            
#declare boja_pijeska2 = colour_map {
            [0 colour rgb c02*0.3+0.3]
            [0.5 colour rgb c03*0.3+0.3]
            [1 colour rgb c04*0.3+0.3]}
          
#declare pijesak_a = texture {pigment {bozo  scale 15
colour_map {boja_pijeska1}}
finish { ambient 0.1 diffuse 0.6 specular 0.99 roughness 0.25}}

#declare pijesak_b = texture {pigment {bozo scale 15 
colour_map {boja_pijeska1}}
finish { ambient 0.1 diffuse 0.6 diffuse 0.6 specular 0.15 roughness 0.05}}

#declare pijesak_a_tamnije = texture {pigment {bozo  scale 15
colour_map {boja_pijeska_tamnije}}
finish { ambient 0.1 diffuse 0.6 specular 0.99 roughness 0.25}}

#declare pijesak_b_tamnije = texture {pigment {bozo scale 15 
colour_map {boja_pijeska_tamnije}}
finish { ambient 0.1 diffuse 0.6 diffuse 0.6 specular 0.15 roughness 0.05}}

#declare pijesak_c = texture {pigment {bozo scale 15 
colour_map {boja_pijeska2}}
finish { ambient 0.1 diffuse 0.6 diffuse 0.6 specular 0.15 roughness 0.05}}

#declare pijesak_blize = texture { granite scale 0.03
texture_map  {[0 pijesak_a]
              [0.17 pijesak_a]
              [0.21 pijesak_b]
              [1 pijesak_b]}warp {reset_children}}
              
#declare pijesak_blize_tamnije = texture { granite scale 0.03
texture_map  {[0 pijesak_a_tamnije]
              [0.17 pijesak_a_tamnije]
              [0.21 pijesak_b_tamnije]
              [1 pijesak_b_tamnije]}warp {reset_children}}
              
#declare pijesak_blize_tamnije_sjena = texture { granite scale 4
texture_map  {[0 pijesak_blize_tamnije]
              [0.22 pijesak_blize_tamnije]
              [0.33 pijesak_blize]
              [1 pijesak_blize]}warp {reset_children}}
              
#declare pijesak_bez_sjene = texture { gradient y translate -0.5 scale 500 translate <0, -170, -99>
texture_map  {[0 pijesak_c]
              [0.25 pijesak_c]
              [0.7 pijesak_blize]
              [1 pijesak_blize]}warp {reset_children}}
              
#declare pijesak_sjena = texture { gradient y translate -0.5 scale 500 translate <0, -170, -99>
texture_map  {[0 pijesak_c]
              [0.25 pijesak_c]
              [0.7 pijesak_blize_tamnije_sjena]
              [1 pijesak_blize_tamnije_sjena]}warp {reset_children}}
              
#declare pijesak = texture  { gradient y 
scallop_wave translate -0.5 scale <270/3, 330/3, 1> translate <0, daljina_mora_od_kamere+70, 0>
warp {turbulence 0.4}
texture_map  {[0 pijesak_sjena]
              //[0.25 pijesak_sjena]
              //[0.7 pijesak_bez_sjene]
              [1 pijesak_bez_sjene]}warp {reset_children}}
                
// ROCKS**************************************************

#declare kamen180800_a = texture { pigment { granite scale 0.01
colour_map {[0 colour rgb c05*0.5]
            [0.5 colour rgb c06*0.5]
            [1 colour rgb c07*0.5]}}
finish { ambient 0.2 diffuse 0.6 specular 0.05 roughness 0.1}}

#declare kamen180800_b = texture { pigment { granite scale 0.01
colour_map {[0 colour rgb c05*0.8]
            [0.5 colour rgb c06*0.8]
            [1 colour rgb c07*0.8]}}
finish { ambient 0.2 diffuse 0.6 specular 0.4 roughness 0.1}}

#declare kamen180800 = texture { gradient y sine_wave scale 17
texture_map {[0 kamen180800_a]
             [1 kamen180800_b]}}
             
//SEA*********************************************************************** 

#declare boja_mora = colour rgb 0.9 filter 0.9;
#declare more_normal = normal { gradient x 0.25 sine_wave scale 1/20 warp { turbulence 0.3} scale 25}

#declare more_osn = texture { pigment { boja_mora }
finish { ambient 0.1 diffuse 0.1 phong 0.99 phong_size 171 
reflection_type 1 reflection_min 0.2 reflection_max 0.6 conserve_energy
}normal {more_normal}}

#declare more_pjena_1 = texture { pigment {boja_mora}
finish { ambient 0.1 diffuse 0.1 phong 0.99 phong_size 171
reflection_type 1 reflection_min 0.2 reflection_max 0.6 conserve_energy 
irid {0.4 thickness 0.2 turbulence 0.4}
}
normal {more_normal}}

#declare more_pjena_2 = texture { pigment {boja_mora}
finish { ambient 0.3 diffuse 0.3 phong 0.99 phong_size 171 specular 0.5 roughness 0.5
reflection_type 1 reflection_min 0.2 reflection_max 0.6 conserve_energy 
irid {0.4 thickness 0.2 turbulence 0.4}
}normal {more_normal}}

#declare more_pjena = texture { granite scale 1.75
texture_map {[0 more_pjena_1]
             [0.18 more_pjena_1]
             [0.22 more_pjena_2]
             [1 more_pjena_2]}warp {reset_children}}
             

#declare more_pjena_dolje = texture { granite scale 9
texture_map { [0 more_osn]
              [0.25 more_osn]
              [0.35 more_pjena]
              [1 more_pjena]}warp {reset_children}}

#declare more_b = material { texture {gradient z 
texture_map {[0 more_osn]
             [0.3 more_osn]
             [0.43 more_pjena_dolje]
             [0.7 more_pjena_dolje]
             [0.86 more_pjena]
             [1 more_pjena]}
             scale visina_mora+0.02 translate <0, 0, spust_mora-0.01>
             warp {reset_children}}
interior { ior 1.33 }}

#declare more_p = material { texture { pigment { colour rgbt 0.7 }
finish { ambient 0.2 diffuse 0.2}}}




           
            
            
