// ============================================================================
//
// Atlantic Still Life
//
// Entry for July/August IRTC - Topic 'Sea'
//
// All code and images copyright (c) Ian Shumsky / Outerarm 2000
//
// ============================================================================

#version unofficial Megapov 0.5;

// ============================================================================
//
// This file constructs a fossil rock containing several Calymene fossils and
// a label describing the piece.
//
// ============================================================================

#include "calymene.inc"

#declare calymene_rand = seed (6);

#declare _calymene_rock = union
{
	#declare calymene_count = 0;
	#declare max_calymene = 7;

	#while (calymene_count < max_calymene)
		object
		{
			calymene
			rotate <-2.5 + (5 * rand (calymene_rand)), 0, 0>
			rotate <0, 0, -0.5 + rand (calymene_rand)>
			rotate y*360*rand (calymene_rand)
			translate <-0.08 + (0.1 * 1.6 * rand (calymene_rand)), -0.005 + (0.01 * rand (calymene_rand)), -0.08 + (0.1 * 1.6 * rand (calymene_rand))>
		}
		#declare calymene_count = calymene_count + 1;
	#end

	union
	{
		height_field
		{
			png "calymene_rock_hf.png"
			smooth
			translate <-.5, 0, -.5>
		}
		box
		{
			<-0.5, -.1, -0.5>, <0.5, 0, 0.5>
		}
		scale <0.25, 0.02, 0.25>
		texture
		{
			rock_texture
			scale 2
			translate <10 * rand (calymene_rand),10 * rand (calymene_rand),10 * rand (calymene_rand)>
		}
	}
	// rest on y = 0
	translate <0, .1*.02, 0>
	scale 1.5
}

#declare calymene_label = union
{
	//
	// Mount
	//

	box
	{
		<0, 0, 0>, <1, 1, 1>
		translate <-0.5, -0.5, -0.5>
		scale <3.8 + 0.1, .78 + 0.1, 1>
		texture
		{
			rock_texture
			scale 2
			translate <10 * rand (calymene_rand),10 * rand (calymene_rand),10 * rand (calymene_rand)>
		}
	}

	//
	// Label
	//

	box
	{
		<0, 0, 0>, <1, 1, 1>
		texture
		{
			pigment
			{
				image_map
				{
					png "calymene_label.png"
					map_type 0
					interpolate 2
				}
			}
		}
		translate <-0.5, -0.5, -0.5>
		scale <3.8, .78, 1>
		translate <0, 0, -00.02>
	}
	rotate x*90
	scale <0.03, 0.02, 0.03>
}

#declare calymene_rock = union
{
	object
	{
		_calymene_rock
	}
	object
	{
		calymene_label
		translate <0, 0.015, -0.15>
	}
}

