// ============================================================================
//
// Atlantic Still Life
//
// Entry for July/August IRTC - Topic 'Sea'
//
// All code and images copyright (c) Ian Shumsky / Outerarm 2000
//
// ============================================================================

#version unofficial Megapov 0.5;

// ============================================================================
//
// This file constructs a fossil rock containing a single Dalmaniyes fossils
// and a label describing the piece.
//
// ============================================================================

#include "dalmanites.inc"

#declare dalmanites_rand = seed (270);

#declare rock_hf_2 = height_field
{
	png "dalmanites_rock_hf.png"
	smooth
	translate <-.5, 0, -.5>
	rotate y*180
}

#declare _dalmanites_rock = union
{
	object
	{
		dalmanites
		translate <0, 0.002, 0>
		rotate z*0.7
		rotate y*180
		rotate y * -135
		scale 3
	}
	union
	{
		object
		{
			rock_hf_2
		}
		box
		{
			<-0.5, -.1, -0.5>, <0.5, 0, 0.5>
		}
		scale <0.25, 0.02, 0.25>
		texture
		{
			rock_texture
			scale 2
			translate <10 * rand (dalmanites_rand),10 * rand (dalmanites_rand),10 * rand (dalmanites_rand)>
		}
	}
	// rest on y = 0
	translate <0, .1*.02, 0>
	scale 1.15
}

#declare dalmanite_label = union
{
	//
	// Mount
	//

	box
	{
		<0, 0, 0>, <1, 1, 1>
		translate <-0.5, -0.5, -0.5>
		scale <3.8 + 0.1, .78 + 0.1, 1>
		texture
		{
			rock_texture
			scale 2
			translate <10 * rand (dalmanites_rand),10 * rand (dalmanites_rand),10 * rand (dalmanites_rand)>
		}
	}

	//
	// Label
	//

	box
	{
		<0, 0, 0>, <1, 1, 1>
		texture
		{
			pigment
			{
				image_map
				{
					png "dalmanites_label.png"
					map_type 0
					interpolate 2
				}
			}
		}
		translate <-0.5, -0.5, -0.5>
		scale <3.8, .78, 1>
		translate <0, 0, -00.02>
	}
	rotate x*90
	scale <0.03, 0.02, 0.03>

}

#declare dalmanites_rock = union
{
	object
	{
		_dalmanites_rock
	}
	object
	{
		dalmanite_label
		translate <-0.078, 0.015, -0.12>
	}
}

