#include "colors.inc"
#include "textures.inc"
#include "chapeau.inc"
#include "bouee.inc"
#include "texttest.inc"
#include "pendule.inc"


#declare x0 = 5*pi/12; //angle au niveau de la tte
#declare x4 = -5*pi/12;// angle au niveau du dbut de la queue
#declare x1 = x0+(x4-x0)*1.7/12.3; // angle au niveau du rayon max du corps   
#declare x2 = x0+(x4-x0)*8.3/12.3;
#declare x3 = x0+(x4-x0)*11.2/12.3; //angle au niveau le + troit 

#declare a=10; //largeur de l'ellipse decrite par le corps
#declare b=10; //longueur de l'ellipse decrite par le corps  
#declare coef = b*(x0-x4)/12.3;

#declare y0 = coef*1.8; // rayon de la tete du dauphin
#declare y1 = coef*1.9; // rayon max du corps du dauphin 
#declare y2 = coef*1.0;
#declare y3 = coef*0.4; // rayon min du corps du dauphin   
#declare y4 = coef*0.4; //rayon au dbut de la queue   

#declare iterations=200; // nombre d'itrations utilises pour la construction du corps.
//Entre P3(x3,y3) et P4(x4,y4) F3(x)=A3x+B3
#declare den3 = (x4-x3);
#declare A3 = (y4-y3)/den3;
#declare B3 = (y3*x4-x3*y4)/den3;
//Entre P2(x2,y2) et P3(x3,y3) F2(x)=A2x^2+B2x+C2
#declare den2 = pow(x3-x2,2);
#declare A2 = ((x3-x2)*A3+y2-y3)/den2;
#declare B2 = (2*x3*(y3-y2)+(pow(x2,2)-pow(x3,2))*A3)/den2;
#declare C2 = (y2*pow(x3,2)+y3*pow(x2,2)-2*x2*x3*y3+x2*x3*(x3-x2)*A3)/den2;
//Entre P1(x1,y1) et P2(x2,y2) F1(x)=A1x^2+B1x+C1
#declare den1 = pow(x2-x1,2);
#declare A1 = ((x2-x1)*(2*x2*A2+B2)+y1-y2)/den1;
#declare B1 = (2*x2*(y2-y1)+(pow(x1,2)-pow(x2,2))*(2*x2*A2+B2))/den1;
#declare C1 = (y1*pow(x2,2)+y2*pow(x1,2)-2*x1*x2*y2+x1*x2*(x2-x1)*(2*x2*A2+B2))/den1;
//Entre P0(x0,y0) et P1(x1,y1) F0(x)=A0x^2+B0x+C0
#declare den0 = pow(x1-x0,2);
#declare A0 = ((x1-x0)*(2*x1*A1+B1)+y0-y1)/den0;
#declare B0 = (2*x1*(y1-y0)+(pow(x0,2)-pow(x1,2))*(2*x1*A1+B1))/den0;
#declare C0 = (y0*pow(x1,2)+y1*pow(x0,2)-2*x0*x1*y1+x0*x1*(x1-x0)*(2*x1*A1+B1))/den0;

#declare vue_profil=
  camera {
    location <0, b, -35>
    look_at <0, b, 0>
  }

#declare tete_profil=
  camera {
    location <0, 2*b, -15>
    look_at <0, 2*b, 0>
  }

#declare vue_face=
  camera {
    location <-35, b, -0>
    look_at <0, b, 0>
  }

#declare tete_face=
  camera {
    location <-15, 2*b, -0>
    look_at <0, 2*b, 0>
  }

#declare vue_3quarts=
  camera {
    location <-25, 2*b, -25>
    look_at <0, 15, 0>
  } 
  
#declare tete_3quarts=
  camera {
    location <-10, 2*b, -10>
    look_at <0, 2*b, 0>
  }
        
#declare PrismQueue =
prism {
  cubic_spline
  conic_sweep
  0,
  1.0,
  29,
  

  < 0, 1.5>, < -1.2,  0.5>, < -2, -0.5>, < -4,  -1.5>, < -6, -2.5>, 
  < -7,  -3.5>, < -8,  -5.5>, < -8, -6.5>, < -7.2,  -6.5>, < -5, -5.7>,
  < -3, -5.3>, < -1, -4.7>, < 0, -3.5>,
  < 0, -3.5>,
  < 0, -3.5>, < 1, -4.7>, < 3, -5.3>,   
  < 5, -5.7>, < 7.2,  -6.5>, < 8, -6.5>, < 8,  -5.5>, < 7,  -3.5>,
  < 6, -2.5>, < 4,  -1.5>, < 2, -0.5>, < 1.2,  0.5>, < 0, 1.5>,
  < -1.2,  0.5> , < -2, -0.5>

  translate <0, -1, 0> 
  scale < 1, 1/2, 1>
}

#declare Queue = 
merge{
   object { 
      PrismQueue   
      }
   object {
      PrismQueue
      matrix < 1, 0, 0,
               0, -1, 0,
               0, 0, 1,
               0, 0, 0 >
      }
   }

#declare PrismAileron =
prism {
  cubic_spline
  conic_sweep
  0,
  1.0,
  12,
  

  < -1, 0>, < 0,  2>, < 4, 5>, < 5,  4.5>, < 4, 2>, 
  < 5,  0>, < 6, -1>, < 5,  -2>, < 0, -2>, < -1,  0>, < 0, 2>,
  < 4, 5>

  translate <0, -1, 0> 
  scale < 1, 1/2, 1>
}

#declare Aileron = 
merge{
   object { 
      PrismAileron   
      }
   object {
      PrismAileron
      matrix < 1, 0, 0,
               0, -1, 0,
               0, 0, 1,
               0, 0, 0 >
      }
   //translate <0, 1, 0> 
   rotate <-90, 0, -90>
   //translate <0, -1, 0> 
   }

#declare Nageoire =
prism {
  cubic_spline
  conic_sweep
  0,
  1.0,
  17,
  

  < 0, 1.8>, < -1.5,  1>, < -3, 0>, < -5,  -1>, < -6, -2>, 
  < -7,  -4>, < -7,  -5>, < -6, -5>, < -4,  -4>, < -1, -3.7>,
  < 0, -3>, < 1, -2>, < 2, 0>, < 1, 2>,
  < 0, 1.8>, < -1.5,  1>, < -3, 0>
  
  translate -y
  matrix < 1, 0, 0,
           0, -1, 0,
           0, 0, 1,
           0, 0, 0 >
  scale < 1, 1/4, 1> 
  rotate <-20, 30, 15> 
}

#declare Nageoire_positionnee = 
  object {Nageoire  
    #local position_nageoire = 40;
    rotate -90*x - position_nageoire*y 
    translate <y1*cos(pi+radians(position_nageoire)),
             0,
             y1*sin(pi+radians(position_nageoire))>
    }
    
#declare Nageoires =  
  union {
    object {Nageoire_positionnee}   
    object {Nageoire_positionnee
      matrix < 1, 0, 0,
               0, 1, 0,
               0, 0, -1,
               0, 0, 0 >
      }   
    }
       
#declare corps=   
   union{    
      // tte
      union {   
         //crane + yeux
         union {            
            difference {    
               sphere{<0,0,0>,y0}    
               plane{-x,0}
               scale <2,1,1>   
               }     
            #local pos_oeil=pi/3;
            #local r_oeil = 0.5;
            #local a_oeil = 25;  
            #local s_oeil = 0.5;
            sphere {<0,0,0>,r_oeil 
               scale <1,s_oeil,s_oeil> 
               translate <-2*y0*cos(pos_oeil),0,y0*sin(pos_oeil)>
               rotate a_oeil*x
               pigment { Black}
               finish {F_Glass1}
               }   
            sphere {<0,0,0>,r_oeil 
               scale <1,s_oeil,s_oeil> 
               translate <-2*y0*cos(pos_oeil),0,-y0*sin(pos_oeil)>
               rotate -a_oeil*x
               pigment { Black}  
               finish {F_Glass1}
               }   
            }   
         //museau               
         difference {    
            sphere{<0,-y0/2,0>,y0/2}    
            plane{-x,0}
            scale <5.5,1,1>
            }
         rotate -degrees(pi/2-x0)*z  
         translate <a*cos(x0), b*sin(x0), 0>
         }    
      //courbe du corps                 
      #declare i=0;    
      #while (i<iterations) 
         #declare angle_alpha = x0 + i*(x4-x0)/(iterations - 1);
         #declare cx= a*cos(angle_alpha);
         #declare cy= b*sin(angle_alpha);            
         #switch (angle_alpha)   
         #range (x4,x3)   
           #declare R = A3*angle_alpha+B3;  
           #declare couleur = pigment {Red}
         #break
         #range (x3,x2)
           #declare R = A2*pow(angle_alpha,2)+B2*angle_alpha+C2;
           #declare couleur = pigment {Orange}
         #break
         #range (x2,x1)
           #declare R = A1*pow(angle_alpha,2)+B1*angle_alpha+C1;
           #declare couleur = pigment {Yellow}
         #break  
         #range (x1,x0)
           #declare R = A0*pow(angle_alpha,2)+B0*angle_alpha+C0;
           #declare couleur = pigment {Green}
         #break  
         #else
           #declare R = 1;  
           #declare couleur = pigment {White}
         #end   
         sphere { <cx,cy,0>, R
           //pigment {couleur}
           }
         #declare i=i+1;        
      #end       
      //queue 
      union {            
         difference {    
            sphere{<0,0,0>,y4}    
            plane{-x,0}
            scale <2,1,1>
            }          
         object {
            Queue     
            rotate 90*y
            }
         rotate -degrees(-pi/2-x4)*z  
         translate <a*cos(x4), b*sin(x4), 0>
         }   
      //Nageoires
      object {Nageoires 
         rotate degrees(x1)*z 
         translate <b*cos(x1),b*sin(x1), 0>  
         texture {marbre_nageoires scale 6}  
         }                
      //Aileron   
      object {Aileron 
         translate <b+y0-1,3,0> 
         texture {marbre_nageoires scale 6}  
         }   
      texture { t_dauphin 
         scale b+y1
         }
      }


#declare dauphin =
union { 
  object {pendule
    scale 0.18 
    rotate <0,90,90>
    translate <0,2.2,0>
    }
  object {corps }      
  object { chapeau 
    scale y0/7  
    rotate 45*y
    rotate -30*x  
    rotate 17*z
    translate <-1.9,(b+y0-1),-1.3>
    }      
  object { bouee 
    scale 6
    translate -12.6*y + 3*x
    } 
  translate (6/4+12.6)*y - 3*x   
  rotate -90*y
  }        
  

