// boat.inc

#ifndef (RowerSeed)
    #declare RowerSeed = seed(5267);
#end

#local Dev = 0;

#local GuideSphere = 0;
#local HullR = 30;
#local Height = 1;
#local Beam = 2;
#local HalfBeam = Beam / 2;
#local Length = 10;
#local HalfLength = Length / 2;
#local R1 = Beam / 4 + Length*Length / Beam;
#local Z1 = R1 - HalfBeam;
#local Thickness = 0.1;
#local Angle = 15;

#if (White)
	#local Boatcolour = <1,1,1>;
	#local BodyColour = <1,1,1>;
	#local HeadColour = <1,1,1>;
	#local BoatLight = <0.7,0.5,0.1>;
	#local BodyLight = <1,0.3,0>;
	#local HeadLight = <1,0.9,0.6>;
#else
	#local Boatcolour = <0.9,0.8,0.5>;
	#local BodyColour = <0,0.5,0.4>;
	#local HeadColour = <1,1,1>;
#end

#local NumOars = 4;
#local OarR = 0.05;
#local NumRowers = 4;
#local HeadR = 0.15;
#local BodyR = 0.2;
#local NumBodyBits = 20;
#local HeadHeight = 1;

#local T_hull = texture {
	pigment { rgb Boatcolour }
	normal { wood 1
		ramp_wave
		scale 0.45
		translate <0,HullR,0>
	}
	finish { brilliance 0.1 }
}

#local T_deck = texture {
	pigment { rgb Boatcolour }
	normal { gradient x 1
		scale 0.35
		translate <-10,0,0>
	}
	finish { brilliance 0.1 }
}

#macro Rower(Pos,xrot,yrot)
	difference {
		union {
			sphere { <0,0,0>, HeadR
				texture {
					pigment { rgb HeadColour }
					normal { crackle 0.7
						scale HeadR
						translate 3*rand(RowerSeed)
					}
				}
			}
			union {
				#local i = 0;
				#while (i < NumBodyBits)
					superellipsoid { <0.6,0.6>
						scale BodyR
						rotate <rand(RowerSeed)*180,rand(RowerSeed)*180,rand(RowerSeed)*180>
						scale <1,0.7,0.5>
						translate <0,HeadHeight,0>
						rotate <i*85/NumBodyBits+5,0,0>
					}
					#local i = i + 1;
				#end
				texture { pigment { rgb BodyColour } }
				//rotate <0,yrot,0>
				translate <0,-HeadHeight,0>
			}
			rotate <xrot,yrot,0>
			translate Pos
		}
		box { <-10,-10,-10>, <10,0,10> }
	}
	#if (White & !Dev)
		// light on head
		#local Offset = vrotate(<0,1,-1>, <xrot,yrot,0>);
		#local Radius = degrees(atan2(HeadR,2));
		Spot(Pos+Offset, Pos, HeadLight, Radius, Radius*2, 0.2)
		// lights on body
		#local Offset = vrotate(<0,1,1>, <xrot,yrot,0>);
		#local Offset2 = vrotate(<0,0,0.5>, <xrot,yrot,0>);
		#local Radius = degrees(atan2(HeadR,0.5));
		Spot(Pos+Offset, Pos+Offset2, BodyLight, Radius, Radius*2, 0)
		#local Offset = vrotate(<0,-0.2,-0.2>, <xrot,yrot,0>);
		#local Offset2 = vrotate(<0,-0.2,0>, <xrot,yrot,0>);
		#local Radius = degrees(atan2(HeadR,0.3));
		Spot(Pos+Offset, Pos+Offset2, BodyLight, Radius, Radius*2, 0)
	#end
#end

#declare Boat = union {
	// guide sphere at centre of boat
	#if (GuideSphere)
		sphere { <0,0,0>, 0.5
			texture {
				pigment { rgb <0,1,0> }
			}
		}
	#end
	// port hull
	difference {
		difference {
			cylinder { <0,HullR,-HalfBeam>, <0,HullR,HalfBeam>, HullR }
			cylinder { <0,HullR,-HalfBeam>, <0,HullR,HalfBeam>, HullR-Height }
			cylinder { <HalfLength,0,Z1>, <HalfLength,Height*5,Z1>, R1-Thickness }
			cylinder { <HalfLength,0,Z1>, <HalfLength,Height*5,Z1>, R1 inverse }
			texture { T_hull }
			rotate <-Angle,0,0>
		}
		plane { -z, 0 }
		plane { -x, -HalfLength }
		// plane to cut extraneous bit off - needs adjustment if angles/sizes changed
		plane { x, -8.5 }
	}
	// starboard hull
	difference {
		difference {
			cylinder { <0,HullR,-HalfBeam>, <0,HullR,HalfBeam>, HullR }
			cylinder { <0,HullR,-HalfBeam>, <0,HullR,HalfBeam>, HullR-Height }
			cylinder { <HalfLength,0,-Z1>, <HalfLength,Height*5,-Z1>, R1-Thickness }
			cylinder { <HalfLength,0,-Z1>, <HalfLength,Height*5,-Z1>, R1 inverse }
			texture { T_hull }
			rotate <Angle,0,0>
		}
		plane { z, 0 }
		plane { -x, -HalfLength }
		// plane to cut extraneous bit off - needs adjustment if angles/sizes changed
		plane { x, -8.5 }
	}
	// upper deck
	difference {
		difference {
			cylinder { <0,HullR,-Beam>, <0,HullR,Beam>, HullR-Height+0.2 }
			cylinder { <0,HullR,-Beam-1>, <0,HullR,Beam+1>, HullR-Height+0.1 }
			texture { T_deck }
			rotate <0,0,-2.5>
			translate <0,-0.2,0>
		}
		cylinder { <HalfLength,0,Z1>, <HalfLength,Height*5,Z1>, R1-Thickness
			rotate <-Angle,0,0>
			inverse
		}
		cylinder { <HalfLength,0,-Z1>, <HalfLength,Height*5,-Z1>, R1-Thickness
			rotate <Angle,0,0>
			inverse
		}
		plane { -x, HalfLength }
	}
	// lower deck
	difference {
		difference {
			cylinder { <0,HullR,-Beam>, <0,HullR,Beam>, HullR-Height+0.2 }
			cylinder { <0,HullR,-Beam-1>, <0,HullR,Beam+1>, HullR-Height+0.1 }
			texture { T_deck }
			rotate <0,0,-2.5>
			translate <0,-0.8,0>
		}
		cylinder { <HalfLength,-Height,Z1>, <HalfLength,Height*5,Z1>, R1-Thickness
			rotate <-Angle,0,0>
			inverse
		}
		cylinder { <HalfLength,-Height,-Z1>, <HalfLength,Height*5,-Z1>, R1-Thickness
			rotate <Angle,0,0>
			inverse
		}
		plane { -x, -HalfLength }
	}
	// back plate
	difference {
		box { <HalfLength-Thickness,0,-Beam>, <HalfLength,Height,Beam>
			texture { T_hull }
		}
		cylinder { <HalfLength,-Height,Z1>, <HalfLength,Height*5,Z1>, R1-Thickness
			rotate <-Angle,0,0>
			inverse
		}
		cylinder { <HalfLength,-Height,-Z1>, <HalfLength,Height*5,-Z1>, R1-Thickness
			rotate <Angle,0,0>
			inverse
		}
	}
	// oars
	#local i = 0;
	#while (i < NumOars)
		cylinder { <HalfLength-1-0.5*i,1.5-0.1*i,-HalfBeam>, <HalfLength+1-0.5*i,-0.5-0.1*i,-Beam>, OarR
		}
		cylinder { <HalfLength-1-0.5*i,1.5-0.1*i,HalfBeam>, <HalfLength+1-0.5*i,-0.5-0.1*i,Beam>, OarR
		}
		#local i = i + 1;
	#end
	// rowers
	#local i = 0.5;
	#while (i < NumRowers)
		Rower(<HalfLength-1-0.5*i,1.5-0.1*i,-HalfBeam>,0,0)
		Rower(<HalfLength-1-0.5*i,1.5-0.1*i,HalfBeam>,0,180)
		#local i = i + 1;
	#end
	// bowmen
	Rower(<-HalfLength/2,1.2,-HalfBeam/2>,40,20)
	Rower(<-HalfLength/2,1.2,HalfBeam/2>,40,200)
	
	// spotlights
	#if (White)
		#local x1 = -7;
		#while (x1 < 5)
			#local y1 = 0.4 + (x1-1.5)*(x1-1.5)*0.01;
			Spot(<x1,y1,-Beam>, <x1,y1,0>, BoatLight, 30, 40, 0)
			Spot(<x1,y1+2,0>, <x1,y1,0>, BoatLight, 30, 40, 0)
			#local x1 = x1 + 0.7;
		#end
	#end

	// base texture
	texture {
		pigment { rgb Boatcolour }
	}
}