// spot.inc

#macro Spot(Pos, Aim, Colour, Radius, Falloff, ConeLength)
	light_source { Pos, rgb Colour
		spotlight
		point_at Aim
		radius Radius
		falloff Falloff
		fade_distance 5
		fade_power 1
	}
	#if (ConeLength > 0)
		cone { Pos, 0, Pos + ConeLength*(Aim - Pos)/vlength(Aim - Pos), ConeLength*tan(radians(Radius))
			open
			no_shadow
			texture {
				pigment { rgb Colour }
				finish { ambient 0.5 }
			}
		}
	#end
#end