#include "colors.inc"
#include "ship.inc"

camera {
  location <-5, 3,-75>
  look_at <40,0,0>
  }
 
 light_source {<-5,120,-100> color White}
 
#declare Water_Color = color red 0.237255 green 0.556863 blue 0.719608
 
//Create ocean
merge{
 
 difference {
  plane {y,-2} 
  plane {x, 0}
 }
  
 difference {
  plane {y,-3}
  plane {x,-1}                              
 }
 
 cylinder {
  <0, -3, -76>,
  <0, -3, 2000>,
  1
 }
  
  rotate y*-5
  normal {wrinkles 30 scale 5 turbulence .5}
  pigment {Water_Color}
  finish {
   ambient 0
   diffuse 1
   //reflection .2
   specular 1
   roughness 1
 }
 }
 
//sky
sky_sphere {
  pigment {
   gradient x
   color_map {
     [0.0 Black]
     [1.0 SkyBlue]
    }
    scale .9
   }
   pigment {
    gradient x
    pigment_map {
      [0.0 granite  
        color_map {
            [0.72 rgb 0.00 ] // No Stars in this area
            [0.72 rgb 0.20 ] // Very Very Faint Stars
            [0.75 rgb 0.40 ] // Very Very Faint Stars
            [0.78 rgb 0.60 ] // Very Faint Stars
            [0.81 rgb 0.80 ] // Faint Stars
            [0.85 rgb 0.95 ] // Medium White Stars
            [0.91 rgb 1.00 ] // White Stars 
            [0.91 rgb 0.00 ] // No Stars in this area
        }
    scale .015]
    
    [0.5 bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 color rgb 0.85]
          [0.1 color rgb 0.75]
          [0.5 color rgbt 1]
          [1.0 color rgbt 1]
      }
      scale <0.2, 0.5, 0.2>]
     
     [1.0 bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 color rgb 0.85]
          [0.1 color rgb 0.75]
          [0.5 color rgbt 1]
          [1.0 color rgbt 1]
      }
      scale <0.2, 0.5, 0.2>]
    }
    rotate x*-135
    scale .9
  }              
 }

object {Ship scale .5 rotate y*-10 translate <45,3,-15>}

 
  

