#include "colors.inc" 
#include "textures.inc"

background {color White}

camera {
 location <0,50,-50>
 look_at <0,50,0>
 }
 
light_source {<0, 40, -140> color White}

#declare WoodTex =
pigment {
    wood
    turbulence 0.05
    octaves 5
    scale <0.075, .075, 1>
    color_map {
        [0.1 rgb <0.40, 0.20, 0.150>]
        [0.9 rgb <0.25, 0.07, 0.038>]
    }
}

#declare NearBlack = rgb <0.2,0,0>
 
#declare Tub =
difference {
 sphere {
  <0,0,0>, 15
  scale <4,1.3,1>
 }
 sphere {
  <0,10,0>,15
  scale <5,1.3,1>
  }
 }


#declare Ship = union {
//boat bottom 
difference { 
 difference { 
  intersection {
   object {Tub translate <0,.0001,-3>}
   object {Tub translate z*3}
   pigment {
    gradient y
    pigment_map {
     [0.4 WoodTex]
     [0.41 NearBlack]
     [0.9 WoodTex]
     [0.91 NearBlack]
     [1.0 WoodTex]
     }
    scale y*2
    }
   }
  superellipsoid {<.25,.25>
  scale <25,6,20>
  }
 }
 box {
  <52,-20,-10>,
  <60,5,10>
  }
 }

cone {
 <-58,-1,0>,1.5
 <-90,8,0>,0
 texture {WoodTex}
 }
 
//vertical rigging
#macro Rigging (BaseValue)
 cylinder {
  <BaseValue,Start,zValue>,
  <0,End,0>,
  .2
  pigment {color Black}
  }
#end

//horizontal rigging
#macro HRigging (BaseVal2)
 #local yVal = Start;
 #local Angle = asin(zValue/(End-Start));
 #local Angle2 = asin(BaseVal2/(End-Start));
 #local Point1 = BaseVal2;
 #local zLoc = zValue;
 #while (yVal < End)
  #local Point2 = -1*Point1;
  cylinder {
   <Point1,yVal,zLoc>,
   <Point2,yVal,zLoc>,
   .2
   pigment {color Black}
   }
  #local yVal = yVal + 1;
  #local hyp = End - yVal;
  #local zLoc = hyp*sin(Angle);
  #local a = sqrt((hyp*hyp)-(zLoc*zLoc));   
  #local Point1 = hyp*tan(Angle2);
 #end
#end
 

//miscellaneous rigging
#declare LongRigging = 
 cylinder {
  <0,-5,-6>,
  <0,55,0>,
  .2
  pigment {color Black}
  }
  
#declare LongRigging2 =
 cylinder {
  <0,-5,-20>,
  <0,52,0>,
  .2
  pigment {color Black}
  }

//masts
#declare Mast =  
union {
 cone {
  <0,-5,0>,1.5
  <0,60,0>,0
  }
 cylinder {
  <0,8,0>,
  <0,9,0>,
  4       
  }
 cylinder {
  <0,39,0>,
  <0,39.5,0>,
  2             
  }
   
 object {LongRigging}
 object {LongRigging2 rotate y*90}
 object {LongRigging rotate y*180}
 object {LongRigging2 rotate y*270}
 
 //top rigging
 #local Start = 39.5;
 #local End = 55;
 #local zValue = -2;
 Rigging(0)
 Rigging(.5)
 Rigging(1)
 Rigging(-.5)
 Rigging(-1)
 HRigging(1)
 
 #local zValue = 2;
 Rigging(0)
 Rigging(.5)
 Rigging(1)
 Rigging(-.5)
 Rigging(-1)
 HRigging(1)
 
 //middle rigging
 #local Start = 9;
 #local End = 39;
 #local zValue = -4;
 Rigging(0)
 Rigging(1)
 Rigging(2)
 Rigging(-1)
 Rigging(-2)
 HRigging(2)

 #local zValue = 4;
 Rigging(0)
 Rigging(1)
 Rigging(2)
 Rigging(-1)
 Rigging(-2)
 HRigging(2)
 pigment {WoodTex}
 }
 
 //bottom rigging
 #local Start = -6; 
 #local End = 9; 
 #local zValue = -9;
 Rigging(0)
 Rigging(1.5)
 Rigging(3)
 Rigging(-1.5)
 Rigging(-3)
 HRigging(3)

 #local zValue = 9; 
 Rigging(0)
 Rigging(1.5)
 Rigging(3)
 Rigging(-1.5)
 Rigging(-3)
 HRigging(3)
 
#declare BRigging =
 union {
  #local Start = -5;
  #local End = 8;
  #local zValue = -6;
  Rigging(0)
  Rigging(1.5)
  Rigging(3)
  Rigging(-1.5)
  Rigging(-3)
  HRigging(3)
  
  #local zValue = 6;
  Rigging(0)
  Rigging(1.5)
  Rigging(3)
  Rigging(-1.5)
  Rigging(-3)
  HRigging(3)
  }

object {BRigging translate x*30}
object {BRigging translate x*-30}
  
object {Mast scale y*1.1}
object {Mast translate x*30}
object {Mast translate x*-30}
cone {
 <0,-3.5,0>,1.05
 <0,42,0>,0
 translate x*45
 pigment {WoodTex}
 }
cylinder {
 <45,40,0>,
 <35,-3.5,0>,
 .2
 pigment {color Black}
 }


//sail
#declare Sail = 
union {
difference { 
difference {
 difference {
  cylinder {
   <3.9999,0,0>,
   <-3.9999,0,0>,
   3.9999
   //pigment {color Flesh}
   }
 
   box {
    <-4,-4,-3>,
    < 4,4,4>
   }
  }
 
  cylinder {
   <4,0,0>,
   <-4,0,0>,                                     
   3.9998
  }
 }
 sphere {
  <0,-8,0>,7
  }
 }

 //horizontal mast for sail
 cylinder {
  <4.5,2.55,-3>,
  <-4.5,2.55,-3>,
  .1
  pigment {WoodTex}
  }
 }
  
#declare Sails = union {
 object {Sail scale <3,1.8,3> translate <0,49,9> }
 object {Sail scale <3.25,2.25,3.25> translate <0,38,9> }
 object {Sail scale <3.5,2.75,3.5> translate <0,25,9> }
 object {Sail scale <3.75,3.5,3.75> translate <0,9,9> }
 rotate y*60
 }

union { 
 object {Sails scale y*1.1}
 object {Sails translate x*30}
 object {Sails translate x*-30}
 normal {ripples frequency .5 turbulence .2 scale 5 translate <60,40,0>}
 pigment {color Flesh}
 }

//front sail
#declare FrontSail = 
union {
difference { 
difference {
 difference {
   cylinder {
    <4.9999,0,0>,
    <-4.9999,0,0>,
    3.9999
   }
 
   box {
    <-5,-4,-3>,
    < 5,4,4>
   }
  }
 
  cylinder {
   <5,0,0>,
   <-5,0,0>,                                     
   3.9998
  }
 }
 
 #declare Cut =
 sphere {
  <0,0,0>,5  
  scale x*2
  }
union { 
 object {Cut translate <-9.8,-2,-3>}
 object {Cut translate <9.8,-2,-3>}
 }
}
 cylinder {
 <0,-1,-4>,
 <0,-7,-4>,
 .06666667
 pigment {color Black}
 }
 rotate z*45
}

union {
 object {FrontSail scale 3 translate <-63, 10, 10>}
 cylinder {
  <-59,25,1>,
  <-30,57,0>,
  .2     
  pigment {color Black}
  }
 object {FrontSail scale 3 translate <-56,8,10>}
 cylinder {
  <-52,23,1>,
  <-30,47,0>,
  .2
  pigment {color Black}
  }
 object {FrontSail scale 2.8 translate <-48,6,10>}
 cylinder {
  <-44,20,1>,
  <-30,37,0>,
  .2
  pigment {color Black}
  }
 pigment {color Flesh}
 }

//back sail
difference {
 object {FrontSail rotate z*-45}
 cylinder {
 <0,-1.0001,-4>,
 <0,-7.0001,-4>,
 .06667
 }
 rotate z*90 scale 2 translate <51,25,6>
 pigment {color Flesh}
}

cylinder {
 <0,0,0>,
 <22,0,0>,
 .3
 pigment {WoodTex}
 rotate z*50
 translate <45,13,0>
 }
difference {
 difference { 
  object {FrontSail rotate z*-45}
  cylinder {
   <0,-1.0001,-4>,
   <0,-7.0001,-4>,
   .06667
   }
  scale 3.5 rotate <-2,0,55>
  }
 box {
  <-19,-10,-15>,
  <-9,8,8>
  }
  translate <55,7,12>
  pigment {color Flesh}
 }
 

}
//object {Ship}
