//=========================================
// Easy chair for Pov-ray 3.1 & higher
// (c) 1999 Gilles Tran tran@inapg.inra.fr
//-----------------------------------------
// Easy chair that can be more or less folded
// A striped texture is assigned to the fabric
// Used in "Vacancy".
//-----------------------------------------
#macro MakeEasyChair(angleChair,colChair,colFabric_1,colFabric_2,colFabric_3)
/*                                                                           
#declare angleChair=10;                 // folding angle (between 10 and 13)
#declare colChair=rgb<1,0.8,0.6>*0.8;   // Wood frame color
#declare colFabric_1=Red;               // fabric stripes colors
#declare colFabric_2=Red;
#declare colFabric_3=Red;
*/
//-----------------------------------------
// textures
//-----------------------------------------
// Striped fabric texture
//-----------------------------------------
#local txtFabric=texture{
        pigment{
                gradient x
                color_map{
                        [0.0 color colFabric_1]
                        [0.2 color colFabric_1]
                        [0.2 color Black]
                        [0.4 color Black]
                        [0.4 color colFabric_2]
                        [0.6 color colFabric_2]
                        [0.6 color colFabric_3]
                        [0.8 color colFabric_3]
                        [0.8 color colFabric_1]
                        [1 color colFabric_1]
                }
        }
        finish{ambient 0.1 specular 0.01 roughness 0.1}
}     
//-----------------------------------------
// wood texture
//-----------------------------------------
#local txtChair=texture{
         pigment{
                 wood
                 turbulence 0.2
                 color_map{
                 [0 color colChair]
                 [0.5 color colChair*0.8]
                 [1 color colChair*1.1]
                 }
         }
         finish{crand 0.1 ambient 0.1 specular 0.01 roughness 0.1}
         rotate 45
}
//-----------------------------------------
// chair frame parameters
//-----------------------------------------
#local lMontant1=15;    // rod length 1
#local lMontant2=14;    // rod length 2
#local lMontant3=6;     // connecting rod length 3
#local rMontant=0.2;    // rod radius
#local eMontant=0.1;    // connecting rod radius
#local xChair=5;        // chair width
#local lM1=0.7;         // crossing position for rod 1
#local lM2=0.7;         // crossing position for rod 2
#local lM3=0.7;         // crossing position for rod 2 & 3
#local rtM1=angleChair; // angle
#local rtM2=degrees(asin(lM1*sin(radians(rtM1))/(1-lM2)));
#local rtM3=degrees(acos(lM2*lMontant2*lM3*sin(radians(rtM1+rtM2))/lMontant3)) +90 - rtM1 -rtM2;
#local yChair=sin(radians(rtM1))*lM1*lMontant1; // Chair height
#local yPend=-yChair*0.6;                       // the fabric sags a little
#local Montant1=union{
         cylinder{z*lMontant1*lM1,-z*lMontant1*(1-lM1),rMontant}
         sphere{z*lMontant1*lM1,rMontant}
         sphere{z*lMontant1*(lM1-1),rMontant}
         rotate x*rtM1
}
#local Montant2=union{
         cylinder{z*lMontant2*lM2,-z*lMontant2*(1-lM2),rMontant}
         sphere{z*lMontant2*lM2,rMontant}
         sphere{z*lMontant2*(lM2-1),rMontant}
         rotate -x*rtM2
}
#local Transverse11 = cylinder{-x*xChair*0.5,x*xChair*0.5,rMontant*0.8 translate z*lM1*lMontant1*0.95 rotate x*rtM1}
#local Transverse12 = cylinder{-x*xChair*0.5,x*xChair*0.5,rMontant*0.8 translate -z*(1-lM1)*lMontant1*0.95 rotate x*rtM1}
#local Transverse21 = cylinder{-x*(xChair*0.5+2*rMontant+2*eMontant),x*(xChair*0.5+2*rMontant+2*eMontant),rMontant*0.8 translate z*lM2*lMontant2*0.95 rotate -x*rtM2}
#local Transverse22 = cylinder{-x*(xChair*0.5+2*rMontant+2*eMontant),x*(xChair*0.5+2*rMontant+2*eMontant),rMontant*0.8 translate -z*(1-lM2)*lMontant2*0.95 rotate -x*rtM2}
#local Montant3=union{
         cylinder{0,-z*lMontant3,rMontant}
         sphere{0,rMontant}
         sphere{-z*lMontant3,rMontant}
         rotate x*-rtM3
         translate z*lM2*lMontant2*lM3
         rotate x*-rtM2
         scale <eMontant/rMontant,1,1>
}                                                                          
//-----------------------------------------
// fabric bezier patch
//-----------------------------------------
#local TL11=vrotate(<-xChair/2,0,lM2*lMontant2*0.95>,-rtM2*x);
#local TL12=TL11 + x*xChair/3;
#local TL13=TL11 + x*2*xChair/3;
#local TL14=TL11 + x*xChair;
#local TL21=vrotate(<-xChair/2,yPend*1.5,lM2*lMontant2*0.2>,-rtM2*x);
#local TL22=TL21 + x*xChair/3;
#local TL23=TL21 + x*2*xChair/3;
#local TL24=TL21 + x*xChair;
#local TL31=vrotate(<-xChair/2,yPend*0.3,(lM1-1)*lMontant1*0.5>,rtM1*x);
#local TL32=TL31 + x*xChair/3;
#local TL33=TL31 + x*2*xChair/3;
#local TL34=TL31 + x*xChair;
#local TL41=vrotate(<-xChair/2,0,(lM1-1)*lMontant1*0.95>,rtM1*x);
#local TL42=TL41 + x*xChair/3;
#local TL43=TL41 + x*2*xChair/3;
#local TL44=TL41 + x*xChair;

#local Fabric=union{
        cylinder{TL11,TL14,rMontant*1.01}
        cylinder{TL41,TL44,rMontant*1.01}
        bicubic_patch{
                type 1    flatness 0.1   u_steps 3   v_steps 3
                TL11, TL12, TL13, TL14,TL21, TL22, TL23, TL24, TL31, TL32, TL33, TL34, TL41, TL42, TL43, TL44
        }
        texture{txtFabric scale xChair/2 translate -x*xChair}
        scale <(xChair-rMontant*1.1)/xChair,1,1>
}

//-----------------------------------------
// chair building
//-----------------------------------------
union{
        object{Fabric}
        object{Transverse11}
        object{Transverse12}
        object{Transverse21}
        object{Transverse22}
        union{
                object{Montant1}
                object{Montant2 translate -x*2*(rMontant+eMontant)}
                object{Montant3 translate -x*(rMontant+eMontant)}
                translate -x*xChair/2
        }
        union{
                object{Montant1}
                object{Montant2 translate x*2*(rMontant+eMontant)}
                object{Montant3 translate x*(rMontant+eMontant)}
                translate x*xChair/2
        }
        texture{txtChair}
        translate y*(yChair+rMontant)
}
#end


//=========================================
// Examples
//-----------------------------------------
/*
#include "colors.inc"
#declare PdV=<2, 10 , -64>;
#declare PdA=<2,3.7,0>;
camera {location  PdV  direction 7*z up y right 4/3 look_at PdA}
light_source { PdV color White*0.3}
light_source{<-450,1000,-1000> color White*2}

#declare colChair=rgb<1,0.8,0.6>*0.8;      

object{MakeEasyChair(10,colChair,Yellow,SkyBlue,Red) rotate y*60}

plane{y,0 texture{pigment{Yellow}}}
plane{z,30 texture{pigment{White*2}}}
*/
