#version unofficial MegaPov 0.5;
#include "mwindow.pov"

/*******************************************************************

Top part

*******************************************************************/

#macro randsph()
  #local rad = .7+.4*rand(SArbre);
  #local a = (-.2+.7*rand(SArbre)) *pi;
  #local b = rand(SArbre) *2*pi;
  rad*<cos(b)*cos(a), sin(a), sin(b)*cos(a)>
#end

#declare SArbre = seed(0);
#macro MurArbre(U)
  union{
    sphere {
      0, 1 scale <.3, .4, .3>
      pigment {
	bozo color_map{
	  [0 rgb<0, .8, 0>*.6]
	  [1 rgb<.4, 1.2, .4>*.6]
	}
	scale .05
	translate 100*rand(SArbre)
      }
      translate .2*y
    }
    #local i=0;
    #while (i<500)
      triangle {
	#local U1 = randsph();
	#local U2 = vrotate(U1*1.1, 20*y);
	#local U3 = vrotate(U1*0.9, 20*z);
	U1, U2, U3
	//randsph(), randsph(), randsph()
	texture{
	  //pigment {rgb<.4*rand(SArbre), .8+.4*rand(SArbre), .4*rand(SArbre)>}
	  pigment {rgb<.2+.4*rand(SArbre), .8+.4*rand(SArbre), .2+.4*rand(SArbre)>}
	  normal {dents 1 bump_size 5 scale .2 translate 10*rand(SArbre)}
	  finish {
	    phong .1
	    phong_size .1
	    //metallic
	  }
	}
      }
      #local i = i +1;
    #end
    scale 250+80*<rand(SArbre), rand(SArbre), rand(SArbre)>
    translate U
    no_shadow
  }
#end

#macro UnePersonneMur()
  #local pig = int(rand(SGM)*5);
  #switch(pig)
    #case(0)#local coul=colour Red; #break
    #case(1)#local coul=colour Yellow; #break
    #case(2)#local coul=colour Green; #break
    #case(3)#local coul=colour White; #break
    #case(4)#local coul=colour Orange; #break
  #end
  #declare BM_Torso_Tex=texture{
    pigment{coul}
    finish{ambient .3}
  }
  // Simplify model to save time & memory
  #declare BM_PoseNo=-1;
  #declare BM_HairStyle=-1;
  #declare BM_Hair_On = 0;
  #declare BM_R_Foot = 0;
  #declare BM_L_Foot = 0;
  #declare BM_R_Hand = 0;
  #declare BM_L_Hand = 0;
  #declare BM_Head_Mass = -1;
  #declare BM_R_Upperarm_Mass = 0;
  #declare BM_L_Upperarm_Mass = 0;
  #declare BM_R_Lowerarm_Mass = 0;
  #declare BM_L_Lowerarm_Mass = 0;
  #declare BM_R_Thigh_Mass = 0;
  #declare BM_L_Thigh_Mass = 0;
  #declare BM_R_Calf_Mass = 0;
  #declare BM_L_Calf_Mass = 0;
  #declare BM_Flex = 0;
  #if(rand(SGM)>.5)
    Blob_Man(Female,160+30*rand(SGM))
  #else
    Blob_Man(Female,150+20*rand(SGM))
  #end
  
#end

#declare SGM = seed(0);
#macro GensMur()
  #local a=270;
  #local S = seed(0);
  #while (a < 300)
    #local U = <1, 0, 0>;
    #local U = vrotate(U, a*y);
    #local U = U*<12050+100*rand(SGM), 1, 11050+100*rand(SGM)>;
    #local U = U + <-5000, 2600, -10000>;
    UnePersonneMur()
    object {BlobMan 
      transform BMO_Foot_R
      rotate (a+90-30+60*rand(S))*y
      translate U
    }
    #local a = a+.07+1.6*pow(rand(S), 2);
  #end
#end


/*******************************************************************

Life guards etc...

*******************************************************************/




#macro LifeGuards()
  box{ // House
    <-100, 0, -350>, <500, 300, 350>
    pigment {White}
    normal {
      crackle scallop_wave
      scale <2, 10, 2>*5
      bump_size .3}
    finish {
      phong .8 phong_size 3
      brilliance 1
    }
  }
  union{ // Windows
    box{<-102, 100, -260>, <-50, 170, -340>}
    cylinder {<-102, 130, -90>, <-50, 130, -90>, 30}
    box{<-102, 100, -120>, <-50, 170, -40>}
    //cylinder {<-102, 130, 80>, <-50, 130, 80>, 30}
    cylinder {<-102, 130, 170>, <-50, 130, 170>, 30}
    cylinder {<-102, 130, 260>, <-50, 130, 260>, 30}
      pigment {Black}
      normal{bumps bump_size 1 translate 100 scale 10}
      finish {phong 1 phong_size 10}
    }
  union{ // Red Cross
    box{<-102, -50, -20>, <-50, 50, 20>}
    box{<-102, -20, -50>, <-50, 20, 50>}
    translate <0, 130, 60>
    pigment {Red}
    normal {
      crackle scallop_wave
      scale <2, 10, 2>*5
      bump_size .3}
    finish {
      phong .9 phong_size 1
      reflection 0.03
      brilliance 1
      metallic
    }
  }
  box{ // Door
    <-102, 5, -230>, <-50, 200, -150>
    pigment {Black}
  }
  union{ // Crane
    cylinder {<-100, 300, -340>, <-150, 330, -310>, 10}
    cylinder {<-100, 200, -340>, <-150, 330, -310>, 10}
    cylinder {<-100, 300, -40>, <-150, 330, -70>, 10}
    cylinder {<-100, 200, -40>, <-150, 330, -70>, 10}
    pigment {Red}
    normal {
      crackle scallop_wave
      scale <2, 10, 2>
      bump_size .3}
    finish {
      phong .9 phong_size 1
      reflection 0.03
      brilliance 1
      metallic
    }
  }
  
  #local YNacelle = -900;
  union{
    box {
      <-110, 0, -310>, <-190, 100, -70>
      pigment {White}
      normal {
	crackle scallop_wave
	scale <2, 10, 2>*5
	bump_size .3}
      finish {
	phong .9 phong_size 1
	reflection 0.03
	brilliance 1
      }
    }
    union{
      cylinder{<-110, 100, -70>, <-150, 250, -70>, 10}
      cylinder{<-190, 100, -70>, <-150, 250, -70>, 10}
      cylinder{<-110, 100, -310>, <-150, 250, -310>, 10}
      cylinder{<-190, 100, -310>, <-150, 250, -310>, 10}
      cylinder{<-150, 250, -70>, <-150, 250, -310>, 10}
      pigment {Red*.8}
      normal {
	crackle scallop_wave
	scale <2, 10, 2>*5
	bump_size .3}
      finish {
	phong .7 phong_size 1
	reflection 0.03
	brilliance 1
	metallic
      }
    }
    #declare BM_Torso_Tex=texture{
      pigment{Pink}
      finish{ambient .3}
    }
    Blob_Man(Female,170)
    object {BlobMan 
      transform BMO_Foot_R
      rotate 90*y
      translate <-150, 5, -190>
    }
    #declare BM_Torso_Tex=texture{
      pigment{Blue}
      finish{ambient .3}
    }
    Blob_Man(Female,190)
    object {BlobMan 
      transform BMO_Foot_R
      rotate 90*y
      translate <-150, 5, -130>
    }
    #declare BM_Torso_Tex=texture{
      pigment{Red}
      finish{ambient .3}
    }
    Blob_Man(Female,150)
    object {BlobMan 
      transform BMO_Foot_R
      rotate 90*y
      translate <-150, 5, -250>
    }
    translate YNacelle*y
  }
  
  // Cables
  
  union{
    cylinder{<-150, 250+YNacelle, -70>, <-150, 330, -70>, 7}
    cylinder{<-150, 250+YNacelle, -310>, <-150, 330, -310>, 7}
    pigment {White}
    finish {diffuse -10000 ambient -10000}
  }
#end


/*******************************************************************

Hotel

*******************************************************************/

#declare HSeed=seed(1);

#macro HFenetre(T)
#if (T = 2)
  object{WCase_2_wl}
  object{Balcony_5_wl}
#end
#if (T = 4)
  object{WCase_4_nl}
#end
#if (T = 6)
  object{WCase_6_wl}
  object{Balcony_5_wl}
#end
#if (rand(HSeed) < .5) // Volets ouverts
  object{Window_3_c translate z*2}
  #local TH0=70+20*rand(HSeed);
  #local TH1 = TH0 + 15*(1-2*rand(HSeed));
  #local TH2 = TH0 + 15*(1-2*rand(HSeed));
  object{mShutter(4,xL,yL,0.2,0.3,20,5,TH1,TH2,0.7,0.1,HSeed,0.5,txtV1)}
  #if(rand(HSeed) < .5) // Somebody on the left
    UnePersonneMur()
    object {BlobMan 
      transform BMO_Foot_R
      translate <-50+30*rand(HSeed), 5, -40+20*rand(HSeed)>
      no_shadow
    }
  #end
  #if(rand(HSeed) < .5) // Somebody on the right
    UnePersonneMur()
    object {BlobMan 
      transform BMO_Foot_R
      rotate <2*rand(HSeed), -50+100*rand(HSeed), 2*rand(HSeed)>
      translate <20+30*rand(HSeed), 5, -40+20*rand(HSeed)>
      no_shadow
    }
  #end
  difference{
    box {<-110, 0, 10>, <110, 220, 400>}
    box {<-xL+1, 1, 0>, <xL-1, yL-1, 350>}
    pigment {
      rgb <.7+.5*rand(HSeed), .7+.5*rand(HSeed), .7+.5*rand(HSeed)>
    }
    finish{ambient .2}
  }
#else
  object{mShutter(4,xL,yL,0.2,0.3,20,5,0,0,0.7,0.1,HSeed,0.5,txtV1)}
#end
#end

#macro Hotel()
  #local TMurHotel1=texture{
    pigment{
      granite color_map{
	[0.0 White]
	[0.5 White * .6]
	[1.0 rgb <1, .9, .8>]
      }
      
      scale 300
    }
    normal{granite scale 10}
    finish{ambient 0.4 phong 0.4 phong_size 1}
  }
  #local TMurHotel=texture{
    pigment {
      gradient y turbulence 0.2 color_map{
	[0 rgb <.9, 1, .95> * .9]
	[1 rgb <1, 1, 1> * 1.2]
      }
      scale <1, 3000, 1>
    }
    normal {
      agate
      turbulence 0.3
      bump_size 0.3
      scallop_wave
      scale 10
    }
    finish {
      ambient .3
      phong .3
      phong_size 3
    }
    translate -1000*y
  }
  #declare xL=60;
  #declare yL=200;
  #declare txtFen1=texture{pigment{ForestGreen}}         
  #declare txtFen2=texture{pigment{White}}
  #declare txtVit1=texture{pigment{Clear}}
  #declare txtBalcon1=texture{pigment{Green*0.3}}
  #declare txtBalcon2=texture{TMurHotel}
  #declare txtTF=texture{pigment{rgb<1,0.9,0.8>*1.3}}
  #declare txtToit=texture{pigment{rgb<0.8,0.7,0.9>*0.3}}
  #declare txtV1=texture{pigment{SkyBlue*1.5}}
  #declare txtV2=texture{pigment{rgb<1,0.8,0.5>}}
  #declare Window_3_c=object{mWindow(2,xL,yL,0.2,0.3,0.1,0.1,1,3,0,0,0.5,0.1,txtFen1,txtFen2,txtVit1)}
  #declare Balcony_5_wl=object{mBalcony(5,xL+1,70,80 , 7, 6,0,7,txtBalcon2)}
  #declare WCase_2_wl=object{mWindowCase(2,xL,yL,5,1,0.1,  0,1,  2,5,70,txtTF,txtToit)}
  #declare WCase_4_nl=object{mWindowCase(4,xL,yL,5,1,0.1,0.6,0,  0,5,70,txtTF,txtToit)}
  #declare WCase_6_wl=object{mWindowCase(6,xL,yL, 5,1,0.1,0.2,2,0.1,5,70,txtTF,txtToit)}
  #declare Shutter_4_o=object{mShutter(4,xL,yL,0.2,0.3,20,5,75,56,0.7,0.1,HSeed,0.5,txtV1)}
  
  #local dZ = 3*xL;
  #local ZStart = -900;
  #local Zfin = 500;
  #local n = int((-ZStart+Zfin)/dZ);
  #local Z0 = ZStart+((-ZStart+Zfin)/n)/2+xL/2;
  #local Z = Z0;
  #while (Z <= Zfin+ZStart-Z0)
    union{HFenetre(2) rotate 90*y translate <-505, 50, Z>}
    union{HFenetre(2) rotate 90*y translate <-505, 350, Z>}
    union{HFenetre(6) rotate 90*y translate <-505, 650, Z>}
    #local Z = Z+dZ;
  #end
  difference{
    box{<-500, 0, ZStart>, <1000, 1000, Zfin> texture{TMurHotel}}
    #local Z = Z0;
    #while (Z <= Zfin+ZStart-Z0)
      box {<-600, 0, -xL>, <0, 200, xL> translate  <0, 50, Z>}
      box {<-600, 0, -xL>, <0, 200, xL> translate  <0, 350, Z>}
      box {<-600, 0, -xL>, <0, 200, xL> translate  <0, 650, Z>}
      #local Z = Z+dZ;
    #end
  }
  text {
    ttf "/usr/ttfonts/winfonts/tt1028m_.ttf"
    " HOTEL  LE  GEOMETRE"
    0.1, 0
    pigment{SkyBlue*.5}
    scale <120, 130, 10>
    rotate 90*y
    translate <-501, 880, 200>
    //no_shadow
    bounded_by{box{<-510, 850, ZStart>, <-490, 1000, Zfin>}}
  }
  
  rotate 20*y
#end


/*******************************************************************

Lighthouse

*******************************************************************/

#macro Phare()//300-1000
  difference{
    union{
      sphere {300*y, 100}
      cylinder  {300*y, 1000*y, 100}
      cylinder  {350*y, 450*y, 200}
    }
    box {<-200, 750, -40>, <200, 850, 40>}
    box {<-200, 750, -40>, <200, 850, 40> rotate 90*y}
    pigment {White}
    normal {
      agate
      turbulence 0.3
      bump_size 0.3
      scallop_wave
      scale 10
    }
    finish {
      ambient .3
      phong .3
      phong_size 3
    }
  }
  difference{
    union{
      sphere {1000*y, 100}
      cylinder  {600*y, 700*y, 101}
      cylinder  {900*y, 1000*y, 101}
    }
    box {<-200, 750, -40>, <200, 850, 40>}
    box {<-200, 750, -40>, <200, 850, 40> rotate 90*y}
    pigment {rgb <.5, 1, .5>*.7}
    normal {
      agate
      turbulence 0.3
      bump_size 0.3
      scallop_wave
      scale 10
    }
    finish {
      ambient .3
      phong .3
      phong_size 3
    }
  }
#end

/*******************************************************************

Putting everything together

*******************************************************************/

#macro Mur(HAUT)
  #local lg_angle=278;
  #local TMur2=texture{
    pigment {
      gradient y turbulence 0.2 color_map{
	[0 rgbf <.9, 1, .95, .5> * .7]
	[1 rgbf <1, 1, 1, 1> * 1.2]
      }
      scale <100, 3500, 100> translate -500*y
    }
    /*normal {
      agate
      turbulence 0.3
      bump_size 0.3
      scallop_wave
      scale 100
    }
    finish {
      phong -1
      phong_size 3
    }*/
  }
  #local NMur11=normal {
    agate
    turbulence 0.3
    bump_size 1.3
    scallop_wave
    scale 100
    }
  #local NMur12=normal {
      cells
      turbulence 0
      bump_size 10.0
      scallop_wave
      scale <30, 200, 30>
    }

  #local TMur1=texture{
    pigment {
      cells turbulence 0 color_map{
      [0 White]
      [1 rgb <.98, 1, .95>]
      }
    scale <30, 200, 30>
    rotate 45*y
    translate 5200*y
    }
    normal {
      average normal_map{
	[1 NMur11]
	[2 NMur12]
      }
    }
    finish {
      phong -1
      phong_size 3
    }
  }
  difference {
    union {
      difference {
	box {<0, -1000, -12000>, <20000, 2500, 12000>}
	cylinder {-1100*y, 10000*y, 1 scale <12000, 1, 11000>}
      }
      cylinder {<0, -1000, 11000+300>, <0, 2500, 11000+300>, 300}
      sphere {0, 1 scale <300, 200, 300> translate <0, 2500, 11000+300>}
      intersection {
	box {<0, 2500, -12000>, <20000, 3100, 12000>}
	torus {
	  11200, 200
	  scale <12200/11200, 1, 11200/11200>
	  translate <0, 2500, 0>
	}
      }
    }
    box{
    <-1000, -1000, -380>, <200, 3000, 0>
      translate <11000+100, 0, 0>
      rotate lg_angle*y
      scale <12000/11000, 1, 1>
    }
    texture {TMur1}
    texture {TMur2}
    translate <-5000, 0, -10000>
  }
  
  // People and trees
  
  #if ((HAUT = 1) | (HAUT = -1))
    #local a=270;
    #local S = seed(0);
    #while (a < 300)
      #local U = <1, 0, 0>;
      #local U = vrotate(U, a*y);
      #local U = U*<12300, 1, 11300> + <-5000, 2950+100*rand(S), -10000>;
      MurArbre(U)
      #local a = a+1.7+.6*rand(S);
    #end
    GensMur()
  #end
  
  // Life guards
  
  #if ((HAUT = 1) | (HAUT = -2))
    union{
      LifeGuards()
      box{
	<-100, -4000, 35>, <200, 0, -5> translate 0*z
	pigment {
	  gradient z-y color_map{
	    [0.5 Yellow*2]
	    [0.5 Black]
	  }
	  scale 100
	}
      }
      box{
	<-100, -4000, -35>, <200, 0, 5> translate -380*z
	pigment {
	  gradient y+z color_map{
	    [0.5 Yellow*2]
	    [0.5 Black]
	  }
	  scale 100
	}
      }
      translate <11000+50, 2500, 0>
      rotate lg_angle*y
      scale <12000/11000, 1, 1>
      translate <-5000, 0, -10000>
    }
  #end
  
  // Hotel
  
  #if ((HAUT = 1) | (HAUT = -3))
    union{
      Hotel()
      translate <11000, 1000, 0>
      rotate 288*y
      scale <12000/11000, 1, 1>
      translate <-5000, 0, -10000>
    }
  #end
  
  // Lighthouse
  
  #if ((HAUT = 1) | (HAUT = -4))
    union{
      Phare()
      translate <11000, 1000, 0>
      rotate 269*y
      scale <12000/11000, 1, 1>
      translate <-5000, 0, -10000>
    }
  #end
#end
