// Copyright Grard Mansoif - Aot 2000
//
// As the map for the submarine are quite big, they are not provided here
// However, they were derived from this one :
// http://www.bulletproof-studios.com/ship1.jpg
// Also, the "Stamp" font used for the ship's name is not given. It was found on an old Corel Draw CD-ROM
// The map for the map is given (minemap.png)
// This image uses many megapov features including
// - media (scattering and absorption) with method 3
// - object pattern
// - focal_blur and soft_glow
// - cells pattern
// - isosurface
// - particle system (requires Megapov 0.5a Plus mode 0.2.5 from Chris Huff's site)
//   Get it here http://homepage.mac.com/chrishuff/povpatch.html
// 


#version unofficial Megapov 0.5;
global_settings{
//        ini_option "+F +w500 +h200"
        ini_option "+F +W1200 +H480 +AA0.3"
        post_process{
        focal_blur {0,300,2,1}
        soft_glow {0.7,5}
        }
}
#include "colors.inc"
// Camera          
#declare PdV=<-20, 30, -400>;
camera{
        location PdV
        direction z*2
        up y
        right 2.5*x
        look_at <-20, 20, 0>
}
// Lumire
#declare posSub=<19,5,0>;
#declare rotSub=-15;

#declare colMine=rgb<0.175,0.174,0.171>;
#declare colMine=rgb<0.25,0.224,0.211>*0.5;
#declare colWater1=rgb<49,40,85>/255;
#declare colWater2=rgb<64,77,147>/255;

#declare colWater2=rgb<64,100,147>*2/255;
#declare colWater3=rgb<103,199,215>/255;
#declare colWater4=rgb<103,199,255>/255;
#declare colWater4=colWater2;

#declare colSub=colWater2;
#declare Profond = colWater1*0.8;
#declare Moyen = colWater2;
#declare Surface = colWater3*1.1;
light_source {<-10, 1000, -10> color colWater4*10}
light_source {<-200, -1000, -300> color colWater4*2 shadowless media_interaction off}
light_source {PdV color Moyen shadowless media_interaction off}
#declare Bulles=sphere{0,0.001 pigment{White}}
// Particle system for the trail bubbles - not really necessary
#declare System = particle_system {
	wind < 0, 0, 0>
	gravity < 0,0.002, 0>
	iterations 200
	time 250
	jitter 0
	drag 0
	threshold 0.5
				
	particle_emitter {
		location <0, 0, 0>
		direction < 0,0, 1>
		radius 0.5
		angle 12
		lifespan 100
		rate 4
		type 1
		elasticity 0.9
	}
}
#declare numOfParts = get_particle(System);
#declare Pos = < 0, 0, 0>;
#declare Vel = < 0, 0, 0>;
#declare X=0;
#declare J=0;
#declare Bulles=union{
#while(J<numOfParts)
	#declare X = get_particle(System, J, Pos, Vel);
	sphere {Pos, 0.13}
	#declare J=J+1;
        #end
        texture{pigment{rgbf<1,1,1,0.8>*0.4} finish{ambient 0 diffuse 0.4 specular 1 roughness 0.01}}
        interior{ior 1.3}
        
}
// End of particle system for the trail bubbles

#declare pigSub1=pigment{
                cells
                color_map{
                        [0 color colSub*0.1]
                        [1 color colSub*2]
                }
                warp{repeat x*10 offset 3.1} warp{repeat y*5 offset 1.3} warp{repeat z*1.3 offset 2.1}
                }
#declare pigSub2=pigment{
                cells
                color_map{
                        [0 color colSub*0.1]
                        [1 color colSub*2]
                }
                warp{repeat x*10 offset 3.1}
                warp{repeat y*5 offset 1.3}
                warp{repeat z*1.3 offset 2.1}
                scale 2.3 translate <0.3,0.4,0.1>
        }
#declare txtPeau=texture{
        pigment{
                average
                pigment_map{
                        [1 pigSub1]
                        [1 pigSub2]
                }
        }                            
        finish{ambient 0 diffuse 0.5 specular 0.17   roughness 0.4}
        scale 5
}
#declare txtPeau2=texture{
        pigment{
                gradient y turbulence 0.01 omega 1.5 lambda 5 poly_wave 1.5 
                color_map{[0 rgbf<0,0,0,0.1>][0.1 rgbf<0,0,0,0.5>][0.2 Clear] [1 Clear]}
                }
        finish{ambient 0 diffuse 0.2}
        scale 70 translate y*15
}
#declare txtDeco=texture{
        pigment{
                agate 
                color_map{[0 colSub*0.5][0.5 colSub*0.5][0.6 colSub*0.2] [1 colSub*0.2]}
        }
        finish{ambient 0 diffuse 0.5 specular 0.17   roughness 0.4}
        scale 40
}
#declare txtMine=texture {
        pigment{color Surface*0.1}
        finish{ambient 0 diffuse 0.4 specular 0.03 roughness 0.2 reflection 0.05}
}
#declare txtFilMine=texture {
        pigment{color Surface*0.1}
        finish{ambient 0 diffuse 0.1 specular 0.02 roughness 0.2}
}

#declare Piquant = union{
        #declare rPiq1=0.08;
        #declare rPiq2=rPiq1*0.3;
        #declare yPiq=0.4;
        cone{0,rPiq1,y*yPiq,rPiq2}
        sphere{0,rPiq2 translate y*yPiq}
        sphere{0,rPiq1*1.5 scale <1,0.3,1>}
        #declare i=0;#while (i<360) sphere{0,0.015 scale <2,1,2> translate <rPiq1*2.8,-0.04,0> rotate y*i} #declare i=i+30;#end
        translate y
}                                 
#declare rd=seed(0);

#declare hfs=function{pigment{image_map{png "minemap" map_type 1 interpolate 2}}}
#declare r0=0.03;

#declare TeteMine =union {
        isosurface {
                function{x*x+y*y+z*z-1 
                +(1 - hfs(x,y,z))*r0
                +noise3d(x*10,y*10,z*10)*0.05}
                threshold 0
                contained_by{sphere{0,1}}
        }
      
        #declare i=0;
        #while (i<360)                              
                #declare j=0;
                #while (j<180)        
                        object{Piquant rotate z*(i+rand(rd)*2) rotate y*(j+rand(rd)*2)}
                        #declare j=j+45;
                #end
                #declare i=i+45;
        #end
                                
        object{Piquant rotate 90*y}
        object{Piquant rotate -90*y}
        rotate 360*rand(rd)        
        
        bounded_by{sphere{0,1+yPiq+rPiq2}}
}                                      

#declare rFil=0.03;
#declare yFil=100;
#declare f1=function{"helix1", <3,35,0.35*rFil,0.55*rFil,2,1,0>}
#declare FilMine=isosurface{
        function{f1(x,y,z)}
        contained_by {box {<-rFil,0,-rFil>,<rFil,yFil,rFil>}}
        max_gradient 1.5
        sign 1 threshold 0
        scale <1,-1,1>*3 translate -y
}                  


#declare CollierMine=lathe{
	cubic_spline
	15,
	<0.058,0.003>,<0.081,0.000>,<0.101,0.055>,<0.099,0.085>,<0.104,0.132>,<0.066,0.152>,
	<0.095,0.169>,<0.089,0.194>,<0.144,0.227>,<0.143,0.281>,<0.145,0.307>,<0.109,0.325>,
	<0.067,0.353>,<0.031,0.362>,<0.030,0.363>
	translate -y*0.363
}

#declare Mine=union{
        object{TeteMine}
        sphere{0,1 scale <0.4,0.14,0.4> translate -y*0.91}
        #declare i=0;#while (i<360) cylinder{0,-y*0.1,0.02 translate <0.35,-0.91,0> rotate y*i} #declare i=i+30;#end
        object{CollierMine scale <1.2,2,1.2> translate -y*0.92}
        object{CollierMine translate -y*2}
        object{FilMine}
        texture{txtMine}
} 



#declare sc=3;
#declare sx=6*sc;                                      
#declare syb=10*sc;                                      
#declare syh=2*sc;
#declare szv=20*sc;
#declare szr=100*sc;
#declare Part=sphere{0,1}
#declare Part1=blob{ // bas avant
        threshold 0.6
        sphere{0,1,1} 
//        cylinder{-x,0,1,1 scale <0.4,0.02,0.1> rotate x*-1 translate <0,-0.1,-0.4>} // aileron
        cylinder{-z*2,z,0.04,-1 translate <-0.2,-0.3,1> pigment{Black}}
        cylinder{-z*2,z,0.04,-1 translate <-0.17,-0.18,1> pigment{Black}}
        sphere{0,1,1 scale <0.1,0.45,1.05>} 
        sphere{0,1,1 scale <0.3,0.45,0.8>} 
}
#declare Part2=blob{ // haut avant
        threshold 0.6
        sphere{0,1,1} 
        sphere{0,1,1 scale <0.3,0.45,0.8>} 
        sphere{0,1,1 scale <0.2,1.2,1.05>} 
}        
#declare Part3=blob{ // bas arrire
        threshold 0.6
        sphere{0,1,1} 
        cylinder{-x,0,1,1 scale <0.5,0.03,0.02> translate <0,-0.05,0.45>}
        cylinder{-y,0,1,1 scale <0.03,0.2,0.02> translate <0,-0.05,0.45>}
}        
#declare Part4=blob{ // haut arrire
        threshold 0.6
        sphere{0,1,1} 
        cylinder{-y,y,2,2 scale <0.03,0.3,0.012> translate <0,0.5,0.45>}
        sphere{0,1,1 scale <0.2,1.2,0.4>} 
        
        cylinder{-x,0,1,1 scale <0.2,0.2,0.04> rotate x*-10 translate <0,1.5,0.2>}
        cylinder{0,y,0.2,2 scale <0.6,2.5,0.4>*0.7  translate <0,-0.05,0.16>}
        cylinder{0,y,0.2,2 scale <0.4,2.5,0.4>*0.7  translate <0,-0.05,0.165>}
        cylinder{0,y,0.2,2 scale <0.2,2.5,0.4>*0.7  translate <0,-0.05,0.17>}
}        
#declare Trou=box{<-6,0,0>,<1,0.05,0.5> translate y*0.1}
#declare SubTop=union{
       difference{
                object{Part2} // haut avant
                plane{y,0}
                plane{z,0 inverse}
                plane{x,0 inverse}
                scale <sx,syh,szv>
        }
        difference{   
                object{Part4} // haut arrire
                plane{y,0}
                plane{z,0}
                plane{x,0 inverse}
                scale <sx,syh,szr>
        }
}
#declare SubBottom=union{
         difference{
                object{Part1} // bas avant
                plane{y,0 inverse}
                plane{z,0 inverse}
                plane{x,0 inverse}
                union{
                        #declare i=0;
                        #declare rd=seed(1);
                        #while (i<15)
                                #declare yt1=1+rand(rd)*0.04;
                                #declare yt2=yt1+0.09+rand(rd)*0.013;
                                #declare yt3=yt2+0.09+rand(rd)*0.013;
                                object{Trou scale 1 translate <0,yt1,i+0.22>}
                                object{Trou scale 1 translate <0,yt2,i+0.11>}
                                object{Trou scale 1 translate <0,yt3,i>}
                                #declare i=i+1;
                        #end  
                        translate -y
                        scale <1,-syh/syb,-0.06>                
                }
                scale <sx,syb,szv>
        }
        difference{
                object{Part3} // bas arrire
                plane{y,0 inverse}
                plane{z,0}
                plane{x,0 inverse}
                scale <sx,syb,szr>
        }
}                  
#declare Balustrade=union{
        #declare rB1=0.02;
        #declare rB2=0.04;                
        #declare yB=1;
        #declare rB3=yB*6;                
        #declare rB4=3;                
        #declare zB=20;
        #declare zB2=8;      
        #declare i=0;
        #while (i<zB)
                cylinder{0,y*yB,rB1 translate z*i}
                #declare i=i+zB/12;
        #end                
        cylinder{0,z*zB,rB2 translate y*yB}
        cylinder{0,z*zB,rB2 translate y*yB*0.3}
        cylinder{0,z*zB,rB2 translate y*yB*0.6}
        union{
                difference{torus{rB3,rB2 rotate z*90} plane{y,0} plane{z,0 inverse} plane{z,0 rotate x*-45}}
                cylinder{0,-z*zB*0.1,rB2 translate y*rB3 rotate x*-45}
                translate y*(yB-rB3)
        }                                           
        union{
                difference{torus{rB4,rB2} plane{x,0 inverse} translate <0,yB,0>}
                difference{torus{rB4,rB1} plane{x,0 inverse} translate <0,yB*0.5,0>}
                #while (i<180)
                        cylinder{0,y*yB,rB1 translate -z*rB4 rotate y*i}
                        #declare i=i+180/14;
                #end                
                scale <0.4,1,1>
                translate z*(rB4+zB)
        }       
        union{
                difference{torus{rB3,rB2 rotate z*90} plane{y,0} plane{z,0 inverse} plane{z,0 rotate x*-65}}
                cylinder{0,-z*zB*0.1,rB2 translate y*rB3 rotate x*-65}
                translate y*(yB-rB3)
                scale <1,1,-1>
                translate z*(zB+rB4*2)
        }                                           
        
}               
#declare SubTopFin=union{
        object{SubTop}
        object{SubTop scale <-1,1,1>}
}               

#declare SubBottomFin=union{
        object{SubBottom}
        object{SubBottom scale <-1,1,1>}
} 
              

#declare Canon=union{
        superellipsoid{<0.3,0.3> translate z scale <0.8,1,4>}
        union{
                cone{0,0.4,z*12,0.3} 
                union{
                        cone{0,0.3,z*1.5,0.5}
                        difference{
                                sphere{0,0.5}
                                cylinder{-z,z,0.3}
                                translate z*1.5
                        }
                        translate z*12     
                }
                translate z*8
        }                
        translate -z*3
}

#declare Volant=blob{
        threshold 0.6
        sphere{0,1.3,1 scale <1,1.2,1>}
        cylinder{0,-y*3,0.8,1}
        #declare Teta=0;
        #while (Teta<360)
                cylinder{0,x*3.4,0.4,1  rotate y*Teta}
                cylinder{0,y,0.4,1  translate x*3 rotate y*Teta}
                sphere{0,0.6,1 translate x*3 rotate y*Teta}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+6)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+12)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+18)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+24)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+30)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+36)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+42)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+48)}
                sphere{0,0.4,1 translate x*3 rotate y*(Teta+54)}
                sphere{0,0.5,1 translate x*3 rotate y*(Teta+60)}
                sphere{0,0.5,1 translate x*3 rotate y*(Teta+66)}
                #declare Teta=Teta+72;
        #end
}
#declare Gun1=union{
             object{Canon}
             object{Volant rotate y*10 scale 0.7 rotate z*90 translate -x*1.5}
             
}       
#declare Oeil=union{
        torus{4.5,0.5}
        difference{
                sphere{0,4.3}
                box{-5,5 scale <1,1,0.05>}
                box{-5,5 scale <1,1,0.05> translate z}
                box{-5,5 scale <1,1,0.05> translate z*2}
                box{-5,5 scale <1,1,0.05> translate z*3}
                box{-5,5 scale <1,1,0.05> translate z*4}
                box{-5,5 scale <1,1,0.05> translate -z}
                box{-5,5 scale <1,1,0.05> translate -z*2}
                box{-5,5 scale <1,1,0.05> translate -z*3}
                box{-5,5 scale <1,1,0.05> translate -z*4}
                scale <1,0.7,1>
        }
}        
#declare Anneau1=union{
        cylinder{-0.2*x,0.2*x,1.2}
        torus{1.1,0.1 rotate z*90 scale <2,1,1> translate -x*0.2}
        torus{1.1,0.1 rotate z*90 scale <2,1,1> translate x*0.2}
}
#declare Coude1=intersection{torus{2,1} plane{z,0 inverse} plane{x,0 inverse} }

#declare ElTuyau6i=union{
        cylinder{0,8*x,1}
        object{Coude1 translate <8,0,-2>}
        object{Coude1 rotate y*180 translate <12,0,-2>}
        object{Coude1 rotate y*90 translate <12,0,-2>}
        cylinder{0,z*4,1 translate <14,0,-2>}
        object{Coude1 rotate -y*90 translate <16,0,2>}
        object{Coude1 translate <16,0,2>}
        object{Coude1 rotate y*180 translate <20,0,2>}
        object{Coude1 translate <20,0,-2>}
        object{Coude1 rotate y*180 translate <24,0,-2>}
        object{Coude1 rotate y*90 translate <26,0,-2>}
        object{Coude1 rotate -y*90 translate <30,0,-2>}
        cylinder{0,2*x,1 translate x*30}
        
        object{Anneau1}
        object{Anneau1 translate x*8}
        object{Anneau1 rotate y*90 translate <10,0,-2>}
        object{Anneau1 rotate y*90 translate <14,0,-2>}
        object{Anneau1 rotate y*90 translate <14,0,2>}
        object{Anneau1 rotate y*90 translate <18,0,2>}
        object{Anneau1 translate x*20}
        object{Anneau1 rotate y*90 translate <22,0,-2>}
        object{Anneau1 scale <3,1,1> translate <25,0,-4>}
        object{Anneau1 rotate y*90 translate <28,0,-2>}
        object{Anneau1 translate x*30}
        object{Anneau1 translate x*32}
        
}
#declare Truc=union{
        torus{1.5,0.3 rotate z*90 translate -x}
        cylinder{-x,x,1.5}
        superellipsoid{<0.2,0.2> scale <1.5,2,2.5> translate x*2.5}
        object{Oeil scale 1.5/7 rotate -x*90 translate <2.5,0,-2.5>}
        object{Oeil scale 1.5/7 rotate -x*90 translate <2.5,0,-2.5> scale <1,1,-1>}
        sphere{0,1.5 scale <0.5,1,1> translate x*4}
        sphere{0,1.5 scale <0.5,1,1> translate x*16}
        cylinder{x*4,x*16,1.2}
        torus{1.9,0.1 rotate z*90 translate x*16.5}
        cylinder{x*16.5,x*17.5,2}
        torus{1.9,0.1 rotate z*90 translate x*17.5}
        cylinder{x*17.5,x*23,1.5}
        union{
              torus{0.5,0.1}
              intersection{torus{2.5,0.5 rotate x*90} plane{y,0 inverse} plane{x,0} translate x*2.5}
              torus{0.5,0.1 translate -x*2.5 rotate z*-30 translate x*2.5 }
              torus{0.5,0.1 translate -x*2.5 rotate z*-60 translate x*2.5 }
              torus{0.5,0.1 translate -x*2.5 rotate z*-90 translate x*2.5 }
              union{
                    cylinder{0,9*x,0.5}
                    cylinder{2*x,5*x,0.7}
                    torus{0.5,0.2 rotate z*90 translate x*2}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*2.3}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*2.6}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*2.9}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.2}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.5}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.8}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.1}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.4}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.7}
                    torus{0.5,0.2 rotate z*90 translate x*5}
                    torus{0.5,0.3 rotate z*90 translate x*8}
                    cone{0,0.7,x,0.9 translate x*8}
                    torus{0.9,0.2 rotate z*90 translate x*9}
                    translate <2.5,2.5,0>
                    }
               translate <2.5,2,1.7>
        }
        union{
              torus{0.5,0.1}
              intersection{torus{2.5,0.5 rotate x*90} plane{y,0 inverse} plane{x,0} translate x*2.5}
              torus{0.5,0.1 translate -x*2.5 rotate z*-30 translate x*2.5 }
              torus{0.5,0.1 translate -x*2.5 rotate z*-60 translate x*2.5 }
              torus{0.5,0.1 translate -x*2.5 rotate z*-90 translate x*2.5 }
              union{
                    cylinder{0,9*x,0.5}
                    cylinder{3*x,6*x,0.7}
                    torus{0.5,0.2 rotate z*90 translate x*3}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.3}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.6}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.9}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.2}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.5}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.8}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*5.1}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*5.4}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*5.7}
                    torus{0.5,0.2 rotate z*90 translate x*6}
                    torus{0.5,0.3 rotate z*90 translate x*8}
                    cone{0,0.7,x,0.9 translate x*8}
                    torus{0.9,0.2 rotate z*90 translate x*9}
                    translate <2.5,2.5,0>
                    }
               translate <2.5,2,-1.7>
        }
        union{
                superellipsoid{<0.2,0.2> scale <1,1.3,2.6>}
                object{Oeil scale 1/7 rotate -x*90 translate z*-2.6}
                object{Oeil scale 1/7 rotate -x*90 translate z*2.6}
                object{Oeil scale 1/7 rotate y*90 translate <0,1.3,1.7>}
                object{Oeil scale 1/7 rotate y*90 translate <0,1.3,-1.7>}
                cylinder{x,x*3,1}
                torus{1,0.2 rotate z*90 translate x*3}
                intersection{torus{4.5,1 rotate x*90} plane{y,0 inverse} plane{x,0 inverse} scale <0.5,1,1> translate <3,-4.5,0>}
                torus{1,0.3 scale <0.5,4,1> translate <3+2.25,-3,0>}
                translate <15,4.5,0>
        }
        #declare Teta=0;
        #while (Teta<360)
        union{
                box{<0,-0.1,-0.05>,<12,0.1,0.05> translate <4,1.2,0>}
                cylinder{-x,2*x,0.1 translate y*1.5}
                sphere{0,0.2 translate <20,1.5,0>}
                sphere{0,0.1 translate <16.8,2,0>}
                sphere{0,0.1 translate <17.2,2,0> rotate x*10}
                cylinder{x*20,x*23,0.18 translate y*1.5}
                rotate x*Teta
        }
        #declare Teta=Teta+20;
        #end
        
        translate x
}
#declare PiedGun=union{
        superellipsoid{<0.6,0.6> translate y scale <0.3,3,1> translate -z*2}
        union{
                union{
                        superellipsoid{<0.7,0.7> translate y scale <1.5,3.8,1>}
                        #declare i=0;
                        #while (i<6)          
                                sphere{0,0.2 translate <-1,i+0.5,0.8>}
                                sphere{0,0.2 translate <0,i+0.1,1>}
                                sphere{0,0.2 translate <1,i+0.5,0.8>}
                                #declare i=i+0.7;
                        #end
                        rotate -x*10 translate z*0.6
                }
                
                cylinder{y*4,y*9,0.6} 
                sphere{0,1 scale <4,1,4>}
        }           
}        
#declare Guns=union{
        union{
                object{Truc rotate y*180 scale 0.5 rotate y*-90 rotate z*45 translate <0,4,5>}
                superellipsoid{<0.6,0.6> translate -z scale <0.6,1,3> translate -x*0.5}
                object{Gun1 translate -x*1.7}
                object{Gun1 translate -x*1.7 scale <-1,1,1>}
                rotate x*-20
                translate y*10
        }   
        object{PiedGun}
}             

#declare GunsArriere=union{
        union{
                object{Truc rotate y*180 scale 0.5 rotate y*-90 rotate z*45 translate <0,4,5>}
                superellipsoid{<0.6,0.6> translate -z scale <0.6,1,3> translate -x*0.5}
                object{Gun1 translate -x*1.7}
                object{Gun1 translate -x*1.7 scale <-1,1,1>}
                rotate x*-5
                translate y*10
        }   
        object{PiedGun}
}             

#macro mAlign(P1,P2)
#local yV1=vnormalize(P2-P1);
#local xV1=vnormalize(vcross(yV1,z));
#local zV1=vcross(xV1,yV1);
                matrix <xV1.x,xV1.y,xV1.z,yV1.x,yV1.y,yV1.z,zV1.x,zV1.y,zV1.z,P1.x,P1.y,P1.z>
#end            
#declare Snorkel1=union{
        cone{0,0.3,y*2,0.25}
        cone{y*2,0.25,y*3,0.1}          
        union{
                difference{sphere{0,1 scale<0.3,0.2,0.3>}plane{y,0 inverse}}
                difference{sphere{0,1 scale<0.3,0.6,0.3>}plane{y,0}}
                translate y*3
        }
        scale <0.8,1,0.8>
}
#declare Snorkel2=blob{
        threshold 0.6
        cylinder{-y,y*4,0.2,1}
        sphere{0,0.4,1 scale <1,1,2> translate y*3.5}
        sphere{0,0.3,1 scale <3,1,1> translate y*2.5}
        scale <0.8,1,0.8>
        }
#declare Snorkel3=union{
        blob{
                threshold 0.6
                cylinder{0,y*3.4,0.25,1 scale <1,1,3>}
                cylinder{0,y*5,0.03,1 translate <0,0,-0.5>}
                
        }                               
        union{                
                cylinder{0,y*4,0.03}
                sphere{0,0.1 translate y*4}
                translate  <-0.1,0,0.5>
        }
        scale <0.8,1,0.8>
}
#declare nDeco=13;
#declare Deco=array[nDeco]
#declare Deco[0]=union{
        cylinder{0,y*2,0.2}
        torus{1,0.2 rotate x*90 translate y*3}
        scale 0.5
}
#declare Deco[1]=cone{-y*0.5,0.2,y*4,0.1}
#declare Deco[2]=blob{
        threshold 0.6
        cylinder{-x,x,0.25,1 scale <1,1,2>}
        cylinder{0,-y,0.21,1 translate -x*0.8}
        cylinder{0,-y,0.21,1 translate x*0.8}
        translate y*0.7
        scale 1
}
#declare Deco[3]=object{Deco[2] rotate y*90}
#declare Deco[4]=torus{1,0.2 rotate z*90}
#declare Deco[5]=object{Deco[3] rotate y*90 scale <1,1.4,1>}
#declare Deco[6]=union{
        cylinder{0,y*0.4,0.1}
        sphere{0,1 scale <0.1,0.1,0.5> translate y*0.4}
}
#declare Deco[7]=difference{sphere{0,1} cylinder{-z,0,0.8} scale <2,0.5,2>translate -y*0.2}                
#declare Deco[8]=difference{sphere{0,1} cylinder{-z,0,0.9} scale <2,0.5,4>translate -y*0.2}                
#declare Deco[9]=cone{0,0.08,y*2,0.03 scale <1,1,2>}
#declare Deco[10]=sphere{0,1 scale <0.2,0.1,0.4>}
#declare Deco[11]=object{Deco[4] scale 1.2}
#declare Deco[12]=object{Deco[5] scale 1.3}
#declare Echelle=union{
        #declare i=0;
        #while (i<9)
                object{Deco[3] scale 0.8 rotate z*90 translate y*i*0.8}
                #declare i=i+1;
        #end
}
#declare Decos=union{                 
        #declare rd=seed(4);
        #declare debut=-40;
        #declare fin=40;
        #declare nstep=200;
        #declare i=0;          
        #declare k=0;
        #while (i<1)                                  
                #declare j=i;      
                #declare Start=<-rand(rd)*5*(mod(k,2)*2-1),1,(1-j)*debut+j*fin>;
                #declare Dir=y;
                #declare Norm1=<0,0,0>;
                #declare Inter=trace( SubTop, Start, Dir, Norm1);
                #if (vlength(Norm1)!=0)   
                        #if (vlength(vcross(Norm1,y))<0.9)
                        #declare n=int(rand(rd)*nDeco);
                        object{Deco[n]  scale 0.4 mAlign(Inter,Inter+Norm1)}
                #end
                #end
                #declare k=k+1;
                #declare i=i+1/nstep;
        #end
}                                         
                                   
#declare link_thick = 0.1; //  rad
#declare link_width = 0.3;  //  rad
#declare half_torus = intersection {torus { link_width,link_thick }  plane { x,0 }  translate x*(link_width-link_thick)}
#declare cyl_link = cylinder {  <link_width-link_thick,0,0>,<1-(link_width-link_thick),0,0>, link_thick}
#declare link = union {  object { half_torus }  object { half_torus scale <-1,1,1> translate x*1 }  object { cyl_link translate z*link_width }  object { cyl_link translate -z*link_width }}
#declare link_length = 0.2;
#declare link_rotation = 93.5;
#declare link_error = 0.01; // (fraction of link_length)
#declare chain_start=<-1,1,0>;
#declare chain_end=<1,1,0>;
#declare chain_scale=0.05;      // chain scale
#declare chain_debug=off;
#declare chain_type=1;
#include "mchain.inc"
                                   
#declare Chaine=union{                 
        #declare debut=-40;
        #declare fin=40;
        #declare nstep=7;
        #declare i=debut;          
        #declare yChaine=1.5;
        #while (i<fin)                                  
                #declare Start=<-0.1,1,i>;
                #declare Dir=y;
                #declare Norm1=<0,0,0>;
                #declare Inter=trace( SubTop, Start, Dir, Norm1);
                #if (vlength(Norm1)!=0)   
                        cylinder{0,y*yChaine,0.05 translate Inter}
                        #if (i>debut)
                                #declare chain_end=Inter+y*yChaine;
                                union{mChain(link,link_length,link_rotation,link_error,chain_start,chain_end,chain_scale,chain_debug,chain_type)}
                        
                        #end
                        #declare chain_start=Inter+y*yChaine;
                #end
                #declare i=i+nstep;
        #end
}                                         
                            
#declare trb=0.0001;
#declare pigLettre=pigment{bozo color_map{[0 White*1.3][1 White*0.5]}}
#declare txtLettre=texture{
        pigment {
                object {
                        text{ttf "c:\winnt\fonts\stampn.ttf" "PERSISTENCE" 10, 0.3*x}
                        pigment{color Clear}, pigment{pigLettre}
                } 
                turbulence 0.05
                rotate y*90
        scale 1.5 translate <-10,-2.5,-21>
        }
        
        finish{ambient 0 diffuse 0.2}
        
}
#declare txtSubTop=

                texture{pigment{image_map{png "shiphullm" map_type 2} turbulence trb rotate x*90 scale 50 translate z*10}
                normal{bump_map{png "shiphulln" map_type 2} turbulence trb bump_size 1.5 rotate x*90 scale 50 translate z*10}
                finish{ambient 0 diffuse 0.3 specular 0.05   roughness 0.1}
                }
                
                texture{txtPeau2}   
                
                   
#declare txtSubBottom=

        texture{pigment{image_map{png "shiphullm"} turbulence trb rotate y*90 scale 50 translate z*10}
                normal{bump_map{png "shiphulln"} turbulence trb bump_size 2 rotate y*90 scale 50 translate z*10}
                finish{ambient 0 diffuse 0.1 specular 0.17   roughness 0.4}
                }
                texture{txtLettre}
                texture{txtPeau2}
                
#declare SubFin=union{
        union{
                object{SubTop}                
                object{Decos}
                object{Chaine}
                object{Echelle translate <-1.5,4,40>}
                object{Echelle translate <1.5,4,40>}
                object{Guns rotate y*180 scale 0.3 translate <0,4,30>}
                object{GunsArriere scale 0.3 translate <0,4,70>}
                union{
                        object{Snorkel1 translate z*3}
                        object{Snorkel2}
                        object{Snorkel3 translate -z*2}
                        scale 2*<1,1.1,1>
                        translate <0,10,50>
                }
                object{Balustrade scale 2.5 translate <-4,2,5>}
                object{Balustrade scale 2.5 translate <-4,2,5> scale <-1,1,1>}
                union{
                        object{Balustrade scale 2 translate <-3,2,5>}
                        object{Balustrade scale 2 translate <-3,2,5> scale <-1,1,1>}
                        rotate y*180
                        translate z*100
                }
                texture{txtSubTop}
        }
        object{SubBottomFin texture{txtSubBottom}}                

}

union{
        union{
                object{SubFin}
                //object{SubFin translate z*(-2700*clock+1800)} // animate it !!!
                object{Bulles translate z*130}
                scale 3/4
        }
        
        sphere{0,1 scale 410 hollow
                texture{pigment{Clear}finish{ambient 0 diffuse 0}}
                interior{
                        media{
                                scattering {5,0.00034 eccentricity 0.7 extinction 0.8}
                                absorption <255-64,255-100,255-147>*0.001/255
                                method 3
                        }
                }
        }
        
        scale 4
        rotate y*rotSub  translate posSub
}

#declare rd=seed(0);
object{Mine rotate y*80 scale 14 translate <-110, 41, -205>}
object{Mine rotate -y*10 scale 8 translate <-75, 25, -165>}
object{Mine rotate y*125 scale 5 translate <105, -5, -155>}

union{
        #declare i=0;
        #while (i<20)

                object{Mine rotate y*125 scale 3 translate <50+rand(rd)*(200+i*10),(0.5-rand(rd))*60,i*30>}
                object{Mine rotate y*150 scale 3 translate <-50-rand(rd)*(200+i*10),(0.5-rand(rd))*60,i*30>}
                
                object{Mine rotate y*10 scale 3 translate <50+rand(rd)*(200+i*10),(0.5-rand(rd))*140+50+i*10,i*30>}
                object{Mine rotate y*37 scale 3 translate <-50-rand(rd)*(200+i*10),(0.5-rand(rd))*140+50+i*10,i*30>}
                #declare i=i+1;
        #end         
        rotate y*rotSub translate posSub
        translate -z*150
        translate x*30
} 
