// Persistence of Vision Ray Tracer Scene Description File
// File: midntsun.pov
// Vers: 3.1g
// Desc: Midnight Sun in Norway, July 1997
// Date: 29.8.00 
// Auth: Uwe Brunotte 

camera
{
  location  <0.0 , 7.0 ,-5.0>
  look_at   <0.0 , 4.0 , 20.0>
}

// Himmel, Sonnenuntergang mit ein paar Wolken
sky_sphere
	{
	pigment {
  	gradient y
    color_map {
    	[0.0  color rgb <0.9, 0.5, 0.4>]
		[0.05 color rgb <0.8, 0.4, 0.4>]
		[0.1 color rgb <0.6, 0.4, 0.5>]
		[0.2 color rgb <0.3, 0.2, 0.4>]
		[0.4 color rgb <0.1, 0.1, 0.3>]
		[1 color rgb <0.0, 0.0, 0.3>]
    			}
		scale <1.6,1.4,1>
		turbulence <0.1,0.3,0.1>*0.2
		translate -1
		rotate <-72,0,0>
			}
		}
#declare Wolken=	// Wolkenhimmel
sphere{0,2800
	pigment	{
    bozo
    turbulence 0.65
    octaves 6
    omega 0.65 // 0.7
    lambda 2            
    frequency 1
    color_map {
    	[0.0 0.001 color rgbt <0.7, 0.3, 0.33,0>
				color rgbt <0.8, 0.35, 0.35,0.2>]
		[0.01 0.02 color rgbt<0.8, 0.35, 0.35,0.2>
				color rgbt <0.9, 0.3, 0.35, 0.3>]
		[0.02 0.3 color rgbt <0.9, 0.3, 0.35, 0.3>
				color rgbt <0.8, 0.5, 0.5, 0.7>]
		[0.3 0.5 color rgbt <0.8, 0.5, 0.5, 0.7>
				 color rgbt <1, 0.7, 0.7, 1>]
		[0.5 1.0 color rgbt <1, 1, 1, 1>
                 color rgbt <1, 1, 1, 1>]   
  			    }
    	scale <0.7, 0.1, 0.2>*1500
		rotate 70*y               
		}                                 
	finish{ambient 0.1 diffuse 0.9}
	scale<2,1,2>
	hollow       
}

// Sonne am Horizont
light_source
{
<0, 260,2500>
color rgb <1,.6,.3>
}

// Der Lichtschein um die Sonne, mit Media statt Halo
#declare Halo =
interior{ 
//	ior 1.03
//	caustics 0.5
	media{
		emission rgb<0.8,0.8,1>
//		absorption rgb<0.5,0.5,0.5>
//		scattering {1, rgb<1,1,1> extinction 0.7}
		samples 1, 10
	density{
		spherical
		frequency 1
		turbulence 0.09
		color_map {
      	[0.0 color rgb 0]
      	[0.75 color rgb <0.01, 0.01, 0>]
      	[0.8 color rgb <0.6, 0.5, 0>]
      	[1.0 color rgb <1, 0.7, 0>]
				}
		scale 0.9
			}
		}
	}
sphere{0,1
	pigment{ color rgbf <1,1,1,1>}	//vllig durchsichtig
	interior{Halo}
	finish{ambient 0 diffuse 0}
	scale 100
	translate<0, 150,1600>
	hollow on
	}
object{Wolken} 

// Die Steintextur fr die Felsen
#declare Felsen =
texture {
     	pigment { color rgb <0.75,0.75,0.75> }
		normal {
		 	granite
		  	frequency 4.5
      		turbulence 1
			scale .6
				}
		finish	{
			ambient 0.25
			diffuse 0.75
				}
			}

// Eine zweite Lichtquelle als Hintergrundbeleuchtung (rtlich, ohne Schatten)
light_source { <5,10,-5> color rgb <0.3,0.1,0.1> shadowless}

height_field { png "midntsun.png"
 smooth
//	water_level 0.39
 	texture { Felsen}
	translate <-0.5,-0.39,-0.5>		// Mitte der xy-Achse auf <000>
	rotate 180*y					// Einmal drehen
	translate 0.7*z					// Wieder Stck nach vorne
	scale <33,2.5,22>
}

plane{ y , -50	// Der Meeresboden (Himmel scheint sonst durch)
	texture {Felsen}
	}

// Die Wasserflche
plane{ y , 0
	pigment { color rgbt <0,0.4,0.6, 0.6>}
	normal {
		average
		normal_map {
				[0.25 waves scale 0.7 translate <0,0,900> frequency 5]
				[0.25 waves scale 0.6 translate <500,0,740> frequency 3]
				[0.25 waves scale 0.7 translate <-120,0,870> frequency 4]
				[0.25 waves scale 0.9 translate <370,0,1150> frequency 1]
							}
					}
	finish{
		ambient 0.1
		diffuse 0.9
		reflection 0.4
	    specular 1.0
		roughness 0.02
		}
	interior{
		ior 1.33
		}
}

