// File: eve.pov

#version unofficial MegaPov 0.5   ;   

#include "colors.inc"

#include "eve.inc"

global_settings { assumed_gamma 1.0  }

// ----------------------------------------
camera {
    location < 0.031,  0.25,  0.955>
    look_at  < 0.031,  0.096,  0.082>
}

light_source { <0,30,0> color White spotlight radius .5 falloff 2 point_at <0,0,0>}
// ----------------------------------------
plane { y, -.35 pigment {color rgb <0.4,0.2,0.0>}}



object { poser_object rotate <0,80,0> }
       
height_field {tga "seabott2.tga" smooth on  scale <2,.4,2>  pigment {color rgb <0.7,0.5,0.3>} translate <-1,-.35,-1> }
                                         

  fog {
    distance 150
    color rgbf<0.3, 0.3, 0.8, 1>
  }

#declare i = 250 ;
#declare R2 = seed(12345);

#while (i>= 0)
  sphere {<rand (R2) ,rand (R2) *2 -1 ,rand(R2) > rand (R2) *.007 pigment {color rgbf<1,1,1,.999> } 
  interior {ior 1.33}
  translate x*-.5
  }
  
  #declare i = i -1 ;                                         
#end 
