#version unofficial MegaPov 0.5;

#include "colors.inc"	// Standard Color definitions
#include "txttree.inc " // Tree texture file

// Ocean
#declare WaterColA = pigment {
	granite
	color_map {
		[ 0.0 rgbft<0.1, 0.7, 0.3, 0.7, 0.3> ]
		[ 0.5 rgbft<0.1, 0.7, 0.5, 0.5, 0.5> ]
		[ 1.0 rgbft<0.1, 0.7, 0.3, 0.3, 0.7> ]
	}
}

#declare WaterColB = pigment {
	granite
	color_map {
		[ 0.0 color rgbft<0.1, 0.7, 0.3, 0.2, 0.8> ]
		[ 0.5 color rgbft<0.1, 0.7, 0.5, 0.1, 0.9> ]
		[ 1.0 color rgbft<0.1, 0.7, 0.3, 0.0, 1.0> ]
	}
}

#declare WaterColC = pigment { color rgbf 1 }

#macro Water(Type)
	#if (Type=0) // Normal
	texture {
		pigment { WaterColC }
		normal {
			granite
			normal_map {
				[ 0.00 ripples 3 ]
				[ 0.25 bumps ]
				[ 0.50 agate agate_turb 0.1 ]
				[ 0.75 waves ]
				[ 1.00 ripples 3 ]
			}
			scale 5
		}
		finish {
			ambient 0
			phong 0.6
			phong_size 70
			conserve_energy
			reflection_min .05
			reflection_max .80
			reflection_falloff 2.5
		}
	}
	interior { 
		ior 1.33
		media {
			absorption <1, .4, .6> * 0.06
			samples 2, 2
		}
		caustics 0.5
	}
	#else // Test
	texture { pigment { rgb <0.4, 1.0, 0.8> } }
	#end
#end

// Sky
#declare Sky1 =	pigment {
	bozo
	turbulence 1.3
	omega 0.75
	frequency 40
	octaves 8
	color_map {
		[ 0.02 color rgb <1.9, 1.9, 1.9> ]
		[ 0.17 color rgb <0.3, 1.0, 1.0> ]
		[ 0.83 color rgb <0.3, 1.0, 1.0> ]
		[ 0.98 color rgb <1.9, 1.9, 1.9> ]
	}
	translate <-15, .5, 3>
	scale < 175, 1.0, 0.6 >
}

#declare Sky2 = pigment {
	gradient y
	color_map {
		[ 0.25 rgb <0.1, 0.6, 0.6> ]
		[ 1.00 rgb <0.5, 1.0, 1.0> ]
	}
	scale 2
	translate -1
}



// Sea Floor
#macro BottomPat()
	granite
	triangle_wave
	scale 5
#end

#declare BottomCol = texture {
	pigment {
		BottomPat()
		color_map {
			[ 0.00 rgb <0.95, 0.85, 0.24> ]
			[ 0.10 rgb <0.50, 0.90, 0.20> ]
			[ 0.25 rgb <0.80, 0.40, 0.35> ]
			[ 0.45 rgb <0.75, 0.75, 0.40> ]
			[ 0.70 rgb <0.65, 0.80, 0.05> ]
			[ 0.99 rgb <1.00, 0.75, 0.50> ]
			[ 0.99 rgb <0.00, 0.00, 0.00> ]
		}
	}
	normal { BottomPat() }
}

// Coral
#declare BranchCol = texture {
	pigment {
		granite
		color_map {
			[ 0.00 color rgb < 0.50, 1.00, 1.00> ]
			[ 0.13 color rgb < 0.90, 0.90, 0.90> ]
			[ 0.26 color rgb < 0.60, 1.00, 0.85> ]
			[ 0.39 color rgb < 1.00, 1.00, 1.00> ]
			[ 0.52 color rgb < 1.00, 1.00, 1.00> ]
			[ 0.65 color rgb < 1.00, 0.90, 1.00> ]
			[ 0.78 color rgb < 0.95, 0.98, 1.00> ]
			[ 0.91 color rgb < 0.90, 0.90, 0.90> ]
			[ 1.00 color rgb < 0.50, 1.00, 1.00> ]
		}
	}
	normal { granite 0.3 scale 0.3 }
	finish { phong 0.2 phong_size 24 }
	scale 0.1
}

#declare txtTree = texture { BranchCol } // needed for macro-generated coral

#declare TubeCol = texture {
	pigment { rgbt 1.0 }
	normal { crackle 5.0 }
	finish { phong 0.3 phong_size 54 }
}

// Bird
#macro FeatherPat()
	crackle
	scallop_wave
	turbulence 0.3
	scale <.3, .1, 3>
#end

#declare Feathers = texture {
	pigment {
		FeatherPat()
		color_map {
			[ 0.00 rgb 0.3 ]
			[ 0.01 rgb 0.8 ]
			[ 0.02 rgb 1.0 ]
		}
	}
	normal { FeatherPat() }
	finish {
		ambient 0.3
		phong 0.3
		phong_size 45
		irid { 0.15 thickness 0.3 turbulence 0.6 }
	}
}

#declare BeakCol = texture {
	pigment {
		gradient x
		triangle_wave
		turbulence 0.4
		omega 0.6
		color_map {
			[ 0.00 rgb < 0.9, 0.7, 0.3 > ]
			[ 1.00 rgb < 1.0, 0.4, 0.1 > ]
		}
	}
	finish {
		specular 0.5
		roughness 0.001
		diffuse 0.5
		reflection 0.05
	}
}

#declare BirdEyeCol = texture {
	pigment { rgbf <0.1, 0.3, 1.0, 1.0> }
	normal { 
		waves 0.2
		turbulence 0.4
		omega 0.75
		scale 0.1
	}
	finish {
		phong 0.7
		phong_size 160
		reflection 0.3
	}
}

// Fish
#declare FishCol1 = texture {
	pigment {
		agate
		agate_turb 0.8
		color_map {
			[0.00 color rgb <0.30, 0.90, 0.30> ]
			[0.50 color rgb <0.30, 0.90, 0.90> ]
			[1.00 color rgb <0.30, 0.90, 0.30> ]
		}
		frequency 3
	}
	normal {
		agate
		agate_turb 0.8
		frequency 6
	}
	finish {
		ambient 0.3
		diffuse 0.7
		specular 0.7
		roughness 0.01
	}
}

#declare FishCol2 = texture {
	pigment {
		bozo
		turbulence 0.5
		omega 0.9
		lambda 1.5
		color_map {
			[0.00 color rgbt<0.00, 0.20, 0.10, 0.0> ]
			[0.20 color rgbt<0.00, 0.50, 0.25, 0.0> ]
			[0.30 color rgbt<0.20, 0.40, 0.30, 1.0> ]
			[0.70 color rgbt<0.20, 0.40, 0.30, 1.0> ]
			[0.80 color rgbt<0.00, 0.50, 0.25, 0.0> ]
			[1.00 color rgbt<0.00, 0.20, 0.10, 0.0> ]
		}
		frequency 3
	}
	normal {
		bozo
		turbulence 0.5
		omega 0.9
		lambda 1.5
		frequency 6
	}
	finish {
		ambient 0.2
		diffuse 0.7
		specular 0.9
		roughness 0.20
		metallic
	}
}

#declare TestCol = texture { pigment { rgb <0.0, 1.0, 0.5> } }

#declare FishCol = 
	texture { FishCol1 }
	texture { FishCol2 }

#declare EyeballCol = texture {
	pigment { rgbf <0.2, 0.8, 0.5, 1.0> }
	normal { 
		waves 0.5
		turbulence 0.8
		omega 0.8
		scale 0.1
	}
	finish {
		phong 0.5
		phong_size 60
		reflection 0.3
	}
}

// Turtle
#macro UpperPat()
	crackle
	turbulence 0.05
	scale 0.3
#end

#declare UpperCol = texture {
	pigment {
		UpperPat()
		color_map {
			[ 0.05 rgb <0.0, 0.4, 0.2> ]
			[ 0.05 rgb <0.1, 0.9, 0.5> ]
			[ 1.00 rgb <0.3, 0.5, 0.4> ]
		}
	}
	normal { UpperPat() }
	finish {
		phong 0.4
		phong_size 125
	}
}

#macro RibPat()
	bozo
	scallop_wave
	turbulence 0.7
	omega 0.6
	frequency 8
#end

#declare RibCol = texture {
	pigment {
		RibPat()
		color_map {
			[ 0.0 rgb <0.4, 1.0, 0.7> ]
			[ 0.5 rgb <0.2, 0.6, 0.4> ]
			[ 1.0 rgb <0.6, 1.0, 0.8> ]
		}
	}
	normal { RibPat() }
	finish {
		phong 0.6
		phong_size 75
		metallic 0.6
	}
}

#macro InnerPat ()
	agate
	agate_turb 0.8
	sine_wave
#end

#declare InnerCol = texture {
	pigment {
		InnerPat()
		color_map {
			[ 0.1 rgb <0.1, 0.6, 0.1> ]
			[ 0.9 rgb <0.0, 0.5, 0.5> ]
		}
	}
	normal { InnerPat() }
}

#macro EyePat()
	granite
	sine_wave
	scale .03
#end

#declare TurtleEyeCol = texture {
	pigment {
		EyePat()
		color_map {
			[ 0.0 rgbf <0.3, 1.0, 1.0, 1.0> ]
			[ 1.0 rgbf <0.5, 1.0, 0.5, 1.0> ]
		}
	}
	normal { EyePat() }
}

