/*
//glass commented out due to spped-up reasons
#declare ap=array[12]
#declare ap[0]=<0.0,-0.5,0>;
#declare ap[1]=<0.6, 0.0,0>;
#declare ap[2]=<0.6, 0.2,0>;
#declare ap[3]=<1.0, 0.4,0>;
#declare ap[4]=<0.5, 0.7,0>;
#declare ap[5]=<0.4, 1.0,0>;
#declare ap[6]=<0.35,1.0,0>;
#declare ap[7]=<0.45,0.7,0>;
#declare ap[8]=<0.95,0.4,0>;
#declare ap[9]=<0.55,0.2,0>;
#declare ap[10]=<0.55,0,0>;
#declare ap[11]=<0,0,0>;
#declare glass_tube=
object{meshlathe(ap,.25,18)}
*/

#declare protec=
union{
 cylinder{<1.5,0.3,0>,<2.7,.25,0>,.2}
 sphere{<2.7,.25,0>,.2}
 cylinder{<2.7,.25,0>,<3.2,1,0>,.2}
 sphere{<3.2,1,0>,.2}
 cylinder{<3.2,1,0>,<2.7,7,0>,.2}
 sphere{<2.7,7,0>,.2}
 cylinder{<2.7,7,0>,<2.2,7.5,0>,.2}
 sphere{<2.2,7.5,0>,.2}
 cylinder{<2.2,7.5,0>,<1.5,8,0>,.2}
}

// *** LAMP ***
#macro oil_lamp(r_lamp)
//#include "glass.inc"

#local fd=140;

union{
 union{
  object{protec}
  object{protec rotate 45*y}
  object{protec rotate 90*y}
  object{protec rotate (90+45)*y}
  object{protec rotate 180*y}
  object{protec rotate (180+45)*y}
  object{protec rotate 270*y}
  object{protec rotate (270+45)*y}
  torus{3,0.2 translate 2*y}
  torus{2.6,0.2 translate 6*y}
  torus{2.3,0.4 translate -.8*y}
  torus{2.4,0.3 translate -.4*y}
  torus{2,0.2 }
  torus{1.7,0.2 translate .4*y}
  torus{1.5,0.2 translate .8*y}
  difference{
   cylinder{<0,-.1,0>,<0,.1,0>,2}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 0*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 45*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 90*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 135*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 180*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 225*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 270*y}
   cylinder{<0,-.2,0>,<0,.2,0>,.5 translate -1.4*z rotate 315*y}
  }
  torus{1.2,0.2 translate 7.2*y}
  torus{1.5,0.2 translate 7.6*y}
  torus{1.7,0.2 translate 8*y}
  torus{1.5,0.2 translate 8.4*y}
  difference{
   union{
    intersection{
     difference{
      sphere{0,1}
      sphere{0,.95}
     }
     plane{y,0 inverse}
     scale <1.5,2,1.5>
    }
    cylinder{<0,-.1,0>,<0,.1,0>,1.5}
   }
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 0*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 45*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 90*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 135*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 180*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 225*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 270*y}
   cylinder{<0,2.1,0>,<0,-.2,0>,.3 translate -.9*z rotate 315*y}
   translate 8*y
  }
  torus{1,0.2 rotate 90*x translate 11*y}
  texture{Copper_Metal}
  translate -4*y
 }
/*
 object{glass_tube
  hollow
  material{
   texture{
    T_Glass4
   }
  }
  hollow
  translate -.5*y
  scale <2.5,8,2.5>
 }
*/
 sphere{<0,0,0>,1
   pigment { color rgbf<1, 1, 1, 1> }
   finish { ambient 0 diffuse 0 }
   interior{
     media {
      emission 0.05
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
        spherical
        cubic_wave
        turbulence .1
        color_map {
          [0.0 Black]
          [0.7 Gold]
          [0.9 Gold+White]
          [1.0 Gold*2+White*2]
        }
        frequency 1
      }
     }
   }
   no_shadow
   hollow
   scale 10
 }
 sphere{<0,0,0>,1
   pigment { color rgbf<1, 1, 1, 1> }
   finish { ambient 0 diffuse 0 }
   interior{
     media {
      emission 0.5
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
        wrinkles
        cubic_wave
        turbulence .4
        lambda 2
        color_map {
          [0.0 Black]
          [0.3 Red]
          [0.6 Yellow]
          [1.0 Black]
        }
        frequency 3
      }
     }
   }
   no_shadow
   hollow
   scale <2,3,2>
   scale .5
 }
 #if (use_area)
 light_source{
  0
  (White+Gold)*.5
  area_light <2,0,0>,<0,2,0>,4,4
  fade_distance fd
  fade_power 4
 }
 #else
 light_source{
  0
  (White+Gold)*.5
  fade_distance fd
  fade_power 4
 }
 #end
 rotate 360*rand(r_lamp)*y
 translate -11*y
 rotate (-5+10*rand(r_lamp))*z
 translate 11*y
}
#end