/*

  "Sinking" ("Naufragio")

  Raytraced with MegaPOV 0.5a

  Jaime Vives Piqueres, (?)2000.

  Entry for the 07-08-2000 round of the IRTC, topic "SEA".

*/

// *** THAT'S MEGAPOV CODE ***
#version unofficial MegaPov 0.5;

// *** STANDARD INCLUDES ***
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
//#include "glass.inc"
#include "skies.inc"

// *** GLOBBAL SETTINGS ***
global_settings{
 max_trace_level 16
 ambient_light 0.1
// ambient_light 0
// #include "i_radiosity.inc"
}

// *** CUSTOM INCLUDES ***
#include "meshlath.inc"

// *** CONTROL CENTER ***
#declare use_boxes  =1;
#declare use_barrels=1;
#declare use_bags   =1;
#declare use_water  =1;
#declare use_lamps  =1;
#declare use_area   =1;

// *** GLOBAL VARIABLES ***
#declare sinking_angle=<-3,0,1>;

// *** CUSTOM INLCUDES ***
#include "i_board_mcr.inc"

// *** COMMON TEXTURES ***
#include "i_textur.inc"

// *** MOUNT THE SHIP ***
#declare rds=seed(367);
#include "i_ship.inc"
#declare ship=
union{
object{curved_section(rds) translate 80*0*z}
object{curved_section(rds) translate 80*1*z}
object{curved_section(rds) translate 80*2*z}
object{curved_section(rds) translate 80*3*z}
object{curved_section(rds) translate 80*4*z}
object{curved_section(rds) translate 80*5*z}
object{curved_section(rds) translate 80*6*z}
object{curved_section(rds) translate 80*7*z}
object{curved_section(rds) translate 80*8*z}
object{curved_section(rds) translate 80*9*z}
object{curved_section(rds) translate 80*10*z}
object{curved_section(rds) translate 80*11*z}
object{back_wall translate <0,-50,1000>}
object{back_wall translate <0,-50,-5>}
object{pillar(rds) translate 0*z}
object{pillar(rds) translate 250*z}
object{pillar(rds) translate 500*z}
object{pillar(rds) translate 750*z}
object{pillar(rds) translate 1000*z}
#if (use_lamps)
#declare r_lamp=seed(2367);
#include "i_lamp.inc"
object{oil_lamp(r_lamp) translate <0,-30,260>}
object{oil_lamp(r_lamp) translate <0,-30,490>}
object{lamp_nail rotate 180*y translate <0,-23,495>}
object{oil_lamp(r_lamp) translate <0,-30,510>}
object{oil_lamp(r_lamp) translate <0,-30,740>}
object{lamp_nail rotate 180*y translate <0,-23,745>}
object{oil_lamp(r_lamp) translate <0,-30,760>}
//object{oil_lamp(r_lamp) translate <0,-30,990>}
// up
union{
object{oil_lamp(r_lamp) translate <0,-30,510>}
object{oil_lamp(r_lamp) translate <0,-30,740>}
object{oil_lamp(r_lamp) translate <0,-30,760>}
 translate 100*y
}
#end
object{beam(rds) translate <0,-5,0>}
object{beam(rds) translate <0,-5,500+750>}
object{beam(rds) translate <55,-5,500>}
object{beam(rds) translate <-55,-5,500>}
object{beam(rds) translate <127,-5,500>}
object{beam(rds) translate <-127,-5,500>}
object{supp_beam(rds) translate <65,-4,500>}
object{supp_beam(rds) translate <75,-4,500>}
object{supp_beam(rds) translate <85,-4,500>}
object{supp_beam(rds) translate <95,-4,500>}
object{supp_beam(rds) translate <105,-4,500>}
object{supp_beam(rds) translate <115,-4,500>}
object{supp_beam(rds) translate <-65,-4,500>}
object{supp_beam(rds) translate <-75,-4,500>}
object{supp_beam(rds) translate <-85,-4,500>}
object{supp_beam(rds) translate <-95,-4,500>}
object{supp_beam(rds) translate <-105,-4,500>}
object{supp_beam(rds) translate <-115,-4,500>}
object{supp_beam(rds) translate <10,-4,500+750>}
object{supp_beam(rds) translate <20,-4,500+750>}
object{supp_beam(rds) translate <30,-4,500+750>}
object{supp_beam(rds) translate <40,-4,500+750>}
object{supp_beam(rds) translate <-10,-4,500+750>}
object{supp_beam(rds) translate <-20,-4,500+750>}
object{supp_beam(rds) translate <-30,-4,500+750>}
object{supp_beam(rds) translate <-40,-4,500+750>}
object{supp_beam(rds) translate <10,-4,0>}
object{supp_beam(rds) translate <20,-4,0>}
object{supp_beam(rds) translate <30,-4,0>}
object{supp_beam(rds) translate <40,-4,0>}
object{supp_beam(rds) translate <-10,-4,0>}
object{supp_beam(rds) translate <-20,-4,0>}
object{supp_beam(rds) translate <-30,-4,0>}
object{supp_beam(rds) translate <-40,-4,0>}
#if (use_boxes)
#include "i_wbox.inc"
#declare r_wbox=seed(88);
object{woodbox(r_wbox) translate <-80,-80,900>}
object{woodbox(r_wbox) translate <-30,-80,900>}
object{woodbox(r_wbox) rotate 1*y  translate <-80,-39,902>}
object{woodbox(r_wbox) rotate -2*y translate <-30,-39,899>}
object{woodbox(r_wbox) translate <-80,-80,800>}
object{woodbox(r_wbox) translate <-31,-80,810>}
object{woodbox(r_wbox) rotate 3*y  translate <-80,-39,802>}
object{woodbox(r_wbox) rotate -4*y translate <-30,-39,799>}
object{woodbox(r_wbox) translate < 80,-80,900>}
object{woodbox(r_wbox) translate < 30,-80,900>}
object{woodbox(r_wbox) rotate -1*y  translate <80,-39,902>}
object{woodbox(r_wbox) rotate 2*y translate <30,-39,899>}
// up
union{
object{woodbox(r_wbox) translate <-80,-80,900>}
object{woodbox(r_wbox) rotate 1*y  translate <-80,-39,902>}
object{woodbox(r_wbox) translate <-80,-80,800>}
object{woodbox(r_wbox) rotate 3*y  translate <-80,-39,802>}
object{woodbox(r_wbox) translate <-80,-80,700>}
object{woodbox(r_wbox) rotate 3*y  translate <-80,-39,702>}
 translate 100*y
}
#end
#if (use_bags)
#include "i_bag.inc"
object{bag translate <-80,-90,700>}
object{bag translate <-80,-70,700>}
object{bag translate <-80,-50,700>}
object{bag translate <-80,-90,650>}
object{bag translate <-80,-70,650>}
object{bag translate <-80,-90,600>}
object{bag translate <-80,-70,600>}
object{bag rotate <-80,3,0> translate <-80,-80,560>}
object{bag rotate <12,20,7> translate <-82,-90,495>}
union{
 object{bag translate <-25,-90,800>}
 object{bag translate <-25,-70,800>}
 object{bag translate <-25,-50,800>}
 object{bag translate < 25,-90,800>}
 object{bag translate < 25,-70,800>}
 object{bag translate < 25,-50,800>}
 translate 100*y
}
#end
#if (use_barrels)
#declare r_wood=seed(48);
#include "i_barrel.inc"
object{barrel(r_wood,80,30,24,0) scale .5 translate <25,-80,804>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <27,-80,706>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <26,-80,654>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <58,-80,805>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <57,-80,705>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <57,-80,655>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <58,-80,605>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <84,-80,807>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <85,-80,749>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <83,-80,702>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <85,-80,649>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <84,-80,607>}
object{barrel(r_wood,80,30,24,0) scale .5 rotate <90,45,4> translate <62,-86,490>}
object{barrel(r_wood,80,30,24,0) scale .5 translate <83,-80,552>}
object{barrel(r_wood,80,30,24,0) scale .5 rotate <90,-40,5> translate <23,-87,460>}
object{barrel(r_wood,80,30,24,0) scale .5 rotate <90,130,10> translate <85,-87,432>}
#end
// FLOOR
object{boards_floor translate <0,-100,400>}
// CEIL
difference{
 object{boards_floor scale <1.3,1,1> translate <0,0,400>}
 box{<-50,-10,500>,<50,10,750> texture{t_madera}}
}
difference{
 object{boards_floor scale <1.3,1,1> translate <0,0,400>}
 box{<-50,-10,500>,<50,10,750> texture{t_madera}}
 translate 100*y
}
// step
object{woodstep rotate 20*x translate <-40,-51,728>}
// cuerdas
object{monton_cuerda rotate 20*y translate <-10,-101,690>}
}

// *** PLACE THE SHIP ***
object{ship
 rotate sinking_angle
 translate 350*.5*y
}

// *** WATER ***
#if (use_water)
#include "i_water.inc"
object{incoming_water translate <0,103,120+240+106>}
object{water_source translate <14,104,120+240+34>}
#end


// night sky
sky_sphere{
 pigment{
  wrinkles
  turbulence .5
  lambda 2
  color_map{
   [0.0 Black]
   [0.3 Black]
   [1.0 Gray]
  }
  scale <1,1/6,1>
 }
}


// take the shot
camera{
 location <92,140,249>
 direction 2.2*z
 look_at <-140,145,1000>
// translate 100*y
}
#if (use_lamps=0)
 light_source{
  <95,145,239>
  White+Gold
  fade_distance 10000
  fade_power 2
 }
#end

