// A random sub somewhere in the Arctic ocean
// Started: 2000.8.4

// 1 unit = 1 decimeter = 10 centimeters
#include "colors.inc"
#include "metals.inc"
#include "sub.pov"
#include "skies.inc"

#declare large_icebergs_present=1;
#declare small_icebergs_present=1;
#declare sub_present=1;
#declare clouds_present=1;
#declare water_present=1;
#declare fog_present=1;

#if (fog_present=1)
fog{
  fog_type 2
  color rgbf <1,1,1,1>
  distance 1000
  fog_offset 50
  fog_alt 20
}
#end

#declare my_cloud_pigment = pigment{
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color rgbf <0.85, 0.85, 0.85, .6>
                    color rgbf <0.75, 0.75, 0.75, .6>]
        [0.1, 0.5   color rgbf <0.75, 0.75, 0.75, .6>
                    color Clear]
        [0.5, 1.001 color Clear
                    color Clear]
    }
    scale <6, 1, 6>
}

#declare my_cloud=texture{

  pigment{
    my_cloud_pigment
  }
  finish{
    diffuse 1
  }
}
texture {
  pigment{
    my_cloud_pigment
  }
  finish{
    diffuse 1
  }
}

#declare my_cloud3 =
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10          
        omega .5  
        lambda 2.5
        color_map {
            [0.0, 0.2 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.2, 0.5 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.5, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 1.0
        diffuse 0.0
    }
}
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.1 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.1, 0.6 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 0.95
        diffuse 0.0
    }
scale .9
translate y*-0.15
}


#declare my_cloud2 =
texture {
    pigment {
        bozo 
        turbulence 1.5
        octaves 10    
        omega .5   
        lambda 2.5 
        color_map {
            [0.0, 0.3 color rgbf <.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.3, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }

    finish {
        ambient 0.9
        diffuse 0.1                      
    }
}

#if (small_icebergs_present=1)
#declare berg=height_field{
   tga "iceberg.tga"
   smooth
   translate <-.5, 0, -.5>
}

#end

//*
light_source{
  <10000,50000,100>
  White
}
//*/

/*
light_source{
  <0,10000,000>
  White
}
*/

//*
camera{
  location <-500, 50, -150>
  look_at  <-150, 38, 0>
}
//*/

/*
camera{
  location <-220, 45, -150>
  look_at  <-220, 40, 0>
}
*/

sky_sphere{
  pigment{
    gradient y
    color_map{
      [0 color <223, 243, 242>/256]
      [1 color <.6, .6, .9>]
    }

  }
}

// a sky
#if (clouds_present=1)
union {
    plane { y, 500
        texture {
            my_cloud2
            scale 6000
        }            
    }
    plane { y, 3000
        texture {
            my_cloud3
            scale <9000,1,9000>
            translate x*3000
            rotate -30*y
        }
    }
    scale 100
    hollow
}
#end

  
//the water
#if (water_present=1)
#declare The_Water =union{
union{
#declare countx=0;
#while (countx < 15)
#declare countz=0;
#declare connection=.001;
#while (countz<15)
height_field{
  tga "water.tga"
  smooth
  translate <countx-connection,0,countz-connection>
}
#declare connection=connection+.001;
#declare countz=countz+1;
#end
#declare countx=countx+1;
#end

translate <-7.5, 0, -7.5>
scale <1000,20,1000>

pigment {color rgbf <1, 1, 1, 1>}
finish {phong 1 phong_size 90 diffuse 0
reflection .2
}

normal {ripples scale 3000 frequency 500 turbulence .3}

interior {
ior 1.33
media {
absorption <.1, .05, .05>
samples 2, 2
}
}
hollow
}
plane {y, -5000 pigment {color 0.4*White}}

union{
box{
  <-1000, 19.9, 5000>, <50000, 20, 50000>
}
box{
  <5000, 19.9, 5000>, <50000, 20, -50000>
}
pigment{color rgbf<1,1,1,1>}
finish{phong 1 phong_size 90 diffuse 0 reflection .2}
normal{ripples scale 3000 frequency 5000 turbulence .3}
interior {
ior 1.33
media {
absorption <.1, .05, .05>
samples 2, 2
}
}
hollow

}
}
#end

//plane {y, 0 pigment {color Red} hollow}

#if (sub_present=1)
object{
  sub
  translate y*-10
}
#end

#if (water_present=1)
object{
  The_Water
}
#end

//The icebergs
#if (large_icebergs_present=1)
#declare ZCount=0;
union{
  #while (ZCount < 3)
    #declare XCount=0;
    #while (XCount < 3)
      height_field{
        tga "mountain.tga"
        smooth
	water_level .0001
        pigment{White}
        translate <XCount,0,ZCount>
      }
      #declare XCount=XCount+1;
    #end
    #declare ZCount=ZCount+1;
  #end
  translate <-1.5, -0, -1.5>
  scale <3000,100,3000>
  translate y*-50
}
#end

#if (small_icebergs_present=1)
object{
  berg
  water_level .0001
  scale <300,50,250>
  translate y*-30
  translate z*-270
  pigment{White}
}

object{
  berg
  water_level .0001
  scale <450,40,280>
  rotate y*200
  translate y*-17
  translate z*-200
  translate x*-210
  pigment{White}
}
  
#end
