//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 7 textures and 206 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 08/31/2000    (31.08.2000)
//



/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            150
    distance_maximum 10.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
}

background { color <0.988,0.816,0.463> }

camera {  //  Camera StdCam
  location  <-12.394, -12.035, 12.240>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <1.609, -0.265, -2.340>
}

//
// *******  L I G H T S *******
//

light_source {   // White_high_light
  <19.261, 12.492, 112.778>
  color rgb <1.000, 1.000, 1.000>
  shadowless
}

light_source {   // blue_fill
  <-13.350, -20.802, 14.662>
  color rgb <0.500, 0.500, 0.845>
}

light_source {   // white_sparkle_light
  <-3.881, -6.917, 12.702>
  color rgb <0.750, 0.750, 0.750>
  shadowless
}


//
// ********  TEXTURES  *******
//

#include "seatest.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare TraSwp6 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG6 = difference {
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp6 }
  sphere { // Sphere11
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere12
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
#declare segment5 = difference { // segment5
  object { CSG6 }
  torus { // Torus36
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus37
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus38
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus39
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus40
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus41
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus42
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.1
  translate  <-0.59495, -0.008615, -3.043624>
}




//
// ********  OBJECTS  *******
//

#include "D:\projects\irtc\ocean\algae\algae.inc"

object {
  aqua04_default
  texture {
    Dark_Green_Algae
  }
  scale <0.055, -0.055, 0.055>
  rotate -79.158325*z
  translate  <-3.11527, 6.136138, 0.0>
}


object {
  aqua04_default
  texture {
    Dark_Green_Algae
  }
  scale <0.06, 0.07, 0.06>
  rotate 134.012039*z
  translate  <-3.417647, 5.852932, 3.009273>
}


object {
  aqua04_default
  texture {
    Dark_Green_Algae
  }
  scale <0.06, 0.06, 0.035>
  rotate <-0.0, -0.0, 91.23584>
  translate  <-7.268964, -7.04006, 0.621538>
}


object {
  aqua04_default
  texture {
    Dark_Green_Algae
  }
  scale <0.05, -0.04, -0.03>
  rotate <-171.451889, -21.078043, 120.466423>
  translate  <-6.364187, -1.878463, -0.377313>
}


object {
  aqua04_default
  texture {
    Dark_Green_Algae
  }
  scale <0.075, -0.06, 0.025>
  rotate -75.907791*z
  translate  <-7.901086, -4.819944, -0.386331>
}




object {
  aqua04_default
  texture {
    Dark_Green_Algae
  }
  scale <0.055, 0.055, 0.05>
  rotate 135.643768*z
  translate  <-6.871219, -0.191674, 2.263123>
}


union { // column
  object { // segment6->segment5
    segment5
    translate  0.29*z
  }
  object { // segment7->segment5
    segment5
    translate  0.4*z
  }
  object { // segment8->segment5
    segment5
    translate  <0.001864, 0.002531, 0.5>
  }
  object { // segment9->segment5
    segment5
    translate  0.6*z
  }
  object { // segment10->segment5
    segment5
    translate  0.7*z
  }
  object { // segment11->segment5
    segment5
    translate  0.8*z
  }
  scale <0.5, 0.5, 1.0>
  rotate <-17.521858, -88.367409, 27.314539>
  translate  <-2.823425, 1.52451, -1.630427>
}




box { // water_surface
  <-1, -1, -1>, <1, 1, 1>
  scale <100.0, 100.0, 0.01>
  translate  3.0*z
  texture {
    Water_surface
  }
}


box { // sea_floor
  <-1, -1, -1>, <1, 1, 1>
  scale <100.0, 100.0, 0.1>
  translate  <-1.0, 0.0, -3.048146>
  texture {
    seafloor
  }
}




#declare TraSwp001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG001 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp001 }
  sphere { // Sphere2
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment
  object { CSG001 }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus2
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus3
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus4
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus5
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus6
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus7
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.15
  rotate -35.22105*y
  translate  <0.190974, 0.0, -2.988821>
}


#declare TraSwp2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG2 = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp2 }
  sphere { // Sphere3
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment1
  object { CSG2 }
  torus { // Torus8
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus9
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus10
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus11
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus12
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus13
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus14
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale -0.096757
  rotate -23.056679*y
  translate  <2.813692, 0.0, -2.880988>
}


#declare TraSwp3 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG3 = difference {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp3 }
  sphere { // Sphere5
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment2
  object { CSG3 }
  torus { // Torus15
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus16
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus17
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus18
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus19
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus20
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus21
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.117273
  rotate <0.0, 89.05426, 35.27>
  translate  <-0.294116, 1.805604, -2.948675>
}


#declare TraSwp4 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG4 = difference {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp4 }
  sphere { // Sphere7
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere8
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment3
  object { CSG4 }
  torus { // Torus22
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus23
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus24
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus25
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus26
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus27
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus28
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <1.002369, -0.755217, -2.992185>
}


#declare TraSwp5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG5 = difference {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp5 }
  sphere { // Sphere9
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere10
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment4
  object { CSG5 }
  torus { // Torus29
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus30
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus31
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus32
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus33
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus34
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus35
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.12
  rotate <145.380798, -53.59251, -91.672943>
  translate  <2.350297, -2.767551, -3.044695>
}


object { segment5 }


#declare TraSwp7 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG7 = difference {
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp7 }
  sphere { // Sphere13
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment12
  object { CSG7 }
  torus { // Torus43
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus44
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus45
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus46
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus47
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus48
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus49
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.117273
  rotate <-180.0, 34.402645, 180.0>
  translate  <-0.050737, 1.844718, -2.948368>
}


#declare TraSwp8 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG8 = difference {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp8 }
  sphere { // Sphere15
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere16
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment13
  object { CSG8 }
  torus { // Torus50
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus51
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus52
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus53
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus54
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus55
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus56
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.117273
  rotate <180.0, 14.583632, -180.0>
  translate  <-0.19055, 2.244625, -2.898384>
}


#declare TraSwp9 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG9 = difference {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp9 }
  sphere { // Sphere17
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere18
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment14
  object { CSG9 }
  torus { // Torus57
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus58
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus59
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus60
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus61
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus62
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus63
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <-1.412003, 1.2351, -2.992185>
}


#declare TraSwp10 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG10 = difference {
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp10 }
  sphere { // Sphere19
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment15
  object { CSG10 }
  torus { // Torus64
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus65
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus66
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus67
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus68
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus69
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus70
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <-0.636475, 0.947868, -2.992185>
}


#declare TraSwp11 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG11 = difference {
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp11 }
  sphere { // Sphere21
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere22
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment16
  object { CSG11 }
  torus { // Torus71
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus72
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus73
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus74
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus75
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus76
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus77
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <-1.354556, 1.551056, -2.992185>
}


#declare TraSwp12 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG12 = difference {
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp12 }
  sphere { // Sphere23
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere24
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment17
  object { CSG12 }
  torus { // Torus78
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus79
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus80
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus81
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus82
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus83
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus84
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <-1.096047, 0.775528, -2.992185>
}


#declare TraSwp13 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG13 = difference {
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp13 }
  sphere { // Sphere25
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere26
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment18
  object { CSG13 }
  torus { // Torus85
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus86
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus87
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus88
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus89
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus90
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus91
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <-0.808814, 1.2351, -2.992185>
}


#declare TraSwp14 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  18  // control points
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>,
  <-0.44586, -0.968153>,
  <0.023992, -0.40552>,
  <0.37707, -0.968153>,
  <0.755839, -0.766454>,
  <0.363057, -0.122781>,
  <1.010616, 0.270913>,
  <0.861996, 0.607219>,
  <0.222983, 0.363057>,
  <0.231529, 1.042463>,
  <-0.127389, 1.021231>,
  <-0.111306, 0.373673>,
  <-0.766454, 0.596603>,
  <-0.915074, 0.255839>,
  <-0.299363, -0.097611>,
  <-0.684926, -0.660297>
  rotate -x*90
  scale <0.35, 0.35, 1.0>
}
#declare CSG14 = difference {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
  }
  object { TraSwp14 }
  sphere { // Sphere27
    <0,0,0>,1
    scale 3.194138
    translate  -2.973034*z
  }
  sphere { // Sphere28
    <0,0,0>,1
    scale 3.194138
    translate  3.999448*z
  }
  translate  -0.05*z
}
difference { // segment19
  object { CSG14 }
  torus { // Torus92
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
  }
  torus { // Torus93
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.15*z
  }
  torus { // Torus94
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.3*z
  }
  torus { // Torus95
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.45*z
  }
  torus { // Torus96
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.6*z
  }
  torus { // Torus97
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.75*z
  }
  torus { // Torus98
    1.5, 0.5  rotate -x*90
    scale <0.95, 1.0, 0.1>
    translate  0.9*z
  }
  texture {
    SandstP
  }
  scale 0.08
  rotate -20.570433*y
  translate  <-0.088276, -0.55854, -3.019887>
}


#declare RotSwp001 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare head = difference {
  object { RotSwp001 }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.324772, 1.558113, 1.802672>
}
#declare RotSwp2 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare tail_segment = intersection {
  object { RotSwp2 }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.155561, 1.676843, 1.4>
  translate  0.507632*y
}
union { // HorseshoeCrab
  object { head }
  object { tail_segment }
  cone { // tail_of_crab
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      crab_body
    }
    scale <0.5, 0.5, 18.0>
    rotate 95.0*x
    translate  <0.0, 29.252741, 1.347686>
  }
  sphere { // eye1
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <2.2, -5.0, 1.5>
  }
  sphere { // eye2
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <-2.2, -5.0, 1.5>
  }
  scale 0.1
  rotate -85.417885*z
  translate  <8.931032, 0.977443, -2.951852>
}


#declare RotSwp3 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare head1 = difference {
  object { RotSwp3 }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.324772, 1.558113, 1.802672>
}
#declare RotSwp4 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare tail_segment1 = intersection {
  object { RotSwp4 }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.155561, 1.676843, 1.4>
  translate  0.507632*y
}
union { // HorseshoeCrab1
  object { head1 }
  object { tail_segment1 }
  cone { // tail_of_crab1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      crab_body
    }
    scale <0.5, 0.5, 18.0>
    rotate 95.0*x
    translate  <0.0, 29.252741, 1.347686>
  }
  sphere { // eye3
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <2.2, -5.0, 1.5>
  }
  sphere { // eye4
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <-2.2, -5.0, 1.5>
  }
  scale 0.12
  rotate -58.873184*z
  translate  <5.812028, 5.24811, -2.97>
}


#declare RotSwp5 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare head2 = difference {
  object { RotSwp5 }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.324772, 1.558113, 1.802672>
}
#declare RotSwp6 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare tail_segment2 = intersection {
  object { RotSwp6 }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.155561, 1.676843, 1.4>
  translate  0.507632*y
}
union { // HorseshoeCrab2
  object { head2 }
  object { tail_segment2 }
  cone { // tail_of_crab2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      crab_body
    }
    scale <0.5, 0.5, 18.0>
    rotate 95.0*x
    translate  <0.0, 29.252741, 1.347686>
  }
  sphere { // eye5
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <2.2, -5.0, 1.5>
  }
  sphere { // eye6
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <-2.2, -5.0, 1.5>
  }
  scale 0.07
  rotate -84.274696*z
  translate  <12.592662, 4.633009, -2.966819>
}


#declare RotSwp7 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare head3 = difference {
  object { RotSwp7 }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.324772, 1.558113, 1.802672>
}
#declare RotSwp8 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare tail_segment3 = intersection {
  object { RotSwp8 }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.155561, 1.676843, 1.4>
  translate  0.507632*y
}
union { // HorseshoeCrab3
  object { head3 }
  object { tail_segment3 }
  cone { // tail_of_crab3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      crab_body
    }
    scale <0.5, 0.5, 18.0>
    rotate 95.0*x
    translate  <0.0, 29.252741, 1.347686>
  }
  sphere { // eye7
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <2.2, -5.0, 1.5>
  }
  sphere { // eye8
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <-2.2, -5.0, 1.5>
  }
  scale 0.075
  rotate -113.372543*z
  translate  <10.722738, -2.612549, -2.956228>
}


#declare RotSwp9 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare head4 = difference {
  object { RotSwp9 }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.324772, 1.558113, 1.802672>
}
#declare RotSwp10 = lathe {
  cubic_spline
  13  // control points
  <-0.019108, 0.019108>,
  <3.942675, -0.05414>,
  <3.751592, 0.183397>,
  <3.210191, 0.316773>,
  <2.318471, 0.626008>,
  <2.042463, 0.72293>,
  <1.852537, 0.786046>,
  <1.763694, 0.830467>,
  <1.588079, 0.891736>,
  <1.431847, 0.927389>,
  <1.164459, 0.965541>,
  <0.023582, 1.047657>,
  <0.03397, 1.0>
  rotate <90,0,90>
  scale <1.485283, 1.904402, 1.0>
}
#declare tail_segment4 = intersection {
  object { RotSwp10 }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1 
    scale <11.326101, 17.580494, 3.911696>
    translate  <0.0, 18.044884, -0.818915>
  }
  texture {
    crab_body
  }
  scale <1.155561, 1.676843, 1.4>
  translate  0.507632*y
}
union { // HorseshoeCrab4
  object { head4 }
  object { tail_segment4 }
  cone { // tail_of_crab4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      crab_body
    }
    scale <0.5, 0.5, 18.0>
    rotate 95.0*x
    translate  <0.0, 29.252741, 1.347686>
  }
  sphere { // eye9
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <2.2, -5.0, 1.5>
  }
  sphere { // eye10
    <0,0,0>,1
    texture {
      eye_of_crab
    }
    scale 0.5
    translate  <-2.2, -5.0, 1.5>
  }
  scale 0.05
  rotate -79.308975*z
  translate  <18.659813, 3.696607, -2.954266>
}


