// Crypt2.
// Isosurfaces inspired by Tor Olav Kristensen

#version unofficial MegaPov 0.6;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 25
}

// ----------------SCENE------------------

#declare Image_Length = 480;
#declare Image_Height = 640;

camera
{
  location  <.11 , -1.25, -26.75>
  direction 1.5*z
  right Image_Length/Image_Height*x
  look_at   <0.0, 0.25,  0.0>
}
sky_sphere
{
  pigment
  {
    gradient y turbulence .3 lambda 3
    color_map { [0.0 color rgb .75] [1.0 color rgb 1] }
  }
}
// ----------------Front------------------------------  	
light_source{<-1, 1, -23>color<0,.025,.1>/2	
glow{ type 1 
	size .1 
	}
	media_interaction off
	//shadowless
	}
	
light_source{<1., 1, -23>color<0,.125,.0125>/1.75	
glow{ type 1 
	size .1 
	}
	media_interaction off
	//shadowless
	}
	
// --------------------------------------------------------
	
light_source{ <-0.135, 1, -20> color<.025,0,.125>/2	
glow{ type 1 
	size .1 
	}
	media_interaction off
	}

light_source{<0.135, 1, -15.9> color<.075,0,.125>/6
glow{ type 1 
	size .1 
	}
	media_interaction off
	}
	
light_source{<-.135, 1, -7.5> color<.125,0,.025>/6
glow{ type 1 
	size .1 
	}
	media_interaction off
	}

// ------------------------Blue Sides------------------------
 
glow{ type 1
	color<0,0,0.25> // was .5
	size .1 
	warp{turbulence 1}
	translate<4, -3, -8>
	}
	 
glow{ type 1
	color<0,0,0.25> // was .5
	size .1
	warp{turbulence 1}
	translate<-4, -3, -8> 
	}
 
glow{ type 1 
	color<0,0,0.25> // was .5
	size .1 
	warp{turbulence 1}
	translate<4, -3, -16>
	}

glow{ type 1
	color<0,0,0.25> // was .5
	size .1
	warp{turbulence 1}
	translate<-4, -3, -16> 
	}
		
// ================================================================

$ Roof_on = 0; 
$ Nave_on = 1;
$ Mist_on = 0;
$ Lamps_on =0;
$ Light_Rays_On = 0;
$ Windows_on = 0;
$ Figure_on = 0;
$ Raven_on = 1;

// ================================================================

#declare arch1 = union{
     #declare Radius = .975;
       #include "Rib.inc"}

#declare arch2 = union{
     #declare Radius = .975;
       #include "Rib.inc"}

#declare arch3 = union{
    #declare Radius = .95;
      #include "Rib.inc"}

 #declare CrossArch = union{
 object { arch1 translate <0,0,-0.025>}
 object { arch2 translate <0,0,0.025>}
 object { arch3 }
} 

// ================================================================= 
#if(Roof_on = 1)

#declare N=
 normal {
    crackle  
    slope_map {
		[0 <0,2.5>]
		[.1 <2.5,2.5>]
        [.25 <2.5,0>]
        [.75 <2.5,0>]
        [.9 <2.5,-2.5>]
        [1 <0,-2.5>]   
    }
  }
#declare N2=
 normal {
    wrinkles 
    slope_map {
		[0 <0,15>]
        [.2 <15,0>]
        [.8 <15,0>]
        [1 <0,-15>]   
    }
  }  
$ StoneTex = texture{
	pigment{rgb 1.25}
	finish{ambient -.0001 
	phong 25 phong_size 50 // phong was 250
	diffuse .75
	}
	normal{N scale .0325}
	}
$ StoneTex2 = texture{
	pigment{rgb 1.125}
	finish{ambient -.0001 
	phong 15 phong_size 100 // phong was 100
	specular 1 roughness .1
	diffuse .75
	}
	normal{N2}
	}	
		
$ VaultTex = texture{
	pigment{rgb 1}
	finish{ambient -.0001 
	phong 10 phong_size 100 // phong was 100
	diffuse .75 
	}
	}
		  
// isosurface patterns

$ WFunctionZ =   // roof
function { 
	pigment { wrinkles color_map { 
		[ 0 rgb 0 ] 
		[ 1 rgb 1 ]
		} 
		scale .025 
		turbulence .5 
		} 
		}  

$ WFunctionX =  // roof
function {
	pigment { wrinkles color_map { 
		[ 0 rgb 0 ]
 		[ 1 rgb 1 ]
 		}
 		scale .1 
 		turbulence .5   
 		rotate y*90 
 		} 
 		} 


$ MidOfWSquare =   // z
function {
  WFunctionZ(  
    3*(floor(z)),
    3*((x) + 1*noise3d(x, y, z)), 
    10*(floor(y))
  )
}  

$ MidOfWSquare2 =  // x
function {
  WFunctionX(
    3*(floor(x) ),
    3*((z) + 1*noise3d(x, y, z*2)),     
    10*(floor(y))
  )
} 

// cube
#declare BF=function{y-1}

// cylinder
#declare ZCyl=function{sqrt(x^2+y^2)-.01}  
#declare XCyl=function{sqrt(y^2+z^2)-.01}
#declare Col=function{sqrt(x^2+z^2)-.32} 

$ Vault =
isosurface {
  function {
    BF(x,y,z) // Block
    &-(ZCyl(x, y, z)
    	+.1*(MidOfWSquare(x*2, y, z*2))-2) // diff z cyl 
    &-(XCyl(x, y, z)
    	+.1*(MidOfWSquare2(x*4 ,y, z))-2) // diff x cyl
  }
  threshold 1
  sign 1
  accuracy .005 
  max_gradient 5 
  method 2
  contained_by { box{<-1.05,-1.05,-1.05>,<1.05,1.05,1.05> } }
}

$ R = seed (43674); 
#include"columns.inc"

#declare Roof_unit = union{
	object{Vault 
		clipped_by{plane{y,0 inverse}}
			texture{VaultTex} 
			}

object { CrossArch rotate y*225 texture{StoneTex scale 1}}
object { CrossArch rotate y*45  texture{StoneTex scale 1}}
object { CrossArch rotate y*135  texture{StoneTex scale 1}}
object { CrossArch rotate y*315  texture{StoneTex scale 1}} 
}

$ R = seed (43674);

 $ XPos = -4;
 $ ZPos = -20;
 #while(XPos<8)
 	#while(ZPos<0)
 	   object{Boss 
		texture{StoneTex2 scale .1}
		scale .5 
		translate<XPos-2.05,-.5,ZPos+2>  
		}
 		 object{Roof_unit scale <2,2.5,2> translate<XPos,0,ZPos> hollow }
 		object{Pillar scale .25 texture{StoneTex2 scale .1}
 		scale<2,2.25,2> 
 		rotate y*(rand(R)*360)
 		translate<XPos-2.05,-2.3*2,ZPos+2> 
 		no_shadow}
 		
 	#declare ZPos = ZPos+4.1;
 	#end
   #declare ZPos = -20;
 	
   #declare XPos = XPos + 4.1;
 	
 #end

#if(Lamps_on = 1) 
 #include"Lamp.inc"
 
 	object{Lamp scale .175 
	rotate y*(rand(R)*360)
	translate <-.175,.25,-7.5>
	no_shadow
	}
	
	object{Lamp scale .175 
	rotate y*(rand(R)*360)
	translate <.175,.25,-15.9>
	no_shadow
	finish{ambient -1}
	}
	
	object{Lamp scale .175 
	rotate y*(rand(R)*360)
	translate <-.175,.175,-20>
	no_shadow
	}
	
#end
	
#end 	 
// =======================================================================

#if(Nave_on = 1)

$ WallTex = texture{
	pigment{rgb<.2,.175,.125>}
	finish{ambient -.0001 diffuse .5
	//phong 25 phong_size 100
	}
	//normal{crackle 100 scale .33}
	/*normal {
    crackle  
    slope_map {
		[0 <0,-5>]
		[.1 <5,-5>]
        [.25 <5,0>]
        [.75 <5,0>]
        [.9 <5,5>]
        [1 <0,5>]   
    }
    scale .325
  }*/
}
	
$ FTex = texture{
tiles{
  texture    
  {
    pigment { wrinkles scale 0.3 turbulence .5}
    finish{ambient 0 diffuse .5}
  }
  tile2
  texture  
  {
    pigment { granite }
    finish { ambient 0 diffuse .5 specular 0.1 }
  }
}
}

#declare Floor = box{<-10,-10,-34><10,-4.9,0>texture{FTex}hollow} // floor

#declare FFlr = difference{	
	object{Floor}
	box{<-.625,-9.9,-2.5><.625,-3,-9> pigment{Yellow*1.5}} // pit
	}
	
#declare Room = difference{
	box{<-10,-20,-36><10,5,.4>texture{WallTex}} // outer wall
	box{<-9,-8.9,-35><9,4.9,0>texture{WallTex}} // inner wall
	box{<-1.8,-3.75,-12><1.8,2.7,1>pigment{Red}} // window aperture
	}
	
#declare Hall = union{
	object{Room}
	object{FFlr}
	}	
	
object{Hall hollow}	

glow{ type 1 // from pit
	size .125
	color<.25,.125,0>*5
	warp{turbulence 3}
	translate <0,-5,-5>
	}	
				
#if (Light_Rays_On = 1 )

light_source {  
<0, 15, 150>
rgb 2.25//1.75
fade_distance 125 fade_power 2
}
                     
box{<-5,-4.75,-16><5,2,0>
pigment { rgbf 1}
interior{                
media{
scattering{1,.0325 extinction .125}
    method 3
    samples 10,35
    intervals 5 
    ratio .999
    confidence .9
    variance 1/1000
    }
}
hollow
}
#end

#end
// ====================================================================
#if(Mist_on =1)

#declare Mist = 
material {
  texture {pigment {rgbf<1,1,1,1>}}
  interior {
    media {
    method 3
      //emission rgb <.45,0,.8>/1.75
      emission rgb <0,.5,0>/2.75
      intervals 1
      samples 10, 10
      density {
       planar 
      scallop_wave
        turbulence <.5,.3,.3> 
        color_map  {
          [0.0 color rgb <0, 0, 0>]
          [0.15 color rgb <.45,.45,.45>*1.5]
          [0.5 color rgb <.6, .6, .7>*2]
          [0.825 color rgb <.45,.45,.45>*1.5]
          [1.0 color rgb <0, 0, 0>]
        }// cm 
        translate <-2,-2.75,0>
        scale <1,2,.5> 
        }// density
       }// media
  }// interior
  }// material
  
  box{
  <-10, -4.8, -24>
  < 10,  -4.25,  0> 
  material {Mist scale <3,1,3>} 
  translate <0,.5,0> 
  hollow
}
  
#end
// --------------------------------------------------------------

#if(Windows_on = 1)

height_field{  
  tga "w3.tga"   
 	inverse 
		texture {pigment{rgb 1.25}finish{ diffuse .75 ambient -.0001 phong 100 phong_size 100}}
			smooth        
			water_level .15 
				translate <-.5,-.5,0> 
				rotate x*-90
				scale <.5,.9,.1>
				scale 7.5
				translate <0,-3.75,0.5>
				}
				
disc{<0, 1.325, 0.55> z,1.25   
pigment{
  radial color_map{
  	[0, rgbft<1,1,0,1,.25>]
  	[.5, rgbft<1,0,0,1,.25>]
  	[1, rgbft<1,1,0,1,.25>]
  	}
  	rotate x*-90
  	rotate z*-40
  	translate <.25,6.75,0>
  	frequency 5
  	turbulence .5
  	scale .2
  }
}

// middle
prism {
  linear_sweep 
  linear_spline 
  0,
   0.01,
  4, 
  <0,0.325>, <1.6,-3.5>, <-1.5,-3.5>, <0,0.325>
  rotate x*-90
  pigment{
  gradient y color_map{
  	[0 rgbft<0,0,1,1,.325>]
  	[.35 rgbft<0,0,.75,1,.325>/1.125]
  	[.7 rgbft<0,0,.5,1,.325>/1.25]
  	}
  	scale 3.5
  	}
  translate<0,0,.55>
  }

// left
prism {
  linear_sweep 
  cubic_spline 0,0.01,9,
  <-1,-1>,<0,0.2>, <-1.5,-3.25>, <-1.5,1.5>, <-1.25,.75>, <-1,.5>, <-.75,.325>,<0,0.2>,<1,1>
  rotate x*-90
  pigment{
  gradient x color_map{
  	[0 rgbft<1,0,0,1,.325>]
  	[.35 rgbft<0,0,1,1,.325>]
  	[.7 rgbft<1,0,1,1,.325>]
  	}
  	scale 1.5
  	turbulence .5
  	translate x*1
  	}
translate<0,0,.55>
}

// right
prism {
  linear_sweep 
  cubic_spline
  0,0.01,9,
  <1,-1>,<0,0.2>, <1.5,-3.25>, <1.5,1.5>, <1.25,.75>, <1,.5>, <.75,.325>,<0,0.2>,<1,1>
  rotate x*-90
  pigment{
  gradient x color_map{
  	[0 rgbft<1,0,0,1,.325>]
  	[.35 rgbft<0,0,1,1,.325>]
  	[.7 rgbft<1,0,1,1,.325>]
  	}
  	scale 1.5
  	turbulence .5
  	}
translate<0,0,.55>
}
#end  

// ---------------------------------------------------------------------

#if(Figure_on = 1)

#declare OBJuvPOV_Texture = texture{
    pigment{rgbt<1,3,1,.325>*2}
	}
#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnipple = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrow = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlashes = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeball = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVfingerNails = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtoenail = texture {OBJuvPOV_Texture}
#declare Body = union{#include "resurectedbody2.inc"}


#declare HairTex = texture{
	pigment{rgbt<2,4,2,.5>}
		finish{ phong 2250 phong_size 500}
}
#declare OBJuvPOV_Texture_OBJuvPOVdefault = texture {HairTex}
#declare OBJuvPOV_Texture_OBJuvPOVhair = texture {HairTex}
#declare Hair =
union{ #include "resurectedhair.inc"}


#declare DressTex = texture{
	pigment{rgbt<3,6,3,.55>}
}
#declare OBJuvPOV_Texture_OBJuvPOVPreview = texture {DressTex}
#declare Dress =
union{#include "resurecteddress.inc"}



#declare Figure = union{
	object {Body }
	object {Hair}
	object {Dress double_illuminate}
	}
	
object{Figure scale 2.75 rotate y*180 translate<0,-4.85,-5>}
	
#end

// ----------------------------------------------------------

#if(Raven_on = 1)

#declare BTail = union{
#declare Count = 0;
#declare Angle = -56;
#declare Hangle = 16;

#while(Count<16)
        blob{
          threshold 0.3
         sphere { 0, 1, 1 scale <2,13,0.2> translate y*11 rotate z*Angle  rotate y*Hangle}
        }
        
     #declare Count = Count +1;
     #declare Angle = Angle +7.5;
     #declare Hangle = Hangle - 2;
#end     
}

#declare OBJuvPOV_Texture = texture{
    pigment{image_map{tga "raven.tga"}}
    finish{ambient .1 diffuse .75  phong 50 phong_size 100}
	normal{
	bump_map{ 
  		tga "ravenbump.tga" 
  		map_type 0 
  		interpolate 2 
  		bump_size .5
		} // bump_map
	} // normal
}

#declare OBJuvPOV_Texture_OBJuvPOVmaterial1 = texture {OBJuvPOV_Texture}

#declare Raven = #include "Raven2.inc"
object {Raven scale 6 rotate y*0 rotate z*-5 rotate x*5 translate <-.1,-6.5,-18> } // left

#declare OBJuvPOV_Texture4 = texture{
    pigment{image_map{tga "raven.tga"}}
    finish{ambient .1 diffuse .75  phong 50 phong_size 100}
	normal{
	bump_map{ 
  		tga "ravenbump.tga" 
  		map_type 0 
  		interpolate 2 
  		bump_size .5
		} // bump_map
	} // normal
}

#declare Raven3 = #include "Raven4.inc"
object {Raven3 scale 6 rotate y*5 rotate z*20 rotate x*15 translate <2.125,-3.25,-16.5> no_shadow} // right

// ********************************************************

#declare OBJuvPOV_Texture = texture{
    pigment{rgb 3}
    finish{ambient .125 diffuse 1 phong 10 phong_size 100}
    normal{
		bump_map{ 
  			tga "ravenbump.tga" 
  			map_type 1 
  			interpolate 2 
  			bump_size 150
			} // bump_map
		} // normal    
}

#declare OBJuvPOV_Texture_OBJuvPOVmaterial1 = texture {OBJuvPOV_Texture}
#declare Dove = #include "dove.inc"
    
object {Dove scale 7 rotate y*0 rotate z*0 rotate x*-15  translate <1.75,-5.25,-11.5> }// middle
object{BTail scale .02125 pigment{rgb 3}finish{ambient .125 diffuse 1 phong 10 phong_size 100}
	rotate x*-115
	translate<0.025,-4.275,-12.275>
	}		
#end