// A mois d'indications contraires, 1 unit = 1 pied.

// ----------------------------
// ------- Dfinitions --------
// ----------------------------

// ----------------------------
// --------- Couleurs ---------
// ----------------------------

#declare Blanc = color red 1 green 1 blue 1;
#declare BleuCiel = color red 0.8 green 0.8 blue 1;
#declare Chair = color red 0.9 green 0.5 blue 0.4;
#declare GrisFonce = color red 0.03 green 0.05 blue 0.05;
#declare GrisMoyen = color red 0.2 green 0.2 blue 0.2;
#declare GrisPale = color red 0.5 green 0.5 blue 0.5;
#declare JaunePale = color red 1 green 1 blue 0.7;
#declare Kaki = color red 0.1 green 0.2 blue 0.1;
#declare Noir = color red 0 green 0 blue 0;
#declare Sable = color red 0.25 green 0.3 blue 0.15;
#declare Brun = color red 0.2 green 0.15 blue 0.1;
#declare Transparent = color red 1 green 1 blue 1 transmit 1;

// ----------------------------
// --------- Pigments ---------
// ----------------------------

#declare P_Asphalte = pigment {
    granite
    turbulence 0.5
    color_map {
        [ 0.05 color GrisMoyen ]
        [ 0.1 color GrisFonce ]
        [ 0.6 color Noir ]
    }
}
#declare P_Huile = pigment {
    bozo
    turbulence 0.8
    color_map {
        [ 0.0 color Noir filter 1.0 ]
        [ 0.5 color Noir filter 0.7 ]
        [ 1.0 color Noir filter 0.3 ]
    }
}
#declare P_Poussiere = pigment {
    bozo
    turbulence 1
    color_map {
        [ 0.5 color Sable filter 1 ]
        [ 0.9 color Sable filter 0.9 ]
        [ 1 color Sable filter 0.8 ]
    }
}
#declare P_CamoS = pigment {
    bozo
    turbulence 0.5
    color_map {
        [ 0.5 color Sable filter 1 ]
        [ 0.6 color Sable filter 0.1]
    }
}
#declare P_CamoB = pigment {
    bozo
    turbulence 0.5
    color_map {
        [ 0.5 color Brun filter 1 ]
        [ 0.6 color Brun filter 0.1]
    }
}
#declare P_Kaki = pigment {
    bozo
    turbulence 0.1
    color_map {
        [ 0 color Kaki filter 0.5 ]
        [ 0.2 color Kaki filter 0]
    }
}

// ----------------------------
// ---------- Finis -----------
// ----------------------------

#declare F_Mat = finish { diffuse 1 ambient 0 reflection 0 }
#declare F_Brillant = finish { diffuse 0.8 ambient 0 reflection 0.2 specular 0.5 roughness 0.005 }
#declare F_Metallique = finish { diffuse 0.2 ambient 0 reflection 0.8 specular 1 roughness 0.001 metallic }

// ----------------------------
// --------- Textures ---------
// ----------------------------

#declare T_Lignes = texture {
    pigment {
        image_map {
            png "lignes.png"
            once
            interpolate 2
            transmit 0, 1.0
            transmit 1, 0.3
            transmit 2, 0.3
        }
        rotate < 90, 180, 0 >
        scale < 110, 1, 200 >
        translate < 50, 0, 170 >
    }
}
#declare T_Asphalte = texture { pigment { P_Asphalte } finish { F_Mat } }
#declare T_Huile = texture { pigment { P_Huile } finish { F_Mat } }
#declare T_Poussiere  = texture { pigment { P_Poussiere } finish { F_Mat } }
#declare T_Route =
    #ifdef (Textures_Rapides)
        texture { pigment { color GrisFonce } finish { F_Mat } }
    #else
        texture { T_Asphalte scale 0.5 }
        texture { T_Lignes }
        texture { T_Huile scale <8, 1, 20 > }
        texture { T_Poussiere scale < 5, 1, 10 > }
    #end
#declare T_Acier = texture { pigment { color GrisPale } finish { F_Metallique } }
#declare T_Kaki = texture { pigment { P_Kaki } finish { F_Mat } }
#declare T_CamoB = texture { pigment { P_CamoS } finish { F_Mat } }
#declare T_CamoS = texture { pigment { P_CamoB } finish { F_Mat } }
#declare T_Tank =
    #ifdef (Textures_Rapides)
        texture { T_Kaki }
    #else
        texture { T_Kaki scale 0.2 }
        texture { T_CamoS translate < 5, 5, 5 > scale 0.75 } 
        texture { T_CamoB translate < -10, -10, -10 > scale 0.75 }
        texture { T_Huile scale 0.75 }
        texture { T_Poussiere scale 0.25}
    #end
#declare T_Chenille =
    #ifdef (Textures_Rapides)
        texture { T_Acier }
    #else
        texture { T_Acier }
        texture { T_Huile scale 0.25 }
        texture { T_Poussiere scale 0.1}
    #end
#declare T_Etoile = texture {
    pigment {
        image_map {
            png "etoile.png"
            once
            interpolate 2
            transmit 0, 1.0
            transmit 1, 0.5
        }
        translate < -0.5, -0.5, 0 >
        scale 0.5
        rotate < 0, 135, 25 >
    }
}
#declare T_Pantalon = texture { pigment { color GrisFonce } finish { F_Mat } }
#declare T_Cheveux = texture { pigment { color Noir } finish { F_Mat } }
#declare T_Chemise = texture {
    pigment { color Blanc }
    finish { F_Mat }
    #ifndef (Textures_Rapides)
        normal { wrinkles turbulence 0.5 scale 0.5 }
    #end
}
#declare T_Sac = texture {
    pigment { color Sable }
    finish { F_Mat }
    #ifndef (Textures_Rapides)
        normal { wrinkles turbulence 0.5 scale 0.25 }
    #end
}
#declare T_Lampadaire = texture { pigment { color Brun } finish { F_Brillant } }
#declare T_Peau = texture { pigment { color Chair } finish { F_Mat } }
#declare T_Globe = texture { pigment { color JaunePale } finish { F_Mat } }

// ----------------------------
// ---------- Objets ----------
// ----------------------------

// -------- Lampadaire --------

#declare Globe = union {
    sphere { < 0, 0, 0 > 1 translate < 0, 1.75, 0 > texture { T_Globe } }
    difference {
        cylinder { < 0, 0, 0 > < 0, 1, 0 > 0.75 }
        torus { 1, 0.75 }
    }
}
#declare Tube = difference {
    torus { 1, 0.125 }
    box { < -2, -2, -2 > < 2, 2, 0 > }
    rotate -90*x
}
#declare Lampadaire = union {
    cylinder { < 0, 0, 0 > < 0, 8, 0 > 0.25}
    object { Globe translate < 0, 13, 0 > }
    cone { < 0, 10, 0 > 0.75 < 0, 10.5, 0 > 0.5 }
    cone { < 0, 9, 0 > 0.25 < 0, 10, 0 > 0.5 }
    #declare i=0;
    #while (i<360)
        union {
            object { Tube translate < 1, 0, 0 > }
            object { Tube rotate 90*z translate < 1, 2, 0 > }
            object { Tube rotate 180*x translate < 3, 0, 0 > }
            object { Globe translate < 4, 0, 0 > }
            translate < 0, 10, 0 >
            rotate i*y
        }
        #declare i=i+90;
    #end
    #declare i=0;
    #while (i<360)
        union {
            object { Tube scale 1.5 translate < 1.5, 0, 0 > }
            object { Tube scale 1.5 rotate 180*x translate < 4.5, 0, 0 > }
            object { Globe translate < 6, 0, 0 > }
            translate < 0, 7, 0 >
            rotate i*y
        }
        #declare i=i+45;
    #end
    texture { T_Lampadaire } 
} // objet lampadaire

// ----------- Homme ----------

#declare Soulier = box { < -0.125, 0, 0 > < 0.125, 0.25, 0.75 > texture { T_Cheveux } } //Soulier gauche par dfault
#declare Pantalon = union {
    union { //jambe gauche 
        cylinder { < 0, 0, 0 > < 0, -1.375, 0 > 0.25 rotate < 10, 0, 0 > translate < 0, -1.5, 0 > } //jambe
        cylinder { < 0, 0, 0 > < 0, -1.5, 0 > 0.25 } //cuisse
        rotate < 0, 0, -5 >
        translate < -0.25, 3, 0 >
    }
    union { //jambe droite
        cylinder { < 0, 0, 0 > < 0, -1.375, 0 > 0.25 rotate < 5, 0, 0 > translate < 0, -1.5, 0 > } //jambe
        cylinder { < 0, 0, 0 > < 0, -1.5, 0 > 0.25 } //cuisse
        translate < 0.25, 3, 0 >
    }
    union {
        box { < -0.25, 0, -0.25 > < 0.25, .5, 0.25 > } //bassin
        cylinder { < -0.25, 0, 0 > < 0.25, 0, 0 > 0.25 } //fourche
        cylinder { < 0, 0, 0 > < 0, .5, 0 > 0.25 translate < -0.25, 0, 0 > } // hanche gauche
        cylinder { < 0, 0, 0 > < 0, .5, 0 > 0.25 translate < 0.25, 0, 0 > } // hanche droite
        rotate < 5, 0, 0 >
        translate < 0, 2.9, 0 >
    }
    texture { T_Pantalon }
} //Pantalon
#declare Bras = union { //bras gauche
    sphere { < 0, 0, 0 > 0.25 } //epaule
    cone { < 0, 0, 0 > 0.25 < 0, -1, 0 > 0.175 } //manche
    cylinder { < 0, -0.95, 0 > < 0, -1.25, 0 > 0.25 } //manche roulee
    union {
        cone { < 0, -1, 0 > 0.15 < 0, -2, 0 > 0.125 } //bras
        sphere { < 0, -2, 0 > 0.25 scale < 0.5, 1, 1 > } //main
        texture { T_Peau }
    }
} //Bras
#declare Sac = union {
    cone { < 0, 0, 0 > 0.25 < 0, -1, 0 > 0.5 }
    sphere { < 0, 0, 0 > 0.5 scale < 1, 0.25, 1 > translate < 0, -1, 0 > }
    scale < 0.5, 1, 1 >
    texture { T_Sac }
} //Sac
#declare Chemise = union {
    cone { < 0, 1.875, 0 > 0.25 < 0, 2.1, 0 > 0.2 } //col
    difference{
        union {
            box { < -0.25, 0.5, -0.25 > < 0.25, 1.75, 0.25 > } //torse
            cylinder { < -0.25, 0.5, 0 > < -0.25, 1.75, 0 > 0.25 } //cte gauche
            cylinder { < 0.25, 0.5, 0 > < 0.25, 1.75, 0 > 0.25 }//cte droite
        }
        box { < -0.55, 0, -0.26 > < 0, 0.25, 0.26 > rotate < 0, 0, 15 > translate < 0, 1.75, 0 > }
        box { < 0, 0, -0.26 > < 0.55, 0.25, 0.26 > rotate < 0, 0, -15 > translate < 0, 1.75, 0 > }
    }
    difference { //paule gauche
        union {
            cylinder { < -0.4, 0, 0 > < 0.2, 0, 0 > 0.25 }
            cylinder { < -0.4, 0, 0 > < -0.4, -1, 0 > 0.25 }
            box { < -0.4, -1, -0.25 > < 0, 0, 0.25 > }
            rotate < 0, 0, 15 > 
        }
        box { < 0.01, -1, -0.3 > < 0.5, 0.3, 0.3 > }
        translate < 0, 1.75, 0 >
    }
    difference { //paule droite 
        union {
            cylinder { < -0.2, 0, 0 > < 0.4, 0, 0 > 0.25 }
            cylinder { < 0.4, 0, 0 > < 0.4, -1, 0 > 0.25 }
            box { < 0, -1, -0.25 > < 0.4, 0, 0.25 > }
            rotate < 0, 0, -15 >
        }
        box { < -0.01, -1, -0.3 > < -0.5, 0.3, 0.3 > }
        translate < 0, 1.75, 0 >
    }
    union {
        object { Bras }//gauche
        object { Sac rotate < 10, 0, 15 > translate < 0, -2, 0 > }
        rotate < -10, 0, -30 >
        translate < -0.4, 0, 0 >
        rotate < 0, 0, 15 >
        translate < 0, 1.75, 0 >
    }
    object {
        Bras //droit
        rotate < -5, 0, 30 >
        translate < 0.4, 0, 0 >
        rotate < 0, 0, -15 >
        translate < 0, 1.75, 0 >
    }
    texture { T_Chemise }
} //Chemise
#declare Tete = union {
    difference { // cheveux
        sphere { < 0, 0, 0 > 0.6 }
        plane { y, 0 rotate -45*x }
        texture { T_Cheveux }
    }
    sphere { < 0, 0, 0 > 0.5 texture { T_Peau } }
    scale < 0.75, 1, 0.75 >
} //Tete
#declare Homme = union {
    object { Soulier translate < -0.5, 0, -0.25 > } //gauche
    object { Soulier scale < -1, 1, 1 > rotate 15*y translate < 0.25, 0, -0.25 > } //droit
    object { Pantalon }
    object { Chemise rotate < 5, 0, 0 > translate < 0, 2.9, 0 > }
    object { Tete translate < 0, 2.9, 0 > rotate 5*x translate < 0, 2.5, 0 > }
} //Homme

// ------------ Tank ----------
// Note: 1 unit = 1 mtre

#declare Chassis = difference {
    box { < -1.25, 0, 0 > < 1.25, 1, 6 > }
    difference { //Angle avant suprieur
        box { < -2, 0, 0 > < 2, 1, 3 > }
        box { < -1, 0, 0.5 > < 1, 0.1, 0.55 > }
        rotate < -30, 0, 0 >
        translate < 0, 0.5, 0 >
    }
    box { < -2, -1, 0 > < 2, 0, 3 > rotate 30*x translate < 0, 0.5, 0 > } //angle avant infrieur
    box { < -2, -1, -3 > < 2, 0, 0 > rotate -30*x translate < 0, 0.5, 6 > } //angle arrire
    box { < 1, -1, -1 > < 2, 0.8, 7 > } //Puits de roue droit
    box { < -1, -1, -1 > < -2, 0.8, 7 > } //Puits de roue droit
    cylinder { < 0.75, .75, 1.25 > < 0.75, 2, 1.25 > 0.25 } //Trou de l'coutille avant
    #declare i=4.5;
    #while (i<5.5)
        box { < -1, 0.5, i > < 1, 2, i+0.05 > } //grille du moteur
        #declare i=i+0.1;
    #end
    translate < 0, 0.4, -2.5 >
}
#declare Jupe = union {
    difference {
        box { < 0, 0.45, 0.5 > < 0.75, 0.5, 6 > }
        cylinder { < 0.18, 0.5, 0 > < 0.18, 0.5, 7 > 0.01 }
        cylinder { < 0.375, 0.5, 0 > < 0.375, 0.5, 7 > 0.01 }
        cylinder { < 0.57, 0.5, 0 > < 0.57, 0.5, 7 > 0.01 }
    }
    box { < 0, 0, 0.5 > < 0.05, 0.5, 6 > }
    difference { //Avant
        intersection {
            box { < 0, 0, 0 > < 0.75, 0.5, 0.5 > }
            difference {
                cylinder { < -1, 0, 0.5 > < 1, 0, 0.5 > 0.5 }
                cylinder { < 0.05, 0, 0.5 > < 1, 0, 0.5 > 0.45 }
                torus { 0.5, 0.01 rotate z*90 translate < 0.18, 0, 0.5 > }
                torus { 0.5, 0.01 rotate z*90 translate < 0.375, 0, 0.5 > }
                torus { 0.5, 0.01 rotate z*90 translate < 0.57, 0, 0.5 > }
            }
        }
        box { < -1, -1, -1 > < 1, 0, 1 > rotate < 30, 0 , 0 > translate < 0, 0, 0.5 > }
    }
    difference { //Arrire
        intersection {
            box { < 0, 0, 6 > < 0.75, 0.5, 6.5 > }
            difference {
                cylinder { < -1, 0, 6 > < 1, 0, 6 > 0.5 }
                cylinder { < 0.05, 0, 6 > < 1, 0, 6 > 0.45 }
                torus { 0.5, 0.01 rotate z*90 translate < 0.18, 0, 6 > }
                torus { 0.5, 0.01 rotate z*90 translate < 0.375, 0, 6 > }
                torus { 0.5, 0.01 rotate z*90 translate < 0.57, 0, 6 > }
            }
        }
        box { < -1, -1, -1 > < 1, 0, 1 > rotate -30*x translate < 0, 0, 6 > }
    }
} //Jupe
#declare Chainon = union {
    difference {
        box { < 0, 0, -0.0125 > < 0.65, 0.1, 0.0125 > }
        box { < 0.3, 0.075, -1 > < 0.5, 1, 1 > }
        box { < 0.15, -1, -1 > < 0.4, 0.025, 1 > }
    }
    box { < 0, 0.05, -0.08 > < 0.2, 0.075, 0 > }
    box { < 0.45, 0.05, -0.08 > < 0.65, 0.075, 0 > }
    box { < 0.25, 0.05, 0 > < 0.40, 0.075, 0.08 > }
}
#declare Chenille = union {
    //Dessus
    #declare i=0.5;
    #while (i<6)
        object { Chainon rotate 180*x translate < 0.05, 1.125, i > }
        #declare i=i+0.125;
    #end
    union { //Roue dente avant
        #declare a=degrees( atan2( 0.375, 1 ) );
        #declare i=22.5;
        #while (i<180-a)
            object { Chainon translate < 0, -0.375, 0 > rotate -(180+i)*x }
            #declare i=i+22.5;
        #end
        translate < 0.05, 0.75, 0.5 >
    }
    union { //Pente avant
        #declare i=0;
        #while (i<sqrt(1+(0.375*0.375)))
            object { Chainon translate < 0, -0.375, i > }
            #declare i=i+0.125;
        #end
        rotate a*x
        translate < 0.05, 0.75, 0.5 >
    }
    //bas
    #declare i=1.5;
    #while (i<5.25)
        object { Chainon translate < 0.05, 0, i > }
        #declare i=i+0.125;
    #end
    union { //Roue dente arrire
        #declare a=degrees( atan2( 0.375, 0.75 ) );
        #declare i=22.5;
        #while (i<180-a)
            object { Chainon translate < 0, -0.375, 0 > rotate (180+i)*x }
            #declare i=i+22.5;
        #end
        translate < 0.05, 0.75, 6 >
    }
    union { //Pente avant
        #declare i=0;
        #while (i<sqrt(0.75+(0.375*0.375)))
            object { Chainon translate < 0, -0.375, -i > }
            #declare i=i+0.125;
        #end
        rotate -a*x
        translate < 0.05, 0.75, 6 >
    }
    texture { T_Chenille }
}
#declare Roue = union {
    difference { //Roue
        union {
            cylinder { < 0.05, 0, 0 > < 0.25, 0, 0 > 0.3 }
            cylinder { < 0, 0, 0 > < 0.3, 0, 0 > 0.275 }
        }
        cylinder { < 0.2, 0, 0 > < 1, 0, 0 > 0.25 }
    }
    union { //Bras de suspension
        cylinder { < -0.2, 0, -0.5 > < -0.1, 0, -0.5 > 0.15 }
        box { < -0.2, -0.075, -0.5 > < -0.1, 0.075, 0 > }
        cylinder { < -0.2, 0, 0 > < 0, 0, 0 > 0.15 }
        rotate x*25
    }
}
#declare RoueDentee = union {
    difference {
        cylinder { < 0, 0, 0 > < 0.35, 0, 0 > 0.3 }
        cylinder { < 0.20, 0, 0 > < 1, 0, 0 > 0.2 }
        cylinder { < 0.10, 0, 0 > < 1, 0, 0 > 0.05 }
    }
    cylinder { < -0.3, 0, 0 > < 0, 0, 0 > 0.2 } //Axe
    #declare i=0;
    #while (i<360)
        union {
            cylinder { < 0.05, 0.3, 0 > < 0.1, 0.3, 0 > 0.05 }
            cylinder { < 0.25, 0.3, 0 > < 0.3, 0.3, 0 > 0.05 }
            rotate x*i
        }
        #declare i=i+22.5;
    #end
}
#declare Jerrycan = difference {
    union {
        box { < 0, 0, 0 > < 0.35, 0.12, 0.75 > }
        box { < -0.02, 0.02, -0.02 > < 0.37, 0.04, 0.77 > }
        box { < -0.02, 0.06, -0.02 > < 0.37, 0.08, 0.77 > }
    }
    box { < -0.02, 1, -0.3 > < 0.02, 0.1, 0.3 > rotate y*20 translate < 0.175, 0, 0.35 > }
    box { < -0.02, 1, -0.3 > < 0.02, 0.1, 0.3 > rotate -y*20 translate < 0.175, 0, 0.35 > }
}
#declare Phare = union {
    difference {
        union {
            cylinder { < 0, 0, 0 > < 0, 0, 0.1 > 0.1 }
            sphere { < 0, 0, 0.1 > 0.05 }
            cylinder { < 0, -0.2, 0.1 > < 0, 0, 0.1 > 0.05 }
        }
        cylinder { < 0, 0, -1 > < 0, 0, 0.09 > 0.09 }
    }
    difference {
        cylinder { < 0, 0, 0 > < 0, 0, 0.1 > 0.09 }
        sphere { < 0, 0, -0.04 > 0.1 }
        texture { pigment { color Blanc } finish { F_Brillant }
        }
    }
}
#declare Train = union { //ct droit
    object { Jupe translate < 0, 0.75, 0 > }
    object { Phare translate < 0.36, 1.36, 0.85 > }
    object { Jerrycan translate < 0.35, 1.25, 1.25 > }
    object { Jerrycan translate < 0.35, 1.25, 2.25 > }
    box { < 0.35, 1.25, 3.1 > < 0.70, 1.5, 3.6 > } //Bidule-machin-truc
    object { Jerrycan translate < 0.35, 1.25, 3.75 > }
    object { Jerrycan translate < 0.35, 1.25, 4.75 > }
    object { Chenille }
    object { RoueDentee translate < 0.15, 0.75, 0.5 > }
    object { Roue translate < 0.3, 0.375, 1.5 > }
    object { Roue translate < 0.3, 0.375, 2.25 > }
    object { Roue translate < 0.3, 0.375, 3 > }
    object { Roue translate < 0.3, 0.375, 3.75 > }
    object { Roue translate < 0.3, 0.375, 4.5 > }
    object { Roue translate < 0.3, 0.375, 5.25 > }
    object { RoueDentee translate < 0.15, 0.75, 6 > }
} //Train
#macro Ecoutille( Angle )
//Anlge = angle d'ouverture de l'coutille
    union {
        difference {
            cylinder { < 0, 0, 0 > < 0, 0.025, 0 > 0.275 }
            cylinder { < 0, -1, 0 > < 0, 1, 0 > 0.25 }
        }
        difference {
            cylinder { < 0, 0, 0 > < 0, 0.05, 0 > 0.25 }
            box { < 0.05, -1, -0.18 > < 1, 1, 1 > }
            box { < -0.05, -1, -0.18 > < -1, 1, 1 > }
            difference {
                box { < -1, -1, 0 > < 1, 1, 1 > }
                cylinder { < -2, 0, 0 > < 2, 0, 0 > 0.025 }
                translate < 0, 0.025, -0.15 >
            }
        }
        difference {
            cylinder { < 0, 0, 0 > < 0, 0.05, 0 > 0.25 }
            difference {
                box { < -1, -1, -1 > < 1, 1, -0.15 > }
                cylinder { < -2, 0.025, -0.15 > < 2, 0.025, -0.15 > 0.025 }
            }
            box { < -0.06, -1, -1 > < 0.06, 1, -0.12 > }
            translate < 0, -0.025, 0.15 >
            rotate -Angle*x
            translate < 0, 0.025, -0.15 >
        }
    }
#end //Ecoutille
#declare Boite = union {
    box { < 0, 0, 0 > < 0.5, 0.025, 0.1 > }
    cylinder { < 0.1, 0, 0 > < 0.1, 0.05, 0 > 0.02 }
    cylinder { < 0.25, 0, 0 > < 0.25, 0.05, 0 > 0.02 }
    cylinder { < 0.4, 0, 0 > < 0.4, 0.05, 0 > 0.02 }
    cylinder { < 0.1, 0, 0.1 > < 0.1, 0.05, 0.1 > 0.02 }
    cylinder { < 0.25, 0, 0.1 > < 0.25, 0.05, 0.1 > 0.02 }
    cylinder { < 0.4, 0, 0.1 > < 0.4, 0.05, 0.1 > 0.02 }
    cylinder { < -0.5, 0.01, 0.03 > < 0, 0.01, 0.03 > 0.01 }
    cylinder { < -0.5, 0.01, 0.07 > < 0, 0.01, 0.07 > 0.01 }
}
#declare Canon = union {
    intersection { //Base du canon
        cone { < 0, 0, 0 > 0.4 < 0, 0, -0.5 > 0.1 }
        box{ < -0.175, -2, -2 > < 0.175, 2, 0 > }
    }
    cylinder { < 0, 0, 0 > < 0, 0, -2 > 0.08 }
    cylinder { < 0, 0, -2 > < 0, 0, -2.5 > 0.11 }
    difference {
        cylinder { < 0, 0, -2.5 > < 0, 0, -4.5 > 0.075 }
        cylinder { < 0, 0, -2 > < 0, 0, -5 > 0.05 }
    }
}
#declare Montant = difference {
    union {
        box { < -0.01, 0, -0.05 > < 0.01, 0.125, 0.05 > }
        cylinder { < -0.01, 0.125, 0 > < 0.01, 0.125, 0 > 0.05 }
    }
    cylinder { < -1, 0.125, 0 > < 1, 0.125, 0 > 0.025 }
}
#declare Mitrailleuse = union {
    cylinder { < 0, 0, 0 > < 0, 0.5, 0 > 0.025 }
    cylinder { < 0, 0.5, 0 > < 0, 0.52 > 0.06 }
    object { Montant translate < -0.05, 0.52, 0 > }
    object { Montant translate < 0.05, 0.52, 0 > } 
    cylinder { < -0.04, 0.645, 0 > < 0.04, 0.645, 0 > 0.05 }
    box { < -0.04, 0.645, -0.05 > < 0.04, 0.8, 0.05 > }
    cylinder { < -0.02, 0.7, -0.25 > < -0.02, 0.7, 0.2 > 0.02 }
    cylinder { < 0.02, 0.7, -0.25 > < 0.02, 0.7, 0.2 > 0.02 }
    cylinder { < -0.2, 0.7, 0.2 > < 0.2, 0.7, 0.2 > 0.01 }
    cylinder { < 0, 0.77, -0.5 > < 0, 0.77, 0.1 > 0.03 }
    cylinder { < 0, 0.77, -0.75 > < 0, 0.77, -0.5 > 0.01 }
    box { < -0.01, 0.76, -0.7 > < 0.01, 0.8, -0.72 > }
    box { < -0.2, 0, -0.05 > < 0, -0.02, 0.05 > rotate -45*z translate < 0, 0.75, 0 > }
}
#declare Tubes = union {
    box { < 0, 0, 0 > < 0.1, 0.02, 0.5 > }
    union {
        cylinder { < 0, 0, 0 > < 0, 0.2, 0 > 0.03 rotate -30*x translate < 0, 0, 0.1 > }
        cylinder { < 0, 0, 0 > < 0, 0.2, 0 > 0.03 rotate -20*x translate < 0, 0, 0.2 > }
        cylinder { < 0, 0, 0 > < 0, 0.2, 0 > 0.03 rotate -10*x translate < 0, 0, 0.3 > }
        cylinder { < 0, 0, 0 > < 0, 0.2, 0 > 0.03 translate < 0, 0, 0.4 > }
        rotate -30*z
        translate < 0.05, 0.01, 0 >
    }    
}
#macro Tourelle( A_canon, A_ecout2 )
// A_canon = angle du canon
// A_ecout2 = angle de l'coutille de tourelle (0 = ferme, 90 = ouverte)
    union {
        difference {
            union {
                sphere { < 0, 0, 0 > 1.25 }
                intersection {
                    cylinder { < -0.2, 0, 0 > < 0.2, 0, 0 > 1.3 }
                    box { < -1, -2, -2 > < 1, 2, -0.75 > }
                }
                scale < 1, 0.6, 1 > }
            box { < -2, -2, -2 > < 2, 0.01, 2 > }
            box { < -0.18, -2, -2 > < 0.18, 2, -0.8 > }
        }
    object { Canon rotate A_canon*x translate < 0, 0.2, -0.95 > }
    torus { 0.275, 0.4 translate < -0.4, 0.35, 0.3 > }
    object { Ecoutille( 0 ) rotate -y*135 translate < -0.4, 0.75, 0.3 > }
    torus { 0.275, 0.4 translate < 0.4, 0.35, 0.3 > }
    object { Ecoutille( A_ecout2 ) rotate y*10 translate < 0.4, 0.75, 0.3 > }
    cone { < 0.75, 0.4, -0.2 > 0.125 < 0.75, 0.75, -0.2 > 0.02 } //Suport d'antenne
    cylinder { < 0.75, 0.75, -0.2 > < 0.75, 5, -0.2 > 0.01 } //Antenne
    object { Mitrailleuse translate < -0.8, 0.3, -0.2 > }
    object { Tubes translate < 1.15, 0.2, -0.25 > rotate 30*y }
    object { Tubes scale < -1, 1, 1 > translate < -1.15, 0.2, -0.25 > rotate -30*y }
    box { < 1.1, 0.2, -0.25 > < 1.3, 0.5, 0.25 > rotate -45*y }
    }
#end // Tourelle
#macro Tank( A_ecout1, A_ecout2, A_tourelle, A_canon, P_texture )
// A_ecout1 = angle de l'coutille avant (0 = ferme, 90 = ouverte)
// A_ecout2 = angle de l'coutille de tourelle (0 = ferme, 90 = ouverte)
// A_tourelle = angle de rotation de la tourelle
// A_canon = angle du canon
// P_texture = valeur de dplacement de la texture pour que les tanks soient diffrents
    union {
        object { Chassis }
        object { Boite translate < -0.5, 0, 0.15 > rotate < -30, 0, 0 > translate < 0, 0.9, -2.5 > }
        object { Boite translate < -0.5, 0, 0.3 > rotate < -30, 0, 0 > translate < 0, 0.9, -2.5 > }
        object { Phare translate < -0.5, 1.36, -2.1 > }
        object { Phare translate < -0.75, 1.36, -2.1 > }
        object { Ecoutille( A_ecout1) translate < 0.75, 1.4, -1.25 > }
        object { Train scale < -1, 1, 1 > translate < -1, 0, -2.65 > } //gauche    
        object { Train translate < 1, 0, -2.65 > } //droit
        object {
            Tourelle( A_canon, A_ecout2 )                             // La texture doit tre applique sparment pour
            texture { T_Tank translate P_texture + < 0, 1.4, 0.5 > }  // qu'elle ait l'air d'avoir t peinte avec le
            texture { T_Etoile }                                      // canon pointant vers l'avant.
            texture { T_Etoile scale <-1, 1, 1 > }
            rotate A_tourelle*y
            translate < 0, 1.4, 0.5 >
        }
        texture { T_Tank translate P_texture }
        scale 3.2808 //conversion en pieds
    }
#end //Tank