#version unofficial MegaPov 0.5;

#declare Rose = color rgb <1.000,0.529,0.667>;
  
#declare CoqueEcouteur =
union {
 cylinder {<0,0,0>,<0,.1,0>,.5}
 cone {<0,.1,0>,.5,<0,.16,0>,.35}
 cone {<0,.25,0>,.2,<0,.16,0>,.35}
 cylinder {<0,0,0>,<0,.35,0>,.2}
 sphere {<0,0,0>,.2 scale <1,.2,1> translate y*.35}
 cone {<0,.35,0>,.1,<.4,.35,0>,.05}
 sphere {<0,.35,0>,.1}  
  #declare I=0;
  #while (I < 7)
   box {<-.01,-.1,-.1>,<.01,.1,.1> scale <1,1-I*.06,1-I*.06> translate <.1,.35,0>
         translate x*I*.04   
         }
  #declare I = I+1;
  #end
  #declare I=0;
  #while (I < 360)
    sphere {<0,.13,.42>,.02 rotate y*I}
    sphere {<0,.13,.44>,.02 rotate y*I}
    sphere {<0,.13,.40>,.02 rotate y*I}
  #declare I = I+20;
  #end
pigment {Rose}
finish {phong .8}
}                        

#declare MousseEcouteur = union {
 cylinder {<0,0,0>,<0,.4,0>,.5}
 torus {.5 .2 translate y*.2}
 pigment {White*<1.1,.9,.9>}
 finish {crand .1}
}

#declare Ecouteur=
union {
object {CoqueEcouteur translate y*.4}
object {MousseEcouteur}
}

#declare CableSpline3 =
spline {
  cubic_spline
  .0,<0,.8,0>,
  .01,<.01,.8,0>,
  .1,<.8,.7,-.1>,
  .2,<1.5,.5,-1>,
  .3,<-1,.2,-2>,
  
  .4,<-1,.5,-4>,
  .5,<-1.5,.2,-5>,
  .6,<-1.5,.35,-5.5>,
  .7,<-5,.26,-6>,
  .8,<-8,.25,-11>,
  .9,<-7,.1,-12>
  .99,<0,.1,-12>
}

#declare CableSpline4 =
spline {
  cubic_spline
  .0,<0,.8,2>,
  .01,<.01,.8,2>,
  .1,<.8,.7,1.5-.1>,
  .2,<1.5,.9,-.5>,
  .3,<1.5,.2,-2>,
  
  .4,<-1,.5,-4>+.04,
  .5,<-1.5,.2,-5>+.04,
  .6,<-1.5,.35,-5.5>+.04,
  .7,<-5,.26,-6>+.04,
  .8,<-8,.25,-11>+.04,
  .9,<-7,.1,-12>+.04
  .99,<0,.1,-12>+.04  
}

#declare Cable3 = union {
  #local Step=.005;
  #local Actu_Rad = .03;
  #local I=0;   
          #while (I < 1)
            cone {CableSpline3 (I+Step), Actu_Rad,
                  CableSpline3 (I)+rand(r1)*.001, Actu_Rad 
                  }  
          #local I=I+Step;
          #end  
  pigment {Rose} finish {phong .8}          
  }
  
#declare Cable4 = union {
  #local Step=.005;
  #local Actu_Rad = .03;
  #local I=0;   
          #while (I < 1)
            cone {CableSpline4 (I+Step), Actu_Rad,
                  CableSpline4 (I)+rand(r1)*.001,Actu_Rad 
                  }  
          #local I=I+Step;
          #end   
  pigment {Rose} finish {specular .8}          
  }

#declare EcouteursComplets=union {
object {Cable3}
object {Cable4}
object {Ecouteur}
object {Ecouteur rotate y*30 translate z*2}
}
