#version unofficial MegaPov 0.5;
#include "volmac.mac"

//===========================> Variables et Constantes <===================== 
//simplification des textures pour rendu rapide
#declare SimplePig=off;
//angle du panneau de commandes (const, pas touche !)
#declare Angle1=degrees (atan2 (5,17));
//translation verticale de l'appui du levier
#declare NiveauLevier=0;                    
//rotation du bras autour de son axe (entre 0 et 35)
#declare RadialRot=13;                               
//inclinaison du bras (de 0  ...)
#declare AbaisseBras=.9;
//==================================> Textures <=============================
//bois
#declare PigScan = pigment {image_map {png "wood09"}}
#declare ScanMap1 = color_map {
 #declare I=0;
 #while (I < 1)
  [I rgb eval_pigment (PigScan,<I,.5,.5>)]
 #declare I=I+(1/250);
 #end
}
#declare BoisMeublePig = pigment {wood color_map {ScanMap1} scale 15 warp {turbulence .1} scale 2}
#declare Bois_Platine=texture { pigment {BoisMeublePig}
                              normal {pigment_pattern {BoisMeublePig} 1} 
                              finish {phong .4 specular .2}   
                              translate 2
                              rotate <1,1.5,.2>
                              scale .3
                              translate 25
                              }
//chrome
#declare Chrome = texture {pigment {Gray10} finish {reflection .9 phong .9}}
//sillons
#declare SillonTex = 
 texture {pigment {Black}}
 texture {
        pigment {Clear} 
        normal {spherical 5 scale 15 frequency +1}
        finish {phong .9 reflection .0}
        }
 texture {
        pigment {Clear} 
        normal {spherical 5 scale 15 frequency -1}
        finish {phong .9 reflection .0}        
        }
texture {
        pigment {Clear} 
        normal {onion 1 
         slope_map {
                    [0, <1,.5>]  [.1, <.5,1>] [.2, <.2,.8>][.3, <.8,.4>]
                    [.4, <.4,.6>][.5, <.6,.7>][.6, <.7,.5>][.7, <.5,.9>]
                    [.8, <.9,1>] [.9, <1,.2>] [1, <.2,1>]
                    }   
          frequency .8              
        }
        finish {phong .8}        
        }              
texture {
        pigment {Clear} 
        normal {onion 1 
         slope_map {
                    [0, <1,.5>]  [.1, <.5,1>] [.2, <.2,.8>][.3, <.8,.4>]
                    [.4, <.4,.6>][.5, <.6,.7>][.6, <.7,.5>][.7, <.5,.9>]
                    [.8, <.9,1>] [.9, <1,.2>] [1, <.2,1>]
                    }   
          frequency 1              
        }
        finish {phong .7}        
        }       
#declare Silence = .1;
#declare Amorce   = .5;
#declare Sillon = 15 - Amorce;

//==================================> Objets <=============================
//disque
#declare Microsillon = union {
difference {
 cylinder {<0,0,0>,<0,.2,0>,15}
 cylinder {<0,-1,0>,<0,1,0>,.3}
 }
difference {
 cylinder {<0,-.001,0>,<0,.201,0>,4.5}
 cylinder {<0,-1,0>,<0,1,0>,.3}
 pigment {image_map {png "kickinside"} rotate x*90 translate <-.5,0,-.5> scale 9 rotate y*-67}
 normal {bumps .03 scale .2}
 finish {specular .2}
 }
torus {15,.1 translate y*.1}

#while (Sillon > 5.6)
  #declare Increment = rand(r1)*2+.5;
  disc {<0,.2001,0>,y,
        Sillon,
        #if (Sillon - Increment < 5.6)
         5.6
        #else 
         Sillon - Increment
        #end
        texture {SillonTex}
       }   
  #debug "disque !  "             
  #debug str(Sillon,3,3)
 #declare Sillon = Sillon - Increment - Silence;
#end
pigment {Black}
finish {phong .9 reflection .14}
normal {bumps .05 scale 15}
}

#declare Base_Susp = 
intersection {
 object {RoundedBox (<16.5,0,-16.5>,<-16.5,-1,27>,.2)} 
         plane {z,0 rotate y*Angle1 translate z*20}
         pigment {Gray05} finish {phong .8 specular .5 reflection .05}
         normal {bumps .02 scale .3}
         }           
#declare Pan_Commandes =         
intersection {
         box {<17,0,-17>,<-17,-1,27>} 
         plane {z,0 rotate y*Angle1 translate z*20.5 inverse}
         pigment {rgb <1,1,.9>}
         }

#declare Base_Bois =
union {
box {<-17,0,-19>,<-19,6,29> texture {Bois_Platine}}
box {<17,0,-19>,<19,6,29> texture {Bois_Platine}}
box {<17,0,27>,<-17,6,29> texture {Bois_Platine rotate y*90}}
box {<19,0,29.01>,<-19,6,29> texture {Bois_Platine rotate y*90}}//plaquage
box {<17,0,-17>,<-17,6,-19> texture {Bois_Platine rotate y*90}}
box {<19,0,-19.01>,<-19,6,-19> texture {Bois_Platine rotate y*90}}//plaquage
box {<17,0,-17>,<-17,.5,27> texture {Bois_Platine}}//fond
}

#declare Plateau = union {
cylinder {<0,0,0>,<0,1,0>,5}
RoundedCylinder (<0,1,0>,<0,3,0>,15,.1)
cylinder {<0,0,0>,<0,4,0>,.3}
cylinder {<0,3,0>,<0,3.2,0>,15 pigment {Gray20}}//pad
object {Microsillon translate y*3.2}
sphere {<0,4,0>,.3} 
pigment {Gray30} finish {phong .9 reflection .2}
}

#declare Pied=cone {<0,0,0>,1,<0,3,0>,1.5 pigment {Black} finish {phong .8 specular .5}}

#declare BasePivot=
union {
cylinder {<0,0,0>,<0,.8,0>,1.5}
difference {
  cone {<0,.8,0>,1.5,<0,1.3,>,1.2}
  cylinder {<0,.8,0>,<0,1.4,>,.6}
  }
torus {.6 .1 translate y*1.2}
cylinder {<0,0,0>,<0,3,0>,.5}
}

#declare Levier = 
union {
RoundedBox (<0,.8,-.2>,<7,1.3,.2>,.05)
object {RoundedBox (<0,0,-.2>,<-5,.5,.2>,.05) rotate z*8 translate <5,.8,0>}
cylinder {<3.5,.8,0>,<3.5,2.5,0>,.6}
cylinder {<3.5,2.7,0>,<3.5,2.5,0>,.65}
difference {
cylinder {<3.5,2.7,0>,<3.5,3,0>,.3}
cylinder {<3.5,2.7,0>,<3.5,3.1,0>,.25}
}
torus {.25 .05 rotate x*90 translate <3.5,1,1>}
difference {
cylinder {<3.5,1,0>,<3.5,1,1>,.3}
cylinder {<3.5,1,0>,<3.5,1,1.1>,.2}
}
union {            
cylinder {<3.5,3,0>,<3.5,3.5,0>,.2}
cylinder {<3.5,3.4,0>,<3.5,3.5,0>,.25}
translate y*NiveauLevier
}
torus {.5 .1 translate <3.5,.8,0>}
cylinder {<3.5,1,0>,<3.5,1,1.5>,.2}
sphere {<3.5,1,1.5>,.2}
union {//levier
cylinder {<0,0,0>,<0,3,0>,.1}
cone {<0,1.8,0>,.1,<0,2,0>,.15}
cylinder {<0,2,0>,<0,3,0>,.15}
sphere {<0,3,0>,.15}
rotate <30,0,-0> translate <3.5,1,1.5>
}

difference {//quart de cercle
 union {
  cylinder {<0,0,0>,<0,.2,0>,3.7}
  torus {3.45 .1 translate y*.2}
 }
 union {
  cylinder {<0,-1,0>,<0,1,0>,3.2} 
  plane {x,0 rotate y*80}
  plane {x,0 rotate y*150 inverse}
 }
 translate <0,3.5,0>
 translate y*NiveauLevier
}                        

union {//repos
 cylinder {<0,0,0>,<0,3.5,0>,.1} 
 difference {          
  union {
  cylinder {<.5,0,0>,<-.5,0,0>,.5}
  box {<.5,0,.5>,<-.5,.7,-.5>}
  cylinder {<.5,.7,.45>,<-.5,.7,.45>,.05}
  }
  union {
  cylinder {<.6,0,0>,<-.6,0,0>,.4}
  box {<.6,0,.4>,<-.6,1.1,-.7>}
  }
  translate y*3.5
 }
 translate <6.5,1,0>
}
}

#declare Coude = union {
 #declare Cda1=30;
 #declare Cdr1=8;
 intersection
 {
 torus {Cdr1 .4}
 plane {x,0}
 plane {x,0 rotate y*Cda1 inverse}
 translate z*Cdr1
 }
 intersection
 {
 torus {Cdr1 .4}
 plane {x,0}
 plane {x,0 rotate y*Cda1 inverse}
 translate z*Cdr1 scale <-1,1,-1>
 }                      
 rotate y*-Cda1      
 scale <1,1,-1>
}            

#declare PoidsEquil = union {
  difference {
   union {
   cylinder {<.3,0,0>,<1.2,0,0>,2}
   cone {<.3,0,0>,2,<0,0,0>,1.8}
   cone {<1.2,0,0>,2,<1.5,0,0>,1.8}
   }              
   cylinder {<1.6,0,0>,<.8,0,0>,1.6}
   cylinder {<-1,0,0>,<.6,0,0>,1.6}
  }
  cylinder {<.3,0,0>,<1.2,0,0>,.6}
}

#declare Picot = union {
cylinder {<0,0,0>,<.4,0,0>,.04}
sphere {<.4,0,0>,.04}
pigment {rgb <0.871,0.729,0.353>}
finish {reflection .7 reflect_metallic 
        phong .9 metallic}
}           

#declare QuatrePicots = union {
object {Picot translate <0,.2,.2>}
object {Picot translate <0,.2,-.2>}
object {Picot translate <0,-.2,.2>}
object {Picot translate <0,-.2,-.2>}
}

#declare Cellule = union {
  difference {
  RoundedBox (<0,0,-.5>,<1,1.5,.5>,.05)
  cone {<1.1,0,0>,.2,<.7,0,0>,0}
  }
  object {RoundedBox (<0,0,-.5>,<-1,.5,.5>,.05) rotate z*-45}
  RoundedBox (<.5,.5,-.5>,<-1,1.5,.5>,.05)
  cylinder {<0,.8,.65>,<0,1.5,.65>,.25}
  cylinder {<0,.8,-.65>,<0,1.5,-.65>,.25}
  union {
   box {<.05,0,.05>,<0,.01,-.05>}
   box {<-.55,0,.05>,<0,.01,-.05> rotate z*-30}
   cone {<.025,0,0>,.02,<.025,-.05,0>,.01}
   translate <1,-.2,0>
  }
  union {//vis
  cylinder {<0,1,.65>,<0,1.7,.65>,.1}
  cylinder {<0,1,-.65>,<0,1.7,-.65>,.1}
  difference {
         cylinder {<0,1.85,.65>,<0,1.7,.65>,.15}
         box {<-1,1.75,.05>,<1,1.9,-.05> rotate y*30 translate z*.65}            
         }
  difference {
         cylinder {<0,1.85,-.65>,<0,1.7,-.65>,.15}
         box {<-1,1.75,.05>,<1,1.9,-.05> rotate y*30 translate z*-.65}            
         }
    pigment {Gray10} finish {phong .7 reflection .9}
   }
  object {QuatrePicots rotate y*180 translate <-1,1,0>}       
  pigment {rgb <.1,0,.5>} finish {phong .9 reflection .05}
}

#declare PorteCellule = union {
 RoundedCylinder (<0,0,0>,<1,0,0>,.45,.05)
 cylinder {<.2,0,0>,<.8,0,0>,.48}
 cylinder {<0,0,0>,<2,0,0>,.4}
 object {QuatrePicots translate x*2.2}
  union {//fils cellule
   #declare FilCell=
   sphere_sweep {
      catmull_rom_spline_sphere_sweep,5,
       <2.5,.2,.2>,.05,  <2.6,.2,.2>,.05,<2.75,.1,.3>,.05,<2.9,.5,.2>,.05  ,<2.5,.5,.2>,.05
      } 
   object {FilCell pigment {White}}
   object {FilCell pigment {White} translate <0,-.4,-.4>}
   object {FilCell pigment {White} translate <0,-.4,0>}       
   object {FilCell pigment {White} translate <0,0,-.4>}
   finish {phong .9}
   }
 difference {
  union {
   box {<2,1,-1.1>,<2.2,-.5,1.1>}
   box {<2,1,-1.1>,<5.5,.8,1.1>}
   }
   plane {z,0 rotate <18,3,0> inverse translate <2,1,1.1>}
   plane {z,0 rotate <18,3,0> inverse translate <2,1,1.1> scale <1,1,-1>}
   plane {x,0 rotate z*25 inverse translate <5.5,.8,0>}
   cylinder {<4.5,1.5,.65>,<4.5,.5,.65>,.1}
   cylinder {<4.5,1.5,-.65>,<4.5,.5,-.65>,.1}
   cylinder {<3.5,1.5,.65>,<3.5,.5,.65>,.1}
   cylinder {<3.5,1.5,-.65>,<3.5,.5,-.65>,.1}
   box {<3.5,1.5,.75>,<4.5,.5,.55>}
   box {<3.5,1.5,-.75>,<4.5,.5,-.55>}        
   cylinder {<4.5,1.5,.65>,<4.5,.95,.65>,.15}
   cylinder {<4.5,1.5,-.65>,<4.5,.95,-.65>,.15}
   cylinder {<3.5,1.5,.65>,<3.5,.95,.65>,.15}
   cylinder {<3.5,1.5,-.65>,<3.5,.95,-.65>,.15}
   box {<3.5,1.5,.8>,<4.5,.95,.5>}
   box {<3.5,1.5,-.8>,<4.5,.95,-.5>}         
   cylinder {<4.8,1.5,0>,<4.8,.5,0>,.2}
   cylinder {<4,1.5,0>,<4,.5,0>,.2}
   cylinder {<3.2,1.5,0>,<3.2,.5,0>,.2}
   }
 union {
 cylinder {<2.5,.9,0>,<2.5,.9,3>,.1}
 sphere {<2.5,.9,3>,.2}
 translate -<2.5,.9,0> rotate x*-5 translate <2.5,.9,0>
 }
 object {Cellule translate <4.3,-.7,0>}
}

#declare Bras = union {
 cone {<0,0,1>,.5,<0,0,1.2>,.05}
 cylinder {<0,0,1>,<0,0,-1>,.5}
 cone {<0,0,-1>,.5,<0,0,-1.2>,.05}
 cylinder {<-5,0,0>,<10,0,0>,.4}
 cylinder {<-5,0,0>,<-5.1,0,0>,.6}
 object {PoidsEquil translate x*-4}
 object {Coude rotate x*180 translate <14,0,1.072>}
 object {PorteCellule translate <18,0,2.144>}
}

#declare PivotPrincip =
union {
 intersection {
 cylinder {<0,1.5,-1.5>,<0,1.5,1.5>,1.5}
 cylinder {<0,0,-1.6>,<0,0,1.6>,1 scale <1,2,1>}
 cylinder {<0,3.8,-1.2>,<0,3.8,1.2>,3.2 inverse}
 }
 sphere {0,.4 scale <1,1,.2> translate <0,1.5,1.5>}
 sphere {0,.4 scale <1,1,.2> translate <0,1.5,-1.5>}
 object {Bras rotate z*-AbaisseBras translate y*1.5}
}

#declare BrasComplet = union {
object {BasePivot}
object {Levier}
object {PivotPrincip rotate y*RadialRot translate y*3}
pigment {White}  finish {phong .2
                         //reflection .95 
                         //reflection_blur .1 reflection_samples 8
                         }
}

#declare BoutonVitesse = union {
  cylinder {<0,0,0>,<0,1,0>,.2}
  cylinder {<0,.1,0>,<0,.2,0>,1.5}
  cone {<0,.2,0>,1.5,<0,.4,0>,1.2}
  sphere {<1.25,.17,0>,.2 pigment {Red/2}}
  cylinder {<0,2.5,0>,<0,2.51,0>,.9 pigment {White}}
  difference {
  cone {<0,2.5,0>,1,<0,.4,0>,1.2}
   #declare I=0;
   #while (I < 360)
     cone {<1,2.4,0>,.15,<1.2,.5,0>,.25 rotate y*I}
   #declare I=I+30;
   #end
  }    
 cylinder {<0,0,0>,<0,.02,0>,2.5 pigment {Gray10}}
 text {ttf "arial","SPEED",.1,0 align_center scale .5 rotate <90,-90,0> translate <.1,2.52,0> rotate y*-10 pigment {Black}}
 text {ttf "arial","78",.1,0 align_center scale .7 rotate <90,-90,0> translate <-1.7,.05,0> rotate y*-10 pigment {White}}
 text {ttf "arial","45",.1,0 align_center scale .7 rotate <90,-90,0> translate <-1.7,.05,0> rotate y*-50 pigment {White}}
 text {ttf "arial","33",.1,0 align_center scale .7 rotate <90,-90,0> translate <-1.7,.05,0> rotate y*-90 pigment {White}}
 text {ttf "arial","16",.1,0 align_center scale .7 rotate <90,-90,0> translate <-1.7,.05,0> rotate y*-130 pigment {White}}
 pigment {Wheat} finish {phong .9 reflection .2}
} 

#declare BoutonPower = union {
cylinder {<0,0,0>,<0,.3,0>,.8}
torus {.7 .1 scale <1,.3,1> translate y*.3}
cylinder {<0,0,0>,<0,.6,0>,.6}
sphere {0,.6 scale <1,.3,1> translate y*.6}
text {ttf "arial","POWER",.1,0 align_center 
      scale .5 rotate <90,-90,0> translate <1.5,.02,0> pigment {Black}}
pigment {Black}
finish {phong .9}
}

//==================================> Placements <=============================

#declare PlatineComplete = union {
object {Pied translate <16,0,-10>}
object {Pied translate <-16,0,-10>}
object {Pied translate <16,0,23>}
object {Pied translate <-16,0,23>}
object {Base_Bois translate y*3}
object {Base_Susp translate y*9}
object {Pan_Commandes translate y*9}
object {Plateau translate y*9}
object {BrasComplet rotate y*Angle1 translate <-12,9,20>}
object {BoutonVitesse translate <8,9,23>}
object {BoutonPower translate <14,9,23>}
}