#version unofficial MegaPov 0.5;
#include "colors.inc" #include "volmac.mac"

plane {y,0 pigment {MediumForestGreen}}
//camera {location <80,80,60> direction z*1.5 look_at <30,25,15>}
camera {location <80,80,60>*1 direction z*1.5 look_at <30,25,15>}

#declare TapSwitch=on;
#declare BriqueSwitch=on;
#declare PlatineSwitch=on;
#declare EnceinteSwitch=on;
#declare BarbieSwitch=on; 
#declare PochetteSwitch1=on;

#include "ecouteurs.inc"
object {EcouteursComplets rotate y*30 translate <50,45.5,54>}

#include "ampli.inc"
object {AmpliComplet translate <-30,26,50>}

#declare Boucle=0;
#while (Boucle < 1)
    triangle {<rand(r1),rand(r1)*.5,rand(r1)>*1,
              <rand(r1),rand(r1)*.5,rand(r1)>*1,
              <rand(r1),rand(r1)*.5,rand(r1)>*1
              pigment {rgb rand(r1)*.2+.7} translate <rand(r1)*200,.1,rand(r1)*200>+<-50,0,-100>
              }
#declare Boucle=Boucle+.003;
#end

#declare CableSpline1 =
spline {
  cubic_spline
  .0,<.5,.2,-21>,
  .1,<.5,.5,-20>,
  .2,<2,.5,0>,
  .3,<1,5,10>,
  .4,<1,15,12>,
  .5,<1.5,24,15>,
  .6,<-1.5,25,15>,
  .7,<-15,26,17>,
  .8,<-20,25,27>,
  .9,<-20,25,28>
}

#declare CableSpline2 =
spline {
  cubic_spline
  .0,<15,.2,1>,
  .05,<15,.2,0>,
  .1,<5,.5,2>,
  .2,<2,.5,15>,
  .3,<1,5,20>,
  .4,<1,15,20>,
  .5,<1.5,24,20>,
  .6,<-1.5,25,20>,
  .7,<-15,26.5,16>,
  .8,<-25,25,20>,
  .9,<-24,25,28>
   1,<-25,25,30>
}

#declare Cable1 = union {
  #local Step=.005;
  #local Actu_Rad = .2;
  #local I=0;   
          #while (I < 1)
            cone {CableSpline1 (I+Step)+.2*<-1,1,-1>, Actu_Rad,
                  CableSpline1 (I)+rand(r1)*.001+.2*<-1,1,-1>,      Actu_Rad 
                  pigment {Black}
                  }  
            cone {CableSpline1 (I+Step), Actu_Rad,
                  CableSpline1 (I)+rand(r1)*.001,      Actu_Rad 
                  }  

          #local I=I+Step;
          #end   
  pigment {Red} finish {phong .8}          
  }
  
#declare Cable2 = union {
  #local Step=.005;
  #local Actu_Rad = .3;
  #local I=0;   
          #while (I < 1)
            cone {CableSpline2 (I+Step)+.3*<-1,1,-1>, Actu_Rad,
                  CableSpline2 (I)+rand(r1)*.001+.3*<-1,1,-1>,      Actu_Rad 
                  }  
            cone {CableSpline2 (I+Step), Actu_Rad,
                  CableSpline2 (I)+rand(r1)*.001,      Actu_Rad 
                  }  

          #local I=I+Step;
          #end   
  pigment {Gray20} finish {specular .8}          
  }

object {Cable1}
object {Cable2}


#macro PochetteDisque (Image,Couleur,Epaiss,Tordu)
union {

 height_field { png "poch-hf" 
                pigment {image_map {png Image} rotate x*90} finish {phong .7}
                //pigment {Yellow}
                scale <31,Tordu,31> translate y*Epaiss/2}
 height_field { png "poch-hf" 
                pigment {image_map {png Image} rotate x*90} finish {phong .7}
                scale <31,Tordu,31> translate y*-Epaiss/2}
               
 cylinder {<0,0,0>,<31,0,0>,Epaiss/2 scale <1,1,.2> pigment {Couleur}finish {phong .7}}              
 cylinder {<0,0,0>,<31,0,0>,Epaiss/2 scale <1,1,.2> translate z*31 pigment {Couleur}finish {phong .7}}              
 cylinder {<0,0,0>,<0,0,31>,Epaiss/2 scale <.2,1,1> pigment {Couleur}finish {phong .7}}
 }
#end

#if (PochetteSwitch1=on)
union {
object {PochetteDisque ("pc-peau",Gray50,.3,5) rotate x*-80 translate <-3,0,0>}
object {PochetteDisque ("pc-yin",Wheat,.3,5) rotate x*-75 translate z*-3}
object {PochetteDisque ("chatel01",Wheat,.3,5) rotate x*-74 translate z*-4}
object {PochetteDisque ("pc-yin",Wheat,.3,5) rotate x*-73 translate <-1.5,0,-5>}
object {PochetteDisque ("solferin",Wheat,.3,5) rotate x*-72 translate <-.5,0,-6>}
object {PochetteDisque ("calim3",Wheat,.3,5) scale 18/31 rotate x*-71 translate <0,0,-7>}
rotate y*180 translate <0,25,2>
}
object {PochetteDisque ("bush02",White,.3,2) rotate y*-110 translate <80,.2,-30>}
#end
//===========================> Lumires, environnement <=======================
light_source {<8000,9000,-15000>*.2 rgb <1,1,.95>*2.5
              //area_light x*120,z*120,3,3 orient jitter adaptive 1
              }                                   
/*              
light_source {<200,200,200> rgb <.95,.95,1>*1
              area_light x*60,z*60,3,3 jitter adaptive 2
              //shadowless
              }                                   
              
light_source {<200,2,200> rgb <0.282,0.455,0.686>*.2
              shadowless
              }                                   
*/
sky_sphere {pigment {rgb <.8,.8,1>}}              

global_settings {max_trace_level 15 assumed_gamma 1.5
        ini_option "+QR"
        radiosity
                {
                brightness 2
                count 60  //40
                recursion_limit 2
                gray_threshold 0
                error_bound .05 //.05
                pretrace_start .04 //.04
                pretrace_end .01   //.01
                adc_bailout .05
                normal on
                } 
}
fog {Gray20 distance 1500}
//===============================================================================================
//===============================================================================================
//================= TAPIS PLEIN
#declare Plan_Y = function {x*0 + y*1 + z*0}
#declare Taplein = function {sin(x*15)*.1 
                             + cos(z*30)*.01 
                             + noise3d (x*5,y*5,z*5)*.2
                             }

#if (TapSwitch = 1)
 
#declare TapisPlein = 
isosurface { 
  function {Plan_Y
            + Taplein
            }  
  threshold 0   
  contained_by {box{<330,-1,280>,<-200,1,-170>}}
  accuracy .001
  method 2
  //eval
  max_gradient 6
  pigment {color rgb <0.282,0.455,0.686>}
  //finish {phong 1.7}  
  scale 1
  translate y*.2
}

object {TapisPlein}

#else

 box {<330,0,280>,<-200,.1,-170> 
     pigment {color rgb <0.282,0.455,0.686>}
     normal {function {Taplein} .3 sine_wave}
 }//tapis plein simplifi, si l'autre est off

#end //fin TapSwitch

//=========================MURS PIECE
union {
 box {<0,0,-40>,<-40,24.5,250>}
 box {<0,20,-40>,<-80,220,-1.5>}
 box {<-60,20,-10>,<-40,220,250>}
 box {<0,0,-140>,<-400,220,-170>}
 box {<160,0,-140>,<300,220,-170>}
 box {<330,0,-170>,<300,220,250>}
 box {<-150,0,280>,<330,220,250>}
 box {<330,240,280>,<-200,220,-170>}
pigment {White}
}
//=========================OUVRAGE EN BRIQUES
#if (BriqueSwitch=on)
#macro Brique (bx,by,bz)
 intersection {
 box {<0,0,0>,<bx,by,bz> translate -<bx,by,bz>/2}
 box {<0,0,0>,<bx,by,bz> translate -<bx,by,bz>/2 rotate <rand(r1)*3,rand(r1)*3,rand(r1)*3>}
 box {<0,0,0>,<bx,by,bz> translate -<bx,by,bz>/2 rotate <rand(r1)*3,rand(r1)*3,rand(r1)*3>}
 translate <bx,by,bz>/2
 }
 pigment {White}
 normal {wrinkles .2 scale 2 translate <rand(r1),rand(r1),rand(r1)>*50 sine_wave}
#end

union {
 #declare I=0;
 #while (I < 5)
  object {Brique (9,4,19) translate <-8,1,(I*20)-40>} 
  object {Brique (9,4,19) translate <-8,6,(I*20)-30>} 
  object {Brique (9,4,19) translate <-8,11,(I*20)-40>}
 #declare I=I+1;
 #end
}
union {
 #declare I=0;
 #while (I < 20)
  object {Brique (19,9,4) translate <-18,16,(I*5)-32.5>}  
  object {Brique (19,9,4) translate <-18-20,16,(I*5)-30>} 
  object {Brique (19,9,4) translate <-18-40,16,(I*5)-32.5>}   
 #declare I=I+1;
 #end
}
union {
 #declare I=0;
 #while (I < 4)
  object {Brique (9,4,19) translate <-8,26+(I*10),-40>}  
  object {Brique (9,4,19) translate <-8,26+(I*10),-20>}  
  object {Brique (19,4,9) translate <-8-20,26+(I*10),-10>}
  object {Brique (19,4,9) translate <-8-40,26+(I*10),-10>}
    
  object {Brique (9,4,19) translate <-8,31+(I*10),-30>}
  object {Brique (19,4,9) translate <-18,31+(I*10),-10>}
  object {Brique (19,4,9) translate <-18-20,31+(I*10),-10>}        
 #declare I=I+1;
 #end
}
#end //fin BriqueSwitch

//=========================APPAREILS
#if (PlatineSwitch=on)
#include "platine.inc"
object {PlatineComplete rotate y*12 translate <30,0,-3>}
#end                  

#if (EnceinteSwitch=on)
#include "enceinte.inc"
 object {EnceinteDM5 rotate y*40 translate <30,0,63>}
 object {EnceinteDM5 rotate y*0 translate <2.3,0,-35>}
#end

#if (BarbieSwitch=on)
#include "barbie-mp3.inc"
 object {BarbieMP3 scale .8 translate <45,47,45>}
#end
