
// POV-Ray Object File - Glass Objects
// created 26-Nov-00
// last update 29-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "GlassObjects.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// DisplayTable
// StandingFigurine
// FurnaceFigurine
// TinyPedestal
// DioramaGroup
// Chalice1
// WineGlass1
// ChampagneGlass1
// DarkChampagneGlass1
// 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare PlainTex =
	texture {
		pigment {
			color rgb <0.97,0.90,0.92>
		}
		finish { ambient 0.1 specular 0.7 roughness 0.05 }
	}

#declare TableTex =
	texture {
		pigment {
			color rgb <0.757,0.690,0.712>
		}
		finish { ambient 0.1 specular 0.3 roughness 0.05 }
	}

#declare GlassInt =
	interior { ior 1.5 }
#declare GlassFinish = finish { ambient 0.1 specular 0.99 roughness 0.0045 reflection 0.12 }

//#declare ClearGlassColor = color rgbt <0.930,0.935,0.970,0.96>;
#declare ClearGlassColor = color rgbt <0.930,0.935,0.970,0.996>;
#declare LightBlueGlassColor = color rgbf <0.84,0.84,0.97,0.96>;
#declare PinkGlassColor = color rgbf <0.98,0.72,0.72,0.92>;
#declare BlackGlassColor = color rgb<0.002,0.007,0.028>;


#macro GlassMaterial(GlassColor)
	material {
		#if ( WineGlass = on )
			texture {
				pigment { GlassColor }
				finish { GlassFinish }
			}
		interior { GlassInt }
		#else
			texture { PlainTex }
		#end
	}
#end


//===============================================
//             Objects
//===============================================

#declare Chalice1 = 
lathe{
	cubic_spline
	24,
	<0.020000,2.080000>,
	<0.160000,2.080000>,
	<1.000000,1.970000>,
	<1.450000,1.660000>,
	<1.810000,1.170000>,
	<2.050000,0.620000>,
	<2.100000,0.540000>,
	<2.130000,0.620000>,
	<1.950000,1.090000>,
	<1.580000,1.720000>,
	<1.090000,2.100000>,
	<0.550000,2.200000>,
	<0.720000,2.520000>,
	<0.270000,2.720000>,
	<0.210000,3.490000>,
	<0.260000,4.540000>,
	<0.490000,4.760000>,
	<0.430000,4.970000>,
	<0.210000,5.140000>,
	<0.700000,5.300000>,
	<1.220000,5.400000>,
	<1.500000,5.590000>,
	<0.130000,5.580000>,
	<0.010000,5.540000>
	rotate x*-90 // set upright
	translate <0,0,5.6>
	scale <1.05,1.05,0.88>
//	texture { PlainTex } // test
	GlassMaterial(ClearGlassColor)
}

#declare WineGlass1 = 
lathe{
	cubic_spline
	24,
	<0.030000,2.550000>,
	<0.170000,2.550000>,
	<0.330000,2.510000>,
	<0.850000,2.130000>,
	<1.170000,1.280000>,
	<1.280000,0.460000>,
	<1.330000,0.380000>,
	<1.360000,0.460000>,
	<1.280000,1.300000>,
	<1.020000,2.160000>,
	<0.550000,2.610000>,
	<0.220000,2.800000>,
	<0.220000,2.940000>,
	<0.340000,3.040000>,
	<0.180000,3.210000>,
	<0.140000,4.000000>,
	<0.130000,4.700000>,
	<0.230000,5.140000>,
	<0.460000,5.330000>,
	<0.930000,5.430000>,
	<1.200000,5.570000>,
	<0.460000,5.560000>,
	<0.120000,5.470000>,
	<0.000000,5.460000>
	rotate x*-90 // set upright
	translate <0,0,5.6>
	scale <1.08,1.08,1.08>
//	texture { PlainTex } // test
	GlassMaterial(ClearGlassColor)
}

#macro WineGlassC(WColor)
lathe{
	cubic_spline
	24,
	<0.030000,2.550000>,
	<0.170000,2.550000>,
	<0.330000,2.510000>,
	<0.850000,2.130000>,
	<1.170000,1.280000>,
	<1.280000,0.460000>,
	<1.330000,0.380000>,
	<1.360000,0.460000>,
	<1.280000,1.300000>,
	<1.020000,2.160000>,
	<0.550000,2.610000>,
	<0.220000,2.800000>,
	<0.220000,2.940000>,
	<0.340000,3.040000>,
	<0.180000,3.210000>,
	<0.140000,4.000000>,
	<0.130000,4.700000>,
	<0.230000,5.140000>,
	<0.460000,5.330000>,
	<0.930000,5.430000>,
	<1.200000,5.570000>,
	<0.460000,5.560000>,
	<0.120000,5.470000>,
	<0.000000,5.460000>
	rotate x*-90 // set upright
	translate <0,0,5.6>
	scale <1.08,1.08,1.08>
//	texture { PlainTex } // test
	GlassMaterial(WColor)
}
#end

#macro SimpleGlassC(SColor)
lathe{
	cubic_spline
	15,
	<-1,0>,<0,0>,<1,0>,
	<1.1,0.1>,<1.2,0.4>,
	<1.2,4>,<1.2,6>,
	<1.15,6.1>,<1.1,6.0>,
	<1.1,5.9>,<1.1,4.0>,
	<1.0,0.8>,<0.8,0.6>,
	<0.0,0.5>,<-1,0.5>
	rotate x*90 // set upright
	translate <0,0,0>
	scale <1.08,1.08,1.08>
//	texture { PlainTex } // test
	GlassMaterial(SColor)
}
#end

#declare ChampagneGlass1 = 
lathe{
	cubic_spline
	24,
	<0.030000,2.550000>,
	<0.170000,2.550000>,
	<0.330000,2.510000>,
	<0.550000,2.120000>,
	<0.750000,1.290000>,
	<0.760000,0.130000>,
	<0.810000,0.050000>,
	<0.840000,0.130000>,
	<0.860000,1.310000>,
	<0.720000,2.150000>,
	<0.550000,2.610000>,
	<0.220000,2.800000>,
	<0.120000,2.980000>,
	<0.260000,3.110000>,
	<0.140000,3.300000>,
	<0.140000,4.000000>,
	<0.130000,4.700000>,
	<0.210000,5.170000>,
	<0.460000,5.350000>,
	<0.790000,5.460000>,
	<1.060000,5.560000>,
	<0.460000,5.560000>,
	<0.120000,5.470000>,
	<0.000000,5.460000>
	rotate x*-90 // set upright
	translate <0,0,5.6>
	scale <0.9,0.9,1.08>
//	texture { PlainTex } // test
	GlassMaterial(ClearGlassColor)
}

#declare DarkChampagneGlass1 = 
lathe{
	cubic_spline
	19,
	<0.740000,0.910000>,
	<0.710000,0.360000>,
	<0.690000,0.140000>,
	<0.730000,0.080000>,
	<0.780000,0.340000>,
	<0.850000,1.540000>,
	<0.770000,2.210000>,
	<0.550000,2.610000>,
	<0.220000,2.800000>,
	<0.120000,2.980000>,
	<0.120000,3.290000>,
	<0.120000,4.000000>,
	<0.130000,4.700000>,
	<0.210000,5.260000>,
	<0.430000,5.440000>,
	<0.810000,5.520000>,
	<1.060000,5.580000>,
	<0.980000,5.650000>,
	<0.540000,5.580000>
	rotate x*-90 // set upright
	translate <0,0,5.6>
	scale <0.9,0.9,1.08>
//	texture { PlainTex } // test
	GlassMaterial(BlackGlassColor)
}

#declare DisplayTable =
	union {
		box { // tabletop
			<-18,-16,-1>,<0,0,0>
			texture { TableTex }
		}
		box { // base
			<-15,-15,-60>,<-1,-1,-0.99>
			texture { TableTex }
		}
	} // end union

#declare Glass1S =
	merge {
		cylinder {
			<0,0,0>,<0,0,3>,1.1
		}
		sphere {
			<0,0,0>,1.1
			scale <1,1,0.5>
			translate <0,0,3>
		}
		GlassMaterial(LightBlueGlassColor)
	} // end merge
#declare Glass2S =
	merge {
		cylinder {
			<0,0,0>,<0,0,2.1>,0.8
		}
 		sphere {
			<0,0,0>,0.8
			scale <1,1,1>
			translate <0,0,2.1>
		}
		GlassMaterial(PinkGlassColor)
	} // end merge

#declare TinyPedestal =
	merge {
		cone {
			<0,0,0>,1.6,<0,0,1.8>,1.1
		}
 		sphere {
			<0,0,0>,1.1
			scale <1,1,.3>
			translate <0,0,1.8>
		}
		GlassMaterial(PinkGlassColor)
	} // end merge



//--------------- Standing Glassblower Figurine --------------------

// NOTE figurine is modeled full-scale, then scaled down at the end.
// Figure faces -Y

#declare FigurinePipe =
	union {
		sphere_sweep { // pipe
			b_spline_sphere_sweep, 5,
			<   0,   8, 0>, 1.0 // hidden
			<   0,  -6, 0>, 1.0 // start
			< 0.2, -30, 2>, 0.95 // middle is a little crooked
			< -.6, -50, 0>, 0.90 // end
			<   0, -60, 0>, 0.80 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere_sweep { // glass end
			b_spline_sphere_sweep, 5,
			<  0, -45, 0>, 0.8 // hidden
			<  0, -48, 0>, 1.1 // start
			<  0, -50, 1>, 2.2 // middle
			<  0, -52, 0>, 1.5 // end
			<  0, -56, 0>, 0.8 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		texture { PlainTex } // test
//		GlassMaterial(PinkGlassColor)
	} // end union

#declare StandingFigurine =
	merge {
		sphere { // base
			<0,0,0>,1.5*Feet
			scale <1,.7,.15>
			rotate z*-6
			translate <0,0,(1.5*Feet*.15)>
		}
		sphere_sweep { // his left leg and foot
			b_spline_sphere_sweep, 6,
			< 8, -9-3-3, 9>, 1.3 // hidden
			< 8, -6-3, 5>, 1.8 // foot
			< 7,  0-3, 7>, 2 // heel
			< 5, -7, 18>, 3 // knee
			< 3,  0, 32>, 4 // hip
			< 3,  0, 38>, 4 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere_sweep { // his right leg and foot
			b_spline_sphere_sweep, 6,
			<-8, -9+7-3, 9>, 1.3 // hidden
			<-8, -6+7, 5>, 1.8 // foot
			<-7,  0+7, 7>, 2 // heel
			<-5, -5+4, 18>, 3 // knee
			<-3,  0+1, 32>, 4 // hip
			<-3,  0+1, 38>, 4 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere_sweep { // torso
			b_spline_sphere_sweep, 6,
			< 0, 0, 30>, 6 // hidden
			< 0, 0, 36>, 6 // hip
			< 0, 0, 44>, 7 // midsection
			< 0, 1, 54>, 8 // shoulder
			< 0, 2, 59>, 2.5 // neck
			< 0, 2, 62>, 2.5 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
			scale <1,.6,1>
			rotate z*4
		}
		sphere_sweep { // his left arm
			b_spline_sphere_sweep, 5,
			< 8,  2, 62>, 1.8 // hidden
			< 8,  2, 55>, 3.2 // shoulder
			< 9, -7, 48>, 2.5 // elbow
			< 0, -10, 62>, 1.8 // wrist
			<-2, -12, 65>, 1.8 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere { // left hand
			<0,0,0>,4
			scale <.5,1,.7>
			rotate <-72,-23,-4>
			translate <0,-10,62>
		}
		sphere_sweep { // his right arm
			b_spline_sphere_sweep, 5,
			<-8,  -3, 62>, 1.8 // hidden
			<-8,  -2, 55>, 3.2 // shoulder
			<-9, -10, 53>, 2.5 // elbow
			<-1, -18, 65>, 1.8 // wrist
			< 2, -26, 72>, 1.8 // hidden
			sphere_sweep_depth_tolerance 1.0e-3
		}
		sphere { // right hand
			<0,0,0>,4
			scale <.5,1,.7>
			rotate <22,43,34>
			translate <-1,-21,66>
		}
		sphere { // head
			<0,0,0>,5
			scale <.85,1,1>
			rotate <0,10,20>
			translate <0,2,64>
		}
//		texture { PlainTex } // test
		GlassMaterial(LightBlueGlassColor)
	} // end merge

//--------------- Furnace Figurine --------------------
// NOTE figurine is modeled full-scale, then scaled down at the end.

#declare FurnaceFigurine =
	merge {
		difference {
			object { RoundedBox(.2)
				scale <36,24,64>
				translate <0,12,32> // set on ground
			}
			object { RoundedBox(.1)
				scale <12,30,16>
				translate <0,0,44>
			}
		} // end difference
//		texture { PlainTex } // test
		GlassMaterial(PinkGlassColor)
	} // end merge

//--------------- Groups --------------------

#declare FScale = 0.12;
#declare DisplayTableGroup =
	union {
		object { DisplayTable }
//		object { Glass1S translate <-8,-2,0> }

//		object { StandingFigurine rotate z*-160 scale FScale translate <-5,-15,0> }
//		object { FigurinePipe rotate <-5,0,-3> translate <0,4,62> rotate z*-160 scale FScale translate <-5,-15,0> }
//		object { FurnaceFigurine rotate <0,0,0> translate <0,7*Feet,0> scale FScale translate <-5,-15,0> }
		object { StandingFigurine rotate z*-100 scale FScale translate <-5,-5,2> }
		object { FigurinePipe rotate <-5,0,-3> translate <0,4,62> rotate z*-100 scale FScale translate <-5,-5,2> }
		object { TinyPedestal translate <-5,-5,0> }
//		object { FurnaceFigurine rotate <0,0,180> translate <0,-5*Feet,0> scale FScale translate <-5,-5,0> }

		object { Glass2S translate <-12,-3,0> }
		object { Glass2S translate <-11,-12,0> }
	}

#declare DioramaGroup =
	union {
//		object { Glass1S translate <-8,-2,0> }
//		object { StandingFigurine rotate z*-160 scale FScale translate <-5,-15,0> }
//		object { FigurinePipe rotate <-5,0,-3> translate <0,4,62> rotate z*-160 scale FScale translate <-5,-15,0> }
//		object { FurnaceFigurine rotate <0,0,0> translate <0,7*Feet,0> scale FScale translate <-5,-15,0> }
		object { StandingFigurine rotate z*-100 scale FScale translate <-5,-5,2> }
		object { FigurinePipe rotate <-5,0,-3> translate <0,4,62> rotate z*-100 scale FScale translate <-5,-5,2> }
		object { TinyPedestal translate <-5,-5,0> }
//		object { FurnaceFigurine rotate <0,0,180> translate <0,-5*Feet,0> scale FScale translate <-5,-5,0> }

		object { Glass2S translate <-12,-3,0> }
		object { Glass2S translate <-11,-12,0> }
	}
