
// Glenn's POV-Ray Scene File - Glassblowing Workshop
// created 26-Nov-00
// last update 29-Dec-00
// copyright 2000 Glenn McCarter (gmccarter@hotmail.com)

#version unofficial MegaPov 0.6;
//#version 3.1;
global_settings {
	adc_bailout 0.003922
//	ambient_light <1.0,1.0,1.0>
	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.0,0.0,0.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
   // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.

  radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
   // end radiosity section

}


#declare WindowGlass = on; // use window glass, otherwise no glass windows
#declare WineGlass = on; // use clear glasses, otherwise plain texture

#include "Colors.inc"
#include "GIncludeRH.inc" // Glenn's standard includes
//#include "GRuler.inc" // for testing only
#include "GlassObjects.inc" // closeup display table
#include "Furnishings.inc" // desks, benches, tools
#include "Shop.inc" // building architecture
#include "Buildings.inc" // outside environment
#include "Craftsmen.inc" // people
#include "Furnace.inc" // furnaces
#include "GumballMachine.inc" // guess what this is
#include "WorkshopItems.inc" // bucket, pipe rest
#include "Mouse1.inc" // mouse

//===============================================
//             Variables
//===============================================


// Scene origin (Z=0) is at center of the shop.
//#declare CamPos = <32*Feet, -32*Feet, 0>;
// Scene origin (Z=0) is near the camera.
//#declare CamPos = <3*Feet, 3*Feet, 0>;
#declare CamPos = <-0*Feet, -1*Feet, 0>;

#declare Sat = .8; // color saturation

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <1.33333, 0.0,  0.0>  // aspect ratio
		right     <1.8, 0.0,  0.0>  // aspect ratio
		angle 55
	/* // Focal Blur section: uncomment to enable focal blur
		blur_samples 6
		aperture .5    //lower value = wider range in focus
		focal_point <0,0,0>
	*/ // end focal blur
	location CamPos+<0,0,56>
//	look_at <0.0, 0.0, 42>
	look_at <18*Feet, 16*Feet, 29>
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
angle 40
//		location <10*Feet, -45*Feet, 4*Feet> // south, outside
//		look_at <10*Feet, 20*Feet, 45>
//		location <10*Feet, -45*Feet, 24*Feet>
//		look_at <35*Feet, 12*Feet, 10> // snow
//		location <44*Feet, -2*Feet, 6*Feet>
//		look_at <50*Feet, 16*Feet, 50> // elec. box


angle 50
//		location <14*Feet, 25*Feet, 5.4*Feet>
//		look_at <10*Feet, -2*Feet, 45> // annealing oven

//		location <6*Feet, 10*Feet, 5.4*Feet>
//		look_at <0*Feet, -0*Feet, 45> // diorama

//		location <10*Feet, -50*Feet, 28*Feet> // up in front
//		look_at <10*Feet, 20*Feet, 45> // furnace

//		location <16*Feet, 2*Feet, 50> // 
//		look_at <19*Feet, 6*Feet, 45> // front door latch

//		location <17*Feet, 8*Feet, 60> // 
//		look_at <19*Feet, 12*Feet, 60> // register area

//		location <11*Feet, 11.5*Feet, 60> // 
//		look_at <13*Feet, 10*Feet, 52> // cash register keys

//		location <28*Feet, 2*Feet, 80> // 
//		look_at <19*Feet, 4*Feet, 55> // front door lettering

//		location <16*Feet, 16*Feet, 4*Feet> //
//		look_at <14*Feet, 22*Feet, 28> // apprentice side view

//		location <10*Feet, 18*Feet, 4*Feet> //
//		look_at <14*Feet, 22*Feet, 28> // apprentice rear view

//		location <19*Feet, 22*Feet, 4*Feet> //
//		look_at <14*Feet, 22*Feet, 28> // apprentice front view

		location <16*Feet, 23*Feet, 6.2*Feet> //
		look_at <23.5*Feet, 32*Feet, 50> // furnace
	}


camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare SnowDriftTex =
	texture {
		pigment { color rgb <0.8,0.8,1.0>*1.8 }
		finish { ambient <33.0,33.0,37.0> diffuse 0.3 specular .65 roughness .225 }
	}

#declare PoleTex =
	texture {
		pigment { color rgb <.241,.21,.13> }
		finish { ambient .10 specular .65 roughness .125 }
	}


//===============================================
//             Lighting
//===============================================

#declare TestSpot2 =
	light_source { 
		<0,0,0>
		color rgb <0.920,0.963,0.631>*1.1
		spotlight
		point_at <0,0,-100>
		radius 25
		falloff 39
		tightness 3
	}
//object { TestSpot2 rotate <1,-36,0> translate <-5*Feet,-1*Feet,8*Feet> } // local camera test
//object { TestSpot2 rotate <35,-45,0> translate <5*Feet,5*Feet,8*Feet> } // cabinet test
//object { TestSpot2 rotate <0,-20,0> translate <10*Feet,10*Feet,8*Feet> } // cash register test
//object { TestSpot2 translate <10*Feet,18*Feet,9.2*Feet> } // near pole test
//object { TestSpot2 rotate z*180 translate <20*Feet,18*Feet,9.2*Feet> } // far pole test
//object { TestSpot2 translate <15*Feet,6*Feet,7*Feet> } // door ceiling test
//object { TestSpot2 translate <0*Feet,6*Feet,7*Feet> } // display test

#declare TestLight2 =
	light_source { 
		<0,0,0>
		color rgb <0.920,0.963,0.631>*1.1
	}
//object { TestLight2 translate <18*Feet,24*Feet,9*Feet> } // furnace test
//object { TestLight2 translate <16*Feet,4*Feet,4*Feet> } // cabinet test

#declare ShelvesSpot =
	light_source { 
		<0,0,0>
		color rgb <0.920,0.963,0.631>*1.1
		spotlight
		point_at <0,0,-100>
		radius 25
		falloff 39
		tightness 3
	}
object { ShelvesSpot rotate x*35 translate <5*Feet,8*Feet,8*Feet> } // shelves and brick render

#declare ShopSpot =
	light_source { 
		<0,0,0>
		color rgb <0.620,0.763,0.931>*0.62 //  bluish
		area_light <20,0,0>,<0,0,30>,3,6
		adaptive 1
		jitter

		spotlight
		point_at <0,0,-100>
		radius 25
		falloff 49
		tightness 3

//		shadowless
	}
object { ShopSpot rotate <50,0,35> translate <27*Feet,13*Feet,9*Feet> } // render radiosity sim

#declare ApprenticeBackSpot =
	light_source { 
		<-4*Feet,25*Feet,3*Feet>
		color rgb <1.000,0.851,0.361>*0.4 // yellowish
//		area_light <20,0,0>,<0,0,30>,3,6
//		adaptive 1
		jitter
		spotlight
		point_at <14*Feet,22*Feet,3*Feet>
		radius 15
		falloff 29
		tightness 3
		fade_distance 3*Feet
		fade_power 1.5
	}
object { ApprenticeBackSpot } // render radiosity sim

#declare ApprenticeTopSpot =
	light_source { 
		<18*Feet,20*Feet,10*Feet>
		color rgb <0.90,0.851,0.861>*0.7 // yellowish
//		area_light <20,0,0>,<0,0,30>,3,6
//		adaptive 1
		jitter
		spotlight
		point_at <14*Feet,22*Feet,3*Feet>
		radius 10
		falloff 19
		tightness 3
		fade_distance 6*Feet
		fade_power 1.5
	}
object { ApprenticeTopSpot } // render


#declare SBrightness = 0.4; // standard brightness for all bulbs
#declare SDistance = 8*Feet;
#include "InteriorLights.inc"
//object { FakeSpot(<.91,.91,1>,1.1) translate <15*Feet,6*Feet,8*Feet> } // door ceiling test
object { FakeSpotA(<.91,.91,1>,1.1) translate <15*Feet,6*Feet,8*Feet> } // door ceiling render

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.531>*4.3
	}

object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate x*65 // near South horizon, test
  rotate z*30 // South and slightly East
}


//===============================================
//             Environment
//===============================================

background { color rgb <0.2, 0.4, 0.8> } // light blue

sky_sphere { // dusk
	pigment {
		gradient z
		color_map {
			[ 0.03 color rgb <0.70,0.70,0.30> ] // horizon
			[ 0.30 color rgb <0.16,0.18,0.38> ]
		}
	}
}

#declare GroundPlaneSnow =
  plane { z, 0
    texture {
      pigment{color rgb <1.00,1.00,1.00>*2 }
    }
    hollow
  }
object {GroundPlaneSnow translate z*-10}

#declare SnowField1 =
	height_field { // starts extruded into +Y
		png "SnowMaker.png"
		water_level .01
		rotate <90,0,-90> // extrude into +z
		translate <1,1,0> // place on +X+Y plane
		scale <40*Feet,40*Feet/1.3333,10> // scale it up
		texture { SnowDriftTex }
	}
object { SnowField1 rotate <-2,0,10> translate <22*Feet,-5*Feet,0> }

#declare ShadowPole =
	cone {
		<0,0,0>,7,<0,0,25*Feet>,5.6
		texture { PoleTex }
	}
object { ShadowPole translate <46*Feet,-8*Feet,0> }


//===============================================
//             Objects
//===============================================

#declare TestDummy =
	union {
		cylinder {
			<0,0,0>,<0,0,5*Feet>,12
			scale <1,.4,1>
		}
		sphere {
			<0,0,0>,5
			scale <.6,1,1>
			translate <0,0,5.5*Feet>
		}
		texture {
			pigment { color rgb <0.816,0.804,0.733> }
		}
	} // end union

#declare TestDummy2 =
	union {
		sphere {
			<0,0,0>,17
			scale <.81,.81,1>
			translate <0,0,24>
		}
		sphere {
			<0,0,0>,5
			scale <.6,1,1>
			translate <0,0,3.5*Feet>
		}
		texture {
			pigment { color rgb <0.816,0.804,0.733> }
		}
	} // end union



//===============================================
//             Object Placement
//===============================================

object { NextBuilding rotate z*45 translate <60*Feet,7*Feet,-24> }

object { Shop }

object { Furnace rotate z*0 translate <22*Feet,33*Feet,8> }
object { FurnaceLight rotate z*0 translate <22*Feet,33*Feet,8> }
object { AnnealingFurnace rotate z*0 translate <17.3*Feet,33*Feet,0> }
object { PipeRest rotate z*20 translate <23.7*Feet,32*Feet,8> } // main
object { PipeRest scale <1,1,0.8> rotate z*70 translate <29.0*Feet,32*Feet,8> } // far
object { PipeGroup translate <21*Feet,36*Feet-1,8> }

object { FilledBucket rotate z*20 translate <8*Feet,13*Feet,0> }

object { CheckoutCounterGroup rotate z*0 translate <13*Feet,8*Feet,0> }
object { GumballMachine rotate z*-86 translate <18*Feet,7*Feet+4,0> }

object { WorkGroup1 rotate z*97 translate <13*Feet+7,22*Feet,8> } // apprentice
object { WorkGroup1 rotate z*-47 translate <27*Feet,28*Feet,8> } // craftsman
object { FilledShelfGroup translate <24,11*Feet-14,0> }

object { Mouse scale 1.0 rotate z*-60 translate <9.2*Feet,9.5*Feet,0> }



// TESTING ONLY

//object { DisplayTable rotate z*0 translate CamPos+<30,36,45> } // DELETED
//object { Mouse scale 4 rotate z*-0 translate CamPos+<20,26,45> } // DELETED
//object { Mouse scale 4 rotate z*90 translate CamPos+<40,46,55> } // DELETED

//object { Chalice1 translate CamPos + <8,12,52> }
//object { WineGlass1 translate CamPos + <12,8,52> }
//object { ChampagneGlass1 translate CamPos + <12,12,52> }
//object { ChampagneGlass1 translate CamPos + <10,12,52> }
//object { DisplayTable translate CamPos + <20,20,52> }
//box { <0,0,0>,<1,1,6> translate CamPos + <14,8,52> texture { PlainTex }}

//object { Bucket rotate z*20 translate CamPos + <40,40,39> }
//		object { FrontDoorAssy rotate z*90 translate <19*Feet+2,4*Feet,0> }
//object { Blocker2 rotate x*20 rotate y*2 translate <6*Feet,6*Feet,45> }
//object { FakeSpot rotate x*20 rotate y*2 translate <6*Feet,6*Feet,45> }
//object { TestDummy translate <24*Feet,28*Feet,0> }
//object { TestDummy2 translate <14*Feet,22*Feet,0> }
/*

object { Furnace rotate z*-40 translate <55,-11*Feet,0> }
object { AnnealingFurnace rotate z*90 translate <3*Feet,-16*Feet,0> }
object { DisplayTable rotate z*20 translate CamPos+<-16,13,0> }
object { WorkGroup1 rotate z*108 translate <12*Feet,-18*Feet,0> }
*/
//object { TestSphere scale 5 }
