
// POV-Ray Object File - Gumball Machine
// created 16-Dec-00
// last update 16-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "GumballMachine.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// GumballMachine (Ford type)
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#version unofficial MegaPov 0.6;

//===============================================
//             Variables
//===============================================

#declare GRS = seed(39321);

//===============================================
//             Textures
//===============================================

#declare CastIronTex =
	texture {
		pigment {
			color rgb <0.129,0.122,0.106>
		}
		normal { bumps 0.3 scale .25 }
		finish { ambient 0.1 metallic specular 0.7 roughness 0.04 }
	}

#declare GGlassInt =
	interior { ior 1.48 }
#declare GGlassTex =
	texture {
		pigment {
			color rgbt <0.90,0.96,0.92,0.95>
		}
		normal { bumps 0.015 scale 3 }
//		finish { ambient 0.1 diffuse 0.05 specular 0.97 roughness 0.001 reflection 0.18 }
		finish { ambient 0.1 diffuse 0.05 blinn 6 facets 0.04 reflection 0.18 }
	}
#declare GlassGlobeMat =
	material {
		texture { GGlassTex }
		interior { GGlassInt }
	}

#declare StainlessTex =
	texture {
		pigment {
			color rgb <0.819,0.862,0.979>*0.12
		}
		finish { ambient 0.1 metallic specular 0.997 roughness 0.014 reflection 0.77 }
	}

#declare BlackHoleTex =
	texture {
		pigment { color rgb <0.04,0.04,0.06> }
		finish { ambient 0.1 diffuse 0.3 specular 0.1 roughness 0.14 }
	}

#declare GColor1 = rgb<1,1,1>; // white
#declare GColor2 = rgb<.1,1,.1>; // green
#declare GColor3 = rgb<1,1,0>; // yellow
#declare GColor4 = rgb<1,.1,.1>; // red
#declare GColor5 = rgb<.1,.1,1>; //blue
#declare GColor6 = rgb<.1,.1,.1>; // black


//===============================================
//             Objects
//===============================================

//--------------- Gumballs --------------------

#macro Gumball()
	#local ColorNum =int(rand(GRS)*6)+1;
	sphere {
		<0,0,0>,0.33
		texture {
			#if (ColorNum=1) pigment {rgb<1,1,1>} #end // white
			#if (ColorNum=2) pigment {rgb<.1,1,.1>} #end // green
			#if (ColorNum=3) pigment {rgb<1,1,0>} #end // yellow
			#if (ColorNum=4) pigment {rgb<1,.1,.1>} #end // red
			#if (ColorNum=5) pigment {rgb<.1,.1,1>} #end // blue
			#if (ColorNum=6) pigment {rgb<.1,.1,.1>} #end // black
			finish { ambient 0.13 diffuse 0.6 specular 0.9 roughness 0.03 }
		}
	}
#end

//--------------- Globe --------------------

#declare GMGlobe =
	union {
		difference {
			sphere {
				<0,0,0>,4.5
			}
			sphere {
				<0,0,0>,4.38
			}
		} // end difference
		difference {
			cylinder {
				<0,0,0>,<0,0,2>,2.10
			}
			cylinder {
				<0,0,-1>,<0,0,3>,1.98
			}
			translate <0,0,-5>
		} // end difference
		material { GlassGlobeMat }
	} // end union
#declare GMFilledGlobe =
	union {
		object { GMGlobe }
		#local GBC = 1;
		#while (GBC < 400) // main bowl
			object { Gumball()
				translate <0,0,-4.38+0.33>
				rotate <-70+rand(GRS)*140,-12,rand(GRS)*360>
			}
			#declare GBC = GBC + 1;
		#end
		#local GBC2 = 1;
		#while (GBC2 < 100) // top fill
			object { Gumball()
				translate <0,-4.38+0.33+rand(GRS)*4,0>
				rotate <0,12,rand(GRS)*360>
			}
			#declare GBC2 = GBC2 + 1;
		#end
		#local GBC3 = 1;
		#while (GBC3 < 80) // cylinder area
			object { Gumball()
				translate <-1.98+0.33,0,-5.0-rand(GRS)*-2.8>
				rotate <0,0,rand(GRS)*360>
			}
			#declare GBC3 = GBC3 + 1;
		#end
	} // end union

//--------------- Machine --------------------

#declare GMachineTop =
	lathe {
		cubic_spline
		12,
		<1.5,6>,<2.1,6>,<2.2,5.9>,
		<2.4,5.5>,<2.6,5.3>,<3,5.3>,<3.2,5.2>,
		<3.3,4.7>,<3.5,4.65>,<3.55,4.65>,
		<3.6,4.2>,<3.6,4>
		rotate x*90
		texture { StainlessTex }
	}
#declare GMachineBottom =
	union {
		difference {
			lathe {
				cubic_spline
				8,
				<3.2,4.6>,<3.2,4.2>,<3.25,2>
				<3.38,1.3>,<3.8,0.7>,<4,0.5>,<4,0>,<4,-1>
				rotate x*90
			}
			box { // slot
				<-2,-5,0>,<2,0,.15>
				translate <0,0,3.3>
			}
			cylinder { // hole
				<0,-5,0>,<0,0,0>,0.38
				translate <0,0,1.9>
				texture { BlackHoleTex }
			}
		} // end difference
		box { // slider bottom
			<0.25,-3.7,0.04>,<0.25,0,0.13>
			translate <0,0,3.3>
			rotate z*10
		}
		box { // slider
			<0.25,-3.7,0.04>,<0.25,-3.60,0.73>
			translate <0,0,3.3>
			rotate z*10
		}
		difference { // receiver
			sphere {
				<0,0,0>,0.48
				scale <1,2,1>
			}
			sphere {
				<0,0,0>,0.38
				scale <1,2,1>
			}
			box { // cutoff top half
				<-1,-3,0>,<1,3,1>
			}
			translate <0,-3.6,1.8>
		} // end difference
		texture { StainlessTex }
	} // end union
#declare BottomRing =
	torus {
		4.11,0.11
		rotate x*90
		texture { StainlessTex }
	}
#declare GMachine =
	union {
		object { GMachineTop }
		object { GMachineBottom }
		object { BottomRing }
	} // end union


//--------------- Stand --------------------

#declare GMStand =
	union {
		lathe {
			cubic_spline
			11,
			<-1,4>,<0,4>,<1,4>,
			<1.7,3.7>,<2.1,2.4>,<3,1.5>,
			<5,1>
			<8,0.6>,<8.3,0.3>,<8,0.05>,<7,0>
			rotate x*90
			scale <0.85,0.85,0.85>
		}
		cylinder {
			<0,0,0>,<0,0,26>,0.83
		}
		texture { CastIronTex }
	}

//===============================================
//             Groups
//===============================================

#declare GumballMachine =
	union {
		object { GMFilledGlobe translate <0,0,26+6.5+4.1> }
		object { GMachine translate <0,0,26> }
		object { GMStand }
	} // end union


