
// POV-Ray Object File - The Glassblowing Workshop
// created 26-Nov-00
// last update 29-Dec-00
// 2000 Glenn McCarter
//
// This file does not render.  #include "Shop.inc" in another .pov file
// Required #include files: "FrontDoor.inc", "Furnishings.inc"
//
// Objects:
// Shop1 (origin at NW corner)
// Shop2 (origin at SW corner)
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#version unofficial MegaPov 0.6;

#include "FrontDoor.inc"

//===============================================
//             Variables
//===============================================

#declare RS = seed(29835); // random seed


//===============================================
//             Textures
//===============================================

#declare ConcreteFloorTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 color rgb <0.651,0.643,0.592>*.44 ]
				[ 0.5 color rgb <0.651,0.643,0.592>*.20]
				[ 1.0 color rgb <0.651,0.643,0.592>*.44 ]
			}
			scale .2
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness 0.11 }
	}

#declare LinoleumTileTex = // for individual tiles
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 color rgb <0.863,0.788,0.859> ]
				[ 0.5 color rgb <0.463,0.388,0.659> ]
				[ 1.0 color rgb <0.863,0.788,0.859> ]
			}
			scale 2
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.05 }
	}

#declare LinoleumFloorPigment =
		pigment {
			granite
			color_map {
				[ 0.0 color rgb <0.863,0.788,0.859> ]
				[ 0.5 color rgb <0.463,0.388,0.659> ]
				[ 1.0 color rgb <0.863,0.788,0.859> ]
			}
			scale 3/12
		}
#declare GroutPigment =
	pigment {
		color rgb <0.314,0.239,0.129>*.3
	}
#declare LinoleumFloorXPig =
		pigment {
			gradient x
			pigment_map {
				[ 0.00 GroutPigment ]
				[ 0.02 LinoleumFloorPigment ]
			}
			scale 1 // tile size
		}
/*
#declare LinoleumFloorTex = // makes a tile floor
	texture {
		pigment {
			gradient y
			pigment_map {
				[ 0.00 GroutPigment ]
				[ 0.02 LinoleumFloorXPig ]
			}
			scale 12 // tile size
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.05 }
	}
*/
#declare LinoleumFloorTex = // makes a checkerboard floor
	texture {
		pigment {
			checker
				color rgb <0.863,0.788,0.859>
				color rgb <0.863,0.788,0.859>*.83
			scale 12 // tile size
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.05
//			reflection 1.0
//			reflection_blur 0.10
//			reflection_samples 25
		}
	}

#declare PlatformFloorTex =
	texture {
		pigment {
			brick
				color rgb <0.149,0.122,0.086>, // morter
				color rgb <0.227,0.208,0.149> // brick
				brick_size <12,5,3.5>
				mortar 0.5
				rotate x*0
		}
		normal { bumps 0.1 scale 3}
		finish { ambient 0.1 specular 0.1 roughness 0.08 }
	}

#declare PlatformBoardTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 color rgb <0.361,0.329,0.306> ]
				[ 0.50 color rgb <0.361,0.329,0.306>*.6 ]
				[ 1.00 color rgb <0.361,0.329,0.306> ]
			}
			scale <60,60,1>
		}
		normal { bumps 0.2 scale 19 }
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.08 }
	}

#declare CeilingTex =
	texture {
		pigment {
			color rgb <0.463,0.388,0.259>*.73
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.05 }
	}

#declare ShowroomCeilingTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.00 color rgb <0.963,0.988,0.989> ]
			}
		}
		normal {
			gradient y
			slope_map {
      [0.10 <0.0, 0>]   // end of groove, flat
      [0.10 <0.0, 1>]   // end of groove, slope straight up
      [0.20 <1.0, 0>]   // flat slope at top of radius
      [0.80 <1.0, 0>]   // still flat slope at other side of board
      [0.90 <0.0,-1>]   // slope down to bottom of groove
      [0.90 <0.0, 0>]   // flat slope at bottom
      [1.00 <0.0, 0>]   // still flat at bottom center of groove
			}
			scale 6
		}
		finish { ambient 0.15 diffuse 0.6 specular 0.3 roughness 0.03 }
	}

#declare ShowroomCeilingBeamTex =
	texture {
		pigment {
			color rgb <0.963,0.988,0.989>*1.00
		}
		finish { ambient 0.15 diffuse 0.6 specular 0.3 roughness 0.03 }
	}

#declare ShopWallTex =
	texture {
		pigment {
			color rgb <0.463,0.388,0.259>*1.7
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.08 }
	}

#declare ShowroomWallTex =
	texture {
		pigment {
			color rgb <0.989,0.968,0.888>*1.00
		}
		finish { ambient 0.15 diffuse 0.6 specular 0.4 roughness 0.025 }
	}

#declare ShowroomPaintTex =
	texture {
		pigment {
			color rgb <0.989,0.968,0.988>*1.00
		}
		finish { ambient 0.15 diffuse 0.6 specular 0.87 roughness 0.04 }
	}

#declare BrickWallTex =
	texture {
		pigment {
			brick
				color rgb <0.812,0.776,0.718> // morter
				color rgb <0.553,0.204,0.180> // brick
				brick_size <8,3,4.5>
				mortar 0.4
				rotate x*90
		}
//		normal { bumps 0.1 scale 3}
		normal {
			brick .05
			brick_size <8,3,4.5>
			mortar 0.4
			rotate x*90
		}

		finish { ambient 0.1 specular 0.1 roughness 0.08 }
	}


#declare WindowFrameTex =
	texture {
		pigment {
			color rgb <0.963,0.988,0.959>*1.0
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.6 roughness 0.05 }
	}

#declare WindowGlassInt =
	interior { ior 1.45 }
#declare WindowGlassSTex = // simple version, no reflection
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.96>
		}
		normal { bumps 0.035 scale 5 }
		finish { ambient 0.1 specular 0.99 roughness 0.015 }
	}
#declare WindowGlassSMat =
	material {
		texture { WindowGlassSTex }
		interior { WindowGlassInt }
	}
#declare WindowGlassTex = // better version
	texture {
		pigment {
			color rgbf <0.9,0.9,0.9,0.96>
		}
		normal { bumps 0.035 scale 5 }
		finish { ambient 0.1 specular 0.99 roughness 0.015 reflection 0.17 }
	}
#declare WindowGlassMat =
	material {
		texture { WindowGlassTex }
		interior { WindowGlassInt }
	}
#declare ClearGlassTex = // high quality plate glass version
	texture {
		pigment {
			color rgbt <0.90,0.96,0.92,0.96>
		}
		normal { bumps 0.015 scale 16 }
		finish { ambient 0.1 diffuse 0.1 specular 0.999 roughness 0.00001 reflection 0.03 }
	}
#declare ClearGlassMat =
	material {
		texture { ClearGlassTex }
		interior { WindowGlassInt }
	}

#declare ThresholdTex =
	texture {
		pigment {
			color rgb <0.294,0.251,0.176>
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.075 }
	}
#declare DoorHingeTex =
	texture {
		pigment {
			color rgb <0.482,0.494,0.298>
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.62 roughness 0.025 }
	}
#declare ShopDoorTex =
	texture {
		pigment {
			color rgb <0.545,0.463,0.325>
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.2 roughness 0.075 }
	}

//===============================================
//             Macros
//===============================================

#macro TiledWindow(Xlength,Zheight,Xpanes,Zpanes,BarThickness,Quality)
// Window is in XZ plane, with glass centered on Y=0
	#local BT = BarThickness;
#switch ( Quality )
#case ( false ) // use low quality: single pane of glass
	union {
		difference {
			box { // outer frame
				<0,-BT/2,0>,<Xlength,BT/2,Zheight>
			}
			box { // cutout
				<BT/2,-2,BT/2>,<Xlength-BT/2,2,Zheight-BT/2>
			}
		} // end difference
/*
		#local VB = 1;
		#while ( VB < Xpanes ) // vertical bars
			box { <-BT/2,-BT/2,0>,<BT/2,BT/2,Zheight>
				translate <VB*Xlength/Xpanes,0,0>
			}
			#local VB = VB + 1;
		#end

		#local HB = 1;
		#while ( HB < Zpanes ) // horozontal bars
			box { <0,-BT/2,-BT/2>,<Xlength,BT/2,BT/2>
				translate <0,0,HB*Zheight/Zpanes>
			}
			#local HB = HB + 1;
		#end
		box { // glass
			<0,-0.065,0>,<Xlength,0.065,Zheight>
			material { WindowGlassSMat }
		}
*/
		texture { WindowFrameTex }
	} // end union
#break
#else // use individual panes of glass, good quality
	union {
		difference {
			box { // outer frame
				<0,-BT/2,0>,<Xlength,BT/2,Zheight>
			}
			box { // cutout
				<BT/2,-2,BT/2>,<Xlength-BT/2,2,Zheight-BT/2>
			}
		} // end difference

		#local VB = 1;
		#while ( VB < Xpanes ) // vertical bars
			box { <-BT/2,-BT/2,0>,<BT/2,BT/2,Zheight>
				translate <VB*Xlength/Xpanes,0,0>
			}
			#local VB = VB + 1;
		#end
		#local HB = 1;
		#while ( HB < Zpanes ) // horozontal bars
			box { <0,-BT/2,-BT/2>,<Xlength,BT/2,BT/2>
				translate <0,0,HB*Zheight/Zpanes>
			}
			#local HB = HB + 1;
		#end
		#local Hglass = 0;
		#while ( Hglass < Xpanes )
			#local Vglass = 0;
			#while ( Vglass < Zpanes )
				box {
					<0,-0.065,0>,<Xlength/Xpanes,0.065,Zheight/Zpanes>
					material { WindowGlassMat translate <rand(RS)*30*Feet,0,rand(RS)*30*Feet> }
					translate <Hglass*Xlength/Xpanes,0,Vglass*Zheight/Zpanes>
				}
				#local Vglass = Vglass + 1;
			#end
			#local Hglass = Hglass + 1;
		#end
/*
		box { // glass
			<0,-0.065,0>,<Xlength,0.065,Zheight>
			material { WindowGlassMat }
		}
*/
		texture { WindowFrameTex }
	} // end union
#end
#end
//object { TiledWindow(58,36,6,3,0.55) translate <12*Feet,20*Feet,42> } // test

#macro Molding(Type,Length,Cut45)
// Molding runs along +X from origin
	difference {
		prism {
			cubic_spline,
			0,Length,11
			<-1,0>,<0,0>,<0.6,0>,<0.7,0.2>,<0.6,0.4>,
			<0.3,1.8>,<0.2,3.0>,<0.0,3.0>,<-0.1,2.9>,<-0.1,1.5>,<0,0>
			rotate z*-90
		}
		box { <0,-1,0>,<1,1,10> }
		texture { ShowroomPaintTex }
	} // end difference
#end

//===============================================
//             Floors
//===============================================

#declare Platform =
	box {
		<0,0,0>,<30*Feet,30*Feet,8>
		texture { PlatformFloorTex }
	}
#declare PlatformBoard =
	box {
		<0,-1.5,0>,<30*Feet,0,8.05>
		texture { PlatformBoardTex }
	}

#declare ConcreteFloor =
	box {
		<-20*Feet,0,-1>,<30*Feet,30*Feet,0>
		texture { ConcreteFloorTex }
	}


#declare ShowroomFloorS = // simple version
	box {
		<0*Feet,0,-0.5>,<30*Feet,12*Feet,0.15>
		texture { LinoleumFloorTex }
	}
/*
	#local XTLength = 30*Feet;
	#local YTLength = 13*Feet;
	#local TileX = 12;
	#local TileY = 12;
	#local GroutWidth = 0.45;
	#local XC = 0;
	union {
	#while ( XC < XTLength/TileX )
		#local YC = 0;
		#while ( YC < YTLength/TileY )
			box {
				<0,0,-0.5>,<TileX-GroutWidth,TileY-GroutWidth,0>
				texture { LinoleumFloorTex }
				rotate <-1+rand(RS)*2,-1+rand(RS)*2,-3+rand(RS)*6>
				translate <XC*TileX,YC*TileY,0>
			}
			#local YC = YC + 1;
		#end
		#local XC = XC + 1;
	#end
	} // end union
*/
#declare ShowroomFloor = // fancy version with random tiles
	#local XTLength = 30*Feet;
	#local YTLength = 13*Feet;
	#local TileX = 12;
	#local TileY = 12;
	#local GroutWidth = 0.45;
	#local XC = 0;
	union {
	#while ( XC < XTLength/TileX )
		#local YC = 0;
		#while ( YC < YTLength/TileY )
			box {
				<0,0,-0.5>,<TileX-GroutWidth,TileY-GroutWidth,0>
				texture { LinoleumTileTex }
				rotate <-1+rand(RS)*2,-1+rand(RS)*2,-3+rand(RS)*6>
				translate <XC*TileX,YC*TileY,0>
			}
			#local YC = YC + 1;
		#end
		#local XC = XC + 1;
	#end
	} // end union



//===============================================
//             Ceilings
//===============================================

#declare ShowroomCeiling =
	union {
		box { // local
			<-10*Feet,-3.5*Feet,0>,<19*Feet,12*Feet,1>
			translate <0,0,8> // set above beam
			texture { ShowroomCeilingTex }
		}
		box { // beam main
			<-10*Feet,0,0.5>,<19*Feet,4,24>
			translate <0,12*Feet-4,0>
		}
		box { // beam lower side
			<-10*Feet,0.5,0>,<19*Feet,4-0.5,10>
			translate <0,12*Feet-4,0>
		}
		cylinder { // beam near radius
			<-10*Feet,0.5,0.5>,<19*Feet,0.5,0.5>,0.5
			translate <0,12*Feet-4,0>
		}
		cylinder { // beam far radius
			<-10*Feet,3.5,0.5>,<19*Feet,3.5,0.5>,0.5
			translate <0,12*Feet-4,0>
		}
		translate <0,0,8*Feet>
		texture { ShowroomCeilingBeamTex }
	} // end union

#declare AngledCeilingS2=
	box { // main
		<-10*Feet,0,0>,<30*Feet,-22*Feet,1>
		texture { CeilingTex }
		rotate x*-18
		translate <0,30*Feet,8*Feet>
	}
#declare WorkshopCeiling =
	box { // main
		<-10*Feet,0,0>,<30*Feet,-18.6*Feet,1>
		texture { CeilingTex }
		translate <0,30*Feet,18*Feet>
	}



//===============================================
//             Walls
//===============================================

#declare NorthWallS1 =
	union {
		difference {
			box { // main wall
				<0,0,0>,<40*Feet,4,8*Feet>
			}
			box { // west window cutout
				<0,-8,0>,<4*Feet,8,3*Feet>
				translate <4*Feet,0,42>
			}
		} // end difference
		texture { ShopWallTex }
	} // end union

#declare NorthWallS2 =
	union {
			box { // main wall
				<-10*Feet,0,0>,<25*Feet,4,20*Feet>
			}
			box { // far door
				<0,0,0>,<5*Feet,4,20*Feet>
				translate <25*Feet,4*Feet,0>
			}
		texture { ShopWallTex }
	} // end union


//--------------- North Showroom Wall --------------------

#declare NorthShowroomWall =
	union {
		difference {
			height_field { // starts extruded into +Y
				png "BrickHF2.png"
				water_level .01
				scale <1,-1,1> // extrude into -Y
				scale <40*Feet,1.6,40*Feet/1.3333> // scale it up
//				texture { ShowroomWallTex } // test
/*
				texture {
					pigment {
						image_map { // projected from -Z
							png "BrickColorMap2.png"
							once
						}
						rotate <90,0,0> // orient to wall
						scale <40*Feet,1,40*Feet/1.3333> // scale to wall
					}
				}
*/
//				translate <-20*Feet,1,0> // set in shop
				translate <-9*Feet+1.2,1,-0.5> // set in shop, includes east outside wall
			}
			plane { // cut off back side of height_field
				-y,-6
			}
			box { // double door cutout
				<0,-8,-1>,<6*Feet,18,6*Feet+8>
				translate <7*Feet,0,0>
			}
			box { // window cutout
				<0,-8,0>,<4*Feet,18,22>
				translate <14*Feet+1,0,48>
			}
			box { // outside door cutout
				<0,-8,-1>,<3*Feet,18,6*Feet+8>
				translate <24*Feet,0,0>
			}

		} // end difference
		#if (WindowGlass = 1)
		box {
			<-1,0,-1>,<4*Feet+1,0.1,22+1>
			translate <14*Feet+1,2,48>
			material { ClearGlassMat }
		}
		#end
//		texture { BrickWallTex }

				texture {
					pigment {
						image_map { // projected from -Z
							png "BrickColorMap2.png"
							once
						}
						rotate <90,0,0> // orient to wall
						scale <40*Feet,1,40*Feet/1.3333> // scale to wall
					}
					normal { granite 1 scale 1.1 }
					finish { ambient 0.1 crand 0.08 specular 0.08 roughness 0.012 }
					translate <-9*Feet+1.2,4,-0.5> // set in shop
				}

	} // end union

//--------------- West Wall --------------------

#declare WestWallS1 =	
	box {
		<0,-40*Feet,0>,<4,4,8*Feet>
		texture { ShopWallTex }
	}

//--------------- East Wall (furthest East) --------------------

#declare FarEastWall =
	union {
		difference { // far wall
			box {
				<0,0,0>,<4,40*Feet,20*Feet>
			}
			box { // window cutout
				<-1,0,50>,<5,42,7.0*Feet>
				translate <0,5*Feet,0>
			}
			box { // window cutout
				<-1,0,50>,<5,42,7.0*Feet>
				translate <0,13*Feet,0>
			}
		} // end difference
		//#macro TiledWindow(Xsize,Zheight,Xpanes,Zpanes,BarThickness)
		// Window is in XZ plane, with glass centered on Y=0
		object { TiledWindow(42,7.0*Feet-50,5,3,0.55,true)
			rotate z*90
			translate <2,5*Feet,50>
		}
		object { TiledWindow(42,7.0*Feet-50,5,3,0.55,true)
			rotate z*90
			translate <2,13*Feet,50>
		}
		texture { ShopWallTex }
	} // end union


//--------------- East Wall (near) --------------------

#declare NearEastWall =
	union {
		difference {
			box { // main
				<0,-3*Feet,0>,<6,12*Feet,10*Feet>
			}
			box { // door cutout
				<-1,0,-1>,<8,3*Feet,7*Feet>
				translate <0,4*Feet,0>
			}
			box { // window cutout
				<-1,0,42>,<8,3*Feet,6.5*Feet>
				translate <0,7.5*Feet,0>
			}
		} // end difference
		#if (WindowGlass = 1)
		object { TiledWindow(3*Feet,6.5*Feet-42,5,3,0.55,true)
			rotate z*90
			translate <4,7.5*Feet,42>
		}
		object { WindowShade(3*Feet+2,6)
			rotate z*-90
			translate <0,10.5*Feet+1,6.5*Feet+2>
		}
		#end
		object { SmallSign
			rotate <90,0,-90>
			translate <-0.2,11*Feet+6,54>
		}
		texture { ShowroomWallTex }
	} // end union


//--------------- South Wall (east part) --------------------
/*
#declare SouthWallS2 = // origin relative to East wall
	union {
		difference {
			box { // main
				<-11*Feet,0,0>,<0,4,10*Feet>
			}
			box { // door cutout
				<0,-1,-1>,<3*Feet,5,6*Feet+8>
				translate <-6*Feet,0,0>
			}
		} // end difference
		texture { BrickWallTex }
	} // end union
*/
//--------------- Main South Wall --------------------

#declare MainSouthWall =
	union {
		difference {
			box { // main
				<-20*Feet,0,0>,<19.5*Feet,4,10*Feet>
			}
/*
			box { // door cutout
				<0,-1,-1>,<3*Feet,5,7*Feet>
				translate <15*Feet,0,0>
			}
*/
			box { // east window cutout
				<0,-1,0>,<4*Feet,5,60>
				translate <13*Feet,0,28>
			}
			box { // middle window cutout
				<0,-1,0>,<4*Feet,5,60>
				translate <8*Feet,0,28>
			}
			box { // west window cutout
				<0,-1,0>,<4*Feet,5,60>
				translate <3*Feet,0,28>
			}
		} // end difference
		#if (WindowGlass = 1)
		object { // east window
			TiledWindow(4*Feet,60,5,5,0.55,true)
			translate <13*Feet,2,28>
		}
		object { // middle window
			TiledWindow(4*Feet,60,5,5,0.55,true)
			translate <8*Feet,2,28>
		}
		object { // west window
			TiledWindow(4*Feet,60,5,5,0.55,true)
			translate <3*Feet,2,28>
		}
		#end
		texture { ShowroomWallTex }
	} // end union

//--------------- South Upper Wall --------------------

#declare SouthUpperWall =
	union {
		difference {
			box { // main
				<-20*Feet,0,0>,<30*Feet,4,10*Feet>
			}
			box { // wester window cutout
				<0,-1,0>,<3*Feet,5,58>
				translate <7*Feet,0,28>
			}
			box { // west window cutout
				<0,-1,0>,<3*Feet,5,58>
				translate <12*Feet,0,28>
			}
			box { // east window cutout
				<0,-1,0>,<3*Feet,5,58>
				translate <20*Feet,0,28>
			}
			box { // easter window cutout
				<0,-1,0>,<3*Feet,5,58>
				translate <25*Feet,0,28>
			}
		} // end difference
		#if (WindowGlass = 1)
		object { // wester window
			TiledWindow(3*Feet,58,5,5,0.55,true)
			translate <7*Feet,2,28>
		}
		object { // west window
			TiledWindow(3*Feet,58,5,5,0.55,true)
			translate <12*Feet,2,28>
		}
		object { // east window
			TiledWindow(3*Feet,58,5,5,0.55,true)
			translate <20*Feet,2,28>
		}
		object { // easter window
			TiledWindow(3*Feet,58,5,5,0.55,true)
			translate <25*Feet,2,28>
		}
		#end
		translate <0,0,9.96*Feet>
		texture { ShowroomWallTex }
	} // end union



//===============================================
//             Other Stuff
//===============================================

#declare Pillar =
	union {
		box {
			<-4,-4,0>,<4,4,20*Feet>
		}
		box {
			<-4.6,-4.6,0>,<4.6,4.6,1.2*Feet>
		}
		texture { ShopWallTex }
	} // end union


//	Door opening size:
//	<0,-8,-1>,<6*Feet,8,6*Feet+8>
//	translate <7*Feet,0,0>
#declare ShopDoorFrame =
	union {
		cylinder { // threshold
			<0,2,0>,<6*Feet,2,0>,2.6
			scale <1,1,.1>
			texture { ThresholdTex }
		}
/*
		box { // threshold
			<0,0,0>,<6*Feet,4,0.5>
			texture { ThresholdTex }
		}
*/
		box { // left frame
			<0,-5/8,0>,<5/8,4+5/8,6*Feet+8>
		}
		box { // right frame
			<-5/8,-5/8,0>,<0,4+5/8,6*Feet+8>
			translate <6*Feet,0,0>
		}
		box { // right frame inside trim door stop
			<-1/2,-7/8,5/8>,<0,0,6*Feet+8>
			translate <6*Feet-5/8,2,0>
		}
		box { // top frame
			<0,-5/8,-5/8>,<6*Feet,4+5/8,0>
			translate <0,0,6*Feet+8>
		}
		box { // top frame inside trim door stop
			<0,-7/8,-7/8>,<6*Feet,0,0>
			translate <0,2,6*Feet+8>
		}
		texture { ShopDoorTex }
	} // end union
#declare DoorHinge =
	union {
		box {
			<-0.130,-1.1,0>,<-0.05,0,3.25>
		}
		cylinder {
			<0,0,0>,<0,0,3.25>,0.175
		}
		texture { DoorHingeTex }
	} // end union

#macro ShopDoor(OpenAngle) // note only RH door is visible and modeled
	union {
		box { // main
			<-3*Feet,-1.25,0.6>,<-0.1,0,6*Feet+8-5/8-0.2>
			translate <-0.15,-0.65,0> // set pivot point
			texture { ShopDoorTex }
		}
		object { DoorHinge translate <0,0,9> }
		box { <0.05,-1.1,0>,<0.130,0,3.25> rotate z*OpenAngle translate <0,0,9>  texture { DoorHingeTex } }
		object { DoorHinge translate <0,0,39> }
		box { <0.05,-1.1,0>,<0.130,0,3.25> rotate z*OpenAngle translate <0,0,39> texture { DoorHingeTex } }
		object { DoorHinge translate <0,0,69> }
		box { <0.05,-1.1,0>,<0.130,0,3.25> rotate z*OpenAngle translate <0,0,69> texture { DoorHingeTex } }
		rotate z*-OpenAngle                
	} // end union
#end
#declare ShopDoorAssy =
	union {
		object { ShopDoorFrame translate <7*Feet,0,0> }
		object { ShopDoor(140) translate <7*Feet+6*Feet-5/8-0.10,4,0> }
	} // end union



//===============================================
//             Assemblies
//===============================================


#declare Shop =
	union {

		object { ConcreteFloor translate <0,12*Feet,0> }
		object { ShowroomFloorS translate <-10.2*Feet,0,0> }
		object { ShowroomCeiling }

//		object { AngledCeilingS2 }
		object { WorkshopCeiling }
//		object { NorthWallS2 translate <0,26*Feet,0> }
		object { NorthWallS2 translate <10*Feet,36*Feet,0> }
		object { FarEastWall translate <30*Feet,12*Feet,0> }
		object { NearEastWall translate <19*Feet,0,0> }
//		object { SouthWallS2 translate <30*Feet,12*Feet,0> }
		object { Pillar translate <8*Feet,18*Feet,0> }
		object { Pillar translate <22*Feet,18*Feet,0> }
//		object { Platform translate <0,15*Feet,0> }
		object { Platform translate <5*Feet,19*Feet,0> }
//		object { PlatformBoard translate <0,15*Feet,0> }
		object { PlatformBoard translate <5*Feet,19*Feet,0> }

		object { NorthShowroomWall translate <0,12*Feet,0> }

		object { ShopDoorAssy translate <0,12*Feet,0> }

		object { MainSouthWall translate <0,-3.5*Feet,0> }
		object { SouthUpperWall translate <0.1,12*Feet,0> }

		object { FrontDoorAssy rotate z*90 translate <19*Feet+2,4*Feet,0> }
		object { WelcomeMat rotate z*92 translate <17*Feet+5,5.2*Feet,0> }

	}


