
// Glenn's POV-Ray Scene File - Snow Maker
// created 31-Dec-00
// last update 31-Dec-00
// 2000 Glenn McCarter (gmccarter@hotmail.com)
//


//#include "Colors.inc"
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version unofficial MegaPov 0.6;
//#version 3.1;

global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
}

//===============================================
//             Variables
//===============================================

#declare SnowX = 20*Feet;
#declare SnowZ = SnowX/1.33333;

// Image can be rendered twice.
// Once for the color map, once (in greyscale) for the height field
#declare ColorOn=0; // turn on color version for color map, otherwise use greys for heightfield


//===============================================
//             Cameras
//===============================================

#declare Closeup_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//	angle 6
	angle 36
//	location  <0.01*Feet, -30*Feet, 0.01*Feet>
	location  <4.01*Feet, -8*Feet, 4.01*Feet>
//	location  <8.01*Feet, -.61*Feet, 4.01*Feet>
	look_at <0,0,0>
//	location  <WallLength/2, -30*Feet, WallHeight/2>
//	look_at <WallLength/2, 0, WallHeight/2>
}

#declare Parallel_Cam =
	camera {
		orthographic

		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  SnowZ>  // full wall
		right     <SnowX, 0.0,  0.0>
//		up        <0.0,     0.0,  WallHeight/20>  // test small patch
//		right     <WallLength/20, 0.0,  0.0>
//	location  <WallLength/40, -30*Feet, WallHeight/40> // test
//	look_at <WallLength/10, 0, WallHeight/10>
	location  <SnowX/2, -30*Feet, SnowZ/2> // render
	look_at <SnowX/2, 0, SnowZ/2>
	}

camera {
//	Closeup_Cam
	Parallel_Cam
  }


//===============================================
//             Textures
//===============================================

#declare PlainTex =
	texture {
		pigment { color rgb <1,1,3> }
		finish { ambient .10 specular .65 roughness .125 }
	}

#declare SnowDriftTex =
	texture {
		pigment {
			bozo
			color_map {
			[ 0.00 color rgb <1,1,1> ]
			[ 0.50 color rgb <0,0,0> ]
			[ 1.00 color rgb <1,1,1> ]
			}
			scale <7*Feet,4*Feet,4*Feet>*0.4
		}
		finish { ambient 1.0 specular .65 roughness .125 }
	}

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb60Watt translate <-10*Feet,8*Feet,2*Feet> }
#declare MyLight =
	light_source {
		<0,0,0>
		color rgb<1,1,1>
//		fade_distance 12*Feet
//		fade_power 1
	}
//object { MyLight translate <-4*Feet,-4*Feet,8*Feet> } // test
//object { MyLight translate <24*Feet,-1*Feet,24*Feet> } // testr
//object { MyLight translate <12,-4,12> } // test

#if ( ColorOn=1 )
	object { MyLight translate <SnowX/2, -1000*Feet, SnowZ/2> } // render
#end

//===============================================
//             Environment
//===============================================

background { color rgb <0.93, 0.99, 0.4> } // bright yellow


//===============================================
//             Objects
//===============================================

#declare BluSph =
	sphere {
		<0,0,0>,.5
		texture { PlainTex }
		translate <0,0,0.5>
	}

#declare SnowWall =
	box {
		<0,0,0>,<SnowX,1,SnowZ>
		texture { SnowDriftTex }
	}


//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 2 translate <0,-2,1> }
/*
object { BluSph scale 2 translate <3.6*Feet,-7.0*Feet,3.6*Feet> }
object { BluSph scale 5 translate <30,-30,0> }
object { BluSph scale 5 translate <0,-40,0> }
object { BluSph scale 5 translate <0,-35,0> }
object { BluSph scale 5 translate <0,-25,0> }
object { BluSph scale 5 translate <0,-15,0> }
object { BluSph scale 5 translate <0,-5,0> }
object { BluSph scale 5 translate <-2,5,0> }
object { BluSph scale 5 translate <2,15,0> }
*/

object { SnowWall }

//box { <0,0.5,0>,<80,40,80> texture { PlainTex } }