// Persistence of Vision Ray Tracer Scene Description File
// File: jd_dof.pov
// Vers: MegaPov 0.6a 
// Date: 15 Dec 2000
// Auth: Johannes Dahlstrm

#version unofficial Megapov 0.6;

#include "colors.inc"

global_settings { 
	assumed_gamma 1.0
	motion_blur 4,0.3
}

#default { finish { ambient 0.05 diffuse 0.7 } }  

//Change these to adjust quality and rendering speed
$area_lts = on;  //Use area lights?
$superell = on;  //Use superellipsoids as brickss?
$smedia = on;    //Use media?
$hf_res = 600;   //Heightfield image resolution
	                                                        
$Sh_Stone1 = 
texture {
   pigment {
   	gradient z
   	pigment_map {
   		[0.002 granite scale 0.02 color_map { [0 rgb <0.2,0.2,0.2>] [1 rgb <0.32,0.3,0.3>] } ]
   		[0.002 
				granite turbulence 0.4 scale 0.02 
				color_map { [0.0 Gray60][0.1 rgb <0.6,0.4,0.35>] [0.3 Gray30][0.4 Gray30][1.0 Gray20] } 
   		]
   	}
   }  
   normal { granite 1 scale 0.05 }
} 

   
$Sh_Stone2 =
texture {
	pigment { 
		granite turbulence 0.4 scale 0.02 
		color_map { [0.0 Gray40][0.2 rgb <0.4,0.2,0.2>][0.6 Gray20] } 
	}   
   normal { granite 1 scale 0.05 }
}      

$Sh_Rusty_Metal =
texture {
	pigment {
		bozo
		turbulence 0.5
		scale 0.01
		color_map {
			[0.1 rgb <0.25,0.12,0.12> ]
			[0.9 rgb <0.22,0.18,0.18> ]
		}
	}
	normal { dents scale 0.02 } 
	finish { ambient 0.1 }
} 
texture {
	pigment {
		bozo 
		turbulence 0.2
		scale 0.01
		color_map {
			[0.6 rgb <0.5,0.2,0.1> filter 1 ]
			[0.8 rgb <0.5,0.2,0.1>]   
		}
	}
}



#macro Bird(A1,A2) 
union { 
	// The body
	cone { <0,0,1>,0.2,<0,0,2>,0 }                   
	cone { <0,0,-1>,0.1,<0,0,1>,0.2 }                
	
	// The wings
	polygon { 5,<0,0,-0.5>,<0,0,0.5>,<0,1,0.4>,<0,1,-0.2>,<0,0,-0.5> rotate A1*z }
	polygon { 5,<0,0,-0.5>,<0,0,0.5>,<0,1,0.4>,<0,1,-0.2>,<0,0,-0.5> rotate -A1*z }
	
	triangle { <0,0,-0.2>,<0,0,0.4>,<0,1,0.5> rotate A2*z translate <-sin(radians(A1)), cos(radians(A1))> }
	triangle { <0,0,-0.2>,<0,0,0.4>,<0,1,0.5> rotate -A2*z translate <sin(radians(A1)), cos(radians(A1))> }
	 
	// The tail 
	triangle { <0,0,-0.5>,<0.6,0,-1.5>,<-0.6,0,-1.5> }
} 
#end

camera { 
	right x*image_width/image_height
	location <0.2,1.6,0.8> 
	look_at <0, 1.9, 2.2> 
}  

light_source { 
	<2,2.3,0> rgb <0.8,0.8,0.4> orient
	#if(area_lts) area_light <-0.1,-0.1,0>,<0.1,0.1,0>,3,3 jitter adaptive 1 #end
	fade_distance 1.5 fade_power 3 
	media_interaction off 
}

light_source { 
	<100,300,600> White*1.5 parallel orient
	#if(area_lts) area_light <-10,-10,0>,<10,10,0>,3,3 jitter adaptive 1 #end
}  


$A = degrees(atan2(0.55,1));

$bend_angle = A/4;      
$bend_smoothness = 0;
$object_axis1 = <0,0.0,-0.06>;
$object_axis2 = <0,0.0,0.06>; 
#if(superell)
$bend_object = superellipsoid { <0.06,0.06> translate y scale <0.08,0.1,0.05> rotate -bend_angle/2*y } 
#else
$bend_object = box { -1,1 translate y scale <0.08,0.1,0.05> rotate -bend_angle/2*y }
#end  

// Upper bricks, the arch

union {

	$i = -A;
	#while(i <= A)
	
	object {
		#include "bend.inc" 
		translate -1*x
		rotate i*y
	}
	
	$i = i + A/4;
	#end  

   rotate <90,0,-90>
   translate <0,1.37,1.95>
	texture { Sh_Stone2 }   
} 

// Side and lower bricks

union {
   
   $i = 1.61;
   #while(i <= 2.2)
      
		#if(superell)
   	superellipsoid { <0.06,0.06> translate z scale <0.08,0.05,0.1> translate <-0.56,i,0> }
   	superellipsoid { <0.06,0.06> translate z scale <0.08,0.05,0.1> translate <0.56,i,0> }
   	#else
    	box { -1,1 translate z scale <0.08,0.05,0.1> translate <-0.56,i,0> }
   	box { -1,1 translate z scale <0.08,0.05,0.1> translate <0.56,i,0> } 
      #end
      
   	$i = i + 0.12;
   #end  
   
   $i = -0.42;
   #while(i <= 0.42)
      
     	#if(superell)
     	superellipsoid { <0.06,0.06> translate z scale <0.05,0.08,0.3> translate <i,1.46,0> }
   	#else
   	box { -1,1 translate z scale <0.05,0.08,0.1> translate <i,1.46,0> }
   	#end

   	$i = i + 0.12;
   #end 
   
   translate 1.95*z 

	texture { Sh_Stone2 }   
}    


$Bl = (<0, 1.9, 2.2>-<0.2,1.6,0.8>)*15 

// Birds
 
motion_blur {
	union {
		object { 
			Bird(40,70) 
			scale 0.2 rotate 130*y 
			translate Bl + <-2,1,-1> + clock*<sin(degrees(130)),0,cos(degrees(130))> 
		}  
		object { 
			Bird(110,140) 
			scale 0.2 rotate 160*y 
			translate Bl + <5.5,1.5,1> + clock*<sin(degrees(160)),0,cos(degrees(160))>
		}  
		object { 
			Bird(70,110) 
			scale 0.2 rotate 210*y 
			translate Bl + <2.5,4.5,4> + clock*<sin(degrees(210)),0,cos(degrees(210))> 
		}  
		pigment { Gray80 }
	}
}   

// The wall and the window

difference {
	intersection {
		height_field {
			pattern hf_res,hf_res {
				crackle
				poly_wave 0.6
				scale 0.1  
				translate <0,-0.5,0.5> 
				turbulence 0.05
				octaves 5
				omega 0.5
				color_map {
					[0.12 Black]
					[1.00 White]
				}
			}
			translate <-0.5,0,-0.5>
		   
		   scale <4,0.08,4>
			rotate -90*x    
		} 
		plane { z, 0.6 }   
      
      texture { Sh_Stone1 }
		translate <0,2,2>
	}
	 
	intersection {
		box { <-0.5,0.0,-1>,<0.5,1.2,1> translate 0.0*y} 
		cylinder { <0,0,-1>,<0,0,1>,1 translate -0.2*y }  
	   translate <0,1.5,2.2> 
   }
	
	texture { Sh_Stone1 finish { ambient 0 } }
   
   clipped_by { box { <-1.5,0,1.5>,<1.5,3,3> } }
	bounded_by { clipped_by }  
} 

// Window bench

prism { 
	-0.5, 0.5, 6, <0,0>,<0.01,0>,<0.1,0.35>,<0.1,0.6>,<0,0.6>,<0,0>    
	texture { Sh_Rusty_Metal }
	rotate 90*z
	translate <0,1.53,1.92>
} 

// Window bars

union {
	cylinder { <0,0,0>,<0,1,0>,0.04 translate <0,1.5,2.4> }
	cylinder { <0,0,0>,<0,1,0>,0.04 translate <0.3,1.5,2.4> }
	cylinder { <0,0,0>,<0,1,0>,0.04 translate <-0.3,1.5,2.4> }    
	
	texture { Sh_Rusty_Metal }
}

// A scattering media to simulate dust inside the room

#if(smedia)
box { 
	<-2,-1,-2.5>,<2,3.5,2.5>
	pigment { Clear }
	hollow 
	interior {
		media {
			scattering { 2 0.05 }
			method 1 
			samples 1,1  
			intervals 5
		}
	}
}  
#end

// Sky

sky_sphere {
	pigment {
		gradient y 
		color_map { 
			[0.0 rgb <0.8,0.8,0.9>] 
			[0.6 White red 0.3 green 0.3] 
		} 
	}
	pigment { 
		pigment_pattern {
			gradient y    
			scale 2
			translate -0.6*y
			turbulence 0.5 
			lambda 2   
			omega 0.8
			octaves 8
			color_map { [0 Black][1 White] }
		}
		pigment_map { 
			[0.05 Gray70 ] 
			[0.2
				bozo
				scale <0.02,0.02,0.02> 
				turbulence 0.5 
				octaves 8
		    	omega 0.8
		    	lambda 2
				color_map { [0.3 Gray80][0.6 Gray90 ] }
			]
			[0.5
				bozo
				scale <0.05,0.05,0.05> 
				turbulence 0.5 
				octaves 8
		    	omega 0.8
		    	lambda 2
				color_map { [0.3 Gray80][0.6 Gray90 ][0.9 Clear] }
			]

			[0.7 Clear]
		}
	}
}
