
#version unofficial MegaPov 0.5;
#include "statue4c.inc"

#declare Torso = 
union {
    object { Hip }
    object { Abdomen }
    object { Chest }
    object { Neck }
    object { Right_Collar }
    object { Left_Collar }
}
#declare Head =
union {
    object { Head }
    object { Left_Eye }
    object { Right_Eye } 
}
#declare RightArm =
union {

    object { Right_Shoulder }
    object { Right_Forearm }
    object { Right_Hand }
    object { Right_Thumb_1 }
    object { Right_Thumb_2 }
    object { Right_Thumb_3 }
    object { Right_Index_1 }
    object { Right_Index_2 }
    object { Right_Index_3 }
    object { Right_Mid_1 }
    object { Right_Mid_2 }
    object { Right_Mid_3 }
    object { Right_Ring_1 }
    object { Right_Ring_2 }
    object { Right_Ring_3 }
    object { Right_Pinky_1 }
    object { Right_Pinky_2 }
    object { Right_Pinky_3 }
}
#declare LeftArm =
union {

    object { Left_Shoulder }
    object { Left_Forearm }
    object { Left_Hand }
    object { Left_Thumb_1 }
    object { Left_Thumb_2 }
    object { Left_Thumb_3 }
    object { Left_Index_1 }
    object { Left_Index_2 }
    object { Left_Index_3 }
    object { Left_Mid_1 }
    object { Left_Mid_2 }
    object { Left_Mid_3 }
    object { Left_Ring_1 }
    object { Left_Ring_2 }
    object { Left_Ring_3 }
    object { Left_Pinky_1 }
    object { Left_Pinky_2 }
    object { Left_Pinky_3 }
}
#declare RightLeg =
union {
    object { Right_Thigh }
    object { Right_Shin }
    object { Right_Foot }
    object { Right_Toe }
}
#declare LeftLeg =
union {
    object { Left_Thigh }
    object { Left_Shin }
    object { Left_Foot }
    object { Left_Toe }
}

#declare traceTorso =
object { Torso  rotate y*-90 scale 6 translate < .55, -1, -1.5 >    }
#declare traceHead =
object { Head  rotate y*-90 scale 6 translate < .55, -1, -1.5 >    }
#declare traceRightArm =
object { RightArm  rotate y*-90 scale 6 translate < .55, -1, -1.5 >    }
#declare traceLeftArm =
object { LeftArm  rotate y*-90 scale 6 translate < .55, -1, -1.5 >    }
#declare traceRightLeg =
object { RightLeg  rotate y*-90 scale 6 translate < .55, -1, -1.5 >    }
#declare traceLeftLeg =
object { LeftLeg  rotate y*-90 scale 6 translate < .55, -1, -1.5 >    }

#declare traceStatue =
union {
        object { traceTorso }
        object { traceHead }
        object { traceRightLeg }
        object { traceLeftLeg }
} 


#declare traceObject = object { poser_object rotate y*-90 scale 6 translate < .55, -1, -1.5 >   } 

#declare min_ex = min_extent ( traceObject )
#declare max_ex = max_extent ( traceObject )
#declare y_range = max_ex.y - min_ex.y;

#declare box0 =  box { <0, -2, -2> <.99, 2, 2> }
#declare box1 =  box { <1, -2, -2> <1.99, 2, 2> }
#declare box2 =  box { <2, -2, -2> <2.99, 2, 2> } 
#declare box3 =  box { <3, -2, -2> <3.99, 2, 2> } 
#declare box4 =  box { <4, -2, -2> <4.99, 2, 2> }
#declare box5 =  box { <5, -2, -2> <5.99, 2, 2> }

#declare thr = .0125;
#declare strengthVal = .05; 
#declare radiusVal = .0125;
#declare xincr = .025;
#declare rotincr = 2.5;

#macro blob_object()    //threshold <= StrengthVal
        sphere { hit, strengthVal, radiusVal  }          
#end

#declare Norm = <0, 0, 0>;
         
#declare statue =                                                         
union {

blob { threshold thr
        sphere { 0, 0, 0 }                       
        #local xtrans=0.1;#while( xtrans<2.0 )
                 
                 
                #local rot=0;#while( rot < 360 )
                        
                        #declare Start = vaxis_rotate ( < xtrans, 1.2, 0 >, < 1, 0, 0 >, rot );
                         
                                                          
                        #declare hit =  trace ( traceTorso, Start, <0, -1, -1>*Start, Norm );
                                                 
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end
                        #declare hit =  trace ( traceHead, Start, <0, -1, -1>*Start, Norm );  
                                               
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceRightLeg, Start, <0, -1, -1>*Start, Norm ); 
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceLeftLeg, Start, <0, -1, -1>*Start, Norm );
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                                   
                #local rot=rot+rotincr;#end
                
        #local xtrans=xtrans+xincr;#end
         
bounded_by { box0 }
}

blob { threshold thr
        sphere { 0, 0, 0 }                         
        #local xtrans=1.0;#while( xtrans<2.0 )
                 
                 
                #local rot=0;#while( rot < 360 )
                        
                        #declare Start = vaxis_rotate ( < xtrans, 1.2, 0 >, < 1, 0, 0 >, rot );
                         
                                                          
                        #declare hit =  trace ( traceTorso, Start, <0, -1, -1>*Start, Norm );
                                                 
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end
                        #declare hit =  trace ( traceHead, Start, <0, -1, -1>*Start, Norm );  
                                               
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceRightLeg, Start, <0, -1, -1>*Start, Norm ); 
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceLeftLeg, Start, <0, -1, -1>*Start, Norm );
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                                  
                #local rot=rot+rotincr;#end
                
        #local xtrans=xtrans+xincr;#end
         
bounded_by { box1 }
}

blob { threshold thr
        sphere { 0, 0, 0 }                         
        #local xtrans=2.0;#while( xtrans<3.0 ) 
                 
                 
                #local rot=0;#while( rot < 360 )
                        
                        #declare Start = vaxis_rotate ( < xtrans, 1.2, 0 >, < 1, 0, 0 >, rot );
                         
                                                          
                        #declare hit =  trace ( traceTorso, Start, <0, -1, -1>*Start, Norm );
                                                 
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end
                        #declare hit =  trace ( traceHead, Start, <0, -1, -1>*Start, Norm );  
                                               
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceRightLeg, Start, <0, -1, -1>*Start, Norm ); 
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceLeftLeg, Start, <0, -1, -1>*Start, Norm );
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                                    
                #local rot=rot+rotincr;#end
                
        #local xtrans=xtrans+xincr;#end
         
bounded_by { box2 }
}

blob { threshold thr
        sphere { 0, 0, 0 }                         
        #local xtrans=3.0;#while( xtrans<4.0 )
                 
                 
                #local rot=0;#while( rot < 360 )
                        
                        #declare Start = vaxis_rotate ( < xtrans, 1.2, 0 >, < 1, 0, 0 >, rot );
                         
                                                          
                        #declare hit =  trace ( traceTorso, Start, <0, -1, -1>*Start, Norm );
                                                 
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end
                        #declare hit =  trace ( traceHead, Start, <0, -1, -1>*Start, Norm );  
                                               
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceRightLeg, Start, <0, -1, -1>*Start, Norm ); 
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceLeftLeg, Start, <0, -1, -1>*Start, Norm );
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                                  
                #local rot=rot+rotincr;#end
                
        #local xtrans=xtrans+xincr;#end
         
bounded_by { box3 }
}

blob { threshold thr
        sphere { 0, 0, 0 }                         
        #local xtrans=4.0;#while( xtrans<5.0 )
                 
                 
                #local rot=0;#while( rot < 360 )
                        
                        #declare Start = vaxis_rotate ( < xtrans, 1.2, 0 >, < 1, 0, 0 >, rot );
                         
                                                          
                        #declare hit =  trace ( traceTorso, Start, <0, -1, -1>*Start, Norm );
                                                 
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end
                        #declare hit =  trace ( traceHead, Start, <0, -1, -1>*Start, Norm );  
                                               
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceRightLeg, Start, <0, -1, -1>*Start, Norm ); 
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                        #declare hit =  trace ( traceLeftLeg, Start, <0, -1, -1>*Start, Norm );
                                                
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                                        blob_object() 
                        #end 
                                    
                #local rot=rot+rotincr;#end
                
        #local xtrans=xtrans+xincr;#end
         
bounded_by { box4 }
}



} //end union



