 
metalbear.inc   
>@ 8"
> D  PҸҽdsxԢ   
>@>TEXTMPS           W  ~v]                       5  // Persistence Of Vision INCLUDE file
// File:    metalbear.inc
// Vers:    3.1g.r1 Mac PPC
// Desc:    Lonely bear in metallic set
// Uses:    tedbearm.inc
// Auth:    Peter Murray

#debug "\r  metalbear.inc - Lonely bear in metallic set\r"

/*------------------------------------------------------------
Without anti-aliasing:
Time For Parse:    0 hours  0 minutes   4.0 seconds (4 seconds)
Time For Trace:    0 hours 41 minutes  43.0 seconds (2503 seconds)
    Total Time:    0 hours 41 minutes  47.0 seconds (2507 seconds)
------------------------------------------------------------*/
//------------------------------------------------------------
#declare WarmFurTx=
texture{
	normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
	}
	pigment{
		granite
		colour_map{
			[0.0 colour rgb <0.85,0.60,0.15>*1.2]
			[0.3 colour rgb <0.95,0.70,0.15>*1.2]
			[0.6 colour rgb <0.95,0.75,0.15>*1.2]
			[1.0 colour rgb <0.95,0.70,0.15>*1.2]
		}
		scale .5
	}
}

#declare WarmFur2Tx=
texture{
	normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
	}
	pigment{
		granite
		colour_map{
			[0.0 colour rgb <0.88,0.70,0.20>*1.2]
			[0.3 colour rgb <1.00,0.80,0.20>*1.2]
			[0.6 colour rgb <0.90,0.84,0.20>*1.2]
			[1.0 colour rgb <1.00,0.80,0.20>*1.2]
		}
		scale .5
	}
}

#declare DirtTouch=
texture{
  pigment{
    spotted
    colour_map{
      [0.00 colour rgbf <.3,.3,.3,0.75>]
      [0.05 colour rgbf <.4,.4,.4,0.75>]
      [0.06 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.25
  }
}

#declare DirtSpatter=
texture{
  pigment{
    spotted
    colour_map{
      [0.00 colour rgbf <.3,.3,.3,0.75>]
      [0.15 colour rgbf <.4,.4,.4,0.75>]
      [0.16 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.25
  }
}

#declare DirtSmear=
texture{
  pigment{
    spotted
    colour_map{
      [0.00 colour rgbf <.3,.3,.3,0.5>]
      [0.25 colour rgbf <.4,.4,.4,0.5>]
      [0.26 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.10
  }
}

#declare InchGridX=normal{
	gradient x
	slope_map{
		[0.00 <0,0>]
		[0.45 <0,0>]
		[0.46 <0,1>]
		[0.50 <1,0>]
		[0.54 <0,1>]
		[0.55 <0,0>]
		[1.00 <0,0>]
	}
}

#declare InchGridY=normal{
	gradient y
	slope_map{
		[0.00 <0,0>]
		[0.45 <0,0>]
		[0.46 <0,1>]
		[0.50 <1,0>]
		[0.54 <0,1>]
		[0.55 <0,0>]
		[1.00 <0,0>]
	}
}

#declare SilverWall=
texture{T_Silver_1C finish{reflection 0.2} normal{InchGridX scale 3}}

#declare SilverDoor=
texture{T_Silver_1B finish{reflection 0.2} normal{InchGridY scale 4}}

#declare FloorTile=
texture{T_Silver_2C}
texture{DirtSmear}

#declare SteelFloor=
texture{
	brick texture{T_Silver_1A} texture{FloorTile} brick_size <6,0.5,6>*in mortar 0.25*in
}

#declare SteelCeiling= //same as floor, but not dirty
texture{
	brick texture{T_Silver_1A} texture{T_Silver_2C} brick_size <6,0.5,6>*in mortar 0.25*in
}

#declare SteelGirder=
texture{
	T_Silver_2C
	normal{crackle scale 0.5}
}

#declare SteelGirder2=
texture{
	T_Silver_3A
	normal{dents scale 0.25}
}

#declare SteelRail=
texture{
	T_Silver_5A
}

#declare FloorPit=
texture{
	wrinkles turbulence 0.4
	texture_map{
		[0.00 T_Silver_1C]
		[0.75 T_Silver_1C]
		[0.76 T_Brass_5A]
		[1.00 T_Brass_5A]
	}
	//scale 0.5
}

#declare WBTex=
texture{T_Silver_1B normal{crackle}}

#declare WB2Tex=
texture{T_Silver_2A}

#declare MetalGrid=
texture{
  pigment{
    gradient x
    colour_map{
      [0.00 colour rgbf <.7,.7,.72,0>]
      [0.25 colour rgbf <.7,.7,.72,0>]
      [0.26 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.25
  }
  finish{Metal}
}
texture{
  pigment{
    gradient x
    colour_map{
      [0.00 colour rgbf <.7,.7,.72,0>]
      [0.25 colour rgbf <.7,.7,.72,0>]
      [0.26 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*-45
    scale 0.25
  }
  finish{Metal}
}

#declare BeltTx=
texture{
	pigment{colour rgb <0.1,0.1,0.1>}
}

#declare WandererGreen=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.15,0.30,0.00>]
			[0.40 colour rgb <0.20,0.40,0.00>]
			[0.60 colour rgb <0.15,0.30,0.00>]
			[1.00 colour rgb <0.20,0.40,0.00>]
		}
		scale 0.25
	}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

#declare BrownShoe=
texture{
	pigment{
		colour rgb <0.3,0.15,0.0>
	}
	finish{
		reflection 0.25
	}
}

//------------------------------------------------------------
// Scenery/utility objects
/*
#declare Marker=
union{
	cylinder{<-6,0,0>*in,<6,0,0>*in,0.25*in}
	cylinder{<0,-6,0>*in,<0,6,0>*in,0.25*in}
	cylinder{<0,0,-6>*in,<0,0,6>*in,0.25*in}
	no_shadow
	texture{RedPt}
}
*/

#declare WallBlock=
union{
	box{
		<-2.9,-6,0>*in,<2.9,0,4>*in
	}
	box{
		<-3,-5.9,0.2>*in,<3,-0.1,4>*in texture{WB2Tex}
	}
	texture{WBTex}
	rotate x*30
}

#declare WallColumn=
difference{
	union{
		box{
			<-2.9,-25,1>*in,<2.9,-5.19615,-3>*in
		}
		object{WallBlock}
		box{
			<-2.9,-3,1>*in,<2.9,10,-1>*in
		}
		texture{WBTex}
	}
	cylinder{<0,1,-4>*in,<0,1,2>*in,1.6*in}
}

#declare LightBox=
box{
	<-2.75,-0.85,1.65>*in,<2.75,1.25,4.75>*in no_shadow
	interior{I_Glass}
	texture{
		WBTex pigment{colour rgbt <0.75,0.90,0.90,1.00>}
		finish{ambient 0.6} normal{InchGridX}
	}
}

#declare LightBoxOn=
light_source{
	<0,-0.25,-2.75>*in
	colour rgb <0.8,1,1.2>*0.25
	looks_like{LightBox}
	fade_distance 24*in fade_power 2
}

/*
    [ cylinder ]
    [ falloff FALLOFF ]
    [ looks_like { OBJECT } ]
    [ fade_distance FADE_DISTANCE ]
    [ fade_power FADE_POWER (1...2) ]
}
*/

#declare WallBlockLight=
union{
	difference{
		box{
			<-2.9,-6,0>*in,<2.9,0,4>*in
		}
		box{
			<-2.75,-6.1,-0.1>*in,<2.75,-4,3>*in
		}
	}
	box{
		<-3,-5.9,0.2>*in,<3,-0.1,4>*in texture{WB2Tex}
	}
	//object{LightBox translate <0,-5,1>*in}
	object{LightBoxOn translate <0,-5,1>*in}
	/*
	box{
		<-2.75,-6.1,-0.1>*in,<2.75,-4,3>*in
		texture{WBTex pigment{colour rgb <0.75,0.90,0.90>} normal{InchGridX}}
	}
	*/
	texture{WBTex}
	rotate x*30
}

/*
	plocn:
	protn:
	pdoor: 1 is open, 0 is closed.
*/
#macro MetalDoor(plocn,protn,pdoor)
union{
	difference{
		union{
			torus{6*in,1*in rotate x*90 scale <1,0.5,1> translate <0,12,-1>*in}
			torus{6*in,1*in rotate x*90 scale <1,0.5,1> translate <0,12,1>*in}
		}
		box{<-6,-0.5,-2>*in,<6,12,2>*in}
	}
	cylinder{<-6,0,-1>*in,<-6,12,-1>*in,1*in}
	cylinder{<6,0,-1>*in,<6,12,-1>*in,1*in}
	cylinder{<-6,0,1>*in,<-6,12,1>*in,1*in}
	cylinder{<6,0,1>*in,<6,12,1>*in,1*in}
	box{<-6.25,0.05,-0.1>*in,<-0.05,14.95,0.1>*in translate <pdoor*-5.9,0,0>*in texture{SilverDoor}}
	box{<6.25,0.05,-0.1>*in,<0.05,14.95,0.1>*in translate <pdoor*5.9,0,0>*in texture{SilverDoor}}
	rotate protn translate plocn
}
#end

#declare TextPlaque=
union{
	#local UseFont="palatino.ttf"//"palatii.ttf"//"palatbi.ttf"
	text{
		ttf UseFont,"pdmmetal.jpg",0.2*in,<0.2,0,0> scale <0.5,0.5,0.5>
		rotate y*-90 translate <0,5.75,0>*in texture{Grey25Pt}
	}
	text{
		ttf UseFont,"copyright Peter Murray",0.2*in,<0.1,0,0> scale 0.4
		rotate y*-90 translate <0,5.30,0>*in texture{Grey50Pt}
	}
	text{
		ttf UseFont," 03 Dec 2000",0.2*in,<0.1,0,0> scale <0.3,0.4,0.4>
		rotate y*-90 translate <0,4.85,0>*in texture{Grey50Pt}
	}
	text{
		ttf UseFont,"Contrast (Nov-Dec 2000)",0.2*in,<0.1,0,0> scale <0.3,0.4,0.4>
		rotate y*-90 translate <0,4.40,0>*in texture{Grey50Pt}
	}
	text{
		ttf UseFont,"Internet Raytracing Competition",0.2*in,<0.1,0,0> scale <0.3,0.4,0.4>
		rotate y*-90 translate <0,3.95,0>*in texture{Grey50Pt}
	}
}

/*	Overhead structures
	plocn
	protn
	plength: Length of structure, starting at plocn, rotated protn about plocn
*/
#macro Overstructure(plocn,protn,plength)
union{
	#local LinkRef=vrotate(<2,0,0>*in,z*45);
	#local ZZ=0;
	#while (ZZ<plength)
		difference{
			torus{2*in,0.25*in rotate x*90}
			box{<-2.5,-2.5,-0.5>*in,<2.5,0,0.5>*in}
			translate <0,0,ZZ>*in
		}
		cylinder{LinkRef*<-1,1,1>+z*ZZ*in,LinkRef+z*ZZ*in,0.2*in}
		cylinder{LinkRef*<-1,1,1>+z*ZZ*in,<-2,3,ZZ>*in,0.2*in}
		cylinder{LinkRef+z*ZZ*in,<2,3,ZZ>*in,0.2*in}
		cylinder{<-2,0,ZZ>*in,<-2,3,ZZ>*in,0.2*in}
		cylinder{<2,0,ZZ>*in,<2,3,ZZ>*in,0.2*in}
		cylinder{<2,3,ZZ>*in,<-2,3,ZZ>*in,0.2*in}
		cylinder{<-0.5,LinkRef.y/in-0.75,0>*in,<0.5,LinkRef.y/in-0.75,0>*in,0.15*in texture{SteelGirder2}}
		cylinder{<0,LinkRef.y/in-0.75,0>*in,<0,LinkRef.y/in,0>*in,0.15*in texture{SteelGirder2}}
		#local ZZ=ZZ+12;
	#end
	#local ZZ=4;
	#while (ZZ<plength)
		difference{
			torus{2*in,0.125*in rotate x*90}
			box{<-2.5,-2.5,-0.5>*in,<2.5,0,0.5>*in}
			cylinder{<-0.5,LinkRef.y/in-0.75,0>*in,<0.5,LinkRef.y/in-0.75,0>*in,0.15*in}
			cylinder{<0,LinkRef.y/in-0.75,0>*in,<0,LinkRef.y/in,0>*in,0.15*in}
			texture{SteelGirder2}
			translate <0,0,ZZ>*in
		}
		#local ZZ=ZZ+4;
		#if (mod(ZZ,12)=0) #local ZZ=ZZ+4; #end
	#end
	difference{
		torus{2*in,0.25*in rotate x*90}
		box{<-2.5,-2.5,-0.5>*in,<2.5,0,0.5>*in}
		translate <0,0,plength>*in
	}
	cylinder{<-2,3,0>*in,<-2,3,plength>*in,0.25*in}
	#write(DebugFile,"Y value =",LinkRef.y/in-0.75,"\n")
	cylinder{<-0.5,0,0>*in,<-0.5,0,plength>*in,0.15*in scale <1,2,1> translate <0,LinkRef.y/in-0.75,0> texture{SteelRail}}
	cylinder{<0.5,0,0>*in,<0.5,0,plength>*in,0.15*in scale <1,2,1> translate <0,LinkRef.y/in-0.75,0> texture{SteelRail}}
	cylinder{<2,3,0>*in,<2,3,plength>*in,0.25*in}
	box{<1.875,-0.375,0>*in,<2.125,0.375,plength>*in rotate z*5}
	box{<1.875,-0.375,0>*in,<2.125,0.375,plength>*in rotate z*45}
	box{<1.875,-0.375,0>*in,<2.125,0.375,plength>*in rotate z*90}
	box{<-1.875,-0.375,0>*in,<-2.125,0.375,plength>*in rotate z*-45}
	box{<-1.875,-0.375,0>*in,<-2.125,0.375,plength>*in rotate z*-5}
	texture{SteelGirder}
	rotate protn
	translate plocn
}
#end

#macro OverCrane(plocn,protn)
union{
	box{<-0.75,0.51,-1>*in,<0.75,0.26,1>*in}
	box{<-0.75,1.12,-1>*in,<-0.65,0.26,1>*in}
	box{<-0.75,1.12,-1>*in,<-0.3,1.24,1>*in}
	box{<0.75,1.12,-1>*in,<0.65,0.26,1>*in}
	box{<0.75,1.12,-1>*in,<0.3,1.24,1>*in}
	cylinder{<-0.75,0.51,-1>*in,<-0.75,0.51,1>*in,0.25*in}
	cylinder{<0.75,0.51,-1>*in,<0.75,0.51,1>*in,0.25*in}
	difference{
		torus{0.6*in,0.1*in rotate z*-90 scale <1,2.5,1> translate <0.8,0.5,0>*in}
		box{<0.65,0.5,-1>*in,<0.95,2.3,1>*in}
	}
	difference{
		torus{0.6*in,0.1*in rotate z*-90 scale <1,3,1> translate <-0.8,0.5,0>*in}
		box{<-0.65,0.5,-1>*in,<-0.95,3.4,1>*in}
	}
	texture{T_Silver_3C} texture{DirtTouch}
	rotate protn translate plocn
}
#end

//------------------------------------------------------------
// Robots

#declare Robwheel=
union{
	torus{1*in,0.25*in rotate z*90 translate <0,1.25,0>*in texture{BlackPt}}
	sphere{<0,0,0>,0.75*in scale <0.25,1,1> translate <0,1.25,0>*in}
	texture{T_Silver_1A normal{ripples 0.75 rotate z*90 scale <-2,0.25,0.25>}}
}

#declare Roblink=
difference{
	sphere{<0,0,0>,0.75*in texture{T_Silver_3A}}
	sphere{<0,0,0>,0.65*in}
	box{<-1,-0.2,-0.25>*in,<1,0.2,-1>*in}
	box{<-0.2,-1,-0.25>*in,<0.2,1,-1>*in}
	texture{T_Silver_1A}
}

#declare Roblinkbar=
union{
	sphere{<0,0,0>,0.63*in}
	cylinder{<0,0,0>*in,<0,0,2>*in,0.15*in}
	sphere{<0,0,2>*in,0.63*in}
	texture{T_Silver_1A}
}

#declare Load1=
union{
	// 19.4 -> 0.2-3.86 (3.88)
	#local ZZ=0.4;
	#while (ZZ<20)
		box{<-2.75,3.5,ZZ+0.4>*in,<2.75,7.6,ZZ+3.84>*in texture{T_Silver_4A finish{reflection 0.2} normal{crackle}}}
		#local ZZ=ZZ+3.88;
	#end
}

#declare Load2=
union{
	// 19.4 -> 0.2-3.86 (3.88)
	#local ZZ=0.4;
	#while (ZZ<20)
		cylinder{
			<-2.75,0,0>*in,<2.75,0,0>*in,1*in
			scale <1,1.2,1.85>
			translate <0,6.5,ZZ+2.3>*in
			texture{T_Silver_4A finish{reflection 0.2} normal{crackle}}
		}
		#local ZZ=ZZ+3.88;
	#end
}

#declare Hauler=
union{
	//basic body
	difference{
		union{
			box{<-3,3.25,0>*in,<3,7,10>*in}
			cylinder{<-3,0,0>*in,<3,0,0>*in,0.5*in scale <1,3.75,2> translate <0,5.125,0>*in}
		}
		sphere{<0,0,0>,0.75*in translate <0,4,-0.6>*in}
		sphere{<0,0,0>,0.75*in translate <0,4,10>*in}
	}
	difference{
		union{
			cylinder{<0,0,0>*in,<0,0,10>*in,0.5*in}
			sphere{<0,0,0>*in,0.5*in scale <1,1,2.5>}
			scale <2,6,1> translate <-3,4,0>*in
		}
		box{<-3.3,0.75,-1>*in,<-2.7,2.6,11>*in}
		box{<-3.75,3.6,2>*in,<-4.1,6.5,8>*in texture{T_Silver_1C finish{reflection 0.2}}}
	}
	difference{
		union{
			cylinder{<0,0,0>*in,<0,0,10>*in,0.5*in}
			sphere{<0,0,0>*in,0.5*in scale <1,1,2.5>}
			scale <2,6,1> translate <3,4,0>*in
		}
		box{<3.3,0.75,-1>*in,<2.7,2.6,11>*in}
		box{<3.75,3.6,2>*in,<4.1,6.5,8>*in texture{T_Silver_1C finish{reflection 0.2}}}
	}
	//with wheels
	object{Robwheel translate <-3,0,0.75>*in}
	object{Robwheel translate <3,0,0.75>*in}
	object{Robwheel translate <-3,0,8.5>*in}
	object{Robwheel translate <3,0,8.5>*in}
	//connectors for other robots
	object{Roblink translate <0,4,-0.6>*in}
	object{Roblink rotate y*180 translate <0,4,10>*in}
	//face
	difference{
		prism{
			linear_sweep linear_spline
			0, 0.25*in,	16,
			// right "eye"
			< 0.00, 0.00>, <-2.75, 0.00>, <-3.00,-0.15>, <-2.90,-0.7>, <-1.90,-0.65>,
			<-0.90,-0.25>, < 0.00, 0.20>, < 0.00, 0.00>,
			// left "eye"
			< 0.00, 0.00>, < 2.75, 0.00>, < 3.00,-0.15>, < 2.90,-0.7>, < 1.90,-0.65>,
			< 0.90,-0.25>, < 0.00, 0.20>, < 0.00, 0.00>
			texture{T_Silver_3C}
		}
		prism{
			linear_sweep linear_spline
			0.15*in, 0.30*in,	12,
			// right "eye"
			<-1.00,-0.10>, <-2.80,-0.25>, <-2.70,-0.6>, <-2.10,-0.55>, <-1.20,-0.35>,
			<-1.00,-0.10>,
			// left "eye"
			< 1.00,-0.10>, < 2.80,-0.25>, < 2.70,-0.6>, < 2.10,-0.55>, < 1.20,-0.35>,
			< 1.00,-0.10>
			texture{Grey25Pt}//{T_Silver_5A}
		}
		rotate x*-80 translate <0,6,-0.8>*in
	}
	//spine
	sphere{<0,7,1>*in,0.5*in scale <2,1,1>}
	difference{
		torus{1*in,0.025*in rotate z*90 scale <1,3,2>}
		box{<-0.2,0,0>*in,<0.2,4,3>*in rotate x*15}
		texture{T_Silver_1C finish{reflection 0.2}}
		translate <0,7,3>*in
	}
	cone{<0,7,1>*in,0.5*in,<0,7,8>*in,0*in scale <2,1,1>}
	texture{T_Silver_1C finish{reflection 0.2} normal{InchGridY}}
	texture{DirtSpatter}
}

#declare Haulee=
union{
	//basic body
	difference{
		box{<-3,3.25,0>*in,<3,7,20>*in}
		box{<-2.8,3.45,0.4>*in,<2.8,7.5,19.8>*in texture{T_Silver_1C finish{reflection 0.2}}}
		sphere{<0,0,0>,0.75*in translate <0,4,0>*in}
		sphere{<0,0,0>,0.75*in translate <0,4,20>*in}
		//face
		box{<-0.1,-0.7,0.15>*in,<0.1,0.7,-0.1>*in rotate z*-30 translate <-2.5,6,0>*in texture{T_Silver_1C finish{reflection 0.1}}}
		box{<-0.1,-0.7,0.15>*in,<0.1,0.7,-0.1>*in rotate z*-30 translate <-2.0,6,0>*in texture{T_Silver_1C finish{reflection 0.1}}}
		box{<-0.1,-0.7,0.15>*in,<0.1,0.7,-0.1>*in rotate z*30 translate <2.5,6,0>*in texture{T_Silver_1C finish{reflection 0.1}}}
		box{<-0.1,-0.7,0.15>*in,<0.1,0.7,-0.1>*in rotate z*30 translate <2.0,6,0>*in texture{T_Silver_1C finish{reflection 0.1}}}
		box{<-0.1,5,0.15>*in,<0.1,6,-0.1>*in texture{T_Silver_1C finish{reflection 0.1}}}
	}
	difference{
		cylinder{<0,0,0>*in,<0,0,20>*in,0.5*in scale <2,6,1> translate <-3,4,0>*in}
		box{<-3.3,0.75,-1>*in,<-2.7,2.6,21>*in}
	}
	difference{
		cylinder{<0,0,0>*in,<0,0,20>*in,0.5*in scale <2,6,1> translate <3,4,0>*in}
		box{<3.3,0.75,-1>*in,<2.7,2.6,21>*in}
	}
	//with load
	object{Load2}
	//with wheels
	object{Robwheel translate <-3,0,1.5>*in}
	object{Robwheel translate <3,0,1.5>*in}
	object{Robwheel translate <-3,0,18.5>*in}
	object{Robwheel translate <3,0,18.5>*in}
	//connectors for other robots
	object{Roblink translate <0,4,0>*in}
	object{Roblink rotate y*180 translate <0,4,20>*in}
	texture{T_Silver_1C finish{reflection 0.2} normal{InchGridY}}
	texture{DirtSpatter}
}

/*
	A Hauler pulling several Haulees
	plocn: "nose" of Haulee is above this
	protn: rotation of whole train about plocn
	anglelist: array of y*angles between trucks
*/
#macro Haultrain(plocn,protn,anglelist)
union{
	#local nHaulees=-1+dimension_size(anglelist,1);
	#local Count=1;
	object{Hauler}
	object{TextPlaque translate <3.85,-0.2,2.3>*in}
	object{TextPlaque rotate y*180 translate <-3.85,-0.2,7.7>*in}
	object{Roblinkbar rotate y*0.5*anglelist[0] translate <0,4,10>*in}
	#local CurAngle=anglelist[0];
	// calculate other end of Roblinkbar
	#local CurLocn=<0,0,10>*in+vrotate(<0,0,2>*in,y*0.5*anglelist[0]);
	#local CurRotn=y*anglelist[1];
	#while (Count<=nHaulees)
		object{Haulee rotate CurRotn translate CurLocn}
		// calculate new position
		#local Count=Count+1;
		#if (Count<=nHaulees)
			#local CurAngle=CurAngle+anglelist[Count];
			#local CurLocn=CurLocn+vrotate(<0,0,20>*in,y*CurAngle);
			object{Roblinkbar rotate y*(CurAngle-0.5*anglelist[Count]) translate CurLocn+<0,4,0>*in}
			#local CurLocn=CurLocn+vrotate(<0,0,2>*in,y*(CurAngle+0.5*anglelist[Count]));
			#local CurRotn=CurRotn+y*anglelist[Count];
		#end
	#end
	rotate protn
	translate plocn
}
#end

//------------------------------------------------------------
// Build the cold metallic set
#if (Setting=1)
	// Visible wall
	union{
		difference{
			box{<-100,0,36>*in,<100,34,38>*in}
			box{<-6,-0.5,34>*in,<6,12,40>*in}
			box{<-12,-0.5,36.85>*in,<12,15,37.15>*in}
			cylinder{<0,0,34>*in,<0,0,40>*in,6*in scale <1,0.5,1> translate <0,12,0>*in}
		}
		MetalDoor(<0,0,37>*in,0,0.9)
		interior{ior 1.5}
		texture{SilverWall translate x*1.5*in}
		texture{DirtTouch}
		//texture{gradient y texture_map{[0 DirtSmear][1 DirtTouch]} scale 34}
	}
	
	#local XX=-16;
	#while (XX<=16)
		#switch (XX)
		#case (-12) #case (-8) #case (-4) #case (0) #case (4) #case (8) #case (12)
			#local It=object{WallBlockLight}
		#break
		#case (-14) #case (-10) #case (-6) #case(-2) #case(2) #case(6) #case (10) #case (14)
			#local It=union{
				object{WallColumn}
				object{Overstructure(<0,1,-1>*in,<0,180,0>,35)}
			}
		#break
		#else
			#local It=object{WallBlock}
		#end
		object{
			It translate <XX*6,24,36>*in
		}
		object{
			It rotate y*180 translate <XX*6,24,-36>*in
		}
		object{
			It translate <XX*6,24,72>*in
		}
		#local XX=XX+1;
	#end

	OverCrane(<-6*6,25,28>*in,<0,0,0>)
	
	// Backdrop wall
	box{
		<-100,0,72>*in,<100,34,74>*in
		texture{SilverWall}
		texture{DirtTouch}
	}
	
	// Wall behind camera
	union{
		difference{
			box{<-100,0,36>*in,<100,34,38>*in}
			box{<-6,-0.5,34>*in,<6,12,40>*in}
			box{<-12,-0.5,36.85>*in,<12,15,37.15>*in}
			cylinder{<0,0,34>*in,<0,0,40>*in,6*in scale <1,0.5,1> translate <0,12,0>*in}
		}
		MetalDoor(<0,0,37>*in,0,0.75)
		interior{ior 1.5}
		texture{SilverWall translate x*1.5*in}
		texture{DirtTouch}
		rotate y*180 //thus moving it from z=36..38 to z=-36..-38
	}
	
	// Wall at left
	box{
		<-102,0,-100>*in,<-100,34,74>*in
		texture{SilverWall}
		texture{DirtTouch}
	}
	
	// Wall at right
	box{
		<100,0,-100>*in,<102,34,74>*in
		texture{SilverWall}
		texture{DirtTouch}
	}
	
	//floor
	difference{
		box{
			<-100,-0.1,-100>*in,<100,0.1,74>*in
			texture{SteelFloor translate x*3*in}
		}
		box{<3,-6,-15>*in,<9,0.5,-9>*in texture{FloorPit}}
		box{<-15,-6,-9>*in,<-9,0.5,-3>*in texture{FloorPit}}
		box{<9,-6,3>*in,<15,0.5,9>*in texture{FloorPit}}
		box{<-39,-6,3>*in,<-33,0.5,9>*in texture{FloorPit}}
		box{<-9,-6,9>*in,<-3,0.5,15>*in texture{FloorPit}}
		box{<21,-6,15>*in,<27,0.5,21>*in texture{FloorPit}}
		box{<-45,-6,15>*in,<-39,0.5,21>*in texture{FloorPit}}
		box{<-27,-6,21>*in,<-21,0.5,27>*in texture{FloorPit}}
		box{<9,-6,27>*in,<15,0.5,33>*in texture{FloorPit}}
	}
	
	//floor gratings
	box{<3,-0.25,-15>*in,<9,0,-9>*in texture{MetalGrid}}
	box{<-15,-0.25,-9>*in,<-9,0,-3>*in texture{MetalGrid}}
	box{<9,-0.25,3>*in,<15,0,9>*in texture{MetalGrid}}
	box{<-39,-0.25,3>*in,<-33,0,9>*in texture{MetalGrid}}
	box{<-9,-0.25,9>*in,<-3,0,15>*in texture{MetalGrid}}
	box{<21,-0.25,15>*in,<27,0,21>*in texture{MetalGrid}}
	box{<-45,-0.25,15>*in,<-39,0,21>*in texture{MetalGrid}}
	box{<-27,-0.25,21>*in,<-21,0,27>*in texture{MetalGrid}}
	box{<9,-0.25,27>*in,<15,0,33>*in texture{MetalGrid}}
	
	//box{<-3,4,-15>*in,<-9,8,-9>*in texture{FloorPit}}
	
	
	//ceiling
	#if (ViewPoint.y<33)
		box{
			<-100,34,-100>*in,<100,34.5,74>*in
			texture{SteelCeiling translate x*3*in}
		}
	#end

	//robots
	union{
		object{Haulee rotate y*-90 translate <0,0,0>*in}
		object{Roblinkbar rotate y*-90 translate <-20,4,0>*in}
		object{Haulee rotate y*-90 translate <-22,0,0>*in}
		translate <-15,0,28>*in
	}

	union{
		object{Haulee rotate y*-90 translate <0,0,0>*in}
		object{Roblinkbar rotate y*-90 translate <-20,4,0>*in}
		object{Haulee rotate y*-90 translate <-22,0,0>*in}
		translate <-20,0,16>*in
	}

	Haultrain(<-6,0,-16>*in,y*20,
		array[5]{0,-20,-15,-10,-5}
	)

	Haultrain(<9,0,20>*in,y*125,
		array[5]{0,-15,-15,-10,-5}
	)

	// And finally
	#declare BearTextureList=array[5]{
		BeltTx,WandererGreen,WandererGreen,BrownShoe,WandererGreen
	}
	#declare BearOptionsList=array[5]{
		1.3,0.8,0,0,0
	}
	#include "wanderer.cdf"
	object{
		TeddyBear(
			<8.5,-.25,-12>*in,<0,210,0>,
			<0,20,0>,<-120,-45,0>,<30,0,0>,<-15,0,0>,<15,0,0>,
			array[5]{WarmFurTx,WarmFur2Tx,dEyeTx,dMouthTx,dNoseTx}
		)
	}

#end //of Setting=1

//------------------------------------------------------------
#if (Setting=0)
	//#local Test=object{Hauler}
	#local Test=object{Haulee}
	//#local Test=object{Roblink scale 3}
	object{Test translate <5,0,-12>*in}
	object{Test rotate y*-90 translate <-7,0,0>*in}
	object{Test rotate y*-90 rotate x*-90 translate <-7,15,6>*in}
	object{Test rotate y*45 translate <7,10,6>*in}
	//------------------------------------------------------------
	// And finally
	object{
		TeddyBear(
			<12,-.25,-10>*in,<0,210,0>,
			<0,20,0>,<-120,-45,0>,<30,0,0>,<-15,0,0>,<15,0,0>,
			array[5]{WarmFurTx,WarmFur2Tx,dEyeTx,dMouthTx,dNoseTx}
		)
	}
#end

#if (Setting=2)
	// Door
	//object{MetalDoor(<0,0,37>*in,0,0) texture{SilverWall translate x*1.5*in}}
	// robot trains
	/*
	object{Hauler translate <9,0,-12>*in}
	union{
		object{Hauler}
		object{TextPlaque translate <3.85,0,2.2>*in}
		object{TextPlaque rotate y*180 translate <-3.85,0,7.8>*in}
		//rotate y*45 translate <-8,0,-12>*in
		rotate y*-90 translate <2,0,-12>*in
	}
	//object{Haulee translate <-5,0,-12>*in}
	Haultrain(<30,6,48>*in,y*-90,
		array[5]{0,-20,-15,-10,-10}
	)
	object{
		Haultrain(0,<0,-90,0>,
			array[4]{0,20,15,15}
		)
		rotate x*-90 translate <30,-10,25>*in
	}
	*/
	// Overhead structures
	background{colour rgb <0.4,0.4,0.8>}
	Overstructure(<0,8,-16>*in,<0,0,0>,30)
	OverCrane(<0,8,-16>*in,<0,0,0>)
	//sphere{<0,8,-10>*in,1*in texture{RedPt}}
	Overstructure(<12,10,-10>*in,<0,0,0>,30)
	OverCrane(<12,10,-5>*in,<0,0,0>)
	//sphere{<12,10,-5>*in,1*in texture{RedPt}}
	Overstructure(<-16,-1,6>*in,<0,90,0>,30)
	OverCrane(<-10,-1,6>*in,<0,90,0>)
	//sphere{<-10,-1,6>*in,1*in texture{RedPt}}
	OverCrane(<6,-1,-12>*in,<0,0,0>)
	OverCrane(<-6,-1,-12>*in,<0,90,0>)
#end

#debug "\r--------------------\rend of metalbear.inc\r--------------------\r"

                                                        OLNSAPPL                       
metalbear.incEX) Apr 2000ge4km TEXTMPS                     Pg~v  W               %WILDSTAK                              =%atcoDDf9                              %atcoTVex                        A    3.06Nisus 3.0 File Format
Paragon Concepts, Inc. 1988-96   2   4.1.6%4.1.6
Paragon Concepts, Inc. 1988-96   This document could not be opened because the application Nisus could not be found.  To order a copy of Nisus, contact Nisus Software, Inc. at (619)481-1477.          B                                                                                                                       
                                   b                                                                                                    

Zapf Dingbats	Wingdings7Webdingss#Verdana Venice  tengwar5  tengwar4P  tengwar3UTrebuchet MSTimes New Roman Times SymbolPSkia h	ShawRough PalatinoP New York	MT Extra Monaco  Maplin London"IPAPhonImpact^Hoefler Text Ornaments Hoefler Text 	Helvetica/Georgia Geneva 	GangstersFootnote Dingbats
Dancingmen  
Cupertino Courier New Courier
Comic Sans MS 0Cirth?ChicagoCharcoal^ dCamelot/-Arial BlackArial Apple ChanceryAndale Mono &   
    
                   	   Chapter s           ma         n          88         4.         ag            .         	    d        
no           us                    l            T         y          ta         ar         9)                      	             
                                                                                                                 	             
                                                                     s         We         an            ng        	   P         
Tr           me                   Table a           Pa                    ra         Ma         "            ct        	    O        
ef           et                
   	Equation Fo           ts         n                            c                     	   al        
Ar           l                   Figure                                                                                 	            
                                                                                                            	             
           @                                                                                    "        	   	^        
	 \                                                              ^                                  0        	   
          

                                                                                                               	             
                                                                             rl                               	    P        
                                                                                                                 	   
          

                                               	                   He         r          us            es        	            
e                                                                    k                                          	             
                                       \  ,                                                                                                  $   d          (                                  xDocument Sounds           n              x    H H    BAJ {    hh    }Jl 2JG P    '                        d                  L152                     	      B  @  @         $                                         H HAJ    !                                B       @                         :       
-                                              
                                   .[                                    	                               O              O                                                                                                                                                                   1     1          $ l   
              e                                                                                                               1     1             "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     $  6 , 7                           H 	Monaco 0,0p]
			[0.3 colour r     < $ L]  J  J  A    6     WallColumn   +  -Hauler   5  5Haulee       < $ L  A                   w$@D    vers  STR    RULE   FRMT   MRK7   VARI   FTAB  PGRA  FLST  DSPL  *SGP1  6PREC  BCPRC  NPGLY  ZSTYL  fSTNM  rSTRL  ~STNX  INFO  INF2  MPSR NwPo               E       {                                  N   C      I      _                                 M      Q      U      Y      ]                  5      oy$                                                                                                                            