#version unofficial MegaPov 0.6; 
 
global_settings { 
  ini_option "+H800"
  ini_option "+W600"

  ini_option "+QR"
  
  radiosity{
    pretrace_start 0.08
    pretrace_end   0.01
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound .5        // CHANGE - range from 1 to 3 - should correspond with pretrace_end
                         //   1 : pretrace_end = 0.02
                         //   3 : pretrace_end = 0.08
                         //   use pretrace_start = 0.08
                         // you can go lower than 1, but then you probably will want to set
                         // pretrace_end to 0.01, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
}   


camera {
  location <0.0, 0.2, -2.25>*.5
  direction 1.5*z*.5
  right     1*x
  up        4/3*y
  look_at <0.0, .65, 0.0>
}

//**********Lights**********

light_source { <-300,1000,-1200> color rgb 1 }
light_source { <-300,1000,-1200> color rgb .1 shadowless }

//**********Sky*************

sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,0.8>] [1.0 color rgb <.3,.3,.4>] }
  }
}

box { <-10, 0, 0>, <10, 10, 10> 
  texture {
    pigment { color rgbt 1 } 
  }
  interior {
    media {
      absorption rgb .6
    }
  }
  hollow
}

//*************************************************Ground*************************************************

#declare BottomTex = texture {
  pigment { 
    color rgb <.6, .52, .5>*.55 }
  normal {
    granite
    slope_map {
      [0 <0, 0>]
      [.3 <.4, 1>]
      [1 <.7,1>]
    }
    scale .04
  }
}

#declare Clear = pigment { color rgbt 1 }

#declare BaseNorm1 = normal {
  granite
  slope_map {
    [0 <0,0>]
    [.5 <.5,1>*.25*3]
    [1 <1,0>*.25*3]
  }
  scale <3,1,1>*.1
  rotate <0, -30, 0>
}

#declare BaseNorm2 = normal {
  bumps .3
  turbulence .5
  scale .001
}

#declare BaseNorm3 = normal {
  granite
  slope_map {    
    [0 <0, 0>]
    [.35 <0, 0>]
    [.55 <.5, 1>*2]
    [1 <1,0>*2]
  }
  scale .02
}

#declare Base = texture {
  pigment { 
    color rgb <.851, .731, .677>*.6 }
  normal {
    average
    normal_map {
      [BaseNorm1]
      [BaseNorm2]
      [BaseNorm3]
    }
  }
}

#declare TopTex =  texture { Base scale 20 }

#declare CracksTex = texture {
  crackle
  texture_map {
    [0 BottomTex]
    [.003 BottomTex]
    [.005 TopTex]
    [1 TopTex]
  }
  cubic_wave
  scale 2
  warp { turbulence .1 }
  scale 1/2
  scale .1
}

#declare Cracks = function {
  pigment {
    crackle
    color_map {
      [0 rgb 0]
      [.005 rgb 0]
      [.01 rgb 1]
      [.25 rgb .7]
      [1 rgb .6]
    }
    cubic_wave
    scale 2
    warp { turbulence .1 }
    scale 1/2
    scale .1
  }
}

#declare Bumps = function { pigment { 
  blob { 
    sphere { <0,0,0>, .1, strength .02 density_function 0, 1 }
    sphere { <.45,0,.4>, .1, strength .02 density_function 0, 1 }
    sphere { <-.75,0,.25>, .1, strength .02 density_function 0, 1 }
    threshold 0
    max_density 1
  }
  color_map {
    [0 rgb 0]
    [1 rgb 1]
  }
  scale 20
  warp { turbulence .5 }
  scale 1/20 
} }


isosurface {
  function { y-.005*Cracks(x,0,z)-Bumps(x,y,z) }
  contained_by { box { <-10, -.01, -10>, <10, .1, 10> } }
  texture { CracksTex }
} 

//********************************************* Flower ***************************************************

/* POV-Ray 3.1 Scene Description File
   FURTEX
   Copyright April 2000 Rune S. Johansen - http://rsj.mobilixnet.dk
   
   Use:
   
   object {
      MyObject
      FurTex ( color MyColor )
   }
   
*/
// Start of FurTex macro
   #macro FurTex(Color)
      texture {
         average
         texture_map {
            [
               pigment {
                  bozo
                  color_map {[0,color Color*0.9][1,color Color*1.1]}
                  scale 0.001
               }
               normal {
                  average
                  normal_map {
                     [
                        bumps 0.3*2
                        warp {turbulence 1}
                        scale 0.2
                     ]
                     [
                        bumps 0.2*2
                        warp {turbulence 0.5}
                        scale 0.001
                     ]
                  }
               }
               finish {ambient 0.1*2 diffuse 0.6*2 brilliance 0.6}
            ]
            [
               pigment {color -Color}
               finish {ambient 0 diffuse 0 phong 0.5*2 phong_size 2 metallic}
            ]
         }
      }
   #end
// End of FurTex macro

#declare LeafPig1 = pigment { 
  bozo
  color_map {
    [0 rgb <.45,.55,.28>*.8]
    [.4 rgb <.41, .52, .23>]
    [.6 rgb <.44, .61, .39>*.9]
    [1 rgb <.34, .53, .29>]
  }
  warp { turbulence 1 }
  scale <.1, 1, .1>
  warp { turbulence .5 }  
}

#declare LeafPig2 = pigment { 
  bozo
  color_map {
    [0 rgb <.35,.55,.32>*.8]
    [.15 rgb <.54, .61, .39>*.85]
    [.4 rgb <.41, .42, .23>]
    [.7 rgb <.44, .61, .39>*.9]
    [1 rgb <.44, .53, .29>]
  }
  warp { turbulence .3 }
  scale <.1, 1, .1> 
}

#declare LeafPig3 = pigment { 
  bozo
  color_map {
    [0 rgb <.39,.55,.30>*.8]
    [.15 rgb <.54, .61, .39>*.85]
    [.4 rgb <.41, .42, .23>]
    [.7 rgb <.49, .61, .39>*.9]
    [1 rgb <.48, .53, .29>]
  }
  warp { turbulence .3 }
  scale <.07, 1, .07> 
}

#declare LeafNorm1 = normal {
  radial 
  slope_map {
    [0 <0, 0>]
    [.1 <0, 1>*.2]
    [.25 <.7, 1>*.2]
    [.4 <1, .5>*.2]
    [.95 <.9, .3>*.2]
    [1 <1, 0>*.2]
  }
  frequency 20
}

#declare LeafNorm2 = normal {
  function { noise3d(100*x/sqrt(x^2+z^2),4*y,100*z/sqrt(x^2+z^2)) }
  slope_map {
    [0 <0,0>]
    [.2 <.1,.25>*4]
    [.5 <.18, .1>*4]
    [1 <.2, 0>*4]
   }
}

#declare LeafTex = texture {
  pigment {
    radial 
    pigment_map {
      [0 LeafPig1]
      [.4 LeafPig1]
      [.8 LeafPig3]
      [1 LeafPig3]
    }
    triangle_wave
    frequency 4
    rotate <0,45,0>
    warp { black_hole <.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <-.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <.7, 2.5, -.7>, 1.7 strength 2 inverse }
    warp { black_hole <-.7, 2.3, -.7>, 1.5 strength 2 inverse }
  }
  normal {
    average
    normal_map {
      [LeafNorm1]
      [.7 LeafNorm2]
    }
    warp { black_hole <.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <-.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <.7, 2.3, -.7>, 1.5 strength 2 inverse }
    warp { black_hole <-.7, 2.3, -.7>, 1.5 strength 2 inverse }
  }
}

#declare PetalTex1 = texture {
  pigment { color rgb <.8,.1,.25> }
  normal {
    function { noise3d(50*x/sqrt(x^2+z^2),2*y,50*z/sqrt(x^2+z^2)) }
    slope_map {
      [0 <0,0>]
      [.2 <.1,.25>]
      [.5 <.18, .1>]
      [1 <.2, 0>]
    }
  }
}

#declare PetalTex2 =  FurTex(rgb <.67,0,.14>)

#declare PetalTex = texture {
  average
  texture_map {
    [.5 PetalTex1]
    [1 PetalTex2]
  }
}

#declare InnerPetalTex1 = texture {
  pigment { color rgb <.87,.5,.42> }
  normal {
    function { noise3d(70*x/sqrt(x^2+z^2),2*y,70*z/sqrt(x^2+z^2)) }
    slope_map {
      [0 <0,0>]
      [.2 <.1,.25>]
      [.5 <.18, .1>]
      [1 <.2, 0>]
    }
  }
}

#declare InnerPetalTex = texture {
  average
  texture_map {
    [.5 InnerPetalTex1]
    [1 PetalTex2]
  }
}

#declare NullNorm = normal { bumps 0 }

#declare StemTex = texture {
  pigment { LeafPig2 }
  normal {
    average
    normal_map {
      [.5 LeafNorm2]
      [1 NullNorm ]
    }
  }
}

#declare RoseLeafTex = texture {
  pigment { color rgb <.37, .52, .32>*.5 }
}

union {
  object { 
    #include "roseTop2.pov"
    rotate <0, -220, 0>
  }
  #include "roseStem.pov"
  #include "roseLeaf.pov"
  rotate < 0,-75+220,0>
  scale .027
  translate <-.094, .17, -.53>
}


//******************************************** Thorn Plant************************************************

//      Stolen directly from John VanSickle's Macs.inc
#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
#if (vlength(vY)>0)
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
#end
//      end of stolen section


#declare BranchNorm1 = normal {
  granite
  slope_map {
    [0 <0,0>]
    [.2 <.1,.25>*3]
    [.5 <.18, .1>*3]
    [1 <.2, 0>*3]
   }
   scale <.4, 1, .4>
   scale 10
   warp { turbulence .3 }
   scale 1/10
}

#declare BranchNorm2 = normal {
  function { noise3d(15*x,y,15*z) }
  slope_map {
    [0 <0,0>]
    [.2 <.1,.25>*4]
    [.5 <.18, .1>*4]
    [1 <.2, 0>*4]
   }
   cubic_wave
   scale 5
   warp { turbulence .3 }
   scale 1/5
}

#declare BranchNormA = normal {
  crackle
  normal_map {
    [0 BranchNorm2]
    [.1 BranchNorm2]
    [.25 BranchNorm1]
    [1 BranchNorm1]
  }
}

#declare BranchNormB = normal {
  crackle
  slope_map {
    [0 <0, 0>]
    [.1 <0, 1>*2]
    [.25 <.7, 1>*2]
    [.4 <1, .5>*2]
    [1 <1, 0>*2]
  }
}

#declare BranchPig1 = pigment {
  bozo
  color_map {
    [0 rgb <.46,.2,.1>]
    [.3 rgb <.46,.2,.1>]
    [1 rgb <.46,.25,.2>]
  } 
}

#declare BranchPig2 = pigment {
  bozo
  color_map {
    [0 color rgb <.4,.2,.1>]
    [1 color rgb <.4, .15, .07>]
  } 
}

#declare Branch = texture {
  pigment {
    crackle
    pigment_map {
      [0 BranchPig2]
      [.1 BranchPig2]
      [.2 BranchPig1]
      [1 BranchPig1]
    }
  }
  normal { 
    average
    normal_map {
      [BranchNormA]
      [BranchNormB]
    }
  }
  scale <.01,.15,.01>
}

#declare ThornNorm1 = normal { 
  function { noise3d(10*x,y,10*z) }
  slope_map {
    [0 <0,0>]
    [.2 <.1,.25>*8]
    [.5 <.18, .1>*8]
    [1 <.2, 0>*8]
  }
  warp { turbulence .2 }
}

#declare ThornNorm2 = normal {
 function { noise3d(150*x,2*y,150*z) }
  slope_map {
    [0 <0,0>]
    [.1 <.1,.25>*3]
    [.3 <.18, .1>*3]
    [1 <.2, 0>*3]
  }
  cubic_wave
  warp { turbulence .05 }
}

#declare Thorn1 = texture {
  pigment { 
    color rgb <.46,.23,.13>
  }
  normal {
    average
    normal_map {
      [ThornNorm1]
      [ThornNorm2]
    }
  }
  finish { specular .03 roughness .1 }
}

#declare Thorn2 = texture {
  pigment { 
    color rgb <1, .8, 0>*.5
  }
  normal {
    average
    normal_map {
      [ThornNorm1]
      [ThornNorm2]
    }
  }
  finish { specular .125 roughness .07 }
}

#declare Thorn = texture {
  gradient y
  texture_map {
    [0 Thorn2]
    [1 Thorn1]
  }
  scale <.05,1,.05>
} 

#macro BranchTex (p1, p2, rad, d)
  texture { Branch
    translate <0,-d,0> 
    Reorient(y,p2-p1)
    translate p2
  }
#end

#declare Random = seed(1);

#macro ThornTex (p1, p2, rad)
  texture { Thorn
    translate <rand(Random), 0, rand(Random)> 
    scale <1,vlength(p1-p2),1>
    Reorient(y,p1-p2)
    translate p2
  }
#end

//      commented out since I didn't incluse most of these in the zip file, this section was included
//      in the rendered image
/*
blob { 
  #include "stalk1blob.inc"
  threshold .5  
  texture { pigment { color rgb 1 } }
  rotate <0,-6.5,0>
} 
 
union {
  #include "stalk2.inc"
  translate <.45,0,.4>
}

union {
  #include "stalk3.inc"
  rotate <0,180,0>
  translate <-.75,0,.25>
}

union {
  #include "stalk3.inc" 
  rotate <0,90,0>
  translate <.2,-.8,.5>
}  

union {
  #include "stalk4.inc" 
  translate <.1,-.8,.7>
} 

union {
  #include "stalk4.inc"
  rotate <0,90,0> 
  translate <-.5,-.8,.8>
}*/ 


//      Not in the pov file used to render the image, included to give an example of the type of output
//      I used to generate the thorn bushes
union {
  #include "stalk2.inc"
}   