#version unofficial MegaPov 0.5;

/*camera{
	location < 12.014, 8.448, -3.465 >*.5
	look_at < 0, 1.200, 0 >
	angle 40.000
	}

light_source{<100,100,-100> rgb 1}
light_source{<0,10,-1000> rgb 1}

global_settings{
        //ini_option "+QR"
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	motion_blur 5,0.0500
	radiosity{
	        normal on
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}

background{ rgb <0/255,0/255,0/255> } */

/* POV-Ray 3.1 Scene Description File
   FURTEX
   Copyright April 2000 Rune S. Johansen - http://rsj.mobilixnet.dk
   
   Use:
   
   object {
      MyObject
      FurTex ( color MyColor )
   }
   
*/
// Start of FurTex macro 
 /*  #macro FurTex(Color)
      texture {
         average
         texture_map {
            [
               pigment {
                  bozo
                  color_map {[0,color Color*0.9][1,color Color*1.1]}
                  scale 0.001
               }
               normal {
                  average
                  normal_map {
                     [
                        bumps 0.3*2
                        warp {turbulence 1}
                        scale 0.2
                     ]
                     [
                        bumps 0.2*2
                        warp {turbulence 0.5}
                        scale 0.001
                     ]
                  }
               }
               finish {ambient 0.1*2 diffuse 0.6*2 brilliance 0.6}
            ]
            [
               pigment {color -Color}
               finish {ambient 0 diffuse 0 phong 0.5*2 phong_size 2 metallic}
            ]
         }
      }
   #end
// End of FurTex macro

#declare LeafPig1 = pigment { 
  bozo
  color_map {
    [0 rgb <.45,.55,.28>*.8]
    //[.25 rgb <.44, .61, .39>*.85]
    [.4 rgb <.41, .52, .23>]
    [.6 rgb <.44, .61, .39>*.9]
    [1 rgb <.34, .53, .29>]
  }
  warp { turbulence 1 }
  scale <.1, 1, .1>
  warp { turbulence .5 }  
}

#declare LeafPig2 = pigment { 
  bozo
  color_map {
    [0 rgb <.35,.55,.32>*.8]
    [.15 rgb <.54, .61, .39>*.85]
    [.4 rgb <.41, .42, .23>]
    [.7 rgb <.44, .61, .39>*.9]
    [1 rgb <.44, .53, .29>]
  }
  warp { turbulence .3 }
  scale <.1, 1, .1> 
}

#declare LeafPig3 = pigment { 
  bozo
  color_map {
    [0 rgb <.39,.55,.30>*.8]
    [.15 rgb <.54, .61, .39>*.85]
    [.4 rgb <.41, .42, .23>]
    [.7 rgb <.49, .61, .39>*.9]
    [1 rgb <.48, .53, .29>]
  }
  warp { turbulence .3 }
  scale <.07, 1, .07> 
}

#declare LeafNorm1 = normal {
  radial 
  slope_map {
    [0 <0, 0>]
    [.1 <0, 1>*.2]
    [.25 <.7, 1>*.2]
    [.4 <1, .5>*.2]
    [.95 <.9, .3>*.2]
    [1 <1, 0>*.2]
  }
  frequency 20
}

#declare LeafNorm2 = normal {
  function { noise3d(100*x/sqrt(x^2+z^2),4*y,100*z/sqrt(x^2+z^2)) }
  slope_map {
    [0 <0,0>]
    [.2 <.1,.25>*4]
    [.5 <.18, .1>*4]
    [1 <.2, 0>*4]
   }
}

#declare LeafTex = texture {
  pigment {
    radial 
    pigment_map {
      [0 LeafPig1]
      [.4 LeafPig1]
      [.8 LeafPig3]
      [1 LeafPig3]
    }
    triangle_wave
    frequency 4
    rotate <0,45,0>
    warp { black_hole <.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <-.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <.7, 2.5, -.7>, 1.7 strength 2 inverse }
    warp { black_hole <-.7, 2.3, -.7>, 1.5 strength 2 inverse }
  }
  normal {
    average
    normal_map {
      [LeafNorm1]
      [.7 LeafNorm2]
    }
    warp { black_hole <.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <-.7, 2.3, .7>, 1.5 strength 2 inverse }
    warp { black_hole <.7, 2.3, -.7>, 1.5 strength 2 inverse }
    warp { black_hole <-.7, 2.3, -.7>, 1.5 strength 2 inverse }
  }
}

#declare PetalTex1 = texture {
  pigment { color rgb <.8,.1,.25> }
  normal {
    function { noise3d(50*x/sqrt(x^2+z^2),2*y,50*z/sqrt(x^2+z^2)) }
    slope_map {
      [0 <0,0>]
      [.2 <.1,.25>]
      [.5 <.18, .1>]
      [1 <.2, 0>]
    }
  }
}

#declare PetalTex2 =  FurTex(rgb <.67,0,.14>)

#declare PetalTex = texture {
  average
  texture_map {
    [.5 PetalTex1]
    [1 PetalTex2]
  }
}

#declare InnerPetalTex1 = texture {
  pigment { color rgb <.87,.5,.42> }
  normal {
    function { noise3d(70*x/sqrt(x^2+z^2),2*y,70*z/sqrt(x^2+z^2)) }
    slope_map {
      [0 <0,0>]
      [.2 <.1,.25>]
      [.5 <.18, .1>]
      [1 <.2, 0>]
    }
  }
}

#declare InnerPetalTex = texture {
  average
  texture_map {
    [.5 InnerPetalTex1]
    [1 PetalTex2]
  }
}*/ 
 
union {
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<0.011, -0.000, -0.311> <-0.051, -0.019, -0.245> <0.008, -0.000, -0.095> <0.011, -0.000, -0.003> 
		<0.011, -0.000, -0.311> <-0.006, -0.019, -0.206> <0.053, -0.000, -0.149> <0.056, -0.000, -0.056> 
		<0.011, -0.000, -0.311> <-0.006, -0.019, -0.206> <0.066, -0.014, -0.197> <0.100, -0.014, -0.148> 
		<0.011, -0.000, -0.311> <0.056, -0.000, -0.272> <0.126, -0.000, -0.230> <0.160, 0.000, -0.181> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.011, -0.000, -0.003> <0.014, -0.000, 0.079> <-0.025, -0.014, 0.210> <0.030, -0.000, 0.268> 
		<0.011, -0.000, -0.003> <-0.015, -0.003, 0.136> <0.009, -0.017, 0.180> <0.064, -0.003, 0.238> 
		<0.011, -0.000, -0.003> <-0.015, -0.003, 0.136> <0.059, -0.022, 0.178> <0.116, -0.008, 0.205> 
		<0.011, -0.000, -0.003> <-0.018, -0.003, 0.055> <0.086, -0.022, 0.142> <0.143, -0.008, 0.168> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.160, 0.000, -0.181> <0.193, 0.000, -0.133> <0.231, 0.001, -0.058> <0.228, 0.000, -0.000> 
		<0.160, 0.000, -0.181> <0.133, -0.014, -0.101> <0.166, -0.008, -0.054> <0.164, -0.009, 0.004> 
		<0.160, 0.000, -0.181> <0.133, -0.014, -0.101> <0.085, 0.003, -0.114> <0.040, 0.003, -0.061> 
		<0.160, 0.000, -0.181> <0.100, -0.014, -0.148> <0.056, -0.000, -0.056> <0.011, -0.000, -0.003> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.228, 0.000, -0.000> <0.225, -0.001, 0.056> <0.177, -0.008, 0.123> <0.143, -0.008, 0.168> 
		<0.228, 0.000, -0.000> <0.161, -0.010, 0.061> <0.119, -0.022, 0.097> <0.086, -0.022, 0.142> 
		<0.228, 0.000, -0.000> <0.161, -0.010, 0.061> <0.011, 0.000, -0.003> <-0.018, -0.003, 0.055> 
		<0.228, 0.000, -0.000> <0.164, -0.009, 0.004> <0.040, 0.003, -0.061> <0.011, -0.000, -0.003> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.316, 0.034, 0.009> <0.254, 0.011, -0.057> <0.101, -0.001, 0.001> <0.008, 0.000, 0.000> 
		<0.316, 0.034, 0.009> <0.215, 0.011, -0.015> <0.155, 0.009, 0.046> <0.062, 0.010, 0.045> 
		<0.316, 0.034, 0.009> <0.215, 0.011, -0.015> <0.201, 0.018, 0.056> <0.153, 0.020, 0.088> 
		<0.316, 0.034, 0.009> <0.277, 0.034, 0.051> <0.234, 0.032, 0.117> <0.186, 0.034, 0.149> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.008, 0.000, 0.000> <-0.074, 0.001, -0.001> <-0.206, 0.026, -0.055> <-0.262, 0.042, 0.002> 
		<0.008, 0.000, 0.000> <-0.123, -0.013, -0.030> <-0.169, 0.014, -0.016> <-0.225, 0.029, 0.041> 
		<0.008, 0.000, 0.000> <-0.123, -0.013, -0.030> <-0.157, -0.013, 0.045> <-0.181, 0.000, 0.098> 
		<0.008, 0.000, 0.000> <-0.041, -0.014, -0.029> <-0.114, -0.013, 0.080> <-0.138, 0.000, 0.132> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.186, 0.034, 0.149> <0.138, 0.035, 0.181> <0.063, 0.048, 0.220> <0.006, 0.042, 0.217> 
		<0.186, 0.034, 0.149> <0.105, 0.021, 0.121> <0.062, 0.036, 0.155> <0.005, 0.030, 0.152> 
		<0.186, 0.034, 0.149> <0.105, 0.021, 0.121> <0.117, 0.026, 0.078> <0.063, 0.016, 0.033> 
		<0.186, 0.034, 0.149> <0.153, 0.020, 0.088> <0.062, 0.010, 0.045> <0.008, 0.000, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.006, 0.042, 0.217> <-0.046, 0.037, 0.214> <-0.098, 0.000, 0.164> <-0.138, 0.000, 0.132> 
		<0.006, 0.042, 0.217> <-0.047, 0.025, 0.149> <-0.074, -0.013, 0.112> <-0.114, -0.013, 0.080> 
		<0.006, 0.042, 0.217> <-0.047, 0.025, 0.149> <0.014, 0.002, 0.004> <-0.041, -0.014, -0.029> 
		<0.006, 0.042, 0.217> <0.005, 0.030, 0.152> <0.063, 0.016, 0.033> <0.008, 0.000, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.009, -0.013, 0.267> <0.075, -0.036, 0.206> <0.012, -0.047, 0.052> <0.012, -0.046, -0.041> 
		<0.009, -0.013, 0.267> <0.032, -0.036, 0.168> <-0.032, -0.037, 0.106> <-0.032, -0.036, 0.013> 
		<0.009, -0.013, 0.267> <0.032, -0.036, 0.168> <-0.041, -0.027, 0.154> <-0.073, -0.026, 0.107> 
		<0.009, -0.013, 0.267> <-0.034, -0.013, 0.229> <-0.101, -0.014, 0.187> <-0.134, -0.013, 0.140> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.046, -0.041> <0.011, -0.045, -0.123> <0.063, -0.020, -0.256> <0.005, -0.004, -0.311> 
		<0.012, -0.046, -0.041> <0.039, -0.059, -0.173> <0.025, -0.033, -0.218> <-0.034, -0.017, -0.273> 
		<0.012, -0.046, -0.041> <0.039, -0.059, -0.173> <-0.036, -0.059, -0.205> <-0.089, -0.046, -0.228> 
		<0.012, -0.046, -0.041> <0.040, -0.060, -0.091> <-0.070, -0.059, -0.161> <-0.123, -0.046, -0.184> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.134, -0.013, 0.140> <-0.167, -0.011, 0.092> <-0.207, 0.002, 0.018> <-0.205, -0.004, -0.040> 
		<-0.134, -0.013, 0.140> <-0.106, -0.025, 0.059> <-0.142, -0.009, 0.016> <-0.140, -0.015, -0.042> 
		<-0.134, -0.013, 0.140> <-0.106, -0.025, 0.059> <-0.064, -0.020, 0.069> <-0.020, -0.030, 0.015> 
		<-0.134, -0.013, 0.140> <-0.073, -0.026, 0.107> <-0.032, -0.036, 0.013> <0.012, -0.046, -0.041> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.205, -0.004, -0.040> <-0.203, -0.009, -0.091> <-0.154, -0.046, -0.144> <-0.123, -0.046, -0.184> 
		<-0.205, -0.004, -0.040> <-0.138, -0.020, -0.093> <-0.102, -0.059, -0.121> <-0.070, -0.059, -0.161> 
		<-0.205, -0.004, -0.040> <-0.138, -0.020, -0.093> <0.008, -0.044, -0.035> <0.040, -0.060, -0.091> 
		<-0.205, -0.004, -0.040> <-0.140, -0.015, -0.042> <-0.020, -0.030, 0.015> <0.012, -0.046, -0.041> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.305, 0.021, 0.012> <-0.244, -0.002, 0.078> <-0.090, -0.014, 0.015> <0.003, -0.013, 0.015> 
		<-0.305, 0.021, 0.012> <-0.206, -0.002, 0.035> <-0.144, -0.004, -0.028> <-0.051, -0.003, -0.029> 
		<-0.305, 0.021, 0.012> <-0.206, -0.002, 0.035> <-0.192, 0.006, -0.037> <-0.145, 0.008, -0.070> 
		<-0.305, 0.021, 0.012> <-0.267, 0.021, -0.031> <-0.225, 0.020, -0.098> <-0.178, 0.021, -0.131> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.003, -0.013, 0.015> <0.085, -0.011, 0.014> <0.218, 0.014, 0.067> <0.273, 0.029, 0.008> 
		<0.003, -0.013, 0.015> <0.135, -0.026, 0.042> <0.180, 0.001, 0.028> <0.235, 0.017, -0.030> 
		<0.003, -0.013, 0.015> <0.135, -0.026, 0.042> <0.167, -0.025, -0.033> <0.190, -0.013, -0.086> 
		<0.003, -0.013, 0.015> <0.053, -0.027, 0.043> <0.123, -0.025, -0.067> <0.146, -0.013, -0.120> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.178, 0.021, -0.131> <-0.130, 0.022, -0.164> <-0.056, 0.035, -0.204> <0.002, 0.029, -0.202> 
		<-0.178, 0.021, -0.131> <-0.097, 0.009, -0.103> <-0.054, 0.024, -0.139> <0.004, 0.019, -0.137> 
		<-0.178, 0.021, -0.131> <-0.097, 0.009, -0.103> <-0.107, 0.014, -0.061> <-0.053, 0.004, -0.017> 
		<-0.178, 0.021, -0.131> <-0.145, 0.008, -0.070> <-0.051, -0.003, -0.029> <0.003, -0.013, 0.015> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.002, 0.029, -0.202> <0.053, 0.024, -0.200> <0.106, -0.013, -0.151> <0.146, -0.013, -0.120> 
		<0.002, 0.029, -0.202> <0.055, 0.013, -0.135> <0.083, -0.025, -0.098> <0.123, -0.025, -0.067> 
		<0.002, 0.029, -0.202> <0.055, 0.013, -0.135> <-0.003, -0.011, 0.011> <0.053, -0.027, 0.043> 
		<0.002, 0.029, -0.202> <0.004, 0.019, -0.137> <-0.053, 0.004, -0.017> <0.003, -0.013, 0.015> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <0.055, -0.445, 0.004> <0.055, -0.445, 0.004> <0.055, -0.445, 0.004> 
		<0.012, -0.443, 0.003> <0.055, -0.445, 0.004> <0.084, -0.446, 0.007> <0.114, -0.414, 0.008> 
		<0.012, -0.443, 0.003> <0.055, -0.445, 0.004> <0.114, -0.414, 0.008> <0.143, -0.382, 0.008> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <-0.040, -0.441, 0.001> <-0.040, -0.441, 0.001> <-0.040, -0.441, 0.001> 
		<0.012, -0.443, 0.003> <-0.040, -0.441, 0.001> <-0.070, -0.441, 0.001> <-0.106, -0.405, 0.000> 
		<0.012, -0.443, 0.003> <-0.040, -0.441, 0.001> <-0.106, -0.405, 0.000> <-0.143, -0.369, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <0.015, -0.423, -0.042> <0.015, -0.423, -0.042> <0.015, -0.423, -0.042> 
		<0.012, -0.443, 0.003> <0.015, -0.423, -0.042> <0.023, -0.449, -0.081> <0.023, -0.412, -0.114> 
		<0.012, -0.443, 0.003> <0.015, -0.423, -0.042> <0.023, -0.412, -0.114> <0.023, -0.376, -0.148> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> <0.012, -0.443, 0.003> 
		<0.012, -0.443, 0.003> <0.012, -0.425, 0.049> <0.012, -0.425, 0.049> <0.012, -0.425, 0.049> 
		<0.012, -0.443, 0.003> <0.012, -0.425, 0.049> <0.012, -0.457, 0.091> <0.012, -0.420, 0.124> 
		<0.012, -0.443, 0.003> <0.012, -0.425, 0.049> <0.012, -0.420, 0.124> <0.012, -0.383, 0.156> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.281, 0.008, 0.000> <-0.281, 0.008, 0.142> <-0.131, 0.016, 0.223> <0.012, 0.019, 0.223> 
		<-0.281, 0.008, 0.000> <-0.281, 0.008, -0.004> <-0.131, 0.016, 0.084> <0.012, 0.019, 0.084> 
		<-0.281, 0.008, 0.000> <-0.281, 0.008, -0.004> <-0.135, 0.016, -0.101> <0.012, 0.019, -0.101> 
		<-0.281, 0.008, 0.000> <-0.281, 0.008, -0.146> <-0.135, 0.016, -0.240> <0.012, 0.019, -0.240> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, 0.019, 0.223> <0.143, 0.022, 0.223> <0.270, 0.019, 0.132> <0.270, 0.019, 0.000> 
		<0.012, 0.019, 0.223> <0.143, 0.022, 0.084> <0.270, 0.019, -0.004> <0.270, 0.019, -0.136> 
		<0.012, 0.019, 0.223> <0.143, 0.022, 0.084> <0.148, 0.022, -0.101> <0.148, 0.022, -0.240> 
		<0.012, 0.019, 0.223> <0.012, 0.019, 0.084> <0.012, 0.019, -0.101> <0.012, 0.019, -0.240> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.143, -0.382, 0.008> <0.114, -0.414, 0.008> <0.055, -0.445, 0.004> <0.012, -0.443, 0.003> 
		<0.143, -0.382, 0.008> <0.116, -0.413, -0.052> <0.058, -0.425, -0.041> <0.015, -0.423, -0.042> 
		<0.143, -0.382, 0.008> <0.116, -0.413, -0.052> <0.082, -0.415, -0.113> <0.023, -0.412, -0.114> 
		<0.143, -0.382, 0.008> <0.145, -0.380, -0.051> <0.082, -0.378, -0.146> <0.023, -0.376, -0.148> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.143, -0.382, 0.008> <0.114, -0.414, 0.008> <0.055, -0.445, 0.004> <0.012, -0.443, 0.003> 
		<0.143, -0.382, 0.008> <0.111, -0.415, 0.067> <0.055, -0.427, 0.050> <0.012, -0.425, 0.049> 
		<0.143, -0.382, 0.008> <0.111, -0.415, 0.067> <0.071, -0.423, 0.125> <0.012, -0.420, 0.124> 
		<0.143, -0.382, 0.008> <0.141, -0.383, 0.068> <0.071, -0.386, 0.158> <0.012, -0.383, 0.156> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <-0.040, -0.441, 0.001> <-0.106, -0.405, 0.000> <-0.143, -0.369, 0.000> 
		<0.012, -0.443, 0.003> <-0.040, -0.423, 0.047> <-0.109, -0.406, 0.066> <-0.145, -0.370, 0.066> 
		<0.012, -0.443, 0.003> <-0.040, -0.423, 0.047> <-0.054, -0.417, 0.122> <-0.054, -0.380, 0.155> 
		<0.012, -0.443, 0.003> <0.012, -0.425, 0.049> <0.012, -0.420, 0.124> <0.012, -0.383, 0.156> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.443, 0.003> <-0.040, -0.441, 0.001> <-0.106, -0.405, 0.000> <-0.143, -0.369, 0.000> 
		<0.012, -0.443, 0.003> <-0.036, -0.421, -0.044> <-0.104, -0.403, -0.066> <-0.140, -0.367, -0.067> 
		<0.012, -0.443, 0.003> <-0.036, -0.421, -0.044> <-0.044, -0.409, -0.116> <-0.044, -0.373, -0.150> 
		<0.012, -0.443, 0.003> <0.015, -0.423, -0.042> <0.023, -0.412, -0.114> <0.023, -0.376, -0.148> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.498, 0.127, 0.504> <0.679, 0.290, 0.587> <0.894, 0.579, 0.686> <0.953, 0.830, 0.688> 
		<0.522, 0.130, 0.429> <0.703, 0.293, 0.512> <0.938, 0.576, 0.591> <0.997, 0.826, 0.593> 
		<0.560, 0.144, 0.332> <0.754, 0.311, 0.373> <1.007, 0.576, 0.466> <1.075, 0.827, 0.473> 
		<0.577, 0.138, 0.255> <0.771, 0.306, 0.297> <1.032, 0.568, 0.365> <1.100, 0.818, 0.371> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.756, 2.700, 0.007> <0.756, 2.700, 0.011> <0.619, 2.189, -0.078> <0.625, 1.974, -0.150> 
		<0.738, 2.480, 0.011> <0.738, 2.480, 0.014> <0.635, 2.189, -0.061> <0.641, 1.974, -0.133> 
		<0.663, 2.186, 0.020> <0.665, 2.188, -0.014> <0.682, 1.974, -0.083> <0.669, 1.975, -0.115> 
		<0.697, 1.968, 0.019> <0.699, 1.970, -0.015> <0.691, 1.973, -0.062> <0.678, 1.974, -0.094> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.966, 0.841, -0.592> <0.911, 0.599, -0.611> <0.692, 0.311, -0.586> <0.510, 0.150, -0.532> 
		<0.995, 0.834, -0.519> <0.940, 0.592, -0.539> <0.710, 0.304, -0.518> <0.527, 0.143, -0.464> 
		<1.043, 0.827, -0.426> <0.976, 0.581, -0.444> <0.741, 0.305, -0.409> <0.553, 0.136, -0.374> 
		<1.063, 0.818, -0.350> <0.996, 0.572, -0.369> <0.756, 0.296, -0.340> <0.569, 0.127, -0.305> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.510, 0.150, -0.532> <0.385, 0.040, -0.496> <0.125, 0.034, -0.432> <0.011, -0.000, -0.311> 
		<0.527, 0.143, -0.464> <0.403, 0.033, -0.428> <0.170, 0.034, -0.393> <0.056, -0.000, -0.272> 
		<0.553, 0.136, -0.374> <0.455, 0.047, -0.355> <0.241, 0.026, -0.292> <0.126, -0.000, -0.230> 
		<0.569, 0.127, -0.305> <0.471, 0.038, -0.287> <0.275, 0.026, -0.243> <0.160, 0.000, -0.181> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.030, -0.000, 0.268> <0.141, 0.029, 0.382> <0.384, 0.024, 0.452> <0.498, 0.127, 0.504> 
		<0.064, -0.003, 0.238> <0.174, 0.026, 0.353> <0.408, 0.028, 0.378> <0.522, 0.130, 0.429> 
		<0.116, -0.008, 0.205> <0.241, 0.022, 0.261> <0.456, 0.054, 0.310> <0.560, 0.144, 0.332> 
		<0.143, -0.008, 0.168> <0.267, 0.022, 0.225> <0.473, 0.048, 0.233> <0.577, 0.138, 0.255> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.625, 1.974, -0.150> <0.641, 1.974, -0.133> <0.669, 1.975, -0.115> <0.678, 1.974, -0.094> 
		<0.631, 1.785, -0.213> <0.647, 1.785, -0.197> <0.739, 1.796, -0.151> <0.748, 1.795, -0.129> 
		<0.742, 1.574, -0.360> <0.777, 1.568, -0.295> <0.824, 1.563, -0.241> <0.851, 1.559, -0.172> 
		<0.796, 1.394, -0.430> <0.831, 1.389, -0.365> <0.885, 1.381, -0.281> <0.911, 1.377, -0.212> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.678, 1.974, -0.094> <0.691, 1.973, -0.062> <0.699, 1.970, -0.015> <0.697, 1.968, 0.019> 
		<0.748, 1.795, -0.129> <0.761, 1.794, -0.098> <0.728, 1.777, -0.016> <0.727, 1.774, 0.018> 
		<0.851, 1.559, -0.172> <0.874, 1.556, -0.111> <0.894, 1.555, -0.064> <0.894, 1.555, 0.001> 
		<0.911, 1.377, -0.212> <0.934, 1.374, -0.151> <0.960, 1.370, -0.065> <0.960, 1.371, -0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.666, 1.961, 0.110> <0.658, 1.963, 0.130> <0.645, 1.976, 0.153> <0.636, 1.983, 0.171> 
		<0.741, 1.787, 0.164> <0.733, 1.789, 0.183> <0.651, 1.780, 0.229> <0.642, 1.787, 0.247> 
		<0.847, 1.562, 0.248> <0.824, 1.565, 0.321> <0.781, 1.577, 0.364> <0.746, 1.580, 0.431> 
		<0.915, 1.383, 0.289> <0.892, 1.386, 0.362> <0.833, 1.391, 0.447> <0.797, 1.394, 0.515> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.796, 1.394, -0.430> <0.831, 1.389, -0.365> <0.885, 1.381, -0.281> <0.911, 1.377, -0.212> 
		<0.845, 1.232, -0.493> <0.879, 1.227, -0.428> <0.940, 1.215, -0.318> <0.966, 1.211, -0.249> 
		<1.007, 1.016, -0.577> <1.036, 1.009, -0.505> <1.091, 0.999, -0.413> <1.110, 0.990, -0.338> 
		<0.966, 0.841, -0.592> <0.995, 0.834, -0.519> <1.043, 0.827, -0.426> <1.063, 0.818, -0.350> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.911, 1.377, -0.212> <0.934, 1.374, -0.151> <0.960, 1.370, -0.065> <0.960, 1.371, -0.000> 
		<0.966, 1.211, -0.249> <0.990, 1.208, -0.188> <1.022, 1.195, -0.066> <1.023, 1.196, -0.001> 
		<1.110, 0.990, -0.338> <1.138, 0.978, -0.231> <1.166, 0.952, -0.093> <1.171, 0.952, 0.017> 
		<1.063, 0.818, -0.350> <1.091, 0.806, -0.244> <1.118, 0.772, -0.100> <1.124, 0.772, 0.011> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.960, 1.371, -0.000> <0.961, 1.372, 0.088> <0.942, 1.379, 0.205> <0.915, 1.383, 0.289> 
		<0.894, 1.555, 0.001> <0.895, 1.556, 0.089> <0.873, 1.558, 0.164> <0.847, 1.562, 0.248> 
		<0.727, 1.774, 0.018> <0.725, 1.773, 0.047> <0.752, 1.785, 0.137> <0.741, 1.787, 0.164> 
		<0.697, 1.968, 0.019> <0.695, 1.966, 0.048> <0.677, 1.958, 0.083> <0.666, 1.961, 0.110> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.915, 1.383, 0.289> <0.892, 1.386, 0.362> <0.833, 1.391, 0.447> <0.797, 1.394, 0.515> 
		<0.978, 1.218, 0.326> <0.954, 1.221, 0.399> <0.877, 1.228, 0.520> <0.842, 1.232, 0.587> 
		<1.147, 0.992, 0.376> <1.122, 1.000, 0.477> <1.039, 1.004, 0.594> <0.995, 1.008, 0.689> 
		<1.100, 0.818, 0.371> <1.075, 0.827, 0.473> <0.997, 0.826, 0.593> <0.953, 0.830, 0.688> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.124, 0.772, 0.011> <1.129, 0.772, 0.120> <1.127, 0.809, 0.266> <1.100, 0.818, 0.371> 
		<1.171, 0.952, 0.017> <1.177, 0.952, 0.126> <1.174, 0.983, 0.271> <1.147, 0.992, 0.376> 
		<1.023, 1.196, -0.001> <1.024, 1.196, 0.087> <1.004, 1.214, 0.243> <0.978, 1.218, 0.326> 
		<0.960, 1.371, -0.000> <0.961, 1.372, 0.088> <0.942, 1.379, 0.205> <0.915, 1.383, 0.289> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<1.124, 0.772, 0.011> <1.129, 0.772, 0.120> <1.127, 0.809, 0.266> <1.100, 0.818, 0.371> 
		<1.059, 0.525, 0.003> <1.064, 0.525, 0.112> <1.059, 0.559, 0.259> <1.032, 0.568, 0.365> 
		<0.814, 0.254, -0.041> <0.816, 0.255, 0.051> <0.791, 0.299, 0.207> <0.771, 0.306, 0.297> 
		<0.621, 0.087, -0.043> <0.622, 0.089, 0.049> <0.597, 0.132, 0.166> <0.577, 0.138, 0.255> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.577, 0.138, 0.255> <0.597, 0.132, 0.166> <0.622, 0.089, 0.049> <0.621, 0.087, -0.043> 
		<0.473, 0.048, 0.233> <0.493, 0.041, 0.144> <0.530, 0.009, 0.047> <0.529, 0.008, -0.044> 
		<0.267, 0.022, 0.225> <0.301, 0.022, 0.179> <0.345, 0.016, 0.048> <0.348, 0.017, -0.008> 
		<0.143, -0.008, 0.168> <0.177, -0.008, 0.123> <0.225, -0.001, 0.056> <0.228, 0.000, -0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.621, 0.087, -0.043> <0.814, 0.254, -0.041> <1.059, 0.525, 0.003> <1.124, 0.772, 0.011> 
		<0.619, 0.085, -0.124> <0.813, 0.252, -0.122> <1.053, 0.525, -0.108> <1.118, 0.772, -0.100> 
		<0.587, 0.117, -0.227> <0.774, 0.286, -0.262> <1.024, 0.560, -0.262> <1.091, 0.806, -0.244> 
		<0.569, 0.127, -0.305> <0.756, 0.296, -0.340> <0.996, 0.572, -0.369> <1.063, 0.818, -0.350> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.697, 1.968, 0.019> <0.663, 2.186, 0.020> <0.738, 2.480, 0.011> <0.756, 2.700, 0.007> 
		<0.695, 1.966, 0.048> <0.662, 2.184, 0.049> <0.738, 2.480, 0.007> <0.756, 2.700, 0.003> 
		<0.677, 1.958, 0.083> <0.669, 1.960, 0.103> <0.638, 2.184, 0.072> <0.629, 2.191, 0.090> 
		<0.666, 1.961, 0.110> <0.658, 1.963, 0.130> <0.645, 1.976, 0.153> <0.636, 1.983, 0.171> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.160, 0.000, -0.181> <0.275, 0.026, -0.243> <0.471, 0.038, -0.287> <0.569, 0.127, -0.305> 
		<0.193, 0.000, -0.133> <0.308, 0.026, -0.196> <0.488, 0.028, -0.208> <0.587, 0.117, -0.227> 
		<0.231, 0.001, -0.058> <0.351, 0.018, -0.066> <0.527, 0.006, -0.125> <0.619, 0.085, -0.124> 
		<0.228, 0.000, -0.000> <0.348, 0.017, -0.008> <0.529, 0.008, -0.044> <0.621, 0.087, -0.043> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.442, 0.127, 0.465> <-0.512, 0.287, 0.659> <-0.608, 0.579, 0.881> <-0.603, 0.830, 0.953> 
		<-0.384, 0.130, 0.495> <-0.454, 0.291, 0.689> <-0.520, 0.575, 0.922> <-0.515, 0.826, 0.994> 
		<-0.313, 0.141, 0.550> <-0.348, 0.307, 0.744> <-0.403, 0.578, 0.997> <-0.403, 0.827, 1.064> 
		<-0.250, 0.138, 0.566> <-0.285, 0.304, 0.760> <-0.309, 0.569, 1.022> <-0.309, 0.818, 1.089> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.024, 2.714, 0.839> <0.021, 2.714, 0.839> <0.107, 2.196, 0.706> <0.167, 1.974, 0.700> 
		<0.021, 2.490, 0.814> <0.017, 2.490, 0.814> <0.094, 2.194, 0.713> <0.153, 1.972, 0.708> 
		<0.016, 2.192, 0.739> <0.050, 2.193, 0.738> <0.105, 1.965, 0.733> <0.137, 1.967, 0.721> 
		<0.013, 1.968, 0.758> <0.047, 1.969, 0.756> <0.090, 1.965, 0.738> <0.122, 1.966, 0.726> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.552, 0.841, 0.933> <0.575, 0.615, 0.879> <0.548, 0.334, 0.694> <0.504, 0.183, 0.521> 
		<0.493, 0.834, 0.969> <0.516, 0.608, 0.915> <0.490, 0.317, 0.705> <0.446, 0.166, 0.532> 
		<0.421, 0.826, 1.031> <0.440, 0.581, 0.964> <0.407, 0.302, 0.741> <0.371, 0.137, 0.550> 
		<0.356, 0.818, 1.052> <0.374, 0.572, 0.985> <0.346, 0.293, 0.749> <0.311, 0.127, 0.558> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.504, 0.183, 0.521> <0.472, 0.074, 0.396> <0.430, 0.075, 0.128> <0.316, 0.034, 0.009> 
		<0.446, 0.166, 0.532> <0.414, 0.057, 0.407> <0.391, 0.075, 0.170> <0.277, 0.034, 0.051> 
		<0.371, 0.137, 0.550> <0.352, 0.051, 0.452> <0.295, 0.058, 0.230> <0.234, 0.032, 0.117> 
		<0.311, 0.127, 0.558> <0.292, 0.042, 0.460> <0.248, 0.059, 0.262> <0.186, 0.034, 0.149> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.262, 0.042, 0.002> <-0.365, 0.071, 0.109> <-0.402, 0.034, 0.352> <-0.442, 0.127, 0.465> 
		<-0.225, 0.029, 0.041> <-0.328, 0.058, 0.148> <-0.344, 0.037, 0.383> <-0.384, 0.130, 0.495> 
		<-0.181, 0.000, 0.098> <-0.238, 0.031, 0.223> <-0.294, 0.051, 0.444> <-0.313, 0.141, 0.550> 
		<-0.138, 0.000, 0.132> <-0.195, 0.031, 0.257> <-0.231, 0.048, 0.460> <-0.250, 0.138, 0.566> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.167, 1.974, 0.700> <0.153, 1.972, 0.708> <0.137, 1.967, 0.721> <0.122, 1.966, 0.726> 
		<0.215, 1.793, 0.696> <0.202, 1.790, 0.704> <0.165, 1.790, 0.773> <0.151, 1.789, 0.779> 
		<0.320, 1.569, 0.772> <0.271, 1.564, 0.800> <0.234, 1.556, 0.830> <0.181, 1.553, 0.850> 
		<0.379, 1.394, 0.808> <0.331, 1.389, 0.836> <0.270, 1.381, 0.880> <0.217, 1.377, 0.900> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.122, 1.966, 0.726> <0.090, 1.965, 0.738> <0.047, 1.969, 0.756> <0.013, 1.968, 0.758> 
		<0.151, 1.789, 0.779> <0.119, 1.788, 0.790> <0.045, 1.781, 0.772> <0.011, 1.781, 0.773> 
		<0.181, 1.553, 0.850> <0.121, 1.549, 0.873> <0.074, 1.551, 0.895> <0.008, 1.551, 0.896> 
		<0.217, 1.377, 0.900> <0.156, 1.374, 0.923> <0.071, 1.370, 0.949> <0.006, 1.371, 0.949> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.093, 1.961, 0.734> <-0.115, 1.963, 0.726> <-0.136, 1.976, 0.705> <-0.154, 1.983, 0.693> 
		<-0.140, 1.787, 0.785> <-0.162, 1.789, 0.777> <-0.199, 1.788, 0.704> <-0.217, 1.795, 0.692> 
		<-0.216, 1.558, 0.850> <-0.270, 1.561, 0.835> <-0.298, 1.571, 0.812> <-0.349, 1.575, 0.791> 
		<-0.249, 1.383, 0.904> <-0.303, 1.385, 0.889> <-0.368, 1.391, 0.853> <-0.419, 1.394, 0.831> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.379, 1.394, 0.808> <0.331, 1.389, 0.836> <0.270, 1.381, 0.880> <0.217, 1.377, 0.900> 
		<0.435, 1.229, 0.842> <0.387, 1.224, 0.869> <0.304, 1.212, 0.928> <0.252, 1.209, 0.948> 
		<0.534, 1.013, 0.973> <0.475, 1.006, 1.009> <0.408, 0.998, 1.078> <0.343, 0.990, 1.099> 
		<0.552, 0.841, 0.933> <0.493, 0.834, 0.969> <0.421, 0.826, 1.031> <0.356, 0.818, 1.052> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.217, 1.377, 0.900> <0.156, 1.374, 0.923> <0.071, 1.370, 0.949> <0.006, 1.371, 0.949> 
		<0.252, 1.209, 0.948> <0.191, 1.205, 0.971> <0.068, 1.192, 1.002> <0.003, 1.192, 1.002> 
		<0.343, 0.990, 1.099> <0.238, 0.977, 1.133> <0.103, 0.951, 1.159> <-0.007, 0.951, 1.165> 
		<0.356, 0.818, 1.052> <0.251, 0.805, 1.086> <0.105, 0.772, 1.107> <-0.006, 0.772, 1.113> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.006, 1.371, 0.949> <-0.072, 1.372, 0.950> <-0.175, 1.379, 0.925> <-0.249, 1.383, 0.904> 
		<0.008, 1.551, 0.896> <-0.069, 1.552, 0.896> <-0.141, 1.554, 0.870> <-0.216, 1.558, 0.850> 
		<0.011, 1.781, 0.773> <-0.022, 1.780, 0.774> <-0.110, 1.785, 0.797> <-0.140, 1.787, 0.785> 
		<0.013, 1.968, 0.758> <-0.019, 1.967, 0.759> <-0.063, 1.958, 0.746> <-0.093, 1.961, 0.734> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.249, 1.383, 0.904> <-0.303, 1.385, 0.889> <-0.368, 1.391, 0.853> <-0.419, 1.394, 0.831> 
		<-0.281, 1.214, 0.956> <-0.335, 1.217, 0.942> <-0.433, 1.225, 0.891> <-0.484, 1.228, 0.869> 
		<-0.309, 0.991, 1.136> <-0.403, 1.000, 1.111> <-0.512, 1.001, 1.045> <-0.600, 1.004, 1.004> 
		<-0.309, 0.818, 1.089> <-0.403, 0.827, 1.064> <-0.515, 0.826, 0.994> <-0.603, 0.830, 0.953> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.006, 0.772, 1.113> <-0.098, 0.772, 1.118> <-0.220, 0.809, 1.113> <-0.309, 0.818, 1.089> 
		<-0.007, 0.951, 1.165> <-0.100, 0.951, 1.170> <-0.220, 0.982, 1.160> <-0.309, 0.991, 1.136> 
		<0.003, 1.192, 1.002> <-0.075, 1.193, 1.003> <-0.206, 1.210, 0.977> <-0.281, 1.214, 0.956> 
		<0.006, 1.371, 0.949> <-0.072, 1.372, 0.950> <-0.175, 1.379, 0.925> <-0.249, 1.383, 0.904> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.006, 0.772, 1.113> <-0.098, 0.772, 1.118> <-0.220, 0.809, 1.113> <-0.309, 0.818, 1.089> 
		<-0.004, 0.526, 1.041> <-0.096, 0.526, 1.046> <-0.221, 0.561, 1.045> <-0.309, 0.569, 1.022> 
		<0.014, 0.266, 0.780> <-0.066, 0.267, 0.781> <-0.207, 0.300, 0.780> <-0.285, 0.304, 0.760> 
		<0.017, 0.104, 0.581> <-0.064, 0.105, 0.582> <-0.172, 0.134, 0.586> <-0.250, 0.138, 0.566> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.250, 0.138, 0.566> <-0.172, 0.134, 0.586> <-0.064, 0.105, 0.582> <0.017, 0.104, 0.581> 
		<-0.231, 0.048, 0.460> <-0.153, 0.044, 0.480> <-0.063, 0.035, 0.496> <0.018, 0.034, 0.495> 
		<-0.195, 0.031, 0.257> <-0.155, 0.031, 0.289> <-0.044, 0.056, 0.323> <0.007, 0.061, 0.326> 
		<-0.138, 0.000, 0.132> <-0.098, 0.000, 0.164> <-0.046, 0.037, 0.214> <0.006, 0.042, 0.217> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.017, 0.104, 0.581> <0.014, 0.266, 0.780> <-0.004, 0.526, 1.041> <-0.006, 0.772, 1.113> 
		<0.106, 0.102, 0.580> <0.103, 0.264, 0.778> <0.107, 0.526, 1.035> <0.105, 0.772, 1.107> 
		<0.224, 0.113, 0.568> <0.260, 0.278, 0.759> <0.269, 0.559, 1.019> <0.251, 0.805, 1.086> 
		<0.311, 0.127, 0.558> <0.346, 0.293, 0.749> <0.374, 0.572, 0.985> <0.356, 0.818, 1.052> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.013, 1.968, 0.758> <0.016, 2.192, 0.739> <0.021, 2.490, 0.814> <0.024, 2.714, 0.839> 
		<-0.019, 1.967, 0.759> <-0.016, 2.192, 0.740> <0.025, 2.490, 0.814> <0.028, 2.714, 0.839> 
		<-0.063, 1.958, 0.746> <-0.084, 1.960, 0.738> <-0.063, 2.194, 0.706> <-0.081, 2.201, 0.694> 
		<-0.093, 1.961, 0.734> <-0.115, 1.963, 0.726> <-0.136, 1.976, 0.705> <-0.154, 1.983, 0.693> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.186, 0.034, 0.149> <0.248, 0.059, 0.262> <0.292, 0.042, 0.460> <0.311, 0.127, 0.558> 
		<0.138, 0.035, 0.181> <0.200, 0.061, 0.294> <0.205, 0.027, 0.470> <0.224, 0.113, 0.568> 
		<0.063, 0.048, 0.220> <0.065, 0.067, 0.329> <0.107, 0.032, 0.494> <0.106, 0.102, 0.580> 
		<0.006, 0.042, 0.217> <0.007, 0.061, 0.326> <0.018, 0.034, 0.495> <0.017, 0.104, 0.581> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.460, 0.081, -0.483> <-0.653, 0.241, -0.551> <-0.877, 0.532, -0.662> <-0.941, 0.783, -0.647> 
		<-0.490, 0.084, -0.425> <-0.683, 0.245, -0.493> <-0.920, 0.528, -0.570> <-0.983, 0.780, -0.554> 
		<-0.538, 0.095, -0.351> <-0.733, 0.261, -0.382> <-0.991, 0.530, -0.438> <-1.054, 0.780, -0.436> 
		<-0.559, 0.092, -0.289> <-0.754, 0.258, -0.320> <-1.020, 0.522, -0.341> <-1.083, 0.772, -0.339> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.078, 2.515, -0.010> <-1.078, 2.515, -0.014> <-0.800, 2.137, 0.072> <-0.755, 1.951, 0.130> 
		<-1.026, 2.347, -0.014> <-1.026, 2.347, -0.017> <-0.828, 2.126, 0.059> <-0.783, 1.941, 0.117> 
		<-0.921, 2.131, -0.020> <-0.923, 2.131, 0.019> <-0.852, 1.917, 0.082> <-0.825, 1.916, 0.109> 
		<-0.904, 1.957, -0.022> <-0.905, 1.957, 0.016> <-0.875, 1.918, 0.058> <-0.848, 1.917, 0.086> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.900, 0.795, 0.609> <-0.847, 0.567, 0.626> <-0.681, 0.287, 0.505> <-0.512, 0.137, 0.441> 
		<-0.947, 0.788, 0.545> <-0.894, 0.560, 0.561> <-0.696, 0.270, 0.454> <-0.527, 0.120, 0.390> 
		<-1.027, 0.781, 0.467> <-0.960, 0.532, 0.481> <-0.743, 0.253, 0.378> <-0.551, 0.090, 0.325> 
		<-1.057, 0.772, 0.393> <-0.990, 0.524, 0.407> <-0.755, 0.244, 0.324> <-0.563, 0.081, 0.271> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.512, 0.137, 0.441> <-0.389, 0.028, 0.395> <-0.113, 0.030, 0.379> <0.009, -0.013, 0.267> 
		<-0.527, 0.120, 0.390> <-0.405, 0.011, 0.344> <-0.156, 0.030, 0.341> <-0.034, -0.013, 0.229> 
		<-0.551, 0.090, 0.325> <-0.449, 0.003, 0.297> <-0.220, 0.012, 0.252> <-0.101, -0.014, 0.187> 
		<-0.563, 0.081, 0.271> <-0.461, -0.007, 0.243> <-0.253, 0.014, 0.204> <-0.134, -0.013, 0.140> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.005, -0.004, -0.311> <-0.103, 0.025, -0.412> <-0.349, -0.013, -0.443> <-0.460, 0.081, -0.483> 
		<-0.034, -0.017, -0.273> <-0.142, 0.012, -0.374> <-0.378, -0.009, -0.385> <-0.490, 0.084, -0.425> 
		<-0.089, -0.046, -0.228> <-0.215, -0.016, -0.283> <-0.432, 0.005, -0.334> <-0.538, 0.095, -0.351> 
		<-0.123, -0.046, -0.184> <-0.249, -0.016, -0.239> <-0.452, 0.002, -0.272> <-0.559, 0.092, -0.289> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.755, 1.951, 0.130> <-0.783, 1.941, 0.117> <-0.825, 1.916, 0.109> <-0.848, 1.917, 0.086> 
		<-0.711, 1.772, 0.186> <-0.739, 1.761, 0.172> <-0.841, 1.740, 0.144> <-0.864, 1.741, 0.121> 
		<-0.770, 1.525, 0.279> <-0.803, 1.520, 0.234> <-0.848, 1.505, 0.207> <-0.870, 1.502, 0.156> 
		<-0.792, 1.348, 0.352> <-0.825, 1.343, 0.307> <-0.879, 1.334, 0.253> <-0.902, 1.331, 0.202> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.848, 1.917, 0.086> <-0.875, 1.918, 0.058> <-0.905, 1.957, 0.016> <-0.904, 1.957, -0.022> 
		<-0.864, 1.741, 0.121> <-0.891, 1.742, 0.093> <-0.886, 1.768, 0.013> <-0.885, 1.767, -0.025> 
		<-0.870, 1.502, 0.156> <-0.899, 1.498, 0.092> <-0.926, 1.504, 0.039> <-0.924, 1.512, -0.032> 
		<-0.902, 1.331, 0.202> <-0.930, 1.327, 0.137> <-0.961, 1.318, 0.044> <-0.959, 1.325, -0.027> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.839, 1.915, -0.129> <-0.830, 1.913, -0.150> <-0.830, 1.936, -0.177> <-0.826, 1.946, -0.197> 
		<-0.853, 1.755, -0.175> <-0.844, 1.754, -0.196> <-0.790, 1.780, -0.232> <-0.786, 1.790, -0.252> 
		<-0.850, 1.543, -0.253> <-0.833, 1.553, -0.293> <-0.809, 1.565, -0.304> <-0.783, 1.575, -0.339> 
		<-0.884, 1.383, -0.283> <-0.867, 1.392, -0.323> <-0.824, 1.407, -0.365> <-0.799, 1.417, -0.400> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.792, 1.348, 0.352> <-0.825, 1.343, 0.307> <-0.879, 1.334, 0.253> <-0.902, 1.331, 0.202> 
		<-0.813, 1.177, 0.423> <-0.846, 1.172, 0.378> <-0.911, 1.160, 0.300> <-0.933, 1.157, 0.249> 
		<-0.942, 0.976, 0.596> <-0.989, 0.969, 0.531> <-1.075, 0.957, 0.458> <-1.105, 0.949, 0.383> 
		<-0.900, 0.795, 0.609> <-0.947, 0.788, 0.545> <-1.027, 0.781, 0.467> <-1.057, 0.772, 0.393> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.902, 1.331, 0.202> <-0.930, 1.327, 0.137> <-0.961, 1.318, 0.044> <-0.959, 1.325, -0.027> 
		<-0.933, 1.157, 0.249> <-0.962, 1.153, 0.184> <-0.996, 1.133, 0.048> <-0.993, 1.141, -0.022> 
		<-1.105, 0.949, 0.383> <-1.147, 0.936, 0.274> <-1.180, 0.907, 0.127> <-1.184, 0.907, 0.009> 
		<-1.057, 0.772, 0.393> <-1.100, 0.759, 0.284> <-1.131, 0.726, 0.128> <-1.135, 0.726, 0.010> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.959, 1.325, -0.027> <-0.956, 1.334, -0.108> <-0.916, 1.364, -0.209> <-0.884, 1.383, -0.283> 
		<-0.924, 1.512, -0.032> <-0.921, 1.520, -0.113> <-0.882, 1.525, -0.180> <-0.850, 1.543, -0.253> 
		<-0.885, 1.767, -0.025> <-0.883, 1.767, -0.064> <-0.869, 1.757, -0.139> <-0.853, 1.755, -0.175> 
		<-0.904, 1.957, -0.022> <-0.902, 1.956, -0.062> <-0.856, 1.917, -0.093> <-0.839, 1.915, -0.129> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.884, 1.383, -0.283> <-0.867, 1.392, -0.323> <-0.824, 1.407, -0.365> <-0.799, 1.417, -0.400> 
		<-0.924, 1.196, -0.317> <-0.907, 1.206, -0.357> <-0.844, 1.213, -0.440> <-0.818, 1.224, -0.475> 
		<-1.130, 0.959, -0.338> <-1.101, 0.968, -0.435> <-1.034, 0.982, -0.542> <-0.992, 0.985, -0.634> 
		<-1.083, 0.772, -0.339> <-1.054, 0.780, -0.436> <-0.983, 0.780, -0.554> <-0.941, 0.783, -0.647> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.135, 0.726, 0.010> <-1.139, 0.726, -0.097> <-1.113, 0.763, -0.237> <-1.083, 0.772, -0.339> 
		<-1.184, 0.907, 0.009> <-1.188, 0.907, -0.098> <-1.160, 0.950, -0.236> <-1.130, 0.959, -0.338> 
		<-0.993, 1.141, -0.022> <-0.991, 1.149, -0.103> <-0.955, 1.178, -0.244> <-0.924, 1.196, -0.317> 
		<-0.959, 1.325, -0.027> <-0.956, 1.334, -0.108> <-0.916, 1.364, -0.209> <-0.884, 1.383, -0.283> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.135, 0.726, 0.010> <-1.139, 0.726, -0.097> <-1.113, 0.763, -0.237> <-1.083, 0.772, -0.339> 
		<-1.068, 0.480, 0.011> <-1.072, 0.480, -0.096> <-1.050, 0.513, -0.238> <-1.020, 0.522, -0.341> 
		<-0.814, 0.215, -0.011> <-0.813, 0.216, -0.094> <-0.780, 0.254, -0.242> <-0.754, 0.258, -0.320> 
		<-0.614, 0.058, -0.022> <-0.613, 0.059, -0.104> <-0.585, 0.088, -0.211> <-0.559, 0.092, -0.289> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.559, 0.092, -0.289> <-0.585, 0.088, -0.211> <-0.613, 0.059, -0.104> <-0.614, 0.058, -0.022> 
		<-0.452, 0.002, -0.272> <-0.479, -0.002, -0.194> <-0.516, -0.017, -0.110> <-0.516, -0.019, -0.027> 
		<-0.249, -0.016, -0.239> <-0.280, -0.016, -0.198> <-0.326, 0.011, -0.087> <-0.327, 0.016, -0.036> 
		<-0.123, -0.046, -0.184> <-0.154, -0.046, -0.144> <-0.203, -0.009, -0.091> <-0.205, -0.004, -0.040> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.614, 0.058, -0.022> <-0.814, 0.215, -0.011> <-1.068, 0.480, 0.011> <-1.135, 0.726, 0.010> 
		<-0.615, 0.056, 0.068> <-0.815, 0.213, 0.078> <-1.064, 0.480, 0.129> <-1.131, 0.726, 0.128> 
		<-0.582, 0.066, 0.185> <-0.774, 0.229, 0.238> <-1.032, 0.511, 0.297> <-1.100, 0.759, 0.284> 
		<-0.563, 0.081, 0.271> <-0.755, 0.244, 0.324> <-0.990, 0.524, 0.407> <-1.057, 0.772, 0.393> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.904, 1.957, -0.022> <-0.921, 2.131, -0.020> <-1.026, 2.347, -0.014> <-1.078, 2.515, -0.010> 
		<-0.902, 1.956, -0.062> <-0.920, 2.131, -0.059> <-1.025, 2.347, -0.011> <-1.077, 2.515, -0.007> 
		<-0.856, 1.917, -0.093> <-0.846, 1.916, -0.114> <-0.875, 2.115, -0.113> <-0.871, 2.124, -0.134> 
		<-0.839, 1.915, -0.129> <-0.830, 1.913, -0.150> <-0.830, 1.936, -0.177> <-0.826, 1.946, -0.197> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.134, -0.013, 0.140> <-0.253, 0.014, 0.204> <-0.461, -0.007, 0.243> <-0.563, 0.081, 0.271> 
		<-0.167, -0.011, 0.092> <-0.286, 0.015, 0.157> <-0.480, -0.021, 0.157> <-0.582, 0.066, 0.185> 
		<-0.207, 0.002, 0.018> <-0.329, 0.022, 0.022> <-0.517, -0.021, 0.062> <-0.615, 0.056, 0.068> 
		<-0.205, -0.004, -0.040> <-0.327, 0.016, -0.036> <-0.516, -0.019, -0.027> <-0.614, 0.058, -0.022> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.445, 0.114, -0.457> <0.517, 0.275, -0.657> <0.639, 0.564, -0.887> <0.625, 0.817, -0.969> 
		<0.387, 0.118, -0.487> <0.459, 0.279, -0.686> <0.550, 0.561, -0.930> <0.535, 0.814, -1.012> 
		<0.313, 0.129, -0.535> <0.349, 0.295, -0.737> <0.422, 0.561, -1.009> <0.420, 0.814, -1.084> 
		<0.251, 0.126, -0.556> <0.287, 0.292, -0.757> <0.326, 0.552, -1.035> <0.325, 0.805, -1.111> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.012, 2.542, -0.919> <-0.009, 2.542, -0.919> <-0.109, 2.146, -0.698> <-0.168, 1.962, -0.682> 
		<-0.013, 2.366, -0.871> <-0.010, 2.366, -0.871> <-0.096, 2.146, -0.709> <-0.155, 1.962, -0.693> 
		<-0.016, 2.138, -0.749> <-0.050, 2.140, -0.749> <-0.108, 1.961, -0.726> <-0.139, 1.962, -0.710> 
		<-0.016, 1.955, -0.759> <-0.050, 1.958, -0.758> <-0.093, 1.960, -0.733> <-0.124, 1.962, -0.718> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.687, 0.828, -0.873> <-0.705, 0.603, -0.815> <-0.550, 0.321, -0.673> <-0.479, 0.171, -0.509> 
		<-0.620, 0.822, -0.927> <-0.638, 0.596, -0.869> <-0.499, 0.304, -0.689> <-0.428, 0.154, -0.524> 
		<-0.542, 0.814, -1.021> <-0.553, 0.566, -0.946> <-0.422, 0.287, -0.740> <-0.363, 0.123, -0.548> 
		<-0.462, 0.805, -1.053> <-0.473, 0.558, -0.979> <-0.369, 0.277, -0.752> <-0.309, 0.114, -0.560> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.479, 0.171, -0.509> <-0.428, 0.061, -0.389> <-0.417, 0.064, -0.110> <-0.305, 0.021, 0.012> 
		<-0.428, 0.154, -0.524> <-0.377, 0.044, -0.404> <-0.379, 0.064, -0.153> <-0.267, 0.021, -0.031> 
		<-0.363, 0.123, -0.548> <-0.332, 0.037, -0.446> <-0.289, 0.046, -0.217> <-0.225, 0.020, -0.098> 
		<-0.309, 0.114, -0.560> <-0.278, 0.027, -0.458> <-0.242, 0.047, -0.249> <-0.178, 0.021, -0.131> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.273, 0.029, 0.008> <0.374, 0.058, -0.100> <0.404, 0.023, -0.344> <0.445, 0.114, -0.457> 
		<0.235, 0.017, -0.030> <0.336, 0.046, -0.138> <0.346, 0.026, -0.374> <0.387, 0.118, -0.487> 
		<0.190, -0.013, -0.086> <0.245, 0.018, -0.212> <0.294, 0.040, -0.427> <0.313, 0.129, -0.535> 
		<0.146, -0.013, -0.120> <0.201, 0.018, -0.246> <0.232, 0.037, -0.448> <0.251, 0.126, -0.556> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.168, 1.962, -0.682> <-0.155, 1.962, -0.693> <-0.139, 1.962, -0.710> <-0.124, 1.962, -0.718> 
		<-0.225, 1.781, -0.667> <-0.212, 1.781, -0.678> <-0.179, 1.783, -0.776> <-0.163, 1.783, -0.784> 
		<-0.304, 1.552, -0.791> <-0.266, 1.547, -0.827> <-0.251, 1.548, -0.865> <-0.203, 1.545, -0.885> 
		<-0.382, 1.382, -0.820> <-0.344, 1.376, -0.855> <-0.304, 1.368, -0.917> <-0.256, 1.365, -0.938> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.124, 1.962, -0.718> <-0.093, 1.960, -0.733> <-0.050, 1.958, -0.758> <-0.016, 1.955, -0.759> 
		<-0.163, 1.783, -0.784> <-0.132, 1.781, -0.799> <-0.050, 1.767, -0.768> <-0.015, 1.765, -0.768> 
		<-0.203, 1.545, -0.885> <-0.135, 1.541, -0.915> <-0.085, 1.539, -0.922> <-0.011, 1.540, -0.920> 
		<-0.256, 1.365, -0.938> <-0.188, 1.361, -0.967> <-0.086, 1.358, -0.981> <-0.011, 1.358, -0.979> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.091, 1.948, -0.721> <0.112, 1.950, -0.711> <0.135, 1.964, -0.693> <0.153, 1.970, -0.680> 
		<0.137, 1.775, -0.783> <0.158, 1.777, -0.773> <0.196, 1.777, -0.684> <0.215, 1.784, -0.672> 
		<0.209, 1.546, -0.867> <0.249, 1.549, -0.855> <0.260, 1.555, -0.842> <0.298, 1.559, -0.824> 
		<0.245, 1.370, -0.927> <0.285, 1.372, -0.916> <0.333, 1.378, -0.886> <0.370, 1.382, -0.869> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.382, 1.382, -0.820> <-0.344, 1.376, -0.855> <-0.304, 1.368, -0.917> <-0.256, 1.365, -0.938> 
		<-0.460, 1.211, -0.849> <-0.423, 1.206, -0.884> <-0.353, 1.199, -0.966> <-0.305, 1.196, -0.987> 
		<-0.672, 1.012, -0.920> <-0.605, 1.005, -0.974> <-0.535, 0.988, -1.073> <-0.455, 0.980, -1.106> 
		<-0.687, 0.828, -0.873> <-0.620, 0.822, -0.927> <-0.542, 0.814, -1.021> <-0.462, 0.805, -1.053> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.256, 1.365, -0.938> <-0.188, 1.361, -0.967> <-0.086, 1.358, -0.981> <-0.011, 1.358, -0.979> 
		<-0.305, 1.196, -0.987> <-0.237, 1.192, -1.016> <-0.086, 1.180, -1.038> <-0.011, 1.181, -1.037> 
		<-0.455, 0.980, -1.106> <-0.328, 0.967, -1.158> <-0.153, 0.939, -1.190> <-0.016, 0.939, -1.200> 
		<-0.462, 0.805, -1.053> <-0.336, 0.792, -1.105> <-0.153, 0.759, -1.137> <-0.016, 0.759, -1.148> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.011, 1.358, -0.979> <0.067, 1.359, -0.978> <0.169, 1.365, -0.949> <0.245, 1.370, -0.927> 
		<-0.011, 1.540, -0.920> <0.067, 1.541, -0.918> <0.133, 1.542, -0.889> <0.209, 1.546, -0.867> 
		<-0.015, 1.765, -0.768> <0.018, 1.763, -0.769> <0.106, 1.772, -0.797> <0.137, 1.775, -0.783> 
		<-0.016, 1.955, -0.759> <0.018, 1.953, -0.759> <0.060, 1.945, -0.735> <0.091, 1.948, -0.721> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.245, 1.370, -0.927> <0.285, 1.372, -0.916> <0.333, 1.378, -0.886> <0.370, 1.382, -0.869> 
		<0.279, 1.203, -0.984> <0.319, 1.205, -0.973> <0.402, 1.208, -0.929> <0.440, 1.212, -0.911> 
		<0.324, 0.978, -1.163> <0.420, 0.986, -1.136> <0.524, 0.992, -1.070> <0.614, 0.996, -1.027> 
		<0.325, 0.805, -1.111> <0.420, 0.814, -1.084> <0.535, 0.814, -1.012> <0.625, 0.817, -0.969> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.016, 0.759, -1.148> <0.087, 0.759, -1.155> <0.225, 0.796, -1.139> <0.325, 0.805, -1.111> 
		<-0.016, 0.939, -1.200> <0.088, 0.939, -1.207> <0.224, 0.969, -1.190> <0.324, 0.978, -1.163> 
		<-0.011, 1.181, -1.037> <0.067, 1.182, -1.035> <0.204, 1.198, -1.006> <0.279, 1.203, -0.984> 
		<-0.011, 1.358, -0.979> <0.067, 1.359, -0.978> <0.169, 1.365, -0.949> <0.245, 1.370, -0.927> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.016, 0.759, -1.148> <0.087, 0.759, -1.155> <0.225, 0.796, -1.139> <0.325, 0.805, -1.111> 
		<-0.017, 0.512, -1.076> <0.086, 0.512, -1.083> <0.227, 0.543, -1.063> <0.326, 0.552, -1.035> 
		<-0.020, 0.248, -0.814> <0.063, 0.250, -0.814> <0.209, 0.288, -0.783> <0.287, 0.292, -0.757> 
		<-0.016, 0.091, -0.611> <0.066, 0.093, -0.610> <0.173, 0.122, -0.582> <0.251, 0.126, -0.556> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.251, 0.126, -0.556> <0.173, 0.122, -0.582> <0.066, 0.093, -0.610> <-0.016, 0.091, -0.611> 
		<0.232, 0.037, -0.448> <0.154, 0.033, -0.474> <0.068, 0.017, -0.512> <-0.014, 0.015, -0.512> 
		<0.201, 0.018, -0.246> <0.161, 0.018, -0.277> <0.049, 0.044, -0.322> <-0.002, 0.050, -0.324> 
		<0.146, -0.013, -0.120> <0.106, -0.013, -0.151> <0.053, 0.024, -0.200> <0.002, 0.029, -0.202> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.016, 0.091, -0.611> <-0.020, 0.248, -0.814> <-0.017, 0.512, -1.076> <-0.016, 0.759, -1.148> 
		<-0.106, 0.089, -0.611> <-0.109, 0.246, -0.815> <-0.154, 0.512, -1.066> <-0.153, 0.759, -1.137> 
		<-0.223, 0.099, -0.579> <-0.282, 0.263, -0.771> <-0.346, 0.545, -1.030> <-0.336, 0.792, -1.105> 
		<-0.309, 0.114, -0.560> <-0.369, 0.277, -0.752> <-0.473, 0.558, -0.979> <-0.462, 0.805, -1.053> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.016, 1.955, -0.759> <-0.016, 2.138, -0.749> <-0.013, 2.366, -0.871> <-0.012, 2.542, -0.919> 
		<0.018, 1.953, -0.759> <0.018, 2.136, -0.750> <-0.016, 2.366, -0.871> <-0.015, 2.542, -0.919> 
		<0.060, 1.945, -0.735> <0.081, 1.947, -0.726> <0.074, 2.146, -0.700> <0.093, 2.153, -0.688> 
		<0.091, 1.948, -0.721> <0.112, 1.950, -0.711> <0.135, 1.964, -0.693> <0.153, 1.970, -0.680> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.178, 0.021, -0.131> <-0.242, 0.047, -0.249> <-0.278, 0.027, -0.458> <-0.309, 0.114, -0.560> 
		<-0.130, 0.022, -0.164> <-0.195, 0.048, -0.283> <-0.192, 0.013, -0.477> <-0.223, 0.099, -0.579> 
		<-0.056, 0.035, -0.204> <-0.060, 0.056, -0.326> <-0.104, 0.013, -0.513> <-0.106, 0.089, -0.611> 
		<0.002, 0.029, -0.202> <-0.002, 0.050, -0.324> <-0.014, 0.015, -0.512> <-0.016, 0.091, -0.611> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, 0.019, 0.223> <0.143, 0.022, 0.223> <0.270, 0.019, 0.132> <0.270, 0.019, 0.000> 
		<0.012, -0.015, 0.244> <0.143, -0.012, 0.244> <0.276, -0.015, 0.132> <0.276, -0.015, 0.000> 
		<0.012, -0.055, 0.295> <0.133, -0.057, 0.295> <0.302, -0.066, 0.120> <0.302, -0.062, -0.001> 
		<0.012, -0.094, 0.291> <0.133, -0.096, 0.291> <0.293, -0.100, 0.121> <0.293, -0.096, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, 0.019, -0.240> <-0.135, 0.016, -0.240> <-0.281, 0.008, -0.146> <-0.281, 0.008, 0.000> 
		<0.012, -0.008, -0.255> <-0.135, -0.011, -0.255> <-0.285, -0.020, -0.146> <-0.285, -0.020, 0.000> 
		<0.012, -0.042, -0.295> <-0.115, -0.039, -0.295> <-0.301, -0.053, -0.126> <-0.301, -0.058, 0.000> 
		<0.012, -0.073, -0.291> <-0.115, -0.070, -0.291> <-0.293, -0.080, -0.126> <-0.293, -0.084, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.270, 0.019, 0.000> <0.276, -0.015, 0.000> <0.302, -0.062, -0.001> <0.293, -0.096, 0.000> 
		<0.270, 0.019, -0.136> <0.276, -0.015, -0.136> <0.302, -0.058, -0.123> <0.293, -0.092, -0.121> 
		<0.148, 0.022, -0.240> <0.148, -0.006, -0.255> <0.133, -0.044, -0.295> <0.133, -0.075, -0.291> 
		<0.012, 0.019, -0.240> <0.012, -0.008, -0.255> <0.012, -0.042, -0.295> <0.012, -0.073, -0.291> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.293, -0.096, 0.000> <0.279, -0.144, 0.002> <0.224, -0.190, 0.007> <0.200, -0.234, 0.008> 
		<0.293, -0.100, 0.121> <0.279, -0.148, 0.123> <0.224, -0.192, 0.088> <0.200, -0.236, 0.089> 
		<0.133, -0.096, 0.291> <0.133, -0.144, 0.286> <0.092, -0.180, 0.220> <0.092, -0.224, 0.200> 
		<0.012, -0.094, 0.291> <0.012, -0.141, 0.286> <0.012, -0.180, 0.218> <0.012, -0.224, 0.198> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.200, -0.234, 0.008> <0.178, -0.276, 0.010> <0.175, -0.346, 0.009> <0.143, -0.382, 0.008> 
		<0.200, -0.232, -0.078> <0.178, -0.274, -0.076> <0.177, -0.345, -0.050> <0.145, -0.380, -0.051> 
		<0.098, -0.215, -0.205> <0.099, -0.262, -0.183> <0.082, -0.341, -0.181> <0.082, -0.378, -0.146> 
		<0.012, -0.215, -0.207> <0.013, -0.262, -0.185> <0.023, -0.338, -0.183> <0.023, -0.376, -0.148> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.200, -0.234, 0.008> <0.178, -0.276, 0.010> <0.175, -0.346, 0.009> <0.143, -0.382, 0.008> 
		<0.200, -0.236, 0.089> <0.178, -0.278, 0.090> <0.172, -0.348, 0.069> <0.141, -0.383, 0.068> 
		<0.092, -0.224, 0.200> <0.092, -0.269, 0.179> <0.071, -0.349, 0.191> <0.071, -0.386, 0.158> 
		<0.012, -0.224, 0.198> <0.012, -0.269, 0.178> <0.012, -0.346, 0.189> <0.012, -0.383, 0.156> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.143, -0.369, 0.000> <-0.174, -0.338, -0.000> <-0.180, -0.273, 0.000> <-0.200, -0.234, 0.000> 
		<-0.140, -0.367, -0.067> <-0.172, -0.336, -0.067> <-0.180, -0.271, -0.089> <-0.200, -0.232, -0.089> 
		<-0.044, -0.373, -0.150> <-0.044, -0.335, -0.185> <-0.076, -0.262, -0.187> <-0.077, -0.215, -0.209> 
		<0.023, -0.376, -0.148> <0.023, -0.338, -0.183> <0.013, -0.262, -0.185> <0.012, -0.215, -0.207> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.200, -0.234, 0.000> <-0.225, -0.188, 0.000> <-0.276, -0.134, 0.000> <-0.293, -0.084, 0.000> 
		<-0.200, -0.236, 0.087> <-0.225, -0.189, 0.087> <-0.276, -0.139, 0.126> <-0.293, -0.089, 0.126> 
		<-0.076, -0.224, 0.197> <-0.076, -0.180, 0.217> <-0.115, -0.139, 0.286> <-0.115, -0.091, 0.291> 
		<0.012, -0.224, 0.198> <0.012, -0.180, 0.218> <0.012, -0.141, 0.286> <0.012, -0.094, 0.291> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.200, -0.234, 0.000> <-0.225, -0.188, 0.000> <-0.276, -0.134, 0.000> <-0.293, -0.084, 0.000> 
		<-0.200, -0.232, -0.089> <-0.225, -0.186, -0.089> <-0.276, -0.130, -0.126> <-0.293, -0.080, -0.126> 
		<-0.077, -0.215, -0.209> <-0.079, -0.171, -0.230> <-0.115, -0.120, -0.284> <-0.115, -0.070, -0.291> 
		<0.012, -0.215, -0.207> <0.010, -0.171, -0.228> <0.012, -0.122, -0.284> <0.012, -0.073, -0.291> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.383, 0.156> <0.012, -0.346, 0.189> <0.012, -0.269, 0.178> <0.012, -0.224, 0.198> 
		<-0.054, -0.380, 0.155> <-0.054, -0.343, 0.187> <-0.076, -0.269, 0.176> <-0.076, -0.224, 0.197> 
		<-0.145, -0.370, 0.066> <-0.177, -0.339, 0.066> <-0.180, -0.275, 0.087> <-0.200, -0.236, 0.087> 
		<-0.143, -0.369, 0.000> <-0.174, -0.338, -0.000> <-0.180, -0.273, 0.000> <-0.200, -0.234, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.094, 0.291> <0.012, -0.055, 0.295> <0.012, -0.015, 0.244> <0.012, 0.019, 0.223> 
		<-0.115, -0.091, 0.291> <-0.115, -0.052, 0.295> <-0.131, -0.018, 0.244> <-0.131, 0.016, 0.223> 
		<-0.293, -0.089, 0.126> <-0.301, -0.063, 0.126> <-0.285, -0.020, 0.142> <-0.281, 0.008, 0.142> 
		<-0.293, -0.084, 0.000> <-0.301, -0.058, 0.000> <-0.285, -0.020, 0.000> <-0.281, 0.008, 0.000> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.012, -0.073, -0.291> <0.012, -0.122, -0.284> <0.010, -0.171, -0.228> <0.012, -0.215, -0.207> 
		<0.133, -0.075, -0.291> <0.133, -0.124, -0.284> <0.096, -0.171, -0.226> <0.098, -0.215, -0.205> 
		<0.293, -0.092, -0.121> <0.279, -0.140, -0.120> <0.224, -0.188, -0.079> <0.200, -0.232, -0.078> 
		<0.293, -0.096, 0.000> <0.279, -0.144, 0.002> <0.224, -0.190, 0.007> <0.200, -0.234, 0.008> 
	}
	texture { LeafTex }

}

union{
	bezier_patch {
		4,4
		accuracy 0.01
		<0.615, 2.781, 0.052> <0.612, 2.872, -0.003> <0.579, 2.889, -0.180> <0.529, 2.891, -0.274> 
		<0.615, 2.781, 0.052> <0.588, 2.669, -0.091> <0.581, 2.654, -0.170> <0.532, 2.656, -0.265> 
		<0.615, 2.781, 0.052> <0.588, 2.669, -0.091> <0.612, 2.335, -0.029> <0.509, 2.340, -0.225> 
		<0.615, 2.781, 0.052> <0.592, 2.578, -0.036> <0.640, 2.102, -0.046> <0.537, 2.106, -0.242> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.529, 2.891, -0.274> <0.479, 2.893, -0.371> <0.345, 2.887, -0.506> <0.303, 2.794, -0.544> 
		<0.529, 2.891, -0.274> <0.481, 2.658, -0.362> <0.415, 2.681, -0.416> <0.373, 2.587, -0.453> 
		<0.529, 2.891, -0.274> <0.481, 2.658, -0.362> <0.400, 2.344, -0.434> <0.427, 2.111, -0.451> 
		<0.529, 2.891, -0.274> <0.532, 2.656, -0.265> <0.509, 2.340, -0.225> <0.537, 2.106, -0.242> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.044, 0.035, -0.312> <-0.086, -0.019, -0.246> <-0.061, 0.048, -0.078> <-0.013, 0.046, 0.004> 
		<-0.044, 0.035, -0.312> <0.060, -0.009, -0.208> <0.076, 0.054, -0.135> <0.124, 0.052, -0.053> 
		<-0.044, 0.035, -0.312> <0.060, -0.009, -0.208> <0.259, -0.012, -0.257> <0.335, -0.016, -0.127> 
		<-0.044, 0.035, -0.312> <0.102, 0.044, -0.274> <0.367, 0.070, -0.316> <0.443, 0.067, -0.186> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.013, 0.046, 0.004> <0.035, 0.044, 0.086> <0.172, -0.035, 0.174> <0.247, 0.023, 0.186> 
		<-0.013, 0.046, 0.004> <0.172, 0.051, 0.029> <0.231, -0.022, 0.062> <0.306, 0.036, 0.074> 
		<-0.013, 0.046, 0.004> <0.172, 0.051, 0.029> <0.399, -0.018, -0.017> <0.507, 0.064, -0.077> 
		<-0.013, 0.046, 0.004> <0.124, 0.052, -0.053> <0.335, -0.016, -0.127> <0.443, 0.067, -0.186> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.207, 2.659, -0.652> <-0.288, 2.746, -0.643> <-0.486, 2.728, -0.598> <-0.576, 2.722, -0.521> 
		<-0.207, 2.659, -0.652> <-0.379, 2.592, -0.584> <-0.466, 2.556, -0.579> <-0.555, 2.550, -0.501> 
		<-0.207, 2.659, -0.652> <-0.379, 2.592, -0.584> <-0.366, 2.332, -0.576> <-0.507, 2.322, -0.453> 
		<-0.207, 2.659, -0.652> <-0.297, 2.506, -0.594> <-0.367, 2.158, -0.579> <-0.508, 2.148, -0.457> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.576, 2.722, -0.521> <-0.661, 2.716, -0.447> <-0.709, 2.709, -0.263> <-0.734, 2.622, -0.196> 
		<-0.576, 2.722, -0.521> <-0.640, 2.544, -0.428> <-0.641, 2.567, -0.341> <-0.666, 2.480, -0.274> 
		<-0.576, 2.722, -0.521> <-0.640, 2.544, -0.428> <-0.640, 2.313, -0.338> <-0.641, 2.139, -0.342> 
		<-0.576, 2.722, -0.521> <-0.555, 2.550, -0.501> <-0.507, 2.322, -0.453> <-0.508, 2.148, -0.457> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.313, 0.045, 0.131> <-0.236, -0.010, 0.145> <-0.088, 0.050, 0.063> <-0.029, 0.046, -0.011> 
		<-0.313, 0.045, 0.131> <-0.278, -0.006, 0.032> <-0.215, 0.054, -0.007> <-0.156, 0.050, -0.081> 
		<-0.313, 0.045, 0.131> <-0.278, -0.006, 0.032> <-0.429, -0.011, -0.077> <-0.354, -0.016, -0.171> 
		<-0.313, 0.045, 0.131> <-0.355, 0.049, 0.018> <-0.528, 0.065, -0.151> <-0.453, 0.060, -0.246> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.029, 0.046, -0.011> <0.031, 0.043, -0.085> <0.059, -0.038, -0.246> <0.047, 0.023, -0.319> 
		<-0.029, 0.046, -0.011> <-0.096, 0.047, -0.156> <-0.091, -0.027, -0.224> <-0.103, 0.034, -0.297> 
		<-0.029, 0.046, -0.011> <-0.096, 0.047, -0.156> <-0.259, -0.022, -0.290> <-0.358, 0.055, -0.364> 
		<-0.029, 0.046, -0.011> <-0.156, 0.050, -0.081> <-0.354, -0.016, -0.171> <-0.453, 0.060, -0.246> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.131, 2.743, 0.606> <-0.067, 2.822, 0.614> <0.107, 2.782, 0.651> <0.207, 2.778, 0.631> 
		<-0.131, 2.743, 0.606> <0.038, 2.655, 0.622> <0.111, 2.605, 0.653> <0.211, 2.600, 0.632> 
		<-0.131, 2.743, 0.606> <0.038, 2.655, 0.622> <0.028, 2.372, 0.657> <0.221, 2.363, 0.617> 
		<-0.131, 2.743, 0.606> <-0.026, 2.576, 0.615> <0.026, 2.196, 0.675> <0.219, 2.186, 0.635> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.207, 2.778, 0.631> <0.310, 2.773, 0.610> <0.470, 2.795, 0.521> <0.513, 2.712, 0.474> 
		<0.207, 2.778, 0.631> <0.314, 2.595, 0.611> <0.382, 2.638, 0.569> <0.425, 2.554, 0.522> 
		<0.207, 2.778, 0.631> <0.314, 2.595, 0.611> <0.404, 2.354, 0.580> <0.402, 2.178, 0.597> 
		<0.207, 2.778, 0.631> <0.211, 2.600, 0.632> <0.221, 2.363, 0.617> <0.219, 2.186, 0.635> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.557, 0.075, 0.039> <0.436, -0.021, -0.025> <0.165, 0.091, -0.039> <0.001, 0.092, -0.008> 
		<0.557, 0.075, 0.039> <0.328, -0.014, 0.094> <0.225, 0.092, 0.094> <0.060, 0.094, 0.125> 
		<0.557, 0.075, 0.039> <0.328, -0.014, 0.094> <0.317, 0.022, 0.286> <0.159, 0.023, 0.316> 
		<0.557, 0.075, 0.039> <0.449, 0.082, 0.158> <0.356, 0.096, 0.405> <0.199, 0.097, 0.435> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.001, 0.092, -0.008> <-0.093, 0.093, 0.010> <-0.219, 0.022, 0.123> <-0.246, 0.081, 0.193> 
		<0.001, 0.092, -0.008> <-0.034, 0.094, 0.143> <-0.086, 0.027, 0.196> <-0.112, 0.086, 0.265> 
		<0.001, 0.092, -0.008> <-0.034, 0.094, 0.143> <0.010, 0.024, 0.345> <0.049, 0.098, 0.464> 
		<0.001, 0.092, -0.008> <0.060, 0.094, 0.125> <0.159, 0.023, 0.316> <0.199, 0.097, 0.435> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.518, 2.755, -0.099> <-0.525, 2.825, -0.052> <-0.505, 2.820, 0.094> <-0.467, 2.823, 0.170> 
		<-0.518, 2.755, -0.099> <-0.524, 2.664, 0.040> <-0.520, 2.638, 0.105> <-0.482, 2.641, 0.181> 
		<-0.518, 2.755, -0.099> <-0.524, 2.664, 0.040> <-0.569, 2.391, 0.031> <-0.486, 2.398, 0.196> 
		<-0.518, 2.755, -0.099> <-0.518, 2.594, -0.007> <-0.600, 2.212, 0.042> <-0.516, 2.219, 0.208> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.467, 2.823, 0.170> <-0.424, 2.826, 0.255> <-0.278, 2.859, 0.365> <-0.262, 2.776, 0.410> 
		<-0.467, 2.823, 0.170> <-0.439, 2.645, 0.267> <-0.354, 2.692, 0.304> <-0.338, 2.609, 0.350> 
		<-0.467, 2.823, 0.170> <-0.439, 2.645, 0.267> <-0.399, 2.405, 0.369> <-0.430, 2.226, 0.381> 
		<-0.467, 2.823, 0.170> <-0.482, 2.641, 0.181> <-0.486, 2.398, 0.196> <-0.516, 2.219, 0.208> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.013, 0.085, 0.329> <0.043, 0.022, 0.264> <0.068, 0.093, 0.101> <0.033, 0.091, 0.012> 
		<0.013, 0.085, 0.329> <-0.076, 0.029, 0.244> <-0.057, 0.098, 0.176> <-0.092, 0.097, 0.087> 
		<0.013, 0.085, 0.329> <-0.076, 0.029, 0.244> <-0.226, 0.034, 0.323> <-0.270, 0.033, 0.211> 
		<0.013, 0.085, 0.329> <-0.105, 0.092, 0.309> <-0.338, 0.112, 0.375> <-0.382, 0.110, 0.262> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.033, 0.091, 0.012> <-0.002, 0.090, -0.077> <-0.125, 0.017, -0.188> <-0.196, 0.076, -0.208> 
		<0.033, 0.091, 0.012> <-0.126, 0.096, -0.002> <-0.180, 0.027, -0.047> <-0.252, 0.086, -0.067> 
		<0.033, 0.091, 0.012> <-0.126, 0.096, -0.002> <-0.325, 0.030, 0.070> <-0.438, 0.107, 0.121> 
		<0.033, 0.091, 0.012> <-0.092, 0.097, 0.087> <-0.270, 0.033, 0.211> <-0.382, 0.110, 0.262> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.247, 0.023, 0.186> <0.462, 0.189, 0.220> <0.732, 0.461, 0.140> <0.846, 0.710, 0.141> 
		<0.306, 0.036, 0.074> <0.521, 0.202, 0.108> <0.765, 0.482, -0.061> <0.879, 0.731, -0.060> 
		<0.507, 0.064, -0.077> <0.714, 0.221, -0.190> <0.907, 0.511, -0.268> <1.007, 0.768, -0.330> 
		<0.443, 0.067, -0.186> <0.650, 0.223, -0.299> <0.856, 0.524, -0.465> <0.956, 0.782, -0.528> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.846, 0.710, 0.141> <0.932, 0.897, 0.141> <0.917, 1.193, 0.182> <0.875, 1.395, 0.191> 
		<0.879, 0.731, -0.060> <0.965, 0.919, -0.059> <0.919, 1.134, -0.013> <0.877, 1.336, -0.004> 
		<1.007, 0.768, -0.330> <1.053, 0.885, -0.358> <1.018, 1.071, -0.303> <0.976, 1.190, -0.278> 
		<0.956, 0.782, -0.528> <1.001, 0.898, -0.556> <0.925, 1.079, -0.483> <0.882, 1.197, -0.458> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.170, 2.093, -0.595> <0.176, 1.882, -0.641> <0.280, 1.638, -0.793> <0.342, 1.436, -0.839> 
		<0.327, 1.917, -0.529> <0.333, 1.706, -0.575> <0.442, 1.567, -0.678> <0.504, 1.364, -0.725> 
		<0.587, 1.505, -0.595> <0.626, 1.403, -0.620> <0.748, 1.307, -0.624> <0.785, 1.204, -0.646> 
		<0.695, 1.507, -0.375> <0.733, 1.405, -0.399> <0.845, 1.300, -0.437> <0.882, 1.197, -0.458> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.882, 1.197, -0.458> <0.845, 1.300, -0.437> <0.733, 1.405, -0.399> <0.695, 1.507, -0.375> 
		<0.976, 1.190, -0.278> <0.939, 1.293, -0.256> <0.843, 1.407, -0.172> <0.805, 1.509, -0.148> 
		<0.877, 1.336, -0.004> <0.830, 1.563, 0.006> <0.641, 1.696, 0.053> <0.599, 1.923, 0.030> 
		<0.875, 1.395, 0.191> <0.828, 1.622, 0.201> <0.600, 1.874, 0.226> <0.557, 2.101, 0.204> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.695, 1.507, -0.375> <0.629, 1.680, -0.334> <0.559, 1.918, -0.256> <0.537, 2.106, -0.242> 
		<0.805, 1.509, -0.148> <0.739, 1.683, -0.107> <0.662, 1.914, -0.059> <0.640, 2.102, -0.046> 
		<0.599, 1.923, 0.030> <0.560, 2.128, 0.010> <0.598, 2.399, 0.072> <0.592, 2.578, -0.036> 
		<0.557, 2.101, 0.204> <0.519, 2.306, 0.183> <0.622, 2.601, 0.161> <0.615, 2.781, 0.052> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.695, 1.507, -0.375> <0.587, 1.505, -0.595> <0.327, 1.917, -0.529> <0.170, 2.093, -0.595> 
		<0.629, 1.680, -0.334> <0.522, 1.678, -0.554> <0.321, 2.127, -0.483> <0.164, 2.303, -0.549> 
		<0.559, 1.918, -0.256> <0.450, 1.922, -0.465> <0.290, 2.404, -0.527> <0.220, 2.610, -0.618> 
		<0.537, 2.106, -0.242> <0.427, 2.111, -0.451> <0.373, 2.587, -0.453> <0.303, 2.794, -0.544> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.342, 1.436, -0.839> <0.504, 1.364, -0.725> <0.785, 1.204, -0.646> <0.882, 1.197, -0.458> 
		<0.402, 1.241, -0.885> <0.564, 1.169, -0.770> <0.828, 1.086, -0.670> <0.925, 1.079, -0.483> 
		<0.626, 0.969, -0.970> <0.740, 0.970, -0.859> <0.960, 0.909, -0.710> <1.001, 0.898, -0.556> 
		<0.573, 0.779, -0.899> <0.688, 0.780, -0.787> <0.915, 0.792, -0.682> <0.956, 0.782, -0.528> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.573, 0.779, -0.899> <0.688, 0.780, -0.787> <0.915, 0.792, -0.682> <0.956, 0.782, -0.528> 
		<0.489, 0.472, -0.783> <0.603, 0.473, -0.671> <0.815, 0.534, -0.620> <0.856, 0.524, -0.465> 
		<0.109, 0.226, -0.547> <0.255, 0.235, -0.509> <0.574, 0.227, -0.430> <0.650, 0.223, -0.299> 
		<-0.044, 0.035, -0.312> <0.102, 0.044, -0.274> <0.367, 0.070, -0.316> <0.443, 0.067, -0.186> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.047, 0.023, -0.319> <0.011, 0.193, -0.522> <-0.133, 0.481, -0.721> <-0.170, 0.726, -0.824> 
		<-0.103, 0.034, -0.297> <-0.139, 0.204, -0.500> <-0.337, 0.468, -0.662> <-0.374, 0.712, -0.764> 
		<-0.358, 0.055, -0.364> <-0.528, 0.185, -0.491> <-0.626, 0.447, -0.672> <-0.681, 0.675, -0.755> 
		<-0.453, 0.060, -0.246> <-0.622, 0.191, -0.372> <-0.797, 0.452, -0.544> <-0.851, 0.680, -0.626> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.170, 0.726, -0.824> <-0.198, 0.910, -0.901> <-0.188, 1.196, -0.926> <-0.160, 1.393, -0.893> 
		<-0.374, 0.712, -0.764> <-0.402, 0.896, -0.842> <-0.359, 1.145, -0.858> <-0.331, 1.342, -0.824> 
		<-0.681, 0.675, -0.755> <-0.717, 0.828, -0.810> <-0.653, 1.052, -0.822> <-0.603, 1.211, -0.807> 
		<-0.851, 0.680, -0.626> <-0.888, 0.834, -0.682> <-0.780, 1.064, -0.680> <-0.730, 1.223, -0.665> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.765, 2.079, -0.022> <-0.793, 1.893, 0.001> <-0.875, 1.649, -0.029> <-0.908, 1.464, -0.053> 
		<-0.710, 1.920, -0.178> <-0.738, 1.734, -0.155> <-0.821, 1.577, -0.213> <-0.855, 1.392, -0.236> 
		<-0.767, 1.547, -0.409> <-0.793, 1.439, -0.433> <-0.832, 1.344, -0.502> <-0.866, 1.236, -0.512> 
		<-0.581, 1.549, -0.544> <-0.607, 1.441, -0.568> <-0.697, 1.331, -0.654> <-0.730, 1.223, -0.665> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.730, 1.223, -0.665> <-0.697, 1.331, -0.654> <-0.607, 1.441, -0.568> <-0.581, 1.549, -0.544> 
		<-0.603, 1.211, -0.807> <-0.570, 1.319, -0.797> <-0.410, 1.443, -0.711> <-0.384, 1.551, -0.686> 
		<-0.331, 1.342, -0.824> <-0.299, 1.570, -0.786> <-0.151, 1.697, -0.621> <-0.159, 1.926, -0.578> 
		<-0.160, 1.393, -0.893> <-0.128, 1.621, -0.854> <0.030, 1.858, -0.636> <0.022, 2.088, -0.592> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.581, 1.549, -0.544> <-0.539, 1.723, -0.505> <-0.509, 1.965, -0.460> <-0.508, 2.148, -0.457> 
		<-0.384, 1.551, -0.686> <-0.342, 1.725, -0.647> <-0.368, 1.975, -0.583> <-0.367, 2.158, -0.579> 
		<-0.159, 1.926, -0.578> <-0.166, 2.108, -0.543> <-0.171, 2.371, -0.609> <-0.297, 2.506, -0.594> 
		<0.022, 2.088, -0.592> <0.015, 2.270, -0.558> <-0.080, 2.525, -0.668> <-0.207, 2.659, -0.652> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.581, 1.549, -0.544> <-0.767, 1.547, -0.409> <-0.710, 1.920, -0.178> <-0.765, 2.079, -0.022> 
		<-0.539, 1.723, -0.505> <-0.725, 1.721, -0.370> <-0.685, 2.088, -0.199> <-0.740, 2.247, -0.043> 
		<-0.509, 1.965, -0.460> <-0.642, 1.956, -0.345> <-0.705, 2.348, -0.172> <-0.773, 2.490, -0.093> 
		<-0.508, 2.148, -0.457> <-0.641, 2.139, -0.342> <-0.666, 2.480, -0.274> <-0.734, 2.622, -0.196> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.908, 1.464, -0.053> <-0.855, 1.392, -0.236> <-0.866, 1.236, -0.512> <-0.730, 1.223, -0.665> 
		<-0.947, 1.250, -0.081> <-0.894, 1.177, -0.264> <-0.916, 1.077, -0.528> <-0.780, 1.064, -0.680> 
		<-1.091, 0.953, -0.219> <-1.044, 0.931, -0.349> <-0.999, 0.837, -0.598> <-0.888, 0.834, -0.682> 
		<-1.006, 0.751, -0.193> <-0.960, 0.730, -0.323> <-0.963, 0.683, -0.542> <-0.851, 0.680, -0.626> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-1.006, 0.751, -0.193> <-0.960, 0.730, -0.323> <-0.963, 0.683, -0.542> <-0.851, 0.680, -0.626> 
		<-0.886, 0.465, -0.156> <-0.840, 0.444, -0.286> <-0.908, 0.455, -0.460> <-0.797, 0.452, -0.544> 
		<-0.563, 0.225, 0.084> <-0.605, 0.230, -0.029> <-0.698, 0.196, -0.278> <-0.622, 0.191, -0.372> 
		<-0.313, 0.045, 0.131> <-0.355, 0.049, 0.018> <-0.528, 0.065, -0.151> <-0.453, 0.060, -0.246> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.246, 0.081, 0.193> <-0.330, 0.267, 0.412> <-0.308, 0.547, 0.739> <-0.331, 0.822, 0.855> 
		<-0.112, 0.086, 0.265> <-0.197, 0.271, 0.485> <-0.112, 0.510, 0.772> <-0.135, 0.784, 0.888> 
		<0.049, 0.098, 0.464> <0.115, 0.222, 0.662> <0.087, 0.474, 0.923> <0.128, 0.694, 1.021> 
		<0.199, 0.097, 0.435> <0.264, 0.220, 0.634> <0.282, 0.478, 0.869> <0.323, 0.697, 0.966> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.331, 0.822, 0.855> <-0.345, 0.999, 0.930> <-0.362, 1.270, 0.815> <-0.358, 1.459, 0.774> 
		<-0.135, 0.784, 0.888> <-0.149, 0.961, 0.963> <-0.137, 1.176, 0.852> <-0.133, 1.364, 0.812> 
		<0.128, 0.694, 1.021> <0.151, 0.817, 1.075> <0.185, 1.013, 1.029> <0.166, 1.145, 0.997> 
		<0.323, 0.697, 0.966> <0.346, 0.821, 1.021> <0.412, 1.012, 0.931> <0.393, 1.144, 0.899> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.547, 2.122, 0.262> <0.592, 1.915, 0.230> <0.723, 1.651, 0.240> <0.787, 1.450, 0.277> 
		<0.442, 1.962, 0.408> <0.486, 1.755, 0.376> <0.605, 1.559, 0.427> <0.668, 1.358, 0.464> 
		<0.421, 1.580, 0.666> <0.446, 1.434, 0.703> <0.591, 1.289, 0.768> <0.612, 1.142, 0.803> 
		<0.195, 1.588, 0.749> <0.219, 1.442, 0.786> <0.372, 1.291, 0.863> <0.393, 1.144, 0.899> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.393, 1.144, 0.899> <0.372, 1.291, 0.863> <0.219, 1.442, 0.786> <0.195, 1.588, 0.749> 
		<0.166, 1.145, 0.997> <0.145, 1.292, 0.961> <0.002, 1.449, 0.865> <-0.022, 1.595, 0.828> 
		<-0.133, 1.364, 0.812> <-0.128, 1.576, 0.766> <-0.190, 1.770, 0.652> <-0.152, 1.982, 0.625> 
		<-0.358, 1.459, 0.774> <-0.354, 1.671, 0.729> <-0.339, 1.939, 0.599> <-0.301, 2.151, 0.571> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.195, 1.588, 0.749> <0.166, 1.763, 0.704> <0.217, 2.004, 0.653> <0.219, 2.186, 0.635> 
		<-0.022, 1.595, 0.828> <-0.051, 1.770, 0.784> <0.024, 2.014, 0.693> <0.026, 2.196, 0.675> 
		<-0.152, 1.982, 0.625> <-0.121, 2.163, 0.601> <-0.142, 2.433, 0.601> <-0.026, 2.576, 0.615> 
		<-0.301, 2.151, 0.571> <-0.269, 2.332, 0.548> <-0.248, 2.600, 0.592> <-0.131, 2.743, 0.606> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.195, 1.588, 0.749> <0.421, 1.580, 0.666> <0.442, 1.962, 0.408> <0.547, 2.122, 0.262> 
		<0.166, 1.763, 0.704> <0.392, 1.755, 0.622> <0.402, 2.144, 0.437> <0.508, 2.304, 0.291> 
		<0.217, 2.004, 0.653> <0.400, 1.996, 0.615> <0.502, 2.405, 0.438> <0.590, 2.563, 0.390> 
		<0.219, 2.186, 0.635> <0.402, 2.178, 0.597> <0.425, 2.554, 0.522> <0.513, 2.712, 0.474> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.787, 1.450, 0.277> <0.668, 1.358, 0.464> <0.612, 1.142, 0.803> <0.393, 1.144, 0.899> 
		<0.845, 1.263, 0.311> <0.727, 1.171, 0.498> <0.631, 1.010, 0.836> <0.412, 1.012, 0.931> 
		<0.982, 1.038, 0.528> <0.794, 0.994, 0.670> <0.576, 0.825, 0.956> <0.346, 0.821, 1.021> 
		<0.949, 0.844, 0.495> <0.761, 0.800, 0.636> <0.553, 0.701, 0.901> <0.323, 0.697, 0.966> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.949, 0.844, 0.495> <0.761, 0.800, 0.636> <0.553, 0.701, 0.901> <0.323, 0.697, 0.966> 
		<0.902, 0.559, 0.446> <0.714, 0.515, 0.587> <0.513, 0.482, 0.804> <0.282, 0.478, 0.869> 
		<0.769, 0.243, 0.152> <0.661, 0.250, 0.270> <0.422, 0.219, 0.604> <0.264, 0.220, 0.634> 
		<0.557, 0.075, 0.039> <0.449, 0.082, 0.158> <0.356, 0.096, 0.405> <0.199, 0.097, 0.435> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.196, 0.076, -0.208> <-0.422, 0.263, -0.270> <-0.740, 0.549, -0.218> <-0.854, 0.825, -0.235> 
		<-0.252, 0.086, -0.067> <-0.478, 0.273, -0.129> <-0.749, 0.518, -0.018> <-0.864, 0.794, -0.035> 
		<-0.438, 0.107, 0.121> <-0.625, 0.236, 0.206> <-0.883, 0.487, 0.203> <-0.972, 0.709, 0.248> 
		<-0.382, 0.110, 0.262> <-0.570, 0.239, 0.348> <-0.797, 0.500, 0.386> <-0.886, 0.722, 0.431> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.854, 0.825, -0.235> <-0.928, 1.003, -0.246> <-0.832, 1.277, -0.285> <-0.769, 1.460, -0.293> 
		<-0.864, 0.794, -0.035> <-0.937, 0.972, -0.046> <-0.842, 1.190, -0.054> <-0.780, 1.373, -0.061> 
		<-0.972, 0.709, 0.248> <-1.022, 0.834, 0.274> <-0.962, 1.035, 0.292> <-0.931, 1.166, 0.265> 
		<-0.886, 0.722, 0.431> <-0.936, 0.847, 0.457> <-0.836, 1.039, 0.505> <-0.805, 1.169, 0.478> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.327, 2.068, 0.581> <-0.309, 1.881, 0.635> <-0.133, 1.668, 0.738> <-0.136, 1.477, 0.783> 
		<-0.431, 1.929, 0.481> <-0.413, 1.742, 0.535> <-0.334, 1.576, 0.647> <-0.337, 1.385, 0.691> 
		<-0.657, 1.587, 0.448> <-0.696, 1.444, 0.484> <-0.649, 1.318, 0.654> <-0.684, 1.173, 0.684> 
		<-0.675, 1.605, 0.249> <-0.714, 1.462, 0.286> <-0.770, 1.315, 0.448> <-0.805, 1.169, 0.478> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.805, 1.169, 0.478> <-0.770, 1.315, 0.448> <-0.714, 1.462, 0.286> <-0.675, 1.605, 0.249> 
		<-0.931, 1.166, 0.265> <-0.896, 1.312, 0.235> <-0.736, 1.484, 0.045> <-0.696, 1.627, 0.008> 
		<-0.780, 1.373, -0.061> <-0.705, 1.594, -0.070> <-0.530, 1.758, -0.160> <-0.486, 1.985, -0.127> 
		<-0.769, 1.460, -0.293> <-0.694, 1.681, -0.301> <-0.449, 1.921, -0.321> <-0.405, 2.147, -0.288> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.675, 1.605, 0.249> <-0.626, 1.783, 0.203> <-0.548, 2.031, 0.220> <-0.516, 2.219, 0.208> 
		<-0.696, 1.627, 0.008> <-0.647, 1.805, -0.038> <-0.631, 2.025, 0.054> <-0.600, 2.212, 0.042> 
		<-0.486, 1.985, -0.127> <-0.449, 2.173, -0.099> <-0.503, 2.434, -0.116> <-0.518, 2.594, -0.007> 
		<-0.405, 2.147, -0.288> <-0.368, 2.336, -0.259> <-0.503, 2.595, -0.208> <-0.518, 2.755, -0.099> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.675, 1.605, 0.249> <-0.657, 1.587, 0.448> <-0.431, 1.929, 0.481> <-0.327, 2.068, 0.581> 
		<-0.626, 1.783, 0.203> <-0.608, 1.765, 0.402> <-0.452, 2.139, 0.421> <-0.347, 2.278, 0.521> 
		<-0.548, 2.031, 0.220> <-0.461, 2.038, 0.393> <-0.303, 2.419, 0.453> <-0.227, 2.586, 0.514> 
		<-0.516, 2.219, 0.208> <-0.430, 2.226, 0.381> <-0.338, 2.609, 0.350> <-0.262, 2.776, 0.410> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.136, 1.477, 0.783> <-0.337, 1.385, 0.691> <-0.684, 1.173, 0.684> <-0.805, 1.169, 0.478> 
		<-0.139, 1.298, 0.824> <-0.340, 1.205, 0.733> <-0.715, 1.042, 0.711> <-0.836, 1.039, 0.505> 
		<-0.365, 1.078, 0.908> <-0.527, 1.024, 0.782> <-0.846, 0.861, 0.648> <-0.936, 0.847, 0.457> 
		<-0.346, 0.904, 0.851> <-0.508, 0.849, 0.725> <-0.796, 0.736, 0.623> <-0.886, 0.722, 0.431> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.346, 0.904, 0.851> <-0.508, 0.849, 0.725> <-0.796, 0.736, 0.623> <-0.886, 0.722, 0.431> 
		<-0.315, 0.610, 0.755> <-0.477, 0.555, 0.629> <-0.708, 0.514, 0.578> <-0.797, 0.500, 0.386> 
		<-0.083, 0.291, 0.541> <-0.201, 0.298, 0.521> <-0.526, 0.240, 0.460> <-0.570, 0.239, 0.348> 
		<0.013, 0.085, 0.329> <-0.105, 0.092, 0.309> <-0.338, 0.112, 0.375> <-0.382, 0.110, 0.262> 
	}
	texture { PetalTex }

}

union{
	bezier_patch {
		4,4
		accuracy 0.01
		<0.140, 2.720, -0.600> <0.141, 2.586, -0.588> <0.147, 2.409, -0.563> <0.146, 2.275, -0.561> 
		<0.140, 2.720, -0.600> <0.216, 2.585, -0.572> <0.259, 2.408, -0.538> <0.258, 2.274, -0.536> 
		<0.140, 2.720, -0.600> <0.216, 2.585, -0.572> <0.236, 2.568, -0.521> <0.266, 2.505, -0.489> 
		<0.140, 2.720, -0.600> <0.214, 2.719, -0.584> <0.288, 2.666, -0.491> <0.317, 2.603, -0.458> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.140, 2.720, -0.600> <0.141, 2.586, -0.588> <0.147, 2.409, -0.563> <0.146, 2.275, -0.561> 
		<0.140, 2.720, -0.600> <0.048, 2.588, -0.609> <0.014, 2.411, -0.592> <0.013, 2.277, -0.590> 
		<0.140, 2.720, -0.600> <0.048, 2.588, -0.609> <-0.009, 2.585, -0.570> <-0.067, 2.509, -0.562> 
		<0.140, 2.720, -0.600> <0.046, 2.721, -0.621> <-0.100, 2.685, -0.570> <-0.158, 2.609, -0.562> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.101, 2.798, 0.505> <-0.116, 2.640, 0.525> <-0.144, 2.431, 0.564> <-0.149, 2.271, 0.573> 
		<-0.101, 2.798, 0.505> <-0.197, 2.645, 0.495> <-0.271, 2.439, 0.517> <-0.276, 2.279, 0.526> 
		<-0.101, 2.798, 0.505> <-0.197, 2.645, 0.495> <-0.198, 2.601, 0.431> <-0.231, 2.525, 0.405> 
		<-0.101, 2.798, 0.505> <-0.183, 2.804, 0.475> <-0.234, 2.709, 0.360> <-0.267, 2.634, 0.333> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.101, 2.798, 0.505> <-0.116, 2.640, 0.525> <-0.144, 2.431, 0.564> <-0.149, 2.271, 0.573> 
		<-0.101, 2.798, 0.505> <-0.013, 2.633, 0.563> <-0.006, 2.422, 0.614> <-0.011, 2.262, 0.623> 
		<-0.101, 2.798, 0.505> <-0.013, 2.633, 0.563> <0.042, 2.596, 0.528> <0.100, 2.503, 0.527> 
		<-0.101, 2.798, 0.505> <0.001, 2.792, 0.542> <0.149, 2.696, 0.509> <0.208, 2.603, 0.507> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.513, 2.704, 0.197> <0.515, 2.576, 0.195> <0.512, 2.406, 0.197> <0.518, 2.279, 0.191> 
		<0.513, 2.704, 0.197> <0.483, 2.580, 0.289> <0.465, 2.411, 0.335> <0.471, 2.284, 0.329> 
		<0.513, 2.704, 0.197> <0.483, 2.580, 0.289> <0.383, 2.614, 0.310> <0.349, 2.529, 0.348> 
		<0.513, 2.704, 0.197> <0.482, 2.707, 0.290> <0.310, 2.721, 0.377> <0.277, 2.636, 0.416> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.513, 2.704, 0.197> <0.515, 2.576, 0.195> <0.512, 2.406, 0.197> <0.518, 2.279, 0.191> 
		<0.513, 2.704, 0.197> <0.550, 2.572, 0.092> <0.559, 2.401, 0.060> <0.564, 2.274, 0.054> 
		<0.513, 2.704, 0.197> <0.550, 2.572, 0.092> <0.496, 2.598, 0.019> <0.484, 2.514, -0.050> 
		<0.513, 2.704, 0.197> <0.548, 2.700, 0.094> <0.482, 2.699, -0.084> <0.470, 2.615, -0.153> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.462, 2.861, -0.233> <-0.431, 2.695, -0.244> <-0.356, 2.476, -0.273> <-0.361, 2.306, -0.272> 
		<-0.462, 2.861, -0.233> <-0.417, 2.704, -0.321> <-0.326, 2.494, -0.426> <-0.331, 2.324, -0.425> 
		<-0.462, 2.861, -0.233> <-0.417, 2.704, -0.321> <-0.334, 2.725, -0.349> <-0.312, 2.654, -0.377> 
		<-0.462, 2.861, -0.233> <-0.447, 2.870, -0.309> <-0.313, 2.874, -0.394> <-0.290, 2.804, -0.421> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.462, 2.861, -0.233> <-0.431, 2.695, -0.244> <-0.356, 2.476, -0.273> <-0.361, 2.306, -0.272> 
		<-0.462, 2.861, -0.233> <-0.456, 2.680, -0.120> <-0.391, 2.455, -0.092> <-0.396, 2.285, -0.091> 
		<-0.462, 2.861, -0.233> <-0.456, 2.680, -0.120> <-0.403, 2.715, -0.028> <-0.392, 2.606, 0.038> 
		<-0.462, 2.861, -0.233> <-0.486, 2.847, -0.108> <-0.417, 2.844, 0.105> <-0.406, 2.734, 0.171> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.265, 2.848, 0.256> <-0.276, 2.675, 0.260> <-0.300, 2.445, 0.268> <-0.301, 2.271, 0.269> 
		<-0.265, 2.848, 0.256> <-0.318, 2.682, 0.211> <-0.406, 2.461, 0.144> <-0.407, 2.288, 0.145> 
		<-0.265, 2.848, 0.256> <-0.318, 2.682, 0.211> <-0.376, 2.689, 0.184> <-0.380, 2.629, 0.162> 
		<-0.265, 2.848, 0.256> <-0.307, 2.855, 0.207> <-0.410, 2.843, 0.139> <-0.414, 2.783, 0.116> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.265, 2.848, 0.256> <-0.276, 2.675, 0.260> <-0.300, 2.445, 0.268> <-0.301, 2.271, 0.269> 
		<-0.265, 2.848, 0.256> <-0.228, 2.668, 0.316> <-0.198, 2.429, 0.387> <-0.200, 2.255, 0.388> 
		<-0.265, 2.848, 0.256> <-0.228, 2.668, 0.316> <-0.213, 2.667, 0.374> <-0.187, 2.599, 0.388> 
		<-0.265, 2.848, 0.256> <-0.217, 2.841, 0.312> <-0.164, 2.808, 0.425> <-0.139, 2.740, 0.439> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.178, 2.838, -0.482> <-0.148, 2.668, -0.459> <-0.093, 2.445, -0.416> <-0.078, 2.271, -0.406> 
		<-0.178, 2.838, -0.482> <-0.051, 2.675, -0.491> <0.065, 2.456, -0.469> <0.080, 2.283, -0.459> 
		<-0.178, 2.838, -0.482> <-0.051, 2.675, -0.491> <0.041, 2.711, -0.477> <0.087, 2.622, -0.454> 
		<-0.178, 2.838, -0.482> <-0.081, 2.845, -0.514> <0.112, 2.862, -0.498> <0.158, 2.772, -0.475> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.178, 2.838, -0.482> <-0.148, 2.668, -0.459> <-0.093, 2.445, -0.416> <-0.078, 2.271, -0.406> 
		<-0.178, 2.838, -0.482> <-0.211, 2.664, -0.438> <-0.242, 2.434, -0.366> <-0.227, 2.261, -0.356> 
		<-0.178, 2.838, -0.482> <-0.211, 2.664, -0.438> <-0.221, 2.659, -0.374> <-0.232, 2.599, -0.348> 
		<-0.178, 2.838, -0.482> <-0.241, 2.834, -0.461> <-0.286, 2.800, -0.349> <-0.298, 2.740, -0.323> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.525, 2.838, 0.015> <0.490, 2.668, 0.029> <0.425, 2.445, 0.054> <0.408, 2.271, 0.062> 
		<0.525, 2.838, 0.015> <0.467, 2.675, 0.130> <0.388, 2.456, 0.218> <0.372, 2.283, 0.225> 
		<0.525, 2.838, 0.015> <0.467, 2.675, 0.130> <0.408, 2.711, 0.201> <0.365, 2.622, 0.229> 
		<0.525, 2.838, 0.015> <0.502, 2.845, 0.116> <0.389, 2.862, 0.273> <0.346, 2.772, 0.300> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.525, 2.838, 0.015> <0.490, 2.668, 0.029> <0.425, 2.445, 0.054> <0.408, 2.271, 0.062> 
		<0.525, 2.838, 0.015> <0.504, 2.664, -0.035> <0.459, 2.434, -0.099> <0.443, 2.261, -0.091> 
		<0.525, 2.838, 0.015> <0.504, 2.664, -0.035> <0.455, 2.659, -0.076> <0.438, 2.599, -0.100> 
		<0.525, 2.838, 0.015> <0.539, 2.834, -0.049> <0.467, 2.800, -0.145> <0.450, 2.740, -0.169> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.220, 2.872, 0.441> <0.181, 2.692, 0.401> <0.112, 2.457, 0.329> <0.091, 2.271, 0.307> 
		<0.220, 2.872, 0.441> <0.117, 2.699, 0.431> <-0.043, 2.476, 0.401> <-0.064, 2.290, 0.379> 
		<0.220, 2.872, 0.441> <0.117, 2.699, 0.431> <0.051, 2.714, 0.425> <0.019, 2.654, 0.404> 
		<0.220, 2.872, 0.441> <0.156, 2.880, 0.471> <0.020, 2.878, 0.466> <-0.012, 2.818, 0.446> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.220, 2.872, 0.441> <0.181, 2.692, 0.401> <0.112, 2.457, 0.329> <0.091, 2.271, 0.307> 
		<0.220, 2.872, 0.441> <0.234, 2.685, 0.376> <0.262, 2.439, 0.259> <0.240, 2.253, 0.237> 
		<0.220, 2.872, 0.441> <0.234, 2.685, 0.376> <0.236, 2.679, 0.324> <0.244, 2.627, 0.299> 
		<0.220, 2.872, 0.441> <0.273, 2.866, 0.417> <0.302, 2.831, 0.321> <0.310, 2.779, 0.295> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.361, 2.810, -0.136> <-0.327, 2.640, -0.152> <-0.263, 2.416, -0.180> <-0.247, 2.243, -0.189> 
		<-0.361, 2.810, -0.136> <-0.310, 2.647, -0.253> <-0.235, 2.427, -0.345> <-0.219, 2.254, -0.354> 
		<-0.361, 2.810, -0.136> <-0.310, 2.647, -0.253> <-0.254, 2.683, -0.328> <-0.212, 2.593, -0.358> 
		<-0.361, 2.810, -0.136> <-0.344, 2.817, -0.237> <-0.239, 2.833, -0.400> <-0.197, 2.744, -0.430> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.361, 2.810, -0.136> <-0.327, 2.640, -0.152> <-0.263, 2.416, -0.180> <-0.247, 2.243, -0.189> 
		<-0.361, 2.810, -0.136> <-0.338, 2.635, -0.086> <-0.289, 2.405, -0.026> <-0.273, 2.232, -0.034> 
		<-0.361, 2.810, -0.136> <-0.338, 2.635, -0.086> <-0.286, 2.630, -0.048> <-0.268, 2.570, -0.026> 
		<-0.361, 2.810, -0.136> <-0.372, 2.805, -0.070> <-0.295, 2.771, 0.022> <-0.277, 2.711, 0.044> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.217, 2.858, -0.299> <0.216, 2.674, -0.270> <0.211, 2.429, -0.216> <0.212, 2.243, -0.204> 
		<0.217, 2.858, -0.299> <0.281, 2.680, -0.220> <0.339, 2.442, -0.120> <0.339, 2.255, -0.108> 
		<0.217, 2.858, -0.299> <0.281, 2.680, -0.220> <0.305, 2.667, -0.159> <0.310, 2.593, -0.123> 
		<0.217, 2.858, -0.299> <0.283, 2.865, -0.249> <0.347, 2.818, -0.124> <0.353, 2.744, -0.088> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.217, 2.858, -0.299> <0.216, 2.674, -0.270> <0.211, 2.429, -0.216> <0.212, 2.243, -0.204> 
		<0.217, 2.858, -0.299> <0.156, 2.668, -0.315> <0.087, 2.417, -0.311> <0.087, 2.230, -0.299> 
		<0.217, 2.858, -0.299> <0.156, 2.668, -0.315> <0.108, 2.639, -0.302> <0.078, 2.570, -0.299> 
		<0.217, 2.858, -0.299> <0.158, 2.853, -0.344> <0.050, 2.779, -0.343> <0.020, 2.711, -0.340> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.146, 2.275, -0.561> <0.145, 2.188, -0.560> <0.138, 2.074, -0.590> <0.135, 1.987, -0.590> 
		<0.013, 2.277, -0.590> <0.013, 2.190, -0.588> <0.007, 2.076, -0.634> <0.003, 1.989, -0.633> 
		<-0.067, 2.509, -0.562> <-0.151, 2.401, -0.550> <-0.156, 2.252, -0.551> <-0.160, 2.114, -0.557> 
		<-0.158, 2.609, -0.562> <-0.242, 2.501, -0.551> <-0.282, 2.307, -0.537> <-0.286, 2.169, -0.543> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.146, 2.275, -0.561> <0.145, 2.188, -0.560> <0.138, 2.074, -0.590> <0.135, 1.987, -0.590> 
		<0.258, 2.274, -0.536> <0.258, 2.187, -0.535> <0.258, 2.071, -0.550> <0.255, 1.984, -0.550> 
		<0.266, 2.505, -0.489> <0.321, 2.387, -0.429> <0.320, 2.247, -0.416> <0.323, 2.106, -0.396> 
		<0.317, 2.603, -0.458> <0.373, 2.485, -0.398> <0.401, 2.299, -0.333> <0.404, 2.157, -0.313> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.135, 1.987, -0.590> <0.127, 1.804, -0.588> <0.030, 1.510, -0.657> <0.107, 1.381, -0.554> 
		<0.003, 1.989, -0.633> <-0.004, 1.807, -0.632> <-0.058, 1.550, -0.672> <0.019, 1.421, -0.569> 
		<-0.160, 2.114, -0.557> <-0.164, 1.915, -0.564> <-0.230, 1.606, -0.603> <-0.141, 1.427, -0.606> 
		<-0.286, 2.169, -0.543> <-0.290, 1.970, -0.550> <-0.274, 1.693, -0.602> <-0.185, 1.515, -0.604> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.135, 1.987, -0.590> <0.255, 1.984, -0.550> <0.323, 2.106, -0.396> <0.404, 2.157, -0.313> 
		<0.127, 1.804, -0.588> <0.247, 1.802, -0.548> <0.326, 1.954, -0.374> <0.407, 2.005, -0.291> 
		<0.030, 1.510, -0.657> <0.083, 1.420, -0.585> <0.345, 1.674, -0.315> <0.388, 1.787, -0.279> 
		<0.107, 1.381, -0.554> <0.160, 1.291, -0.483> <0.292, 1.536, -0.357> <0.335, 1.650, -0.322> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.149, 2.271, 0.573> <-0.152, 2.185, 0.577> <-0.131, 2.072, 0.555> <-0.127, 1.987, 0.550> 
		<-0.011, 2.262, 0.623> <-0.014, 2.176, 0.628> <-0.000, 2.075, 0.597> <0.005, 1.989, 0.592> 
		<0.100, 2.503, 0.527> <0.171, 2.391, 0.525> <0.168, 2.247, 0.506> <0.166, 2.114, 0.513> 
		<0.208, 2.603, 0.507> <0.278, 2.490, 0.506> <0.293, 2.302, 0.490> <0.291, 2.169, 0.496> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.149, 2.271, 0.573> <-0.152, 2.185, 0.577> <-0.131, 2.072, 0.555> <-0.127, 1.987, 0.550> 
		<-0.276, 2.279, 0.526> <-0.278, 2.194, 0.531> <-0.248, 2.070, 0.518> <-0.243, 1.984, 0.513> 
		<-0.231, 2.525, 0.405> <-0.288, 2.396, 0.360> <-0.297, 2.253, 0.370> <-0.305, 2.106, 0.363> 
		<-0.267, 2.634, 0.333> <-0.323, 2.504, 0.289> <-0.373, 2.304, 0.290> <-0.381, 2.157, 0.283> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.127, 1.987, 0.550> <-0.117, 1.805, 0.540> <-0.025, 1.512, 0.623> <-0.100, 1.381, 0.521> 
		<0.005, 1.989, 0.592> <0.015, 1.807, 0.581> <0.063, 1.552, 0.635> <-0.012, 1.421, 0.533> 
		<0.166, 2.114, 0.513> <0.163, 1.915, 0.522> <0.238, 1.606, 0.559> <0.150, 1.427, 0.564> 
		<0.291, 2.169, 0.496> <0.289, 1.970, 0.506> <0.282, 1.693, 0.556> <0.193, 1.515, 0.562> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.127, 1.987, 0.550> <-0.243, 1.984, 0.513> <-0.305, 2.106, 0.363> <-0.381, 2.157, 0.283> 
		<-0.117, 1.805, 0.540> <-0.233, 1.803, 0.503> <-0.313, 1.953, 0.356> <-0.390, 2.004, 0.276> 
		<-0.025, 1.512, 0.623> <-0.077, 1.421, 0.553> <-0.330, 1.675, 0.282> <-0.371, 1.788, 0.247> 
		<-0.100, 1.381, 0.521> <-0.152, 1.290, 0.452> <-0.280, 1.536, 0.324> <-0.321, 1.650, 0.290> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.518, 2.279, 0.191> <0.522, 2.191, 0.187> <0.549, 2.075, 0.165> <0.545, 1.987, 0.165> 
		<0.564, 2.274, 0.054> <0.568, 2.186, 0.050> <0.577, 2.077, 0.030> <0.573, 1.989, 0.029> 
		<0.484, 2.514, -0.050> <0.470, 2.409, -0.137> <0.466, 2.251, -0.122> <0.471, 2.114, -0.122> 
		<0.470, 2.615, -0.153> <0.456, 2.510, -0.240> <0.434, 2.306, -0.245> <0.440, 2.169, -0.245> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.518, 2.279, 0.191> <0.522, 2.191, 0.187> <0.549, 2.075, 0.165> <0.545, 1.987, 0.165> 
		<0.471, 2.284, 0.329> <0.475, 2.196, 0.325> <0.524, 2.073, 0.286> <0.520, 1.984, 0.286> 
		<0.349, 2.529, 0.348> <0.301, 2.406, 0.405> <0.369, 2.250, 0.366> <0.372, 2.106, 0.362> 
		<0.277, 2.636, 0.416> <0.228, 2.513, 0.472> <0.295, 2.301, 0.451> <0.298, 2.157, 0.446> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.545, 1.987, 0.165> <0.537, 1.809, 0.164> <0.570, 1.526, 0.105> <0.478, 1.400, 0.188> 
		<0.573, 1.989, 0.029> <0.564, 1.812, 0.029> <0.581, 1.561, 0.002> <0.489, 1.434, 0.085> 
		<0.471, 2.114, -0.122> <0.479, 1.915, -0.122> <0.511, 1.594, -0.198> <0.519, 1.420, -0.101> 
		<0.440, 2.169, -0.245> <0.448, 1.970, -0.245> <0.506, 1.688, -0.251> <0.515, 1.515, -0.154> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.545, 1.987, 0.165> <0.520, 1.984, 0.286> <0.372, 2.106, 0.362> <0.298, 2.157, 0.446> 
		<0.537, 1.809, 0.164> <0.512, 1.807, 0.285> <0.375, 1.953, 0.357> <0.301, 2.004, 0.442> 
		<0.570, 1.526, 0.105> <0.513, 1.448, 0.156> <0.288, 1.690, 0.399> <0.264, 1.791, 0.434> 
		<0.478, 1.400, 0.188> <0.420, 1.322, 0.239> <0.322, 1.548, 0.351> <0.298, 1.650, 0.385> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.361, 2.306, -0.272> <-0.365, 2.202, -0.271> <-0.483, 2.090, -0.230> <-0.490, 1.987, -0.228> 
		<-0.396, 2.285, -0.091> <-0.400, 2.181, -0.091> <-0.513, 2.093, -0.096> <-0.520, 1.989, -0.093> 
		<-0.392, 2.606, 0.038> <-0.378, 2.461, 0.125> <-0.413, 2.284, 0.071> <-0.421, 2.114, 0.060> 
		<-0.406, 2.734, 0.171> <-0.391, 2.590, 0.258> <-0.384, 2.338, 0.194> <-0.392, 2.169, 0.183> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.361, 2.306, -0.272> <-0.365, 2.202, -0.271> <-0.483, 2.090, -0.230> <-0.490, 1.987, -0.228> 
		<-0.331, 2.324, -0.425> <-0.335, 2.220, -0.425> <-0.456, 2.088, -0.351> <-0.463, 1.984, -0.348> 
		<-0.312, 2.654, -0.377> <-0.256, 2.479, -0.445> <-0.322, 2.302, -0.418> <-0.314, 2.106, -0.422> 
		<-0.290, 2.804, -0.421> <-0.235, 2.628, -0.489> <-0.247, 2.353, -0.501> <-0.238, 2.157, -0.505> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.490, 1.987, -0.228> <-0.502, 1.810, -0.224> <-0.517, 1.526, -0.168> <-0.423, 1.400, -0.250> 
		<-0.520, 1.989, -0.093> <-0.532, 1.812, -0.089> <-0.529, 1.561, -0.066> <-0.435, 1.434, -0.147> 
		<-0.421, 2.114, 0.060> <-0.431, 1.916, 0.047> <-0.462, 1.594, 0.136> <-0.469, 1.420, 0.038> 
		<-0.392, 2.169, 0.183> <-0.402, 1.970, 0.170> <-0.459, 1.688, 0.189> <-0.465, 1.515, 0.091> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.490, 1.987, -0.228> <-0.463, 1.984, -0.348> <-0.314, 2.106, -0.422> <-0.238, 2.157, -0.505> 
		<-0.502, 1.810, -0.224> <-0.475, 1.808, -0.344> <-0.307, 1.953, -0.425> <-0.231, 2.004, -0.508> 
		<-0.517, 1.526, -0.168> <-0.458, 1.448, -0.219> <-0.230, 1.690, -0.458> <-0.205, 1.791, -0.492> 
		<-0.423, 1.400, -0.250> <-0.364, 1.322, -0.300> <-0.264, 1.548, -0.410> <-0.239, 1.650, -0.444> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.301, 2.271, 0.269> <-0.302, 2.185, 0.269> <-0.277, 2.072, 0.260> <-0.271, 1.987, 0.258> 
		<-0.200, 2.255, 0.388> <-0.200, 2.169, 0.388> <-0.215, 2.075, 0.344> <-0.208, 1.989, 0.341> 
		<-0.187, 2.599, 0.388> <-0.126, 2.437, 0.421> <-0.088, 2.290, 0.369> <-0.087, 2.114, 0.353> 
		<-0.139, 2.740, 0.439> <-0.077, 2.578, 0.471> <-0.009, 2.345, 0.410> <-0.008, 2.169, 0.394> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.301, 2.271, 0.269> <-0.302, 2.185, 0.269> <-0.277, 2.072, 0.260> <-0.271, 1.987, 0.258> 
		<-0.407, 2.288, 0.145> <-0.407, 2.202, 0.145> <-0.334, 2.070, 0.185> <-0.328, 1.984, 0.183> 
		<-0.380, 2.629, 0.162> <-0.391, 2.448, 0.094> <-0.318, 2.298, 0.073> <-0.297, 2.106, 0.076> 
		<-0.414, 2.783, 0.116> <-0.425, 2.602, 0.049> <-0.329, 2.350, -0.005> <-0.307, 2.157, -0.002> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.271, 1.987, 0.258> <-0.258, 1.805, 0.253> <-0.227, 1.552, 0.305> <-0.235, 1.381, 0.243> 
		<-0.208, 1.989, 0.341> <-0.195, 1.807, 0.336> <-0.196, 1.592, 0.331> <-0.204, 1.421, 0.269> 
		<-0.087, 2.114, 0.353> <-0.086, 1.914, 0.336> <-0.094, 1.651, 0.356> <-0.148, 1.461, 0.320> 
		<-0.008, 2.169, 0.394> <-0.007, 1.969, 0.376> <-0.078, 1.705, 0.366> <-0.133, 1.515, 0.330> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.271, 1.987, 0.258> <-0.328, 1.984, 0.183> <-0.297, 2.106, 0.076> <-0.307, 2.157, -0.002> 
		<-0.258, 1.805, 0.253> <-0.314, 1.803, 0.178> <-0.279, 1.949, 0.079> <-0.290, 2.000, 0.001> 
		<-0.227, 1.552, 0.305> <-0.231, 1.469, 0.275> <-0.294, 1.716, 0.115> <-0.302, 1.800, 0.088> 
		<-0.235, 1.381, 0.243> <-0.239, 1.298, 0.213> <-0.280, 1.566, 0.162> <-0.288, 1.650, 0.135> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.078, 2.271, -0.406> <-0.071, 2.181, -0.401> <-0.104, 2.063, -0.440> <-0.104, 1.973, -0.433> 
		<-0.227, 2.261, -0.356> <-0.219, 2.171, -0.351> <-0.213, 2.066, -0.412> <-0.213, 1.976, -0.405> 
		<-0.232, 2.599, -0.348> <-0.263, 2.441, -0.278> <-0.261, 2.286, -0.266> <-0.247, 2.110, -0.259> 
		<-0.298, 2.740, -0.323> <-0.329, 2.581, -0.253> <-0.322, 2.345, -0.192> <-0.308, 2.169, -0.185> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.078, 2.271, -0.406> <-0.071, 2.181, -0.401> <-0.104, 2.063, -0.440> <-0.104, 1.973, -0.433> 
		<0.080, 2.283, -0.459> <0.088, 2.193, -0.454> <-0.000, 2.060, -0.466> <-0.000, 1.970, -0.458> 
		<0.087, 2.622, -0.454> <0.173, 2.456, -0.412> <0.110, 2.291, -0.366> <0.090, 2.102, -0.344> 
		<0.158, 2.772, -0.475> <0.244, 2.607, -0.432> <0.193, 2.346, -0.328> <0.173, 2.157, -0.306> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.104, 1.973, -0.433> <-0.104, 1.793, -0.418> <-0.151, 1.540, -0.380> <-0.081, 1.381, -0.335> 
		<-0.213, 1.976, -0.405> <-0.214, 1.796, -0.391> <-0.187, 1.580, -0.362> <-0.117, 1.421, -0.317> 
		<-0.247, 2.110, -0.259> <-0.231, 1.910, -0.252> <-0.240, 1.651, -0.249> <-0.185, 1.461, -0.285> 
		<-0.308, 2.169, -0.185> <-0.292, 1.969, -0.177> <-0.255, 1.705, -0.239> <-0.201, 1.515, -0.275> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.104, 1.973, -0.433> <-0.000, 1.970, -0.458> <0.090, 2.102, -0.344> <0.173, 2.157, -0.306> 
		<-0.104, 1.793, -0.418> <-0.001, 1.791, -0.444> <0.074, 1.946, -0.325> <0.157, 2.001, -0.288> 
		<-0.151, 1.540, -0.380> <-0.117, 1.462, -0.358> <0.061, 1.716, -0.339> <0.088, 1.800, -0.336> 
		<-0.081, 1.381, -0.335> <-0.046, 1.302, -0.313> <0.012, 1.566, -0.345> <0.039, 1.650, -0.342> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.408, 2.271, 0.062> <0.400, 2.181, 0.066> <0.451, 2.063, 0.059> <0.444, 1.973, 0.054> 
		<0.443, 2.261, -0.091> <0.434, 2.171, -0.087> <0.484, 2.065, -0.049> <0.477, 1.976, -0.054> 
		<0.438, 2.599, -0.100> <0.394, 2.441, -0.162> <0.389, 2.285, -0.157> <0.370, 2.110, -0.158> 
		<0.450, 2.740, -0.169> <0.406, 2.581, -0.232> <0.357, 2.344, -0.248> <0.338, 2.169, -0.249> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.408, 2.271, 0.062> <0.400, 2.181, 0.066> <0.451, 2.063, 0.059> <0.444, 1.973, 0.054> 
		<0.372, 2.283, 0.225> <0.364, 2.193, 0.229> <0.420, 2.060, 0.161> <0.413, 1.970, 0.156> 
		<0.365, 2.622, 0.229> <0.284, 2.456, 0.280> <0.277, 2.291, 0.203> <0.268, 2.102, 0.175> 
		<0.346, 2.772, 0.300> <0.265, 2.607, 0.352> <0.202, 2.346, 0.255> <0.193, 2.157, 0.226> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.444, 1.973, 0.054> <0.431, 1.793, 0.044> <0.416, 1.541, -0.022> <0.341, 1.381, 0.016> 
		<0.477, 1.976, -0.054> <0.464, 1.796, -0.063> <0.409, 1.581, -0.079> <0.334, 1.421, -0.042> 
		<0.370, 2.110, -0.158> <0.349, 1.914, -0.159> <0.318, 1.635, -0.216> <0.319, 1.448, -0.153> 
		<0.338, 2.169, -0.249> <0.317, 1.973, -0.250> <0.318, 1.702, -0.238> <0.319, 1.515, -0.175> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.444, 1.973, 0.054> <0.413, 1.970, 0.156> <0.268, 2.102, 0.175> <0.193, 2.157, 0.226> 
		<0.431, 1.793, 0.044> <0.400, 1.790, 0.147> <0.261, 1.946, 0.151> <0.186, 2.001, 0.203> 
		<0.416, 1.541, -0.022> <0.379, 1.462, -0.003> <0.280, 1.715, 0.148> <0.264, 1.799, 0.171> 
		<0.341, 1.381, 0.016> <0.304, 1.302, 0.034> <0.309, 1.565, 0.107> <0.293, 1.650, 0.130> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.091, 2.271, 0.307> <0.080, 2.182, 0.296> <0.115, 2.063, 0.341> <0.115, 1.973, 0.334> 
		<0.240, 2.253, 0.237> <0.230, 2.164, 0.226> <0.225, 2.066, 0.318> <0.225, 1.976, 0.311> 
		<0.244, 2.627, 0.299> <0.270, 2.456, 0.214> <0.278, 2.302, 0.184> <0.264, 2.110, 0.166> 
		<0.310, 2.779, 0.295> <0.336, 2.608, 0.211> <0.342, 2.361, 0.112> <0.328, 2.169, 0.094> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.091, 2.271, 0.307> <0.080, 2.182, 0.296> <0.115, 2.063, 0.341> <0.115, 1.973, 0.334> 
		<-0.064, 2.290, 0.379> <-0.075, 2.201, 0.368> <0.010, 2.060, 0.364> <0.011, 1.970, 0.357> 
		<0.019, 2.654, 0.404> <-0.078, 2.471, 0.342> <-0.074, 2.315, 0.277> <-0.076, 2.102, 0.239> 
		<-0.012, 2.818, 0.446> <-0.109, 2.635, 0.383> <-0.155, 2.370, 0.236> <-0.158, 2.157, 0.198> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.115, 1.973, 0.334> <0.116, 1.793, 0.320> <0.164, 1.540, 0.283> <0.095, 1.381, 0.236> 
		<0.225, 1.976, 0.311> <0.226, 1.796, 0.296> <0.201, 1.580, 0.267> <0.132, 1.421, 0.219> 
		<0.264, 2.110, 0.166> <0.250, 1.911, 0.148> <0.257, 1.651, 0.156> <0.201, 1.461, 0.190> 
		<0.328, 2.169, 0.094> <0.313, 1.970, 0.076> <0.273, 1.705, 0.146> <0.217, 1.515, 0.180> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.115, 1.973, 0.334> <0.011, 1.970, 0.357> <-0.076, 2.102, 0.239> <-0.158, 2.157, 0.198> 
		<0.116, 1.793, 0.320> <0.012, 1.791, 0.342> <-0.077, 1.946, 0.211> <-0.159, 2.002, 0.171> 
		<0.164, 1.540, 0.283> <0.130, 1.462, 0.260> <-0.046, 1.716, 0.235> <-0.074, 1.800, 0.231> 
		<0.095, 1.381, 0.236> <0.061, 1.302, 0.213> <0.003, 1.566, 0.243> <-0.025, 1.650, 0.239> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.247, 2.243, -0.189> <-0.239, 2.153, -0.193> <-0.289, 2.034, -0.182> <-0.282, 1.944, -0.179> 
		<-0.273, 2.232, -0.034> <-0.265, 2.142, -0.038> <-0.316, 2.037, -0.073> <-0.310, 1.947, -0.069> 
		<-0.268, 2.570, -0.026> <-0.220, 2.412, 0.035> <-0.209, 2.257, 0.038> <-0.197, 2.082, 0.029> 
		<-0.277, 2.711, 0.044> <-0.229, 2.553, 0.105> <-0.173, 2.316, 0.127> <-0.160, 2.141, 0.118> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.247, 2.243, -0.189> <-0.239, 2.153, -0.193> <-0.289, 2.034, -0.182> <-0.282, 1.944, -0.179> 
		<-0.219, 2.254, -0.354> <-0.211, 2.164, -0.358> <-0.263, 2.031, -0.286> <-0.257, 1.942, -0.282> 
		<-0.212, 2.593, -0.358> <-0.134, 2.428, -0.413> <-0.124, 2.262, -0.337> <-0.113, 2.073, -0.308> 
		<-0.197, 2.744, -0.430> <-0.119, 2.578, -0.485> <-0.051, 2.317, -0.392> <-0.041, 2.128, -0.364> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.282, 1.944, -0.179> <-0.270, 1.765, -0.172> <-0.258, 1.511, -0.112> <-0.186, 1.352, -0.154> 
		<-0.310, 1.947, -0.069> <-0.297, 1.767, -0.062> <-0.259, 1.552, -0.072> <-0.187, 1.392, -0.113> 
		<-0.197, 2.082, 0.029> <-0.182, 1.882, 0.019> <-0.185, 1.622, 0.027> <-0.191, 1.432, -0.038> 
		<-0.160, 2.141, 0.118> <-0.146, 1.941, 0.108> <-0.183, 1.676, 0.046> <-0.189, 1.486, -0.019> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.282, 1.944, -0.179> <-0.257, 1.942, -0.282> <-0.113, 2.073, -0.308> <-0.041, 2.128, -0.364> 
		<-0.270, 1.765, -0.172> <-0.244, 1.762, -0.275> <-0.105, 1.917, -0.285> <-0.032, 1.972, -0.341> 
		<-0.258, 1.511, -0.112> <-0.223, 1.433, -0.132> <-0.123, 1.687, -0.280> <-0.107, 1.771, -0.303> 
		<-0.186, 1.352, -0.154> <-0.150, 1.274, -0.174> <-0.151, 1.537, -0.240> <-0.135, 1.621, -0.262> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.212, 2.243, -0.204> <0.212, 2.153, -0.199> <0.226, 2.034, -0.244> <0.220, 1.944, -0.241> 
		<0.087, 2.230, -0.299> <0.087, 2.140, -0.294> <0.142, 2.037, -0.320> <0.136, 1.947, -0.316> 
		<0.078, 2.570, -0.299> <0.007, 2.409, -0.293> <-0.006, 2.257, -0.278> <-0.004, 2.082, -0.262> 
		<0.020, 2.711, -0.340> <-0.051, 2.550, -0.334> <-0.102, 2.316, -0.287> <-0.100, 2.141, -0.272> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.212, 2.243, -0.204> <0.212, 2.153, -0.199> <0.226, 2.034, -0.244> <0.220, 1.944, -0.241> 
		<0.339, 2.255, -0.108> <0.339, 2.165, -0.102> <0.305, 2.031, -0.173> <0.299, 1.942, -0.169> 
		<0.310, 2.593, -0.123> <0.323, 2.422, -0.038> <0.277, 2.263, -0.033> <0.255, 2.073, -0.030> 
		<0.353, 2.744, -0.088> <0.365, 2.572, -0.003> <0.292, 2.319, 0.057> <0.270, 2.128, 0.060> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.220, 1.944, -0.241> <0.208, 1.765, -0.233> <0.150, 1.511, -0.250> <0.152, 1.352, -0.167> 
		<0.136, 1.947, -0.316> <0.124, 1.767, -0.308> <0.115, 1.552, -0.270> <0.117, 1.392, -0.187> 
		<-0.004, 2.082, -0.262> <-0.001, 1.882, -0.245> <-0.008, 1.622, -0.251> <0.052, 1.432, -0.226> 
		<-0.100, 2.141, -0.272> <-0.097, 1.941, -0.254> <-0.025, 1.676, -0.258> <0.035, 1.486, -0.233> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.220, 1.944, -0.241> <0.299, 1.942, -0.169> <0.255, 2.073, -0.030> <0.270, 2.128, 0.060> 
		<0.208, 1.765, -0.233> <0.287, 1.762, -0.162> <0.237, 1.916, -0.028> <0.252, 1.972, 0.062> 
		<0.150, 1.511, -0.250> <0.151, 1.433, -0.209> <0.235, 1.687, -0.052> <0.247, 1.771, -0.027> 
		<0.152, 1.352, -0.167> <0.153, 1.274, -0.126> <0.212, 1.537, -0.096> <0.225, 1.621, -0.071> 
	}
	texture { InnerPetalTex }

}
}

